---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：53-execute-all-sdl-tools.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：実測データが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/execute-all-sdl-tools.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）
- E-03: `eng/common/sdl/init-sdl.ps1`（呼び出し先スクリプト）
- E-04: `eng/common/sdl/configure-sdl-tool.ps1`（呼び出し先スクリプト）
- E-05: `eng/common/sdl/run-sdl.ps1`（呼び出し先スクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | init-sdl.ps1を呼び出してSDL環境を初期化 | E-01 L78 | ○ |
| C-02 | configure-sdl-tool.ps1を呼び出してツールを設定 | E-01 L101, L121-124 | ○ |
| C-03 | run-sdl.ps1を呼び出してスキャンを実行 | E-01 L129-133 | ○ |
| C-04 | ErrorActionPreference='Stop'で初期化される | E-01 L43 | ○ |
| C-05 | tools.ps1を読み込む | E-01 L52 | ○ |
| C-06 | CI環境変数$ciをtrueに設定 | E-01 L51 | ○ |
| C-07 | リポジトリ名をorg/repo形式に変換 | E-01 L55-60 | ○ |
| C-08 | GuardianCliLocationをパッケージから解決可能 | E-01 L62-66 | ○ |
| C-09 | Guardian CLIパスをTest-Pathで検証 | E-01 L69-75 | ○ |
| C-10 | TsaOnboard=trueでTSAオンボーディング実行 | E-01 L82-94 | ○ |
| C-11 | TSAオンボードに必要パラメータの検証 | E-01 L83, L91-93 | ○ |
| C-12 | Configure-ToolsList関数でツール設定を実行 | E-01 L98-118 | ○ |
| C-13 | ArtifactToolsListの設定 | E-01 L121 | ○ |
| C-14 | SourceToolsListの設定 | E-01 L122 | ○ |
| C-15 | CustomToolsListの設定 | E-01 L124 | ○ |
| C-16 | TsaPublish=trueでTSA公開実行 | E-01 L136-152 | ○ |
| C-17 | TSA公開に必要パラメータの検証 | E-01 L137, L148-150 | ○ |
| C-18 | TsaRepositoryNameの自動生成 | E-01 L138-140 | ○ |
| C-19 | BreakOnFailure=trueでguardian break実行 | E-01 L154-158 | ○ |
| C-20 | GuardianLoggerLevelのデフォルト値は'Standard' | E-01 L34 | ○ |
| C-21 | CredScan追加パラメータのサポート | E-01 L35, L109 | ○ |
| C-22 | PoliCheck追加パラメータのサポート | E-01 L36, L110 | ○ |
| C-23 | CodeQL追加パラメータのサポート | E-01 L37, L111 | ○ |
| C-24 | Binskim追加パラメータのサポート | E-01 L38, L112 | ○ |
| C-25 | パフォーマンス要件の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値：実行時間はコードベースサイズとツール数に依存するため、実測データが必要
  - 候補：実行ログの分析 / CIパイプライン実行履歴 / パフォーマンスベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理フローはソースコードから明確に読み取れる
- 0: 低リスク - パラメータ検証ロジックも明確

## 6) レビュアーチェックリスト（最小）
- [ ] TSA関連パラメータの必須/任意条件が正しいか確認
- [ ] ツールリスト（SourceToolsList等）の形式が正しく文書化されているか確認
- [ ] エラーハンドリングが運用要件を満たしているか確認
- [ ] 各サブスクリプトの呼び出しパラメータが正しいか確認
