---
generated_at: 2026-02-10 10:38:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：54-configure-sdl-tool.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Guardian configureコマンド詳細**：外部ドキュメント参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/configure-sdl-tool.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）
- E-03: `eng/common/sdl/execute-all-sdl-tools.ps1`（呼び出し元スクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToolsListを文字列からハッシュテーブルに正規化 | E-01 L38-47 | ○ |
| C-02 | 未設定のScenarioを空文字で初期化 | E-01 L44 | ○ |
| C-03 | 未設定のArgsを空配列で初期化 | E-01 L45 | ○ |
| C-04 | ErrorActionPreference='Stop'で初期化 | E-01 L25 | ○ |
| C-05 | tools.ps1を読み込む | E-01 L35 | ○ |
| C-06 | CI環境変数$ciをtrueに設定 | E-01 L34 | ○ |
| C-07 | .gdn/rディレクトリに設定ファイルを出力 | E-01 L53, L71 | ○ |
| C-08 | Guardian CLIパスをTest-Pathで検証 | E-01 L54-60 | ○ |
| C-09 | ツール名とシナリオでユニークな設定名を構築 | E-01 L64-67 | ○ |
| C-10 | CredScanにTargetDirectoryを追加 | E-01 L76-78 | ○ |
| C-11 | CredScanにOutputType=preを追加 | E-01 L79 | ○ |
| C-12 | CredScanに追加パラメータを適用 | E-01 L80 | ○ |
| C-13 | PoliCheckにTargetを追加 | E-01 L83-85 | ○ |
| C-14 | PoliCheckに追加パラメータを適用 | E-01 L86 | ○ |
| C-15 | CodeQL/SemmleにSourceCodeDirectoryを追加 | E-01 L88-91 | ○ |
| C-16 | CodeQLに追加パラメータを適用 | E-01 L92 | ○ |
| C-17 | BinskimにTarget（除外パターン付き）を追加 | E-01 L94-98 | ○ |
| C-18 | Binskimで_.pdbを除外（GitHub issue #924） | E-01 L96-98 | ○ |
| C-19 | Binskimに追加パラメータを適用 | E-01 L100 | ○ |
| C-20 | Guardian configureコマンドの実行 | E-01 L111-120 | ○ |
| C-21 | --forceオプションで上書き | E-01 L118 | ○ |
| C-22 | Guardian configureの詳細仕様 | **外部ドキュメント** | △ |

## 4) 不足情報（Unknown / Missing）
- Guardian configureコマンドの詳細仕様：コード内コメント（L109-110）でAzure DevOps Security Integration Wikiへの参照があるが、外部ドキュメントのため詳細確認が必要
  - 候補：Azure DevOps Security Integration Wiki / Guardian CLI公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ツール固有の設定ロジックはソースコードから明確に読み取れる
- 0: 低リスク - Binskimの_.pdb除外理由がコメントで明記されている

## 6) レビュアーチェックリスト（最小）
- [ ] ToolsList形式の文書化が実装と一致しているか確認
- [ ] 各ツール固有のデフォルト引数が最新の要件を満たしているか確認
- [ ] 設定ファイル出力先（.gdn/r）がrun-sdl.ps1と整合しているか確認
- [ ] 追加パラメータの形式が正しく文書化されているか確認
