---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-extract-artifact-archives.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **tarコマンドの環境依存性**：Windows 10/2019以降という前提条件の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/extract-artifact-archives.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tar.gzとzipの両方を展開対象とする | E-01 L27-30 | ○ |
| C-02 | ErrorActionPreference='Stop'で初期化 | E-01 L11 | ○ |
| C-03 | tools.ps1を読み込む | E-01 L21 | ○ |
| C-04 | CI環境変数$ciをtrueに設定 | E-01 L20 | ○ |
| C-05 | Get-ChildItemで*.tar.gzと*.zipを検索 | E-01 L28-29 | ○ |
| C-06 | Start-Jobで並列処理を実行 | E-01 L33 | ○ |
| C-07 | 展開先に.extractedサフィックスを付与 | E-01 L36 | ○ |
| C-08 | New-Itemでディレクトリを作成 | E-01 L38 | ○ |
| C-09 | tar -xfコマンドで展開 | E-01 L45 | ○ |
| C-10 | 標準エラーを標準出力にリダイレクト（2>&1） | E-01 L45 | ○ |
| C-11 | LASTEXITCODEで終了コードをチェック | E-01 L48-49 | ○ |
| C-12 | 失敗時は例外をスロー | E-01 L49 | ○ |
| C-13 | Receive-Job -Waitで全ジョブ待機 | E-01 L56 | ○ |
| C-14 | Measure-Commandで処理時間計測 | E-01 L23 | ○ |
| C-15 | スクリプトコメントでtar対応を記載 | E-01 L3 | ○ |
| C-16 | $using:変数でジョブにパラメータ渡し | E-01 L34-36 | ○ |
| C-17 | Windows 10/2019以降でtarが標準搭載 | **コメントのみ** | △ |

## 4) 不足情報（Unknown / Missing）
- tarコマンドのWindows環境での可用性：コメント（L3）で言及されているが、コード内でのバージョンチェックや代替手段は実装されていない
  - 候補：Windows OSバージョン要件の公式ドキュメント / CIエージェントの環境仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な展開処理ロジックはソースコードから明確
- 1: 中リスク - tarコマンドが利用できない環境での動作

## 6) レビュアーチェックリスト（最小）
- [ ] CIエージェント環境でtarコマンドが利用可能か確認
- [ ] 展開先ディレクトリ命名（.extractedサフィックス）がSDLツールの期待と一致するか確認
- [ ] 並列処理が大量アーカイブで問題を起こさないか確認
- [ ] エラー発生時の例外メッセージが十分な情報を含むか確認
