---
generated_at: 2026-02-10 10:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：57-trim-assets-version.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **trim-assets-versionの詳細動作**：VersionTools CLIの公式ドキュメント参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/trim-assets-version.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Microsoft.DotNet.VersionTools.Cliを使用 | E-01 L18 | ○ |
| C-02 | 入力パス不存在時は終了コード1で終了 | E-01 L34-37 | ○ |
| C-03 | ErrorActionPreference='Stop'で初期化 | E-01 L39 | ○ |
| C-04 | tools.ps1を読み込む | E-01 L49 | ○ |
| C-05 | CI環境変数$ciをtrueに設定 | E-01 L48 | ○ |
| C-06 | InitializeDotNetCliで.NET CLIを初期化 | E-01 L52 | ○ |
| C-07 | Read-ArcadeSdkVersionでバージョン取得 | E-01 L55 | ○ |
| C-08 | dotnet tool install --localでインストール | E-01 L28 | ○ |
| C-09 | dotnet-engフィードを使用 | E-01 L26 | ○ |
| C-10 | --create-manifest-if-neededオプション使用 | E-01 L28 | ○ |
| C-11 | --no-cacheオプション使用 | E-01 L28 | ○ |
| C-12 | dotnet tool listでインストール確認 | E-01 L58 | ○ |
| C-13 | インストール失敗時はエラー終了 | E-01 L59-62 | ○ |
| C-14 | trim-assets-versionコマンド実行 | E-01 L64-68 | ○ |
| C-15 | --assets-pathパラメータを指定 | E-01 L66 | ○ |
| C-16 | --recursiveパラメータを指定 | E-01 L67 | ○ |
| C-17 | Recursiveのデフォルト値はtrue | E-01 L15 | ○ |
| C-18 | trim-assets-versionの詳細動作 | **外部ドキュメント** | △ |

## 4) 不足情報（Unknown / Missing）
- trim-assets-versionコマンドの詳細な動作仕様：ファイル名からバージョン情報を削除するロジックの詳細
  - 候補：Microsoft.DotNet.VersionTools.Cli公式ドキュメント / dotnet/arcadeリポジトリのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローはソースコードから明確
- 1: 中リスク - VersionTools CLIの動作詳細が外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] dotnet-engフィードへのアクセスがCI環境で可能か確認
- [ ] Arcade SDKバージョンとVersionTools CLIバージョンの整合性を確認
- [ ] trim-assets-versionの処理がSDLスキャン要件を満たすか確認
- [ ] Recursiveオプションのデフォルト値（true）が要件と一致するか確認
