---
generated_at: 2026-02-10 10:52:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：58-vmr-sync.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Darc vmr forwardflowの詳細動作**：外部ツールの仕様参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/vmr-sync.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tmpDirは必須パラメータ | E-01 L37-38 Mandatory属性 | ○ |
| C-02 | vmrDirのデフォルト値は$tmpDir/dotnet | E-01 L68-70 | ○ |
| C-03 | tmpDirが存在しない場合は作成 | E-01 L72-74 | ○ |
| C-04 | VMRが存在しない場合はGitHubからクローン | E-01 L78-80 | ○ |
| C-05 | vmrBranch指定時はブランチ作成・切り替え | E-01 L82-84 | ○ |
| C-06 | VMRに未コミット変更があればエラー終了 | E-01 L87-90 | ○ |
| C-07 | vmrBranch指定時はチェックアウト・プル | E-01 L92-96 | ○ |
| C-08 | InitializeDotNetCliで.NET SDKを初期化 | E-01 L105 | ○ |
| C-09 | Get-DarcでDarcツールを取得 | E-01 L106 | ○ |
| C-10 | darc vmr forwardflowコマンドを実行 | E-01 L112-117 | ○ |
| C-11 | ciスイッチで--ciフラグを追加 | E-01 L119-121 | ○ |
| C-12 | azdevPatで--azdev-patを追加 | E-01 L123-125 | ○ |
| C-13 | debugOutputでverbosityをdebugに設定 | E-01 L55-58 | ○ |
| C-14 | 同期成功時に"Synchronization succeeded"出力 | E-01 L130 | ○ |
| C-15 | 同期失敗時にガイダンスを出力 | E-01 L133-137 | ○ |
| C-16 | 失敗時は終了コード1で終了 | E-01 L137 | ○ |
| C-17 | tools.ps1を読み込み | E-01 L104 | ○ |
| C-18 | Fail関数で赤色エラー出力 | E-01 L47-49 | ○ |
| C-19 | Highlight関数でシアン色進捗出力 | E-01 L51-53 | ○ |
| C-20 | Darc vmr forwardflowの詳細動作 | **外部ツール** | △ |

## 4) 不足情報（Unknown / Missing）
- Darc vmr forwardflowコマンドの詳細な動作仕様：パッチ適用ロジック、競合解決方法等
  - 候補：dotnet/arcade Darcドキュメント / Microsoft公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの処理フローはソースコードから明確
- 1: 中リスク - Darcツールの動作が外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] tmpDirパラメータの説明が十分か確認
- [ ] VMR未コミット変更時のエラーメッセージがユーザーに分かりやすいか確認
- [ ] 同期失敗時のリカバリガイダンスが適切か確認
- [ ] ciスイッチとazdevPatの使用条件が明確か確認
