---
generated_at: 2026-02-10 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-eng/make-bootstrap.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/make-bootstrap.ps1` - ブートストラップビルドスクリプト（92行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト出力先はartifacts/bootstrap/local | E-01: `$output = Join-Path $ArtifactsDir "bootstrap" "local"` (21行目) | ○ |
| C-02 | デフォルトtoolsetはDefault | E-01: `$toolset = "Default"` (4行目) | ○ |
| C-03 | デフォルトconfigurationはRelease | E-01: `$configuration = "Release"` (5行目) | ○ |
| C-04 | -forceで既存ディレクトリを削除 | E-01: `if ($force) { Remove-Item -Recurse -Force $output }` (27-29行目) | ○ |
| C-05 | 既存出力先存在時に-forceなしでエラー | E-01: `else { Write-Host ... exit 1 }` (31-34行目) | ○ |
| C-06 | Default toolsetはAnyCpuプロジェクト | E-01: `$projectPath = "src\NuGet\...\AnyCpu\..."` (38行目) | ○ |
| C-07 | Framework toolsetはFrameworkプロジェクト | E-01: `$projectPath = "src\NuGet\...\Framework\..."` (41-42行目) | ○ |
| C-08 | /t:Packでパッケージビルド | E-01: `$args += " /t:Pack"` (60行目) | ○ |
| C-09 | BOOTSTRAP定数を定義 | E-01: `/p:InitialDefineConstants=BOOTSTRAP` (60行目) | ○ |
| C-10 | DotNetUseShippingVersions=true | E-01: `/p:DotNetUseShippingVersions=true` (60行目) | ○ |
| C-11 | NgenOptimization=false | E-01: `/p:NgenOptimization=false` (61行目) | ○ |
| C-12 | PublishWindowsPdb=false | E-01: `/p:PublishWindowsPdb=false` (61行目) | ○ |
| C-13 | Unzipでnupkgを展開 | E-01: `Unzip $packageFilePath.FullName $output` (76行目) | ○ |
| C-14 | dotnet build /t:Cleanでクリーンアップ | E-01: `Exec-DotNet "build --no-restore /t:Clean $projectPath"` (79行目) | ○ |
| C-15 | build-server shutdownを実行 | E-01: `Exec-DotNet "build-server shutdown"` (80行目) | ○ |
| C-16 | 本スクリプトはビルドカテゴリに属する | E-02: No.6のカテゴリ「ビルド」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 主要な入力パラメータがソースコードと一致するか確認済み
- [x] 処理フローがソースコードの実行順序と一致するか確認済み
- [x] ツールセット種別による分岐が正しく記述されているか確認済み
- [ ] 実際の実行環境での動作確認（任意）
