---
generated_at: 2026-02-10 10:58:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：60-internal-feed-operations.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **MSBuildバグのワークアラウンド**：外部Issue参照が必要
  2. **CredProviderの詳細仕様**：外部ドキュメント参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/internal-feed-operations.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Operationパラメータは必須 | E-01 L2 Mandatory属性 | ○ |
| C-02 | tools.ps1を読み込み | E-01 L11 | ○ |
| C-03 | 'setup'操作でCredProviderをインストール | E-01 L114-115 | ○ |
| C-04 | 'install-restore'操作でArcade SDKをリストア | E-01 L117-118 | ○ |
| C-05 | 不明なOperation時はエラー終了 | E-01 L120-122 | ○ |
| C-06 | installcredprovider.ps1をGitHubからダウンロード | E-01 L26, L29 | ○ |
| C-07 | CredProviderプラグインを%USERPROFILE%\.nuget\plugins\netcoreにインストール | E-01 L37 | ○ |
| C-08 | インストール失敗時はエラー終了 | E-01 L38-40 | ○ |
| C-09 | NuGet.configからdarc-int-*フィードを抽出 | E-01 L56 | ○ |
| C-10 | VSS_NUGET_EXTERNAL_FEED_ENDPOINTS環境変数を設定 | E-01 L69-72 | ○ |
| C-11 | NUGET_CREDENTIALPROVIDER_SESSIONTOKENCACHE_ENABLEDをFalseに設定 | E-01 L75-78 | ○ |
| C-12 | フィードなし時は情報ログ出力 | E-01 L82-83 | ○ |
| C-13 | .NET SDK 2.1.507を一時インストール | E-01 L89 | ○ |
| C-14 | restore.projを作成してArcade SDKリストア | E-01 L96-98 | ○ |
| C-15 | 一時ファイル・ディレクトリを削除 | E-01 L102-108 | ○ |
| C-16 | Write-LoggingCommandで環境変数設定 | E-01 L69, L75 | ○ |
| C-17 | 認証エンドポイントをJSON形式で構築 | E-01 L66 | ○ |
| C-18 | Select-XmlでNuGet.configを解析 | E-01 L56 | ○ |
| C-19 | エラー時にスタックトレースを出力 | E-01 L126 | ○ |
| C-20 | Push-Location/Pop-Locationでディレクトリ管理 | E-01 L112, L130 | ○ |
| C-21 | MSBuildバグ(#4430)のワークアラウンド | **外部Issue** | △ |
| C-22 | CredProviderの詳細仕様 | **外部ドキュメント** | △ |

## 4) 不足情報（Unknown / Missing）
- MSBuildバグ（https://github.com/microsoft/msbuild/issues/4430）の詳細：コメントで参照されているがIssueの内容は未確認
  - 候補：Microsoft/MSBuild GitHub Issue #4430
- CredProviderの詳細仕様：VSS_NUGET_EXTERNAL_FEED_ENDPOINTSの形式等
  - 候補：Microsoft artifacts-credprovider README / Azure DevOpsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理フローはソースコードから明確
- 1: 中リスク - 外部依存（CredProvider、MSBuildバグ）の詳細が外部参照

## 6) レビュアーチェックリスト（最小）
- [ ] CredProviderのインストール先パスがCI環境で適切か確認
- [ ] darc-int-*パターンがNuGet.configの実際の設定と一致するか確認
- [ ] .NET SDK 2.1.507が現在も利用可能か確認
- [ ] install-restore操作が現在も必要か確認（MSBuildバグの状況）
