---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：62-retain-build.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5秒以内**：具体的なSLA要件の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/retain-build.ps1` ソースコード（1-46行目）
- E-02: Paramブロック（2-7行目）
- E-03: `Get-AzDOHeaders` 関数定義（12-18行目）
- E-04: `Update-BuildRetention` 関数定義（20-42行目）
- E-05: API呼び出し処理（34-36行目）
- E-06: リクエストボディ定義（27-29行目）
- E-07: APIエンドポイントURL構築（31行目）
- E-08: エラーハンドリング（38-41行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | buildIdパラメータは必須の整数型 | E-02（3行目：[Parameter(Mandatory=$true)][int] $buildId） | ○ |
| C-02 | azdoOrgUriパラメータは必須の文字列型 | E-02（4行目） | ○ |
| C-03 | azdoProjectパラメータは必須の文字列型 | E-02（5行目） | ○ |
| C-04 | tokenパラメータは必須の文字列型 | E-02（6行目） | ○ |
| C-05 | Base64エンコードで認証ヘッダーを生成 | E-03（15-16行目：[Convert]::ToBase64String） | ○ |
| C-06 | Authorization: Basicヘッダーを設定 | E-03（16行目：$headers = @{"Authorization"="Basic $base64AuthInfo"}） | ○ |
| C-07 | keepForeverをtrueに設定するリクエストボディ | E-06（28行目："keepForever": "true"） | ○ |
| C-08 | API バージョン6.0を使用 | E-07（31行目：api-version=6.0） | ○ |
| C-09 | PATCHメソッドでリクエストを送信 | E-05（35行目：-Method Patch） | ○ |
| C-10 | Invoke-RestMethodでAPI呼び出し | E-05（35行目） | ○ |
| C-11 | 成功時にメッセージを出力 | E-04（36行目：Write-Host "Updated retention settings..."） | ○ |
| C-12 | 失敗時にexit 1で終了 | E-08（40行目：exit 1） | ○ |
| C-13 | 正常終了時にexit 0で終了 | E-01（45行目：exit 0） | ○ |
| C-14 | 目標処理時間は5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：処理時間の目標値は推測に基づく。実際のネットワークレイテンシーやAzure DevOps APIの応答時間に依存
  - 候補：Azure DevOps SLAドキュメント / 過去の実行ログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - スクリプトはシンプルで、コア機能はすべてソースコードから確認済み
- **0: 低リスク** - 46行の短いスクリプトであり、複雑なロジックがない

## 6) レビュアーチェックリスト（最小）
- [ ] Azure DevOps APIエンドポイントのURL形式が正しいか確認
- [ ] 必要なトークン権限（Build - Read & Execute以上）が記載されているか確認
- [ ] エラーメッセージが十分に詳細か確認
