---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-pipeline-logging-functions.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/pipeline-logging-functions.ps1` ソースコード（1-261行目）
- E-02: ソースファイルコメント（1行目：azure-pipelines-task-libからの派生）
- E-03: loggingCommandPrefixとエスケープマッピング定義（5-11行目）
- E-04: `Write-PipelineTelemetryError` 関数定義（16-40行目）
- E-05: `Write-PipelineTaskError` 関数定義（43-78行目）
- E-06: `Write-PipelineSetVariable` 関数定義（80-97行目）
- E-07: `Write-PipelinePrependPath` 関数定義（99-109行目）
- E-08: `Write-PipelineSetResult` 関数定義（111-123行目）
- E-09: `Format-LoggingCommandData` 関数定義（128-149行目）
- E-10: `Format-LoggingCommand` 関数定義（151-187行目）
- E-11: `Write-LoggingCommand` 関数定義（189-216行目）
- E-12: `Write-LogIssue` 関数定義（218-260行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | azure-pipelines-task-libから派生したスクリプト | E-02（1行目コメント） | ○ |
| C-02 | ##vso[形式のログコマンドを生成 | E-03（5行目：$script:loggingCommandPrefix = '##vso['） | ○ |
| C-03 | セミコロンを%3Bにエスケープ | E-03（7行目） | ○ |
| C-04 | \rを%0Dにエスケープ | E-03（8行目） | ○ |
| C-05 | \nを%0Aにエスケープ | E-03（9行目） | ○ |
| C-06 | ]を%5Dにエスケープ | E-03（10行目） | ○ |
| C-07 | Write-PipelineTelemetryErrorでカテゴリ付きエラー出力 | E-04（35行目：NETCORE_ENGINEERING_TELEMETRY=$Category） | ○ |
| C-08 | $ci変数でCI環境判定 | E-04（34行目：Test-Path variable:ci） | ○ |
| C-09 | -ForceスイッチでCI形式を強制 | E-04（34行目：$Force -Or ...） | ○ |
| C-10 | 非CI環境でエラーは赤色で出力 | E-05（60行目：Write-Host $Message -ForegroundColor Red） | ○ |
| C-11 | 非CI環境で警告は黄色で出力 | E-05（64行目：Write-Host $Message -ForegroundColor Yellow） | ○ |
| C-12 | Write-PipelineSetVariableで変数設定コマンドを出力 | E-06（91-95行目：Write-LoggingCommand -Area 'task' -Event 'setvariable'） | ○ |
| C-13 | IsMultiJobVariableのデフォルトは$true | E-06（88行目：[bool]$IsMultiJobVariable = $true） | ○ |
| C-14 | Secret変数の設定が可能 | E-06（93行目：'isSecret' = $Secret） | ○ |
| C-15 | Write-PipelinePrependPathでパス追加コマンドを出力 | E-07（107行目：Write-LoggingCommand -Area 'task' -Event 'prependpath'） | ○ |
| C-16 | Write-PipelineSetResultで結果設定コマンドを出力 | E-08（119-122行目：Write-LoggingCommand -Area 'task' -Event 'complete'） | ○ |
| C-17 | 結果はSucceeded/SucceededWithIssues/Failed/Cancelled/Skippedから選択 | E-08（114行目：ValidateSet） | ○ |
| C-18 | Format-LoggingCommandでコマンド文字列を構築 | E-10（162-186行目） | ○ |
| C-19 | Write-LogIssueでエラー/警告を出力 | E-12（231-237行目：Format-LoggingCommand -Area 'task' -Event 'logissue'） | ○ |
| C-20 | エラー時は赤/黒、警告時は黄/黒の背景色を使用 | E-12（243-257行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張がソースコードから確認できる。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能がソースコードから確認済み
- **0: 低リスク** - ライブラリスクリプトであり、直接実行されない

## 6) レビュアーチェックリスト（最小）
- [ ] 各関数のパラメータドキュメントが正確か確認
- [ ] Azure Pipelines ##vso[]コマンド形式が最新仕様と一致しているか確認
- [ ] エスケープ処理が完全か確認（TODOコメントに%のエスケープが未対応との記載あり）
