---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-pipeline-logging-functions.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/pipeline-logging-functions.sh` ソースコード（1-207行目）
- E-02: `Write-PipelineTelemetryError` 関数定義（3-40行目）
- E-03: `Write-PipelineTaskError` 関数定義（42-111行目）
- E-04: `Write-PipelineSetVariable` 関数定義（113-161行目）
- E-05: `Write-PipelinePrependPath` 関数定義（163-182行目）
- E-06: `Write-PipelineSetResult` 関数定義（184-206行目）
- E-07: 引数解析ループ（8-27行目、50-82行目など）
- E-08: CI環境判定（29行目：[[ "$ci" != true ]]）
- E-09: エスケープ処理（149-152行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Write-PipelineTelemetryErrorでカテゴリ付きエラー出力 | E-02（37行目：NETCORE_ENGINEERING_TELEMETRY=$telemetry_category） | ○ |
| C-02 | $ci変数でCI環境判定 | E-08（29行目：[[ "$ci" != true ]]） | ○ |
| C-03 | -forceオプションで強制出力 | E-02（16-17行目：-force処理、34-36行目） | ○ |
| C-04 | 非CI環境では標準エラー出力に出力 | E-02（30-31行目：echo "$message" >&2） | ○ |
| C-05 | Write-PipelineTaskErrorでtype/sourcepath/linenumber等のオプションをサポート | E-03（52-72行目：各オプションの解析） | ○ |
| C-06 | ##vso[task.logissue形式で出力 | E-03（89行目：local message="##vso[task.logissue"） | ○ |
| C-07 | typeのデフォルトはerror | E-03（43行目：local message_type="error"） | ○ |
| C-08 | Write-PipelineSetVariableで変数設定コマンドを出力 | E-04（154行目：##vso[task.setvariable variable=$name;...） | ○ |
| C-09 | シークレット変数の設定が可能 | E-04（135-137行目：-secret処理、154行目：isSecret=$secret） | ○ |
| C-10 | is_multi_job_variableのデフォルトはtrue | E-04（122行目：local is_multi_job_variable=true） | ○ |
| C-11 | セミコロンを%3Bにエスケープ | E-09（149行目：value=${value/;/%3B}） | ○ |
| C-12 | \rを%0Dにエスケープ | E-09（150行目：value=${value/\\r/%0D}） | ○ |
| C-13 | \nを%0Aにエスケープ | E-09（151行目：value=${value/\\n/%0A}） | ○ |
| C-14 | ]を%5Dにエスケープ | E-09（152行目：value=${value/]/%5D}） | ○ |
| C-15 | Write-PipelinePrependPathでPATH環境変数を更新 | E-05（177行目：export PATH="$prepend_path:$PATH"） | ○ |
| C-16 | Write-PipelinePrependPathで##vso[task.prependpath]コマンドを出力 | E-05（180行目：echo "##vso[task.prependpath]$prepend_path"） | ○ |
| C-17 | Write-PipelineSetResultで##vso[task.complete]コマンドを出力 | E-06（204行目：echo "##vso[task.complete result=$result;]$message"） | ○ |
| C-18 | 引数名は大文字小文字を区別しない | E-07（9行目、51行目：tr "[:upper:]" "[:lower:]"） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張がソースコードから確認できる。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能がソースコードから確認済み
- **0: 低リスク** - ライブラリスクリプトであり、直接実行されない

## 6) レビュアーチェックリスト（最小）
- [ ] PowerShell版との機能パリティを確認
- [ ] 各関数のパラメータオプションが正確か確認
- [ ] エスケープ処理がPowerShell版と一致しているか確認
