---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-symbols-validation.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/post-build/symbols-validation.ps1` ソースコード（1-338行目）
- E-02: Paramブロック（1-9行目）
- E-03: tools.ps1読み込み（11行目）
- E-04: 定数定義（12-24行目）
- E-05: 除外リスト読み込み（38-44行目）
- E-06: CountMissingSymbolsスクリプトブロック（46-214行目）
- E-07: 対象拡張子定義（66行目）
- E-08: ref除外処理（92-95行目）
- E-09: FirstMatchingSymbolDescriptionOrDefault（97-159行目）
- E-10: MSDLとSymWeb検証（170-179行目）
- E-11: リトライ処理（132行目：$using:MaxRetry）
- E-12: CheckJobResult関数（216-236行目）
- E-13: CheckSymbolsAvailable関数（238-305行目）
- E-14: Arcade-servicesパッケージ除外（254-264行目）
- E-15: 並列ジョブ制御（268-276行目）
- E-16: InstallDotnetSymbol関数（307-322行目）
- E-17: メイン処理（324-337行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPath、ExtractPath、DotnetSymbolVersionは必須パラメータ | E-02（2-4行目：[Parameter(Mandatory = $true)]） | ○ |
| C-02 | CheckForWindowsPdbsはオプションのスイッチ | E-02（5行目） | ○ |
| C-03 | ERROR_BADEXTRACT=-1、ERROR_FILEDOESNOTEXIST=-2を定義 | E-04（22-23行目） | ○ |
| C-04 | MaxParallelJobs=16 | E-04（13行目） | ○ |
| C-05 | MaxRetry=5 | E-04（16行目） | ○ |
| C-06 | 対象拡張子は.dll, .exe, .so, .dylib | E-07（66行目：$RelevantExtensions = @('.dll', '.exe', '.so', '.dylib')） | ○ |
| C-07 | \ref\パス内のファイルは除外 | E-08（92行目：if ($FileName -Match '\\ref\\')） | ○ |
| C-08 | MSDLとSymWebの両方でシンボル検索 | E-10（170-179行目：--microsoft-symbol-server、--internal-server） | ○ |
| C-09 | 最大5回のリトライ | E-11（132行目：while ($totalRetries -lt $using:MaxRetry)） | ○ |
| C-10 | PDB、NGen PDB、SO DBG、DYLIB DWARFに対応 | E-09（112-125行目） | ○ |
| C-11 | Microsoft.DotNet.Darc.*パッケージを除外 | E-14（255行目） | ○ |
| C-12 | Microsoft.DotNet.Maestro.Tasks.*パッケージを除外 | E-14（260行目） | ○ |
| C-13 | Issue #2457への参照あり | E-14（253行目：コメント） | ○ |
| C-14 | Start-Jobで並列処理 | E-15（268行目：Start-Job） | ○ |
| C-15 | 16ジョブ以上で待機 | E-15（272行目：while ($NumJobs -ge $MaxParallelJobs)） | ○ |
| C-16 | 10秒間隔でジョブ数をチェック | E-04（19行目：$SecondsBetweenLoadChecks = 10）、E-15（274行目） | ○ |
| C-17 | dotnet tool install でdotnet-symbolをインストール | E-16（320行目） | ○ |
| C-18 | グローバルインストール（--global） | E-16（320行目：--global） | ○ |
| C-19 | InputPath不在時は正常終了（ExitWithExitCode 0） | E-01（32-35行目） | ○ |
| C-20 | SymbolExclusionFileでHashSetに除外リストを読み込み | E-05（38-44行目） | ○ |
| C-21 | CheckSymbolsカテゴリでテレメトリエラーを報告 | E-12（222行目）、E-13（293-297行目） | ○ |
| C-22 | Clean指定時に展開ディレクトリを削除 | E-06（204-206行目：if ($using:Clean)） | ○ |
| C-23 | 成功時に"All symbols validated!"を出力 | E-13（303行目） | ○ |
| C-24 | 失敗時に"Symbols missing for X/Y packages"を出力 | E-13（293行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張がソースコードから確認できる。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能がソースコードから確認済み
- **1: 中リスク** - 外部シンボルサーバー（MSDL、SymWeb）への依存があり、サーバー障害時に影響を受ける可能性

## 6) レビュアーチェックリスト（最小）
- [ ] dotnet-symbolのバージョン指定が正しいか確認
- [ ] シンボル除外ファイルの形式が正しく記述されているか確認
- [ ] 並列ジョブ数（16）が適切か確認
- [ ] Arcade-servicesパッケージ除外の必要性が現在も有効か確認
