---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-sourcelink-validation.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/post-build/sourcelink-validation.ps1` ソースコード（1-328行目）
- E-02: Paramブロック（1-7行目）
- E-03: 定数定義（22-32行目）
- E-04: ValidatePackageスクリプトブロック（38-204行目）
- E-05: 対象拡張子定義（56行目）
- E-06: .resources.dll除外処理（80-85行目）
- E-07: ValidateFileネスト関数（89-178行目）
- E-08: sourcelink print-urls実行（98行目）
- E-09: HTTP URL正規表現抽出（104行目）
- E-10: サブモジュールスキップ処理（124-126行目）
- E-11: GitHub/GitHubUserContentホスト判定（127行目）
- E-12: HTTP HEADリクエスト（129行目）
- E-13: リトライ処理（118-169行目）
- E-14: ValidateSourceLinkLinks関数（219-294行目）
- E-15: GHRepoNameフォーマット検証（220-228行目）
- E-16: GHCommitフォーマット検証（230-233行目）
- E-17: GitHub APIファイルツリー取得（236-254行目）
- E-18: 並列ジョブ制御（266-283行目）
- E-19: InstallSourcelinkCli関数（296-311行目）
- E-20: メイン処理（313-327行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InputPath、ExtractPath、SourcelinkCliVersionは必須 | E-02（2,3,6行目：[Parameter(Mandatory=$true)]） | ○ |
| C-02 | GHRepoNameとGHCommitはオプション | E-02（4,5行目：[Parameter(Mandatory=$false)]） | ○ |
| C-03 | MaxParallelJobs=16 | E-03（25行目） | ○ |
| C-04 | MaxRetries=5 | E-03（27行目） | ○ |
| C-05 | RetryWaitTimeInSeconds=30 | E-03（28行目） | ○ |
| C-06 | SecondsBetweenLoadChecks=10 | E-03（31行目） | ○ |
| C-07 | 対象拡張子は.dll, .exe, .pdb | E-05（56行目：$RelevantExtensions = @('.dll', '.exe', '.pdb')） | ○ |
| C-08 | .resources.dllは除外 | E-06（80行目：if ($FileName.EndsWith('.resources.dll'))） | ○ |
| C-09 | sourcelink print-urlsでURLを抽出 | E-08（98行目：& $sourcelinkExe print-urls $FullPath） | ○ |
| C-10 | HTTP(S)のURLを正規表現で抽出 | E-09（104行目：'(http[s]?)(:\/\/)([^\s,]+)'） | ○ |
| C-11 | サブモジュールリンクはスキップ | E-10（123行目：if ($Link -match "submodules")） | ○ |
| C-12 | GitHubまたはGitHubUserContentホストのみ検証 | E-11（127行目：$Uri.Host -match 'github' -or $Uri.Host -match 'githubusercontent'） | ○ |
| C-13 | HTTP HEADリクエストでアクセス可能性を検証 | E-12（129行目：Invoke-WebRequest -Uri $Link -UseBasicParsing -Method HEAD） | ○ |
| C-14 | 5回リトライ、30秒間隔 | E-13（118行目：while ($attempts -lt $using:MaxRetries)、150行目：Start-Sleep） | ○ |
| C-15 | GHRepoNameは<org>/<repo>または<org>-<repo>形式 | E-15（220-228行目：正規表現検証と変換） | ○ |
| C-16 | GHCommitは40文字16進数 | E-16（230行目：'^[0-9a-fA-F]{40}$'） | ○ |
| C-17 | GitHub API（git/trees）でファイルツリー取得 | E-17（236行目：$RepoTreeURL） | ○ |
| C-18 | コード拡張子（.cs, .vb, .fs等）のファイルをキャッシュ | E-17（237行目：$CodeExtensions、246-248行目：HashMapに格納） | ○ |
| C-19 | *.symbols.nupkgパターンでパッケージを検索 | E-18（266行目："$InputPath\*.symbols.nupkg"） | ○ |
| C-20 | Start-Jobで並列処理 | E-18（269行目：Start-Job） | ○ |
| C-21 | dotnet tool install --globalでsourcelinkをインストール | E-19（309行目） | ○ |
| C-22 | SourceLinkカテゴリでテレメトリエラーを報告 | E-04（198行目）、E-14（291行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張がソースコードから確認できる。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能がソースコードから確認済み
- **1: 中リスク** - 外部API（GitHub）への依存があり、API制限やサーバー障害時に影響を受ける可能性

## 6) レビュアーチェックリスト（最小）
- [ ] sourcelink CLIのバージョン指定が正しいか確認
- [ ] GitHub APIのレート制限への考慮が適切か確認
- [ ] サブモジュール処理の現状が正しく記述されているか確認
- [ ] リトライ間隔（30秒）が適切か確認
