---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-publish-using-darc.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/post-build/publish-using-darc.ps1` ソースコード（1-72行目）
- E-02: Paramブロック（1-13行目）
- E-03: 環境設定（18-21行目）
- E-04: Darc取得（23行目）
- E-05: オプションパラメータ構築（25-47行目）
- E-06: darcコマンド実行（49-58行目）
- E-07: 終了コード確認（60-63行目）
- E-08: 例外処理（67-70行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildId、PublishingInfraVersion、AzdoToken、WaitPublishingFinishは必須 | E-02（2-6行目：[Parameter(Mandatory=$true)]） | ○ |
| C-02 | MaestroApiEndPointのデフォルトはhttps://maestro.dot.net | E-02（5行目） | ○ |
| C-03 | $ci = $trueを強制設定 | E-03（18行目） | ○ |
| C-04 | $disableConfigureToolsetImport = $trueを設定 | E-03（19行目） | ○ |
| C-05 | Get-Darc関数でDarcを取得 | E-04（23行目：$darc = Get-Darc） | ○ |
| C-06 | ArtifactsPublishingAdditionalParameters指定時に--artifact-publishing-parameters追加 | E-05（27-30行目） | ○ |
| C-07 | SymbolPublishingAdditionalParameters指定時に--symbol-publishing-parameters追加 | E-05（32-35行目） | ○ |
| C-08 | WaitPublishingFinish="false"時に--no-wait追加 | E-05（37-39行目） | ○ |
| C-09 | RequireDefaultChannels="true"時に--default-channels-required追加 | E-05（41-43行目） | ○ |
| C-10 | SkipAssetsPublishing="true"時に--skip-assets-publishing追加 | E-05（45-47行目） | ○ |
| C-11 | darc add-build-to-channelコマンドを実行 | E-06（49行目） | ○ |
| C-12 | --id $buildIdオプション | E-06（50行目） | ○ |
| C-13 | --default-channelsオプション | E-06（52行目） | ○ |
| C-14 | --source-branch mainがハードコード | E-06（53行目） | ○ |
| C-15 | --ci --verboseオプション | E-06（56-57行目） | ○ |
| C-16 | LastExitCode非0でexit 1 | E-07（60-63行目） | ○ |
| C-17 | 成功時に"done."出力 | E-01（65行目） | ○ |
| C-18 | PromoteBuildカテゴリでテレメトリエラーを報告 | E-08（69行目：-Category 'PromoteBuild'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張がソースコードから確認できる。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての機能がソースコードから確認済み
- **1: 中リスク** - 外部サービス（Maestro）への依存があり、サービス障害時に影響を受ける可能性
- **1: 中リスク** - --source-branch mainがハードコードされており、他ブランチでの使用時に問題が発生する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Darcコマンドのパラメータが最新のdarc CLIと一致しているか確認
- [ ] --source-branch mainのハードコードが要件に合致しているか確認
- [ ] MaestroApiEndPointのデフォルト値が現在も有効か確認
- [ ] 必須パラメータと任意パラメータの区分けが正しいか確認
