---
generated_at: 2026-02-10 14:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：72-build-rootfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **ディスク使用量**：具体的なサイズは推測に基づく
  2. **処理時間**：環境依存のため正確な値は未確認
  3. **GPGキーの有効期限**：ハードコードされたキーの有効性確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/cross/build-rootfs.sh` - メインスクリプト
- E-02: スクリプト内usage関数（5-22行目）
- E-03: スクリプト内アーキテクチャ定義（24-37行目）
- E-04: スクリプト内パッケージ定義（39-131行目）
- E-05: スクリプト内AlpineキーのBase64データ（114-131行目）
- E-06: スクリプト内引数解析ループ（140-424行目）
- E-07: スクリプト内Alpine処理（498-568行目）
- E-08: スクリプト内FreeBSD処理（569-597行目）
- E-09: スクリプト内illumos処理（598-677行目）
- E-10: スクリプト内Haiku処理（678-758行目）
- E-11: スクリプト内Debian/Ubuntu処理（759-829行目）
- E-12: スクリプト内Tizen処理（830-831行目）
- E-13: スクリプト内rootfs削除処理（475-480行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトアーキテクチャはarm | E-03（__BuildArch=arm） | ○ |
| C-02 | デフォルトコード名はxenial | E-03（__CodeName=xenial） | ○ |
| C-03 | サポートアーキテクチャ一覧 | E-02（usage関数） | ○ |
| C-04 | Alpine用のGPGキーがハードコード | E-05（__AlpineKeys変数） | ○ |
| C-05 | --skipunmountオプション | E-06（case文） | ○ |
| C-06 | --skipsigcheckオプション | E-06（case文） | ○ |
| C-07 | --skipemulationオプション | E-06（case文） | ○ |
| C-08 | --rootfsdirオプション | E-06（case文） | ○ |
| C-09 | --use-mirrorオプション | E-06（case文） | ○ |
| C-10 | Alpine処理でapk-toolsを使用 | E-07（apk.static） | ○ |
| C-11 | FreeBSD処理でpkgをビルド | E-08（autogen.sh && configure && make） | ○ |
| C-12 | illumos処理でgccとbinutilsをビルド | E-09（binutils/gcc configure && make） | ○ |
| C-13 | Haiku処理でhpkgを使用 | E-10（package extract） | ○ |
| C-14 | Debian/Ubuntu処理でdebootstrapを使用 | E-11（debootstrap） | ○ |
| C-15 | --skipemulation時はinstall-debs.pyを使用 | E-11（$PYTHON "$__CrossDir/install-debs.py"） | ○ |
| C-16 | Tizen処理はtizen-build-rootfs.shを呼び出す | E-12 | ○ |
| C-17 | 既存rootfsはアンマウントして削除 | E-13（umount && rm -rf） | ○ |
| C-18 | ROOTFS_DIR環境変数でパス指定可能 | E-01（467-469行目） | ○ |
| C-19 | wgetまたはcurlが必要 | E-01（ensureDownloadTool関数） | ○ |
| C-20 | ディスク使用量は数百MB〜数GB | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）

- ディスク使用量について：実際にrootfsを構築した結果のサイズ測定が必要
  - 候補：実行結果のログ / CI環境での実行記録

## 5) リスクフラグ（レビュー観点）

- 0: コマンドラインオプション（ソースコードから明確に確認可能）
- 0: サポートアーキテクチャ（usage関数とcase文で確認可能）
- 1: GPGキーの有効期限（ハードコードされたキーの更新が必要な場合あり）
- 0: 処理フロー（各ディストリビューション別の処理が明確）
- 1: パフォーマンス要件（環境依存の推測値）

## 6) レビュアーチェックリスト（最小）

- [ ] 新しいLinuxディストリビューションバージョンへの対応状況確認
- [ ] Alpine GPGキーの有効期限確認
- [ ] FreeBSD/illumosのビルドツールバージョン確認
- [ ] install-debs.pyの動作確認（--skipemulationオプション使用時）
- [ ] 各アーキテクチャでの実行テスト
