---
generated_at: 2026-02-10 14:34:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-build-android-rootfs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **NDKバージョン互換性**：新しいNDKバージョンでの動作確認推奨
  2. **Termuxリポジトリ安定性**：外部リポジトリへの依存
  3. **APIレベル対応状況**：最新Androidバージョンへの対応確認

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/cross/build-android-rootfs.sh` - メインスクリプト
- E-02: スクリプト内usage関数（5-22行目）
- E-03: スクリプト内デフォルト値定義（3, 24-27行目）
- E-04: スクリプト内引数解析ループ（29-64行目）
- E-05: スクリプト内NDKバージョン処理（66-72行目）
- E-06: スクリプト内ディレクトリ設定（86-96行目）
- E-07: スクリプト内NDKダウンロード処理（105-110行目）
- E-08: スクリプト内LLDBダウンロード処理（112-117行目）
- E-09: スクリプト内依存パッケージ定義（124-128行目）
- E-10: スクリプト内Termuxパッケージ取得（130-137行目）
- E-11: スクリプト内sysrootコピー（139行目）
- E-12: スクリプト内android_platform生成（143行目）
- E-13: スクリプト内完了メッセージ（145-146行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトNDKバージョンはr21 | E-03（__NDK_Version=r21） | ○ |
| C-02 | デフォルトAPIレベルは28 | E-03（__ApiLevel=28） | ○ |
| C-03 | デフォルトアーキテクチャはarm64 | E-03（__BuildArch=arm64） | ○ |
| C-04 | arm64とarmのアーキテクチャをサポート | E-04（case文） | ○ |
| C-05 | --ndkオプションでNDKバージョン指定可能 | E-04（--ndk case） | ○ |
| C-06 | r21/r22とその他でファイル構造が異なる | E-05（if条件分岐） | ○ |
| C-07 | TOOLCHAIN_DIR環境変数でパス指定可能 | E-06（if文） | ○ |
| C-08 | NDK_DIR環境変数でNDKパス指定可能 | E-06（if文） | ○ |
| C-09 | dl.google.comからNDKをダウンロード | E-07（URL） | ○ |
| C-10 | dl.google.comからLLDBをダウンロード | E-08（URL） | ○ |
| C-11 | 依存パッケージはlibicu, libandroid-glob, liblzma, krb5, openssl | E-09（__AndroidPackages） | ○ |
| C-12 | packages.termux.devからパッケージ取得 | E-10（wget URL） | ○ |
| C-13 | dpkgでパッケージを展開 | E-10（dpkg -x） | ○ |
| C-14 | sysroot/usr/にパッケージ内容をコピー | E-11（cp -R） | ○ |
| C-15 | android_platformにRID=android.{ApiLevel}-{BuildArch}を出力 | E-12（echo "RID=..."） | ○ |
| C-16 | 完了時にビルドコマンド例を表示 | E-13（echo） | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: デフォルト値（ソースコードから明確に確認可能）
- 0: 処理フロー（各ステップが順序通りに実装）
- 1: 外部依存（Termuxリポジトリの可用性に依存）
- 1: NDKバージョン対応（新しいNDKへの対応が必要な場合あり）
- 0: パラメータ仕様（ソースコードから確認可能）

## 6) レビュアーチェックリスト（最小）

- [ ] 最新NDKバージョン（r25以降）での動作確認
- [ ] Termux-21リポジトリの可用性確認
- [ ] 最新Android APIレベルでのテスト
- [ ] arm64/arm両アーキテクチャでのビルドテスト
- [ ] 生成されたsysrootを使用したクロスコンパイルの動作確認
