---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：76-common-library

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **Write-PipelineTelemetryError関数**：外部関数の存在確認
  2. **tarコマンドの互換性**：異なるOS間での動作確認
  3. **シムスクリプトの動作**：引数転送の正確性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/native/common-library.sh` - メインスクリプト
- E-02: GetNativeInstallDirectory関数（3-14行目）
- E-03: GetTempDirectory関数（16-20行目）
- E-04: ExpandZip関数（22-53行目）
- E-05: GetCurrentOS関数（55-62行目）
- E-06: GetFile関数（64-95行目）
- E-07: GetTempPathFileName関数（97-104行目）
- E-08: DownloadAndExtract関数（106-133行目）
- E-09: NewScriptShim関数（135-171行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NETCOREENG_INSTALL_DIRECTORYが未設定の場合は$HOME/.netcoreeng/native/を使用 | E-02（if条件） | ○ |
| C-02 | GetTempDirectoryはインストールディレクトリ+temp/を返す | E-03 | ○ |
| C-03 | ExpandZipはforce=falseで既存ディレクトリをスキップ | E-04（if条件） | ○ |
| C-04 | ExpandZipはtarコマンドで展開 | E-04（tar -xf） | ○ |
| C-05 | GetCurrentOSはLinuxとDarwin（MacOS）を検出 | E-05（case文） | ○ |
| C-06 | GetFileはデフォルトでリトライ5回 | E-06（download_retries=${4:-5}） | ○ |
| C-07 | GetFileはデフォルトでリトライ間隔30秒 | E-06（retry_wait_time_seconds=${5:-30}） | ○ |
| C-08 | GetFileはcurlを優先して使用 | E-06（if command -v curl） | ○ |
| C-09 | GetFileはcurlがなければwgetを使用 | E-06（else wget） | ○ |
| C-10 | GetFileはforce=trueで既存ファイルを削除 | E-06（rm -rf $path） | ○ |
| C-11 | GetFileはローカルファイルパスの場合コピーを行う | E-06（cp $uri $path） | ○ |
| C-12 | DownloadAndExtractはGetFileとExpandZipを組み合わせる | E-08 | ○ |
| C-13 | NewScriptShimはforce=falseで既存シムをスキップ | E-09（if条件） | ○ |
| C-14 | NewScriptShimはファイルが見つからない場合小文字パスを試行 | E-09（tr "[:upper:]" "[:lower:]"） | ○ |
| C-15 | NewScriptShimは生成したシムにchmod +xを実行 | E-09（chmod +x） | ○ |
| C-16 | シムスクリプトは#!/usr/bin/env bashで始まる | E-09（shim_contents） | ○ |
| C-17 | 失敗時はWrite-PipelineTelemetryErrorを呼び出す | E-04, E-06, E-08, E-09 | ○ |
| C-18 | curlは--retryオプションでリトライを実行 | E-06（--retry $download_retries） | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 関数インターフェース（ソースコードから明確に確認可能）
- 0: デフォルト値（ソースコードに明示的に記載）
- 1: Write-PipelineTelemetryError関数（外部定義の関数、別スクリプトで定義）
- 0: ダウンロード処理（curl/wget両方に対応）
- 0: シム生成処理（実装が明確）

## 6) レビュアーチェックリスト（最小）

- [ ] Write-PipelineTelemetryError関数の定義場所確認
- [ ] MacOSでのtar動作確認（-xfオプション）
- [ ] シムスクリプトの引数転送動作確認
- [ ] NETCOREENG_INSTALL_DIRECTORYの権限確認
- [ ] curlとwgetの両方でのダウンロード動作確認
