---
generated_at: 2026-02-10 14:48:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：80-install-cmake

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **CMakeアーカイブURL**：ベースURLの可用性確認
  2. **ARM64サポート**：x86_64のみのサポート確認
  3. **シム上書き動作**：force=trueの影響確認

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/native/install-cmake.sh` - メインスクリプト
- E-02: common-library.shのsource（6行目）
- E-03: 変数初期化（8-14行目）
- E-04: 引数解析ループ（16-62行目）
- E-05: パス計算処理（64-72行目）
- E-06: クリーン処理（75-93行目）
- E-07: 既存インストール確認（96-99行目）
- E-08: DownloadAndExtract呼び出し（101-105行目）
- E-09: NewScriptShim呼び出し（109-114行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | common-library.shをsourceする | E-02（. $scriptroot/common-library.sh） | ○ |
| C-02 | デフォルトリトライ回数は5 | E-03（download_retries=5） | ○ |
| C-03 | デフォルトリトライ間隔は30秒 | E-03（retry_wait_time_seconds=30） | ○ |
| C-04 | --baseuriオプション対応 | E-04（case --baseuri） | ○ |
| C-05 | --installpathオプション対応 | E-04（case --installpath） | ○ |
| C-06 | --versionオプション対応 | E-04（case --version） | ○ |
| C-07 | --cleanオプション対応 | E-04（case --clean） | ○ |
| C-08 | --forceオプション対応 | E-04（case --force） | ○ |
| C-09 | GetCurrentOSでOS検出 | E-05（tool_os=$(GetCurrentOS)） | ○ |
| C-10 | アーキテクチャはx86_64固定 | E-05（tool_arch="x86_64"） | ○ |
| C-11 | --clean時はディレクトリを削除 | E-06（rm -rf） | ○ |
| C-12 | 既存インストール時はforce=falseならスキップ | E-07（if条件） | ○ |
| C-13 | DownloadAndExtractでダウンロード・展開 | E-08 | ○ |
| C-14 | NewScriptShimでシム生成（force=true） | E-09（NewScriptShim $shim_path $tool_file_path true） | ○ |
| C-15 | 失敗時はWrite-PipelineTelemetryErrorを呼び出す | E-08, E-09 | ○ |
| C-16 | シムパスはinstallpath/cmake.sh | E-05（shim_path） | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: オプション処理（ソースコードから明確に確認可能）
- 0: ダウンロード処理（common-library.shの関数を使用）
- 1: CMakeアーカイブURL（外部リソースへの依存）
- 1: x86_64限定（ARM64環境での動作制限）
- 0: シム生成（force=trueで常に上書き）

## 6) レビュアーチェックリスト（最小）

- [ ] 指定されるベースURLの可用性確認
- [ ] CMakeの各バージョンでの動作確認
- [ ] Linux/MacOS両環境での動作確認
- [ ] --cleanオプションの動作確認
- [ ] シムスクリプトからのCMake実行確認
- [ ] ARM64環境での制限事項の文書化確認
