---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：81-install-cmake-test.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な時間はコードから読み取れない
  2. **x86_64固定**：コードで確認できるがプラットフォーム拡張可能性は不明
  3. **CI/CDでの使用目的**：コード内コメントからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/install-cmake-test.sh` 行1-117
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行82
- E-03: `eng/common/native/common-library.sh` （参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | baseuri、installpath、version等の引数をパースする | E-01 行16-62 | ○ |
| C-02 | デフォルトのdownload_retriesは5 | E-01 行13 | ○ |
| C-03 | デフォルトのretry_wait_time_secondsは30 | E-01 行14 | ○ |
| C-04 | --cleanオプションで既存インストールを削除 | E-01 行75-93 | ○ |
| C-05 | --forceなしで既存インストールがある場合スキップ | E-01 行96-99 | ○ |
| C-06 | DownloadAndExtract関数でアーカイブを取得・展開 | E-01 行101 | ○ |
| C-07 | NewScriptShim関数でシムスクリプトを生成 | E-01 行110 | ○ |
| C-08 | tool_archはx86_64固定 | E-01 行67 | ○ |
| C-09 | 失敗時はexit 1で終了 | E-01 行103-106, 112-115 | ○ |
| C-10 | common-library.shをソースとして読み込む | E-01 行6 | ○ |
| C-11 | Write-PipelineTelemetryErrorでエラー出力 | E-01 行104, 113 | ○ |
| C-12 | tar.gz形式のアーカイブを使用 | E-01 行72 | ○ |
| C-13 | CMakeインストールテスト用スクリプト | E-02 | ○ |
| C-14 | ツール名はcmake-test | E-01 行64 | ○ |
| C-15 | 目標処理時間は数分以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間はコードに明示されておらず、経験則に基づく推定
  - 候補：パフォーマンステスト結果 / CI実行ログ / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ仕様は明確
- 0: 低リスク - エラー処理は適切に実装
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] common-library.shの関数仕様との整合性確認
- [ ] パフォーマンス要件の妥当性確認
- [ ] エラーメッセージの内容が運用上十分か確認
