---
generated_at: 2026-02-10 14:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-install-dependencies.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/install-dependencies.sh` 行1-65
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行83
- E-03: `eng/common/native/init-os-and-arch.sh` （参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OS引数がない場合init-os-and-arch.shを実行 | E-01 行13-15 | ○ |
| C-02 | /etc/os-releaseからディストリビューション情報を取得 | E-01 行19-21 | ○ |
| C-03 | Debian系でaptを使用 | E-01 行23-29 | ○ |
| C-04 | Fedora/RHEL系でdnf/tdnfを使用 | E-01 行30-32 | ○ |
| C-05 | Alpine系でapkを使用 | E-01 行35-36 | ○ |
| C-06 | macOSでHomebrewを使用 | E-01 行43-57 | ○ |
| C-07 | 未サポートディストリビューションでexit 1 | E-01 行37-40 | ○ |
| C-08 | 未サポートプラットフォームでexit 1 | E-01 行60-63 | ○ |
| C-09 | Debian系でlocaledefを実行 | E-01 行29 | ○ |
| C-10 | Debian系パッケージリスト | E-01 行26-27 | ○ |
| C-11 | Fedora/RHEL系パッケージリスト | E-01 行32 | ○ |
| C-12 | Alpine系パッケージリスト | E-01 行36 | ○ |
| C-13 | macOSパッケージリスト | E-01 行50-56 | ○ |
| C-14 | set -e でエラー時即座に終了 | E-01 行3 | ○ |
| C-15 | Amazon Linuxをサポート | E-01 行33-34 | ○ |
| C-16 | Azure Linuxをサポート | E-01 行30 | ○ |
| C-17 | iOS/tvOS系をmacOSと同様に処理 | E-01 行43 | ○ |
| C-18 | HOMEBREW_NO_INSTALL_CLEANUPを設定 | E-01 行46 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローはコードと完全に一致
- 0: 低リスク - パッケージリストはコードから直接抽出
- 0: 低リスク - エラー処理も明確に定義

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージリストが最新のビルド要件を満たしているか確認
- [ ] 新しいLinuxディストリビューションの追加が必要ないか確認
- [ ] macOSのbrew bundleが最新のHomebrewと互換性があるか確認
