---
generated_at: 2026-02-10 14:34:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-install-tool.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/native/install-tool.ps1` 行1-133
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行84
- E-03: `eng/common/native/CommonLibrary.psm1` （参照のみ）
- E-04: `eng/common/pipeline-logging-functions.ps1` （参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToolName、InstallPath、BaseUri、Versionは必須パラメータ | E-01 行35-41 | ○ |
| C-02 | デフォルトのDownloadRetriesは5 | E-01 行45 | ○ |
| C-03 | デフォルトのRetryWaitTimeInSecondsは30 | E-01 行46 | ○ |
| C-04 | pipeline-logging-functions.ps1をドットソース | E-01 行49 | ○ |
| C-05 | CommonLibrary.psm1をインポート | E-01 行52 | ○ |
| C-06 | Get-MachineArchitectureでアーキテクチャ検出 | E-01 行58 | ○ |
| C-07 | x32の場合win32、それ以外はwin64 | E-01 行59-62 | ○ |
| C-08 | -Cleanで既存インストールを削除 | E-01 行68-83 | ○ |
| C-09 | 既存インストールあり&Force未指定でスキップ | E-01 行86-88 | ○ |
| C-10 | DownloadAndExtract関数でダウンロード・展開 | E-01 行90-95 | ○ |
| C-11 | インストール失敗時にexit 1 | E-01 行97-100 | ○ |
| C-12 | Get-ChildItemで再帰的にexeを検索 | E-01 行103 | ○ |
| C-13 | 複数exeでエラー | E-01 行104-106 | ○ |
| C-14 | exeなしでエラー | E-01 行107-109 | ○ |
| C-15 | New-ScriptShim関数でシム生成 | E-01 行114-119 | ○ |
| C-16 | シム生成失敗でreturn 1 | E-01 行121-124 | ○ |
| C-17 | catchでスタックトレース出力 | E-01 行129 | ○ |
| C-18 | Write-PipelineTelemetryErrorでエラー出力 | E-01 行98, 123, 130 | ○ |
| C-19 | URI形式が$BaseUri/windows/$ToolName/$ToolNameMoniker.zip | E-01 行65 | ○ |
| C-20 | ZIP形式のアーカイブを使用 | E-01 行65 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ仕様はコードと完全一致
- 0: 低リスク - エラー処理は網羅的に実装
- 0: 低リスク - ログ出力も適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] CommonLibrary.psm1の関数仕様との整合性確認
- [ ] Azure Blob StorageのURL構造が正しいか確認
- [ ] シム生成のセキュリティ考慮が十分か確認
