---
generated_at: 2026-02-10 14:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-generate-locproject.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/generate-locproject.ps1` 行1-227
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行85
- E-03: OneLocBuild ドキュメント URL（コメント参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourcesDirectoryは必須パラメータ | E-01 行2 | ○ |
| C-02 | デフォルトのLanguageSetはVS_Main_Languages | E-01 行3 | ○ |
| C-03 | LocExclusions.jsonから除外設定を読み込む | E-01 行15-20 | ○ |
| C-04 | .template.config/localize/*.en.jsonパターンでファイル検索 | E-01 行26 | ○ |
| C-05 | en/strings.jsonパターンでWinFormsファイル検索 | E-01 行34 | ○ |
| C-06 | WXLファイルをスキーマでV3/V5に分類 | E-01 行46-57 | ○ |
| C-07 | en.lproj/*.htmlパターンでmacOSファイル検索 | E-01 行60 | ○ |
| C-08 | XLFファイルを言語コード付きで検索 | E-01 行71-83 | ○ |
| C-09 | 4つのプロジェクトセクションを生成 | E-01 行87-203 | ○ |
| C-10 | ConvertTo-Jsonで深さ5のネストを処理 | E-01 行206 | ○ |
| C-11 | UseCheckedInLocProjectJsonで比較モード | E-01 行210-226 | ○ |
| C-12 | ハッシュ比較で差分検出 | E-01 行218 | ○ |
| C-13 | 不一致時にWrite-PipelineTelemetryError | E-01 行219 | ○ |
| C-14 | WiX V3用にwxl_loc.lss使用 | E-01 行127 | ○ |
| C-15 | WiX V5用にP210WxlSchemaV4.lss使用 | E-01 行152 | ○ |
| C-16 | macOS用にP22DotNetHtmlLocalization.lss使用 | E-01 行177 | ○ |
| C-17 | WiX_CloneLanguagesをCloneLanguageSetに使用 | E-01 行126, 151 | ○ |
| C-18 | VS_macOS_CloneLanguagesをmacOS用に使用 | E-01 行176 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイルパターンはコードから直接抽出
- 0: 低リスク - LocProject構造はコードと完全一致
- 1: 中リスク - OneLocBuildタスクとの互換性は外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] サポートするファイルパターンが最新要件を満たしているか確認
- [ ] OneLocBuildタスクのバージョンとの互換性確認
- [ ] 言語セット設定がローカリゼーション要件と一致しているか確認
