---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-enable-preview-sdks.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/enable-preview-sdks.ps1` 行1-7
- E-02: `eng/build-utils.ps1` 行273-288（EnablePreviewSdks関数）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行87

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Set-StrictMode -version 2.0を設定 | E-01 行1 | ○ |
| C-02 | ErrorActionPreference="Stop"を設定 | E-01 行2 | ○ |
| C-03 | build-utils.ps1をドットソース | E-01 行4 | ○ |
| C-04 | EnablePreviewSdks関数を呼び出す | E-01 行6 | ○ |
| C-05 | LocateVisualStudioでVSインスタンスを検出 | E-02 行274 | ○ |
| C-06 | VS未検出時にスキップメッセージを出力 | E-02 行277 | ○ |
| C-07 | インスタンスIDを取得 | E-02 行281 | ○ |
| C-08 | メジャーバージョンを取得 | E-02 行282 | ○ |
| C-09 | 設定ディレクトリパスを構築 | E-02 行284 | ○ |
| C-10 | Create-Directoryでディレクトリ作成 | E-02 行285 | ○ |
| C-11 | sdk.txtにUsePreviews=Trueを書き込む | E-02 行288 | ○ |
| C-12 | 設定時に書き込み先をログ出力 | E-02 行287 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フローは明確
- 1: 中リスク - LocateVisualStudio関数の詳細は別ファイルに定義
- 0: 低リスク - 設定ファイルの内容は固定

## 6) レビュアーチェックリスト（最小）
- [ ] LocateVisualStudio関数が正しくVSを検出するか確認
- [ ] 複数のVSインスタンスがある場合の動作確認
- [ ] VS再起動後に設定が反映されるか確認
