---
generated_at: 2026-02-10 14:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：87-findibc.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：コードから読み取れない推測値
  2. **Pop-Locationの問題**：対応するPush-Locationがない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/findibc.ps1` 行1-40
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行88

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | intermediateAssemblyパラメータを受け取る | E-01 行3 | ○ |
| C-02 | ibcRootFolderパラメータを受け取る | E-01 行4 | ○ |
| C-03 | Path.GetFileNameでアセンブリ名抽出 | E-01 行7 | ○ |
| C-04 | Path.GetFullPathでパス正規化 | E-01 行8 | ○ |
| C-05 | Directory.Existsで存在確認 | E-01 行9 | ○ |
| C-06 | フォルダ不在時に空文字を返す | E-01 行11 | ○ |
| C-07 | DirectoryInfoで再帰検索 | E-01 行14 | ○ |
| C-08 | SingleOrDefaultで単一ファイル取得 | E-01 行14 | ○ |
| C-09 | DLL未発見時に空文字を返す | E-01 行15-17 | ○ |
| C-10 | *.ibcパターンでIBCファイル列挙 | E-01 行20 | ○ |
| C-11 | スペース区切りでパス結合 | E-01 行27 | ○ |
| C-12 | catchブロックでエラー出力 | E-01 行31-34 | ○ |
| C-13 | finallyでPop-Location実行 | E-01 行37-38 | ○ |
| C-14 | 目標処理時間は100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間はコードに明示されておらず、経験則に基づく推定
  - 候補：パフォーマンステスト結果 / ベンチマーク / 要件定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル検索ロジックは明確
- 1: 中リスク - Pop-LocationにPush-Locationが対応していない可能性
- 0: 低リスク - エラー処理は適切

## 6) レビュアーチェックリスト（最小）
- [ ] Pop-Locationの必要性を確認（対応するPush-Locationがあるか）
- [ ] SingleOrDefaultで複数DLLがマッチした場合の動作確認
- [ ] IBCファイルの想定フォーマットが正しいか確認
