---
generated_at: 2026-02-10 14:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-vscode-build.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/vscode-build.ps1` 行1-26
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行90
- E-03: `eng/build-utils.ps1` （参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | filePathは必須パラメータ | E-01 行2 | ○ |
| C-02 | msbuildEngineのデフォルトは"vs" | E-01 行3 | ○ |
| C-03 | frameworkのデフォルトは空文字 | E-01 行4 | ○ |
| C-04 | Set-StrictMode -version 3.0を使用 | E-01 行7 | ○ |
| C-05 | ErrorActionPreference = "Stop" | E-01 行8 | ○ |
| C-06 | build-utils.ps1をドットソース | E-01 行10 | ○ |
| C-07 | Get-ItemPropertyでファイル情報取得 | E-01 行12 | ○ |
| C-08 | Get-ProjectFileでプロジェクト特定 | E-01 行13 | ○ |
| C-09 | InitializeBuildToolでビルドツール取得 | E-01 行15 | ○ |
| C-10 | -v:m（最小詳細出力）オプション使用 | E-01 行17 | ○ |
| C-11 | -tl:off（ターミナルログ無効）オプション使用 | E-01 行17 | ○ |
| C-12 | -p:RunAnalyzersDuringBuild=false | E-01 行17 | ○ |
| C-13 | Exec-Commandでビルド実行 | E-01 行19 | ○ |
| C-14 | プロジェクト未検出時にexit 1 | E-01 行23-25 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビルド処理は標準的
- 0: 低リスク - パラメータ処理は明確
- 1: 中リスク - Get-ProjectFile関数の詳細はbuild-utils.ps1に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Get-ProjectFile関数が正しくプロジェクトを検出するか確認
- [ ] msbuildEngineの選択肢（vs/dotnet）が正しく動作するか確認
- [ ] アナライザ無効化がビルド品質に影響しないか確認
