---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-eng/test-build-correctness.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/test-build-correctness.ps1` - ビルド正確性検証スクリプト（98行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトconfigurationはDebug | E-01: `$configuration = "Debug"` (14行目) | ○ |
| C-02 | -helpでヘルプ表示 | E-01: `if ($help) { Print-Usage; exit 0 }` (30-33行目) | ○ |
| C-03 | PRターゲットブランチを環境変数から取得 | E-01: `if (Test-Path env:SYSTEM_PULLREQUEST_TARGETBRANCH)` (41-43行目) | ○ |
| C-04 | -enableDumpsでクラッシュダンプ設定 | E-01: `if ($enableDumps)` ブロック (45-51行目) | ○ |
| C-05 | bootstrapDir未指定時はmake-bootstrap.ps1を実行 | E-01: `if ($bootstrapDir -eq "") { ... & eng/make-bootstrap.ps1` (53-58行目) | ○ |
| C-06 | ブートストラップ出力先はartifacts/bootstrap/correctness | E-01: `$bootstrapDir = Join-Path $ArtifactsDir (Join-Path "bootstrap" "correctness")` (55行目) | ○ |
| C-07 | eng/build.ps1をブートストラップコンパイラで実行 | E-01: `& eng/build.ps1 -restore -build -bootstrapDir:$bootstrapDir` (61行目) | ○ |
| C-08 | -runAnalyzers:$trueでアナライザ実行 | E-01: `-runAnalyzers:$true` (61行目) | ○ |
| C-09 | -warnAsError:$trueで警告をエラー化 | E-01: `-warnAsError:$true` (61行目) | ○ |
| C-10 | RoslynEnforceCodeStyle=trueを設定 | E-01: `/p:RoslynEnforceCodeStyle=true` (61行目) | ○ |
| C-11 | BuildBoss.exeで検証実行 | E-01: `$buildBossPath = GetProjectOutputBinary "BuildBoss.exe"` (68行目) | ○ |
| C-12 | BuildBossにRoslyn.slnxを渡す | E-01: `Exec-Command $buildBossPath "-r ... -p Roslyn.slnx"` (69行目) | ○ |
| C-13 | generate-compiler-code.csを-testモードで実行 | E-01: `Exec-DotNet "run --file eng/generate-compiler-code.cs -- -test"` (74行目) | ○ |
| C-14 | dotnet-format whitespaceで検証 | E-01: `Exec-DotNet "tool run dotnet-format whitespace ... --verify-no-changes"` (75行目) | ○ |
| C-15 | 失敗時にブートストラップ調査ガイドへのリンクを表示 | E-01: `"##vso[task.logissue ...bootstrap-builds.md..."` (84行目) | ○ |
| C-16 | 本スクリプトはテストカテゴリに属する | E-02: No.9のカテゴリ「テスト」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 主要な入力パラメータがソースコードと一致するか確認済み
- [x] 処理フローがソースコードの実行順序と一致するか確認済み
- [x] 各検証ステップ（BuildBoss、生成ファイル、フォーマット）が正しく記述されているか確認済み
- [ ] 実際の実行環境での動作確認（任意）
