---
generated_at: 2026-02-10 14:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-vscode-run-tests.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/vscode-run-tests.ps1` 行1-44
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行91
- E-03: `scripts/vscode-build.ps1` （参照のみ）
- E-04: `eng/build-utils.ps1` （参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | filePathは必須パラメータ | E-01 行2 | ○ |
| C-02 | msbuildEngineのデフォルトは"vs" | E-01 行3 | ○ |
| C-03 | frameworkのデフォルトは$null | E-01 行4 | ○ |
| C-04 | filterのデフォルトは空文字 | E-01 行5 | ○ |
| C-05 | Set-StrictMode -version 3.0を使用 | E-01 行8 | ○ |
| C-06 | build-utils.ps1をドットソース | E-01 行11 | ○ |
| C-07 | vscode-build.ps1を呼び出す | E-01 行14 | ○ |
| C-08 | Get-ProjectFileでプロジェクト特定 | E-01 行18 | ○ |
| C-09 | Ensure-DotNetSdkでSDKパス取得 | E-01 行20 | ○ |
| C-10 | artifacts/TestResultsにディレクトリ作成 | E-01 行27-28 | ○ |
| C-11 | 古いHTMLファイルを削除 | E-01 行31 | ○ |
| C-12 | --logger "html;LogFilePrefix=..."を使用 | E-01 行33 | ○ |
| C-13 | --no-buildオプションを使用 | E-01 行33 | ○ |
| C-14 | filter指定時はファイル名をプレフィックスに使用 | E-01 行24 | ○ |
| C-15 | filter未指定時はプロジェクト名をプレフィックスに使用 | E-01 行24 | ○ |
| C-16 | Invoke-Expressionでコマンド実行 | E-01 行35 | ○ |
| C-17 | プロジェクト未検出時にexit 1 | E-01 行40-42 | ○ |
| C-18 | 実行コマンドを出力 | E-01 行34 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - コードから全ての主張を検証可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テスト実行処理は標準的
- 0: 低リスク - パラメータ処理は明確
- 0: 低リスク - エラー処理は適切

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLロガーが正しく動作するか確認
- [ ] テスト結果ディレクトリへの書き込み権限確認
- [ ] フィルタ式の構文が正しいか確認
