---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：92-report-ci-times.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/report-ci-times.ps1` 1-2行目 - スクリプトコメントと使用方法
- E-02: `scripts/report-ci-times.ps1` 4行目 - build-utils.ps1の読み込み
- E-03: `scripts/report-ci-times.ps1` 6-8行目 - 定数定義（pipelineId, minDate, maxDate）
- E-04: `scripts/report-ci-times.ps1` 10-12行目 - API URL定義
- E-05: `scripts/report-ci-times.ps1` 14-43行目 - $wantedRecords配列
- E-06: `scripts/report-ci-times.ps1` 47-76行目 - $priorities連想配列
- E-07: `scripts/report-ci-times.ps1` 78-86行目 - Jobクラス定義
- E-08: `scripts/report-ci-times.ps1` 100-114行目 - requestWithRetry関数
- E-09: `scripts/report-ci-times.ps1` 116-192行目 - initialPass関数
- E-10: `scripts/report-ci-times.ps1` 196-225行目 - $prerequisites連想配列
- E-11: `scripts/report-ci-times.ps1` 227-258行目 - fillPrereqTimes関数
- E-12: `scripts/report-ci-times.ps1` 260-280行目 - getAverageTimes関数
- E-13: `scripts/report-ci-times.ps1` 290-292行目 - CSV出力処理
- E-14: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 93行目 - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力先はartifacts/ci-times.csv | E-13 | ○ |
| C-02 | all-ci-times.xlsxにペーストしてグラフ化することを想定 | E-01 | ○ |
| C-03 | build-utils.ps1を読み込んで$ArtifactsDirを使用 | E-02, E-13 | ○ |
| C-04 | パイプラインIDは15 | E-03 | ○ |
| C-05 | データ収集期間は2022-07-20から2022-08-03 | E-03 | ○ |
| C-06 | Azure DevOps dnceng/public組織のAPIを使用 | E-04 | ○ |
| C-07 | 収集対象ジョブは23種類 | E-05 | ○ |
| C-08 | ジョブの優先度（ソート順）は$prioritiesで定義 | E-06 | ○ |
| C-09 | Jobクラスは7つのプロパティを持つ | E-07 | ○ |
| C-10 | APIリトライは5回、間隔は5秒 | E-08 | ○ |
| C-11 | 成功かつ完了したビルドのみを処理 | E-09 | ○ |
| C-12 | 複数試行のあるビルドはスキップ | E-09 | ○ |
| C-13 | ジョブ間の依存関係は$prerequisitesで定義 | E-10 | ○ |
| C-14 | 待機時間は前提ジョブ完了時刻から算出 | E-11 | ○ |
| C-15 | 開始時刻が前提ジョブ完了前だと例外発生 | E-11 | ○ |
| C-16 | 各ジョブタイプの平均時間を計算 | E-12 | ○ |
| C-17 | Export-CsvでCSV出力 | E-13 | ○ |
| C-18 | 出力後にパスを標準出力に表示 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠があり、読み取り専用のレポート生成処理

## 6) レビュアーチェックリスト（最小）
- [ ] データ収集期間（minDate/maxDate）が現在の分析要件に合致しているか確認
- [ ] $wantedRecordsに含まれるジョブ名が現在のパイプライン構成と一致しているか確認
- [ ] Azure DevOps APIへの認証が不要なpublic組織であることを確認
