---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：93-UploadPerfProject.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：スクリプト内のエコー出力メッセージに誤りがある可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/UploadAzureZip/UploadPerfProject.ps1` 1行目 - AzCopyパス定義
- E-02: `scripts/UploadAzureZip/UploadPerfProject.ps1` 3-7行目 - AzCopy存在確認
- E-03: `scripts/UploadAzureZip/UploadPerfProject.ps1` 9-12行目 - 対話式プロンプト
- E-04: `scripts/UploadAzureZip/UploadPerfProject.ps1` 14-16行目 - パス構築
- E-05: `scripts/UploadAzureZip/UploadPerfProject.ps1` 20-21行目 - Zip圧縮処理
- E-06: `scripts/UploadAzureZip/UploadPerfProject.ps1` 25行目 - AzCopyアップロード
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 94行目 - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AzCopyのパスはProgram Files (x86)\Microsoft SDKs\Azure\AzCopy\AzCopy.exe | E-01 | ○ |
| C-02 | AzCopy未検出時はexit 1で終了 | E-02 | ○ |
| C-03 | ダウンロードURLはhttp://aka.ms/downloadazcopy | E-02 | ○ |
| C-04 | フォルダ名、バージョン、Azureキーを対話式で取得 | E-03 | ○ |
| C-05 | Zipファイル名は{フォルダ名}.{バージョン}.zip形式 | E-04 | ○ |
| C-06 | System.IO.Compression.ZipFileでZip圧縮 | E-05 | ○ |
| C-07 | 圧縮レベルはFastest | E-05 | ○ |
| C-08 | アップロード先はhttps://dotnetci.blob.core.windows.net/roslyn-perf | E-06 | ○ |
| C-09 | AzCopyの/DestKeyオプションでAzureキーを指定 | E-06 | ○ |
| C-10 | カレントディレクトリのフォルダを対象とする | E-03, E-04 | ○ |
| C-11 | ローカルにZipファイルを作成してからアップロード | E-04, E-05, E-06 | ○ |
| C-12 | アップロード開始時のメッセージ出力 | E-05 | △ |

## 4) 不足情報（Unknown / Missing）
- C-12について：スクリプト23行目の`echo "Uploading $ScriptDir/$NugetZipName"`は変数名が誤っている可能性があります（$NugetZipNameは定義されていない）。実際には$ZipNameが使用されるべきと思われます。
  - 候補：スクリプトの記述ミス / 別スクリプトからのコピペ残り / 意図的な設計

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - スクリプト内の変数参照に潜在的な問題があるため、実行前にコードレビュー推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 23行目のエコー文の変数名が正しいか確認（$NugetZipNameは未定義変数）
- [ ] Azure Blob Storageのアクセスキーの取り扱いがセキュリティ要件に準拠しているか確認
- [ ] 対話式プロンプトがCI自動化の妨げにならないか運用要件を確認
