---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-RoslynAnalyzers-install.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. なし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/RoslynAnalyzers/assets/install.ps1` 1行目 - パラメータ定義
- E-02: `src/RoslynAnalyzers/assets/install.ps1` 3-7行目 - analyzersディレクトリ存在確認
- E-03: `src/RoslynAnalyzers/assets/install.ps1` 9行目 - analyzersパス構築
- E-04: `src/RoslynAnalyzers/assets/install.ps1` 11-24行目 - 言語非依存アナライザ登録
- E-05: `src/RoslynAnalyzers/assets/install.ps1` 26-39行目 - 言語判定処理
- E-06: `src/RoslynAnalyzers/assets/install.ps1` 41-55行目 - 言語固有アナライザ登録
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 98行目 - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのパラメータを受け取る（installPath, toolsPath, package, project） | E-01 | ○ |
| C-02 | analyzersディレクトリが存在しない場合は処理を終了 | E-02 | ○ |
| C-03 | toolsPathの親フォルダからanalyzersフォルダを特定 | E-02, E-03 | ○ |
| C-04 | Get-ChildItemで-Filter *.dllを使用してDLLを取得 | E-04 | ○ |
| C-05 | *.resources.dll除外フィルタがない | E-04 | ○ |
| C-06 | AnalyzerReferencesプロパティでアナライザ参照を追加 | E-04, E-06 | ○ |
| C-07 | $project.Typeでプロジェクト言語を判定 | E-05 | ○ |
| C-08 | C#の場合はlanguageFolderを"cs"に設定 | E-05 | ○ |
| C-09 | VB.NETの場合はlanguageFolderを"vb"に設定 | E-05 | ○ |
| C-10 | 言語が判定できない場合は処理を終了 | E-05 | ○ |
| C-11 | 言語固有アナライザはanalyzers/{lang}サブフォルダから取得 | E-06 | ○ |
| C-12 | Test-Pathでフォルダ存在確認後に処理を実行 | E-02, E-04, E-06 | ○ |
| C-13 | NuGetパッケージインストール時に自動実行される | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠があり、NuGet標準のインストールスクリプト形式

## 6) レビュアーチェックリスト（最小）
- [ ] *.resources.dll除外がないことで問題が発生しないか確認
- [ ] src/Setup/PowerShell/install.ps1との実装差異が意図的なものか確認
- [ ] assetsフォルダに配置されることでSDKスタイルプロジェクトでも動作するか確認
