---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 200
  claims_with_evidence: 186
  claims_without_evidence: 14
confidence_derived: 0.93
---

# 根拠レポート：Compilers-CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：186 / 200、根拠なし：14
- 優先レビュー（高）
  1. **Lowering/LocalRewriter関連テストケース（UT-CSC-169）**：内部実装詳細のため完全な検証が困難
  2. **CodeGen/Optimizer関連テストケース（UT-CSC-170）**：最適化の詳細仕様が不明確
  3. **一部のSymbol系テストケース**：内部APIのため動作仕様の確認が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilers/CSharp/Portable/CSharpCompilationOptions.cs` - コンパイルオプションクラスの定義
- E-02: `src/Compilers/CSharp/Portable/CSharpParseOptions.cs` - パースオプションクラスの定義
- E-03: `src/Compilers/CSharp/Portable/LanguageVersion.cs` - 言語バージョン列挙型とユーティリティ
- E-04: `src/Compilers/CSharp/Portable/Syntax/SyntaxFacts.cs` - 構文ファクトメソッド群
- E-05: `src/Compilers/CSharp/Portable/Syntax/SyntaxKindFacts.cs` - SyntaxKind判定メソッド群
- E-06: `src/Compilers/CSharp/Portable/Parser/Lexer.cs` - 字句解析器の実装
- E-07: `src/Compilers/CSharp/Portable/Parser/LanguageParser.cs` - 構文解析器の実装
- E-08: `src/Compilers/CSharp/Portable/Compilation/CSharpCompilation.cs` - コンパイレーションクラス
- E-09: `src/Compilers/CSharp/Portable/Compilation/CSharpSemanticModel.cs` - セマンティックモデル
- E-10: `src/Compilers/CSharp/Portable/FlowAnalysis/DefiniteAssignment.cs` - 確定代入解析
- E-11: `src/Compilers/CSharp/Portable/FlowAnalysis/NullableWalker.cs` - Nullable解析
- E-12: `src/Compilers/CSharp/Portable/FlowAnalysis/ControlFlowPass.cs` - 制御フロー解析
- E-13: `src/Compilers/CSharp/Portable/Binder/Binder.cs` - バインダー基底クラス
- E-14: `src/Compilers/CSharp/Portable/Binder/Binder_Conversions.cs` - 型変換バインディング
- E-15: `src/Compilers/CSharp/Portable/Binder/Binder_Invocation.cs` - 呼び出しバインディング
- E-16: `src/Compilers/CSharp/Portable/Binder/Binder_Lambda.cs` - ラムダバインディング
- E-17: `src/Compilers/CSharp/Portable/Binder/Binder_Patterns.cs` - パターンバインディング
- E-18: `src/Compilers/CSharp/Portable/SymbolDisplay/ObjectDisplay.cs` - オブジェクト表示
- E-19: `src/Compilers/CSharp/Portable/SymbolDisplay/SymbolDisplay.cs` - シンボル表示
- E-20: `src/Compilers/CSharp/Portable/Syntax/CSharpSyntaxTree.cs` - 構文木クラス
- E-21: `src/Compilers/CSharp/Portable/Syntax/SyntaxFactory.cs` - 構文ファクトリ
- E-22: `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineParser.cs` - コマンドラインパーサー
- E-23: `src/Compilers/CSharp/Portable/Symbols/` ディレクトリ - シンボル定義群
- E-24: `src/Compilers/CSharp/Portable/Emitter/` ディレクトリ - コード生成関連
- E-25: `src/Compilers/CSharp/Portable/Errors/` ディレクトリ - エラー処理関連

## 3) Claims と根拠の対応（レビューの主戦場）

### CSharpCompilationOptions 関連（UT-CSC-001 ～ UT-CSC-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | CSharpCompilationOptionsのデフォルト構築 | E-01 | ○ |
| C-002 | AllowUnsafeオプション設定 | E-01 | ○ |
| C-003 | NullableContextOptions設定 | E-01 | ○ |
| C-004 | WithOutputKindメソッド動作 | E-01 | ○ |
| C-005 | 同値でのWithOutputKind最適化 | E-01 | ○ |
| C-006 | WithModuleNameメソッド動作 | E-01 | ○ |
| C-007 | null設定時のWithModuleName | E-01 | ○ |
| C-008 | WithUsingsメソッド動作 | E-01 | ○ |
| C-009 | 空usingsリスト処理 | E-01 | ○ |
| C-010 | WithAllowUnsafeメソッド動作 | E-01 | ○ |
| C-011 | WithNullableContextOptionsメソッド動作 | E-01 | ○ |
| C-012 | Equalsメソッド（等価） | E-01 | ○ |
| C-013 | Equalsメソッド（非等価） | E-01 | ○ |
| C-014 | Equalsメソッド（null比較） | E-01 | ○ |

### CSharpParseOptions 関連（UT-CSC-015 ～ UT-CSC-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-015 | CSharpParseOptionsのデフォルト構築 | E-02 | ○ |
| C-016 | LanguageVersion設定 | E-02 | ○ |
| C-017 | Defaultプロパティ | E-02 | ○ |
| C-018 | WithLanguageVersionメソッド動作 | E-02 | ○ |
| C-019 | 同値でのWithLanguageVersion最適化 | E-02 | ○ |
| C-020 | WithPreprocessorSymbolsメソッド動作 | E-02 | ○ |
| C-021 | 空シンボルリスト処理 | E-02 | ○ |
| C-022 | nullシンボルバリデーション | E-02 | ○ |
| C-023 | WithDocumentationModeメソッド動作 | E-02 | ○ |
| C-024 | WithKindメソッド動作 | E-02 | ○ |
| C-025 | WithFeaturesメソッド動作 | E-02 | ○ |
| C-026 | IsFeatureEnabled（有効機能） | E-02 | ○ |
| C-027 | IsFeatureEnabled（無効機能） | E-02 | ○ |
| C-028 | Equalsメソッド | E-02 | ○ |
| C-029 | GetHashCodeメソッド | E-02 | ○ |

### LanguageVersion 関連（UT-CSC-030 ～ UT-CSC-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-030 | ToDisplayString CSharp1 | E-03 | ○ |
| C-031 | ToDisplayString CSharp7 | E-03 | ○ |
| C-032 | ToDisplayString CSharp7_1 | E-03 | ○ |
| C-033 | ToDisplayString Latest | E-03 | ○ |
| C-034 | ToDisplayString Preview | E-03 | ○ |
| C-035 | TryParse 7.1 | E-03 | ○ |
| C-036 | TryParse latest | E-03 | ○ |
| C-037 | TryParse 大文字小文字 | E-03 | ○ |
| C-038 | TryParse null | E-03 | ○ |
| C-039 | TryParse 不正値 | E-03 | ○ |
| C-040 | TryParse iso-1 | E-03 | ○ |
| C-041 | MapSpecifiedToEffectiveVersion Latest | E-03 | ○ |
| C-042 | MapSpecifiedToEffectiveVersion Default | E-03 | ○ |
| C-043 | MapSpecifiedToEffectiveVersion 具体的バージョン | E-03 | ○ |
| C-044 | IsValid 有効バージョン | E-03 | ○ |
| C-045 | IsValid Preview | E-03 | ○ |
| C-046 | IsValid 不正値 | E-03 | ○ |
| C-047 | GetErrorCode | E-03 | ○ |

### SyntaxFacts 関連（UT-CSC-048 ～ UT-CSC-063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-048 | IsAliasQualifier 正常 | E-04 | ○ |
| C-049 | IsAliasQualifier 異常 | E-04 | ○ |
| C-050 | IsAttributeName | E-04 | ○ |
| C-051 | IsInvoked | E-04 | ○ |
| C-052 | IsIndexed | E-04 | ○ |
| C-053 | IsInTypeOnlyContext | E-04 | ○ |
| C-054 | IsKeywordKind 正常 | E-05 | ○ |
| C-055 | IsKeywordKind 異常 | E-05 | ○ |
| C-056 | IsReservedKeyword 正常 | E-05 | ○ |
| C-057 | IsReservedKeyword コンテキストキーワード | E-05 | ○ |
| C-058 | IsAccessibilityModifier 正常 | E-05 | ○ |
| C-059 | IsAccessibilityModifier 異常 | E-05 | ○ |
| C-060 | IsPreprocessorKeyword | E-05 | ○ |
| C-061 | IsAttributeTargetSpecifier | E-05 | ○ |
| C-062 | GetReservedKeywordKinds | E-05 | ○ |
| C-063 | GetKeywordKinds | E-05 | ○ |

### Lexer/Parser 関連（UT-CSC-064 ～ UT-CSC-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-064 | Lexer構築 | E-06 | ○ |
| C-065 | Lex基本トークン | E-06 | ○ |
| C-066 | Lex文字列リテラル | E-06 | ○ |
| C-067 | Lex数値リテラル | E-06 | ○ |
| C-068 | Lexコメント処理 | E-06 | ○ |
| C-069 | Lex複数行コメント | E-06 | ○ |
| C-070 | Lex補間文字列 | E-06 | ○ |
| C-071 | Lex raw文字列リテラル | E-06 | ○ |
| C-072 | Lexエラートークン | E-06 | ○ |
| C-073 | Lex空ソース | E-06 | ○ |
| C-074 | ParseCompilationUnit基本 | E-07 | ○ |
| C-075 | ParseCompilationUnit top-level statements | E-07 | ○ |
| C-076 | using宣言パース | E-07 | ○ |
| C-077 | global usingパース | E-07 | ○ |
| C-078 | クラス宣言パース | E-07 | ○ |
| C-079 | recordパース | E-07 | ○ |
| C-080 | メソッド宣言パース | E-07 | ○ |
| C-081 | 二項演算式パース | E-07 | ○ |
| C-082 | ラムダ式パース | E-07 | ○ |
| C-083 | LINQ式パース | E-07 | ○ |
| C-084 | if文パース | E-07 | ○ |
| C-085 | switch式パース | E-07 | ○ |
| C-086 | パターンマッチングパース | E-07 | ○ |
| C-087 | 構文エラー診断 | E-07 | ○ |

### Compilation 関連（UT-CSC-088 ～ UT-CSC-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-088 | Compilation作成 | E-08 | ○ |
| C-089 | 参照なしCompilation | E-08 | ○ |
| C-090 | AddSyntaxTrees | E-08 | ○ |
| C-091 | RemoveSyntaxTrees | E-08 | ○ |
| C-092 | AddReferences | E-08 | ○ |
| C-093 | GetSemanticModel | E-08 | ○ |
| C-094 | GetDiagnostics（エラーあり） | E-08 | ○ |
| C-095 | GetDiagnostics（エラーなし） | E-08 | ○ |
| C-096 | Emit成功 | E-08 | ○ |
| C-097 | Emit失敗 | E-08 | ○ |
| C-098 | WithOptions | E-08 | ○ |
| C-099 | GlobalNamespace | E-08 | ○ |

### SemanticModel 関連（UT-CSC-100 ～ UT-CSC-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | GetSymbolInfo正常 | E-09 | ○ |
| C-101 | GetSymbolInfo未解決 | E-09 | ○ |
| C-102 | GetTypeInfo正常 | E-09 | ○ |
| C-103 | GetTypeInfo変換 | E-09 | ○ |
| C-104 | GetDeclaredSymbol | E-09 | ○ |
| C-105 | GetConstantValue定数 | E-09 | ○ |
| C-106 | GetConstantValue非定数 | E-09 | ○ |
| C-107 | LookupSymbols | E-09 | ○ |
| C-108 | AnalyzeDataFlow | E-09 | ○ |

### FlowAnalysis 関連（UT-CSC-109 ～ UT-CSC-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | 確定代入 未初期化検出 | E-10 | ○ |
| C-110 | 確定代入 初期化済み | E-10 | ○ |
| C-111 | 確定代入 分岐両方 | E-10 | ○ |
| C-112 | 確定代入 片方分岐 | E-10 | ○ |
| C-113 | Nullable null参照検出 | E-11 | ○ |
| C-114 | Nullable nullチェック後 | E-11 | ○ |
| C-115 | Nullable 非null代入 | E-11 | ○ |
| C-116 | ControlFlow 到達不能 | E-12 | ○ |
| C-117 | ControlFlow 全パスreturn | E-12 | ○ |
| C-118 | ControlFlow returnなし | E-12 | ○ |

### Binder 関連（UT-CSC-119 ～ UT-CSC-132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | BindExpressionリテラル | E-13 | ○ |
| C-120 | BindExpressionメソッド呼び出し | E-13 | ○ |
| C-121 | BindExpression二項演算 | E-13 | ○ |
| C-122 | BindExpression未定義識別子 | E-13 | ○ |
| C-123 | ClassifyConversion暗黙数値 | E-14 | ○ |
| C-124 | ClassifyConversionユーザー定義 | E-14 | ○ |
| C-125 | ClassifyConversion変換不可 | E-14 | ○ |
| C-126 | オーバーロード解決正常 | E-15 | ○ |
| C-127 | オーバーロード解決曖昧 | E-15 | ○ |
| C-128 | ラムダ型推論 | E-16 | ○ |
| C-129 | 非同期ラムダ | E-16 | ○ |
| C-130 | 型パターン | E-17 | ○ |
| C-131 | プロパティパターン | E-17 | ○ |
| C-132 | リストパターン | E-17 | ○ |

### ObjectDisplay/SymbolDisplay 関連（UT-CSC-133 ～ UT-CSC-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | FormatPrimitive整数 | E-18 | ○ |
| C-134 | FormatPrimitive 16進数 | E-18 | ○ |
| C-135 | FormatPrimitive文字列 | E-18 | ○ |
| C-136 | FormatPrimitiveエスケープ | E-18 | ○ |
| C-137 | FormatPrimitive null | E-18 | ○ |
| C-138 | FormatPrimitive bool | E-18 | ○ |
| C-139 | FormatPrimitive char | E-18 | ○ |
| C-140 | ToDisplayString型名 | E-19 | ○ |
| C-141 | ToDisplayStringメソッド | E-19 | ○ |
| C-142 | ToDisplayParts | E-19 | ○ |

### SyntaxTree/SyntaxFactory 関連（UT-CSC-143 ～ UT-CSC-159）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | ParseText基本 | E-20 | ○ |
| C-144 | ParseTextオプション | E-20 | ○ |
| C-145 | ParseTextファイルパス | E-20 | ○ |
| C-146 | GetRoot | E-20 | ○ |
| C-147 | GetDiagnostics | E-20 | ○ |
| C-148 | WithFilePath | E-20 | ○ |
| C-149 | ParseExpression | E-21 | ○ |
| C-150 | ParseStatement | E-21 | ○ |
| C-151 | Identifier | E-21 | ○ |
| C-152 | ClassDeclaration | E-21 | ○ |
| C-153 | MethodDeclaration | E-21 | ○ |
| C-154 | Token | E-21 | ○ |
| C-155 | SyntaxNormalizer | E-20 | ○ |
| C-156 | SyntaxReplacer | E-20 | ○ |
| C-157 | SyntaxNodeRemover | E-20 | ○ |
| C-158 | CSharpSyntaxRewriter | E-20 | ○ |
| C-159 | CSharpSyntaxVisitor | E-20 | ○ |

### CommandLine/Errors 関連（UT-CSC-160 ～ UT-CSC-166）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-160 | CommandLineParser基本 | E-22 | ○ |
| C-161 | CommandLineParser langversion | E-22 | ○ |
| C-162 | CommandLineParser不正引数 | E-22 | ○ |
| C-163 | MessageProvider GetErrorDisplayString | E-25 | ○ |
| C-164 | MessageProvider GetMessageFormat | E-25 | ○ |
| C-165 | DiagnosticBag Add | E-25 | ○ |
| C-166 | DiagnosticBag ToReadOnlyAndFree | E-25 | ○ |

### Emitter/Lowering 関連（UT-CSC-167 ～ UT-CSC-170）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167 | PEModuleBuilder Compile | E-24 | ○ |
| C-168 | PEModuleBuilder Emit | E-24 | ○ |
| C-169 | LocalRewriter Rewrite | **根拠不足** | △ |
| C-170 | Optimizer Optimize | **根拠不足** | △ |

### その他（UT-CSC-171 ～ UT-CSC-200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-171 | CSharpExtensions IsKind | E-08 | ○ |
| C-172 | CSharpExtensions Kind | E-08 | ○ |
| C-173 | TypeSymbol IsReferenceType | E-23 | ○ |
| C-174 | TypeSymbol IsValueType | E-23 | ○ |
| C-175 | NamedTypeSymbol GetMembers | E-23 | ○ |
| C-176 | MethodSymbol Parameters | E-23 | ○ |
| C-177 | MethodSymbol ReturnType | E-23 | ○ |
| C-178 | PropertySymbol GetMethod | E-23 | ○ |
| C-179 | PropertySymbol SetMethod | E-23 | ○ |
| C-180 | FieldSymbol IsConst | E-23 | ○ |
| C-181 | FieldSymbol IsReadOnly | E-23 | ○ |
| C-182 | ParameterSymbol IsOptional | E-23 | ○ |
| C-183 | ParameterSymbol RefKind | E-23 | ○ |
| C-184 | LocalSymbol Type | E-23 | ○ |
| C-185 | NamespaceSymbol GetTypeMembers | E-23 | ○ |
| C-186 | NamespaceSymbol GetNamespaceMembers | E-23 | ○ |
| C-187 | AssemblySymbol GlobalNamespace | E-23 | ○ |
| C-188 | AttributeData GetNamedArguments | E-23 | ○ |
| C-189 | AttributeData GetConstructorArguments | E-23 | ○ |
| C-190 | ValueSetFactory Create | **根拠不足** | △ |
| C-191 | DeclarationTree CreateRoot | **根拠不足** | △ |
| C-192 | MergedNamespaceDeclaration Children | **根拠不足** | △ |
| C-193 | DocumentationCommentCompiler WriteDocumentationCommentXml | **根拠不足** | △ |
| C-194 | CSharpOperationFactory Create | **根拠不足** | △ |
| C-195 | SyntaxEquivalence AreEquivalent 等価 | E-20 | ○ |
| C-196 | SyntaxEquivalence AreEquivalent 非等価 | E-20 | ○ |
| C-197 | LookupPosition IsInBody | **根拠不足** | △ |
| C-198 | CSharpSyntaxHelper GetNameToken | **根拠不足** | △ |
| C-199 | TypeInfo構築 | E-09 | ○ |
| C-200 | ForEachStatementInfo構築 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **LocalRewriter/Optimizer（C-169, C-170）**：内部最適化実装の詳細仕様ドキュメントが不足
  - 候補：src/Compilers/CSharp/Portable/Lowering/README.md / 開発者向け設計ドキュメント / 既存テストケース参照
- **ValueSetFactory/DeclarationTree関連（C-190, C-191, C-192）**：内部ユーティリティクラスの仕様書が不足
  - 候補：内部ドキュメント / コードコメント / 既存テストコード
- **DocumentationCommentCompiler（C-193）**：XMLドキュメント生成の詳細仕様が不足
  - 候補：C#言語仕様書 / 既存テストケース
- **CSharpOperationFactory（C-194）**：IOperation APIの内部実装詳細が不足
  - 候補：Roslyn IOperation設計ドキュメント
- **LookupPosition/CSharpSyntaxHelper（C-197, C-198）**：ソース生成関連のヘルパー仕様が不足
  - 候補：Source Generator関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: CSharpCompilationOptions, CSharpParseOptions, LanguageVersion, SyntaxFacts関連
  - 公開APIで十分なソースコード根拠あり
- **0 (低リスク)**: Lexer, Parser, Compilation, SemanticModel関連
  - コア機能で詳細なソースコード確認済み
- **1 (中リスク)**: FlowAnalysis, Binder関連
  - 複雑なロジックを含むが、主要なパスは確認済み
- **1 (中リスク)**: Symbol関連
  - 内部APIだが、インターフェースは明確
- **2 (高リスク)**: Lowering, CodeGen, Optimizer関連
  - 内部実装詳細が多く、完全な仕様確認が困難

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度（優先度=高）のテストケース（計56件）のテスト観点が適切か確認
- [ ] 異常系テストケースのエラーコード（CS0165, CS0121等）が正しいか確認
- [ ] 境界値テストケースが網羅的かどうか確認
- [ ] FlowAnalysis関連テストケースがNull許容参照型機能を十分にカバーしているか確認
- [ ] C#14の新機能（field keyword, Extension everything等）に関するテストケースの追加検討
- [ ] 根拠不足（△）の14件について、追加調査または削除を検討
- [ ] Lowering/Optimizer関連テストケースの妥当性を、既存の実装テストと照合して確認
