---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：Compilers-Core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-COR-098**：CryptographicHashProviderの内部実装詳細が未確認
  2. **UT-COR-099, UT-COR-100**：CommonCommandLineParserの具体的なエラーケースが抽象的
  3. **UT-COR-093**：Generated.csファイルの内容は動的生成のため詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Compilers/Core/Portable/Compilation/Compilation.cs` - Compilationクラスの定義
- E-02: `src/Compilers/Core/Portable/Syntax/SyntaxNode.cs` - SyntaxNodeクラスの定義
- E-03: `src/Compilers/Core/Portable/Syntax/SyntaxTree.cs` - SyntaxTreeクラスの定義
- E-04: `src/Compilers/Core/Portable/Text/SourceText.cs` - SourceTextクラスの定義
- E-05: `src/Compilers/Core/Portable/Diagnostic/Diagnostic.cs` - Diagnosticクラスの定義
- E-06: `src/Compilers/Core/Portable/Symbols/ISymbol.cs` - ISymbolインターフェースの定義
- E-07: `src/Compilers/Core/Portable/CodeGen/ILBuilder.cs` - ILBuilderクラスの定義
- E-08: `src/Compilers/Core/Portable/MetadataReference/MetadataReference.cs` - MetadataReferenceクラスの定義
- E-09: `src/Compilers/Core/Portable/Symbols/*.cs` - シンボル関連インターフェース群
- E-10: `src/Compilers/Core/Portable/Emit/EmitOptions.cs` - EmitOptionsクラスの定義
- E-11: `src/Compilers/Core/Portable/MetadataReference/AssemblyIdentity.cs` - AssemblyIdentityクラスの定義
- E-12: `src/Compilers/Core/Portable/MetadataReference/AssemblyIdentityComparer.cs` - AssemblyIdentityComparerクラスの定義
- E-13: `src/Compilers/Core/Portable/SymbolDisplay/SymbolDisplayFormat.cs` - SymbolDisplayFormatクラスの定義
- E-14: `src/Compilers/Core/Portable/SymbolDisplay/SymbolDisplayPart.cs` - SymbolDisplayPartクラスの定義
- E-15: `src/Compilers/Core/Portable/Emit/SemanticEdit.cs` - SemanticEditクラスの定義
- E-16: `src/Compilers/Core/Portable/StrongName/StrongNameKeys.cs` - StrongNameKeysクラスの定義
- E-17: `src/Compilers/Core/Portable/RuleSet/RuleSet.cs` - RuleSetクラスの定義
- E-18: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト計画

## 3) Claims と根拠の対応（レビューの主戦場）

### Compilationクラス（UT-COR-001 ～ UT-COR-007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsCaseSensitiveプロパティが存在し、bool値を返す | E-01 (L57) | ○ |
| C-02 | Languageプロパティが存在し、文字列を返す | E-01 (L132) | ○ |
| C-03 | SyntaxTreeCommonFeaturesメソッドが共通機能を抽出する | E-01 (L98-125) | ○ |
| C-04 | 不一致時にArgumentExceptionがスローされる | E-01 (L113) | ○ |
| C-05 | 空の場合にEmptyが返却される | E-01 (L118-121) | ○ |
| C-06 | CreateAnalyzerDriverが抽象メソッドとして定義される | E-01 (L127) | ○ |
| C-07 | GetDeterministicKeyが決定論的キーを生成する | E-01 (L196-200) | ○ |

### SyntaxNodeクラス（UT-COR-008 ～ UT-COR-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | RawKindプロパティがGreenNodeから値を取得する | E-02 (L60) | ○ |
| C-09 | Languageプロパティが抽象として定義される | E-02 (L67) | ○ |
| C-10 | FullSpanプロパティがTextSpanを返す | E-02 (L85) | ○ |
| C-11 | Spanプロパティがトリビアを除外する | E-02 (L92-110) | ○ |
| C-12 | SpanStartがパフォーマンス最適化されている | E-02 (L119) | ○ |
| C-13 | GetRedメソッドが遅延評価を行う | E-02 (L137-152) | ○ |
| C-14 | 無効なスロットでnullが返却される | E-02 (L143-145) | ○ |

### SyntaxTreeクラス（UT-COR-015 ～ UT-COR-021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | FilePathプロパティが定義される | E-03 (L53) | ○ |
| C-16 | HasCompilationUnitRootが定義される | E-03 (L58) | ○ |
| C-17 | GetTextメソッドがSourceTextを返す | E-03 (L99) | ○ |
| C-18 | TryGetTextがキャッシュ済みでtrueを返す | E-03 (L94) | ○ |
| C-19 | TryGetTextが未キャッシュでfalseを返す | E-03 (L94) | ○ |
| C-20 | GetRootメソッドがSyntaxNodeを返す | E-03 (L141-143) | ○ |
| C-21 | TryGetRootがキャッシュ済みでtrueを返す | E-03 (L128-131) | ○ |

### SourceTextクラス（UT-COR-022 ～ UT-COR-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | From(string)がSourceTextを生成する | E-04 (L105-113) | ○ |
| C-23 | nullでArgumentNullExceptionがスローされる | E-04 (L107-110) | ○ |
| C-24 | From(TextReader)がSourceTextを生成する | E-04 (L131-149) | ○ |
| C-25 | nullリーダーでArgumentNullExceptionがスローされる | E-04 (L137-140) | ○ |
| C-26 | 大きなテキストでLargeTextが使用される | E-04 (L143-146) | ○ |
| C-27 | ValidateChecksumAlgorithmが有効なアルゴリズムを検証する | E-04 (L82-88) | ○ |
| C-28 | 無効なアルゴリズムで例外がスローされる | E-04 (L85-87) | ○ |

### Diagnosticクラス（UT-COR-029 ～ UT-COR-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | Create(descriptor, location)がDiagnosticを生成する | E-05 (L47-53) | ○ |
| C-30 | Create(descriptor, location, properties)がDiagnosticを生成する | E-05 (L67-74) | ○ |
| C-31 | Create(descriptor, location, additionalLocations)がDiagnosticを生成する | E-05 (L88-95) | ○ |
| C-32 | nullのdescriptorで例外がスローされる | E-05 (L150) | ○ |

### ISymbolインターフェース（UT-COR-033 ～ UT-COR-040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Kindプロパティが定義される | E-06 (L28) | ○ |
| C-34 | Nameプロパティが定義される | E-06 (L38) | ○ |
| C-35 | MetadataNameプロパティが定義される | E-06 (L58) | ○ |
| C-36 | ContainingSymbolプロパティが定義される | E-06 (L70) | ○ |
| C-37 | ContainingAssemblyプロパティが定義される | E-06 (L76) | ○ |
| C-38 | Locationsプロパティが定義される | E-06 (L174) | ○ |
| C-39 | IsDefinitionプロパティが定義される | E-06 (L102) | ○ |
| C-40 | IsImplicitlyDeclaredプロパティが定義される | E-06 (L159) | ○ |

### ILBuilderクラス（UT-COR-041 ～ UT-COR-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | コンストラクタが各種パラメータで初期化する | E-07 (L71-85) | ○ |
| C-42 | AreLocalsZeroedプロパティが定義される | E-07 (L87) | ○ |
| C-43 | GetCurrentBlockメソッドがBasicBlockを返す | E-07 (L89-99) | ○ |
| C-44 | CreateBlockメソッドがブロックを作成する | E-07 (L102-108) | ○ |
| C-45 | CreateSwitchBlockメソッドがSwitchBlockを作成する | E-07 (L111-119) | ○ |

### MetadataReferenceクラス（UT-COR-046 ～ UT-COR-051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Propertiesプロパティが定義される | E-08 (L25) | ○ |
| C-47 | WithAliasesメソッドが定義される | E-08 (L50-53, L70-73) | ○ |
| C-48 | WithEmbedInteropTypesメソッドが定義される | E-08 (L60-63) | ○ |
| C-49 | WithPropertiesが同一プロパティで同じインスタンスを返す | E-08 (L80-88) | ○ |
| C-50 | CreateFromImageがPortableExecutableReferenceを返す | E-08 (L119-132) | ○ |
| C-51 | nullイメージで例外がスローされる | E-08 | △ |

### その他のクラス（UT-COR-052 ～ UT-COR-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | SymbolKind列挙型が定義される | E-09 | ○ |
| C-53 | Accessibility列挙型が定義される | E-09 | ○ |
| C-54 | TypeKind列挙型が定義される | E-09 | ○ |
| C-55-57 | SymbolEqualityComparerのメソッドが定義される | E-09 | ○ |
| C-58-59 | EmitOptionsのコンストラクタとデフォルト値 | E-10 | ○ |
| C-60-61 | RuleSetのParseメソッドと例外処理 | E-17 | ○ |
| C-62-65 | AssemblyIdentityのプロパティとメソッド | E-11 | ○ |
| C-66 | AssemblyIdentityComparerのCompareメソッド | E-12 | ○ |
| C-67-70 | IMethodSymbolのプロパティ | E-09 | ○ |
| C-71-73 | ITypeSymbolのプロパティ | E-09 | ○ |
| C-74-76 | INamedTypeSymbolのプロパティとメソッド | E-09 | ○ |
| C-77-78 | INamespaceSymbolのメソッドとプロパティ | E-09 | ○ |
| C-79-81 | IPropertySymbolのプロパティとアクセサ | E-09 | ○ |
| C-82-84 | IFieldSymbolのプロパティ | E-09 | ○ |
| C-85-87 | IParameterSymbolのプロパティ | E-09 | ○ |
| C-88-89 | ILocalSymbolのプロパティ | E-09 | ○ |
| C-90-92 | SymbolDisplayFormat/SymbolDisplayPartのプロパティ | E-13, E-14 | ○ |
| C-93 | OperationKind列挙型が定義される（生成ファイル） | **根拠なし** | △ |
| C-94-95 | SemanticEditのプロパティ | E-15 | ○ |
| C-96-97 | StrongNameKeysのメソッドとプロパティ | E-16 | ○ |
| C-98 | CryptographicHashProvider.GetHashSizeメソッド | **根拠なし** | △ |
| C-99-100 | CommonCommandLineParserのParseメソッド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-COR-093**: `Operations.Generated.cs`は自動生成ファイルのため、生成元の定義を確認する必要がある
  - 候補：`src/Tools/Source/CompilerGeneratorTools/Source/IOperationGenerator/` / BoundTree定義
- **UT-COR-098**: `CryptographicHashProvider`の詳細な実装は`src/Compilers/Core/Portable/Hashing/`ディレクトリで確認が必要
  - 候補：Hashing/CryptographicHashProvider.cs
- **UT-COR-099, UT-COR-100**: `CommonCommandLineParser`の具体的なエラーケースは言語固有の実装で確認が必要
  - 候補：CSharpCommandLineParser / VisualBasicCommandLineParser

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: 大半のテストケースはソースコードから直接確認可能
- **リスク1（中リスク）**: 生成ファイル（Generated.cs）に関するテストケースは生成元の確認が推奨される
- **リスク1（中リスク）**: 抽象クラス・インターフェースのテストは具象実装での動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの網羅性: 主要なpublicメソッド・プロパティがカバーされているか
- [ ] 正常系/異常系/境界値のバランス: 各クラスに対して適切な観点が含まれているか
- [ ] 優先度の妥当性: コンパイラのコア機能（Compilation, SyntaxNode, Symbols）が高優先度になっているか
- [ ] 生成ファイル（OperationKind.Generated.cs等）のテストケース内容が適切か
- [ ] 抽象メソッド・インターフェースに対するテストケースが実装クラスでテスト可能か
- [ ] テストIDの命名規則（UT-COR-xxx）が一貫しているか
- [ ] 入力値と期待結果の記述が具体的で実装可能か
