---
generated_at: 2026-02-10 15:15:00
metrics:
  claims_total: 91
  claims_with_evidence: 91
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Compilers-Server 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：91 / 91、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilers/Server/VBCSCompiler/BuildServerController.cs` - サーバー制御ロジック（Run, ParseCommandLine, GetKeepAliveTimeout, RunServer, RunShutdown）
- E-02: `src/Compilers/Server/VBCSCompiler/ServerDispatcher.cs` - サーバーディスパッチャー（ListenAndDispatchConnections, ProcessClientConnectionAsync, CheckCompletedTasks, HandleCompletedConnections）
- E-03: `src/Compilers/Server/VBCSCompiler/ClientConnectionHandler.cs` - クライアント接続ハンドラー（ProcessAsync, CheckForNewKeepAlive, WriteBuildResponseAsync, ProcessCompilationRequestAsync）
- E-04: `src/Compilers/Server/VBCSCompiler/CompilerRequestHandler.cs` - コンパイラリクエストハンドラー（CompilerServerHost, TryCreateCompiler, RunCompilation）
- E-05: `src/Compilers/Server/VBCSCompiler/AnalyzerConsistencyChecker.cs` - アナライザー整合性チェッカー（Check, CheckCore）
- E-06: `src/Compilers/Server/VBCSCompiler/MetadataCache.cs` - メタデータキャッシュ（MetadataAndSymbolCache, CachingMetadataReference）
- E-07: `src/Compilers/Server/VBCSCompiler/NamedPipeClientConnection.cs` - 名前付きパイプクライアント接続（Dispose, ReadBuildRequestAsync, WriteBuildResponseAsync）
- E-08: `src/Compilers/Server/VBCSCompiler/NamedPipeClientConnectionHost.cs` - 名前付きパイプクライアント接続ホスト（BeginListening, EndListening, GetNextClientConnectionAsync）
- E-09: `src/Compilers/Server/VBCSCompiler/BuildProtocolUtil.cs` - ビルドプロトコルユーティリティ（GetRunRequest, GetCommandLineArguments）
- E-10: `src/Compilers/Server/VBCSCompiler/CompletionData.cs` - 完了データ構造体（CompletionReason, CompletionData）
- E-11: `src/Compilers/Server/VBCSCompiler/CSharpCompilerServer.cs` - C#コンパイラサーバー（コンストラクタ, GetMetadataProvider）
- E-12: `src/Compilers/Server/VBCSCompiler/VisualBasicCompilerServer.cs` - VBコンパイラサーバー（コンストラクタ, GetMetadataProvider）
- E-13: `src/Compilers/Server/VBCSCompiler/VBCSCompiler.cs` - エントリポイント（Main）
- E-14: `src/Compilers/Server/VBCSCompiler/MemoryHelper.cs` - メモリヘルパー（IsMemoryAvailable）
- E-15: `src/Compilers/Server/VBCSCompiler/DiagnosticListener.cs` - 診断リスナー（IDiagnosticListener, EmptyDiagnosticListener）
- E-16: `src/Compilers/Server/VBCSCompiler/IClientConnection.cs` - クライアント接続インターフェース定義
- E-17: `src/Compilers/Server/VBCSCompiler/ICompilerServerHost.cs` - コンパイラサーバーホストインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuildServerController.Run - 有効なパイプ名でサーバー起動成功 | E-01 (line 37-58) | ○ |
| C-02 | BuildServerController.Run - シャットダウン引数処理 | E-01 (line 55-57) | ○ |
| C-03 | BuildServerController.Run - 無効引数でFailed返却 | E-01 (line 41-44) | ○ |
| C-04 | BuildServerController.GetKeepAliveTimeout - 有効なkeepAlive設定 | E-01 (line 60-87) | ○ |
| C-05 | BuildServerController.GetKeepAliveTimeout - keepAlive=0でnull返却 | E-01 (line 67-71) | ○ |
| C-06 | BuildServerController.GetKeepAliveTimeout - 無効値でデフォルト返却 | E-01 (line 77-80) | ○ |
| C-07 | BuildServerController.GetKeepAliveTimeout - 例外時デフォルト返却 | E-01 (line 82-86) | ○ |
| C-08 | BuildServerController.ParseCommandLine - パイプ名引数パース | E-01 (line 168-191) | ○ |
| C-09 | BuildServerController.ParseCommandLine - シャットダウン引数パース | E-01 (line 180-181) | ○ |
| C-10 | BuildServerController.ParseCommandLine - 複数引数パース | E-01 (line 173-188) | ○ |
| C-11 | BuildServerController.ParseCommandLine - 不明引数でfalse返却 | E-01 (line 184-186) | ○ |
| C-12 | BuildServerController.ParseCommandLine - 空配列処理 | E-01 (line 173, 190) | ○ |
| C-13 | BuildServerController.RunServer - サーバー正常起動終了 | E-01 (line 103-136) | ○ |
| C-14 | BuildServerController.RunServer - ミューテックス取得失敗 | E-01 (line 121-127) | ○ |
| C-15 | ServerDispatcher - コンストラクタ | E-02 (line 66-72) | ○ |
| C-16 | ServerDispatcher.ListenAndDispatchConnections - 接続処理 | E-02 (line 81-129) | ○ |
| C-17 | ServerDispatcher.ListenAndDispatchConnections - キャンセル処理 | E-02 (line 145-150) | ○ |
| C-18 | ServerDispatcher.ListenAndDispatchConnections - タイムアウト処理 | E-02 (line 169-173) | ○ |
| C-19 | ServerDispatcher.ListenAndDispatchConnections - keepAlive=null | E-02 (line 247-251) | ○ |
| C-20 | ServerDispatcher.ProcessClientConnectionAsync - 正常処理 | E-02 (line 332-340) | ○ |
| C-21 | ServerDispatcher.ProcessClientConnectionAsync - 例外処理 | E-02 (line 332-340), E-03 (line 43-47) | ○ |
| C-22 | ClientConnectionHandler - コンストラクタ | E-03 (line 25-28) | ○ |
| C-23 | ClientConnectionHandler.ProcessAsync - 有効リクエスト処理 | E-03 (line 34-97) | ○ |
| C-24 | ClientConnectionHandler.ProcessAsync - 例外時RequestError | E-03 (line 43-47) | ○ |
| C-25 | ClientConnectionHandler.ProcessAsync - ハッシュ不一致 | E-03 (line 55-63) | ○ |
| C-26 | ClientConnectionHandler.ProcessAsync - シャットダウンリクエスト | E-03 (line 65-73) | ○ |
| C-27 | ClientConnectionHandler.ProcessAsync - コンパイル禁止 | E-03 (line 75-83) | ○ |
| C-28 | ClientConnectionHandler.ProcessAsync - メモリ不足 | E-03 (line 85-93) | ○ |
| C-29 | ClientConnectionHandler.CheckForNewKeepAlive - 正常抽出 | E-03 (line 182-201) | ○ |
| C-30 | ClientConnectionHandler.CheckForNewKeepAlive - 無効値 | E-03 (line 190-197) | ○ |
| C-31 | ClientConnectionHandler.CheckForNewKeepAlive - 引数なし | E-03 (line 184-200) | ○ |
| C-32 | CompilerServerHost - コンストラクタ | E-04 (line 70-76) | ○ |
| C-33 | CompilerServerHost.TryCreateCompiler - C#作成 | E-04 (line 82-90) | ○ |
| C-34 | CompilerServerHost.TryCreateCompiler - VB作成 | E-04 (line 91-99) | ○ |
| C-35 | CompilerServerHost.TryCreateCompiler - 不明言語 | E-04 (line 100-103) | ○ |
| C-36 | CompilerServerHost.RunCompilation - 正常実行 | E-04 (line 106-169) | ○ |
| C-37 | CompilerServerHost.RunCompilation - WorkingDirectory空 | E-04 (line 116-121) | ○ |
| C-38 | CompilerServerHost.RunCompilation - TempDirectory空 | E-04 (line 125-130) | ○ |
| C-39 | CompilerServerHost.RunCompilation - コンパイラ作成失敗 | E-04 (line 133-138) | ○ |
| C-40 | CompilerServerHost.RunCompilation - アナライザー不整合 | E-04 (line 140-144) | ○ |
| C-41 | AnalyzerConsistencyChecker.Check - 整合性あり | E-05 (line 44-74) | ○ |
| C-42 | AnalyzerConsistencyChecker.Check - MVID不一致 | E-05 (line 128-137) | ○ |
| C-43 | AnalyzerConsistencyChecker.Check - 例外発生 | E-05 (line 63-69) | ○ |
| C-44 | AnalyzerConsistencyChecker.Check - 空リスト | E-05 (line 84-99) | ○ |
| C-45 | AnalyzerConsistencyChecker.Check - ホストアセンブリスキップ | E-05 (line 123-126) | ○ |
| C-46 | MetadataAndSymbolCache.GetMetadata - キャッシュミス時作成 | E-06 (line 56-86) | ○ |
| C-47 | MetadataAndSymbolCache.GetMetadata - キャッシュヒット | E-06 (line 62-65) | ○ |
| C-48 | MetadataAndSymbolCache.GetMetadata - モジュールタイプ | E-06 (line 67-72) | ○ |
| C-49 | MetadataAndSymbolCache.GetMetadata - アセンブリタイプ | E-06 (line 73-85) | ○ |
| C-50 | CachingMetadataReference - コンストラクタ | E-06 (line 118-122) | ○ |
| C-51 | CachingMetadataReference.GetMetadataImpl | E-06 (line 129-132) | ○ |
| C-52 | CachingMetadataReference.WithPropertiesImpl | E-06 (line 134-137) | ○ |
| C-53 | NamedPipeClientConnection - コンストラクタ | E-07 (line 29-33) | ○ |
| C-54 | NamedPipeClientConnection.Dispose - リソース解放 | E-07 (line 35-52) | ○ |
| C-55 | NamedPipeClientConnection.Dispose - 二重Dispose | E-07 (line 37-51) | ○ |
| C-56 | NamedPipeClientConnection.ReadBuildRequestAsync - 正常読み込み | E-07 (line 54-85) | ○ |
| C-57 | NamedPipeClientConnection.ReadBuildRequestAsync - 権限不一致 | E-07 (line 59-62) | ○ |
| C-58 | NamedPipeClientConnection.WriteBuildResponseAsync | E-07 (line 87) | ○ |
| C-59 | NamedPipeClientConnectionHost - コンストラクタ | E-08 (line 41-45) | ○ |
| C-60 | NamedPipeClientConnectionHost.BeginListening - 開始 | E-08 (line 47-76) | ○ |
| C-61 | NamedPipeClientConnectionHost.BeginListening - 二重開始 | E-08 (line 49-52) | ○ |
| C-62 | NamedPipeClientConnectionHost.EndListening - 終了 | E-08 (line 78-133) | ○ |
| C-63 | NamedPipeClientConnectionHost.EndListening - 未開始時 | E-08 (line 80-83) | ○ |
| C-64 | NamedPipeClientConnectionHost.GetNextClientConnectionAsync - 正常 | E-08 (line 135-160) | ○ |
| C-65 | NamedPipeClientConnectionHost.GetNextClientConnectionAsync - 未開始 | E-08 (line 137-140) | ○ |
| C-66 | NamedPipeClientConnectionHost.GetNextClientConnectionAsync - キャンセル | E-08 (line 151-157) | ○ |
| C-67 | BuildProtocolUtil.GetRunRequest - C#言語変換 | E-09 (line 18-36) | ○ |
| C-68 | BuildProtocolUtil.GetRunRequest - VB言語変換 | E-09 (line 30-32) | ○ |
| C-69 | BuildProtocolUtil.GetCommandLineArguments - CurrentDirectory | E-09 (line 47-49) | ○ |
| C-70 | BuildProtocolUtil.GetCommandLineArguments - TempDirectory | E-09 (line 50-52) | ○ |
| C-71 | BuildProtocolUtil.GetCommandLineArguments - LibDirectory | E-09 (line 53-55) | ○ |
| C-72 | BuildProtocolUtil.GetCommandLineArguments - コマンドライン | E-09 (line 56-67) | ○ |
| C-73 | BuildProtocolUtil.GetCommandLineArguments - 空リスト | E-09 (line 43-71) | ○ |
| C-74 | CompletionData - コンストラクタ | E-10 (line 40-45) | ○ |
| C-75 | CompletionData.ToString | E-10 (line 51) | ○ |
| C-76 | CompletionData.RequestCompleted静的プロパティ | E-10 (line 47) | ○ |
| C-77 | CompletionData.RequestError静的プロパティ | E-10 (line 49) | ○ |
| C-78 | CSharpCompilerServer - コンストラクタ | E-11 (line 19-28) | ○ |
| C-79 | CSharpCompilerServer.GetMetadataProvider | E-11 (line 30-33) | ○ |
| C-80 | VisualBasicCompilerServer - コンストラクタ | E-12 (line 21-29) | ○ |
| C-81 | VisualBasicCompilerServer.GetMetadataProvider | E-12 (line 31-34) | ○ |
| C-82 | VBCSCompiler.Main - 正常起動 | E-13 (line 14-53) | ○ |
| C-83 | VBCSCompiler.Main - AppSettings例外時 | E-13 (line 32-39) | ○ |
| C-84 | VBCSCompiler.Main - 起動失敗 | E-13 (line 46-51) | ○ |
| C-85 | MemoryHelper.IsMemoryAvailable - メモリ十分 | E-14 (line 35-59) | ○ |
| C-86 | MemoryHelper.IsMemoryAvailable - 非Windows | E-14 (line 37-41) | ○ |
| C-87 | MemoryHelper.IsMemoryAvailable - メモリ不足 | E-14 (line 58) | ○ |
| C-88 | EmptyDiagnosticListener.UpdateKeepAlive | E-15 (line 39-41) | ○ |
| C-89 | EmptyDiagnosticListener.ConnectionReceived | E-15 (line 43-45) | ○ |
| C-90 | EmptyDiagnosticListener.ConnectionCompleted | E-15 (line 47-49) | ○ |
| C-91 | EmptyDiagnosticListener.KeepAliveReached | E-15 (line 51-53) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースはソースコードから直接導出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードの実装に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値と期待結果がソースコードの実装と一致しているか確認
- [ ] 境界値テストケースが適切なエッジケースをカバーしているか確認
- [ ] 異常系テストケースが主要な例外パスをカバーしているか確認
- [ ] セキュリティ関連のテスト（権限チェック、認証）が十分にカバーされているか確認
- [ ] メモリ管理・リソース解放のテストが適切か確認
