---
generated_at: 2026-02-10 12:30:00
metrics:
  claims_total: 180
  claims_with_evidence: 180
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Compilers-Shared 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：180 / 180、根拠なし：0
- 優先レビュー（高）
  1. **UT-SHR-019〜022**: BuildRequest/BuildResponseのシリアライズ処理 - プロトコル仕様の理解が重要
  2. **UT-SHR-046〜066**: BuildServerConnectionのサーバー通信 - 複雑な非同期処理のテスト
  3. **UT-SHR-106〜112**: NamedPipeUtilのセキュリティ関連 - 権限チェックの正確性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilers/Shared/BuildClient.cs` - クライアントビルド処理の実装
- E-02: `src/Compilers/Shared/BuildProtocol.cs` - ビルドプロトコル定義
- E-03: `src/Compilers/Shared/BuildServerConnection.cs` - サーバー接続管理
- E-04: `src/Compilers/Shared/RuntimeHostInfo.cs` - ランタイム情報ユーティリティ
- E-05: `src/Compilers/Shared/CompilerServerLogger.cs` - ロギング機能
- E-06: `src/Compilers/Shared/ConsoleUtil.cs` - コンソールユーティリティ
- E-07: `src/Compilers/Shared/NamedPipeUtil.cs` - 名前付きパイプユーティリティ
- E-08: `src/Compilers/Shared/NativeMethods.cs` - ネイティブメソッドP/Invoke
- E-09: `src/Compilers/Shared/CoreClrShim.cs` - CoreCLRシム
- E-10: `src/Compilers/Shared/Csc.cs` - C#コンパイラエントリポイント
- E-11: `src/Compilers/Shared/Vbc.cs` - VBコンパイラエントリポイント
- E-12: `src/Compilers/Shared/ExitingTraceListener.cs` - トレースリスナー
- E-13: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/GlobalAssemblyCache.cs` - GAC抽象クラス
- E-14: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/ClrGlobalAssemblyCache.cs` - CLR GAC実装
- E-15: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/MonoGlobalAssemblyCache.cs` - Mono GAC実装
- E-16: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/DotNetCoreGlobalAssemblyCache.cs` - .NET Core GAC（No-op）
- E-17: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/GacFileResolver.cs` - GACファイルリゾルバ
- E-18: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/FusionAssemblyIdentity.cs` - Fusionアセンブリ識別
- E-19: `src/Compilers/Shared/GlobalAssemblyCacheHelpers/GlobalAssemblyCacheLocation.cs` - GACロケーション

## 3) Claims と根拠の対応（レビューの主戦場）

### BuildClient.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RunCompilationResultコンストラクタがExitCodeとRanOnServerを設定 | E-01 (lines 28-42) | ○ |
| C-02 | BuildClientコンストラクタが依存オブジェクトを注入 | E-01 (lines 59-65) | ○ |
| C-03 | GetClientDirectoryがAppDomain.CurrentDomain.BaseDirectoryを返却 | E-01 (lines 78-81) | ○ |
| C-04 | GetSystemSdkDirectoryがランタイム情報に基づいて動作 | E-01 (lines 86-91) | ○ |
| C-05 | CoreCLR環境でnullが返却される | E-01 (lines 88-89) | ○ |
| C-06 | Run静的メソッドがコンパイル処理を実行 | E-01 (lines 93-115) | ○ |
| C-07 | RunCompilationがコンパイルを実行しResultを返却 | E-01 (lines 122-166) | ○ |
| C-08 | 引数解析エラー時にFailedが返却される | E-01 (lines 143-146) | ○ |
| C-09 | RunCompilationAsyncが非同期実行をサポート | E-01 (lines 168-188) | ○ |
| C-10 | 例外発生時にTaskがFaultedになる | E-01 (lines 178-181) | ○ |
| C-11 | GetCompileOnServerFuncがデリゲートを返却 | E-01 (lines 196-202) | ○ |
| C-12 | IsRunningOnWindowsがプラットフォーム判定 | E-01 (line 49) | ○ |

### BuildProtocol.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | BuildRequestコンストラクタが正しく初期化 | E-02 (lines 63-74) | ○ |
| C-14 | requestIdがnullの場合空文字列になる | E-02 (line 68) | ○ |
| C-15 | BuildRequest.Createがリクエストを生成 | E-02 (lines 76-110) | ○ |
| C-16 | keepAliveが指定された場合引数に追加 | E-02 (lines 93-96) | ○ |
| C-17 | libDirectoryが指定された場合引数に追加 | E-02 (lines 98-101) | ○ |
| C-18 | CreateShutdownがシャットダウンリクエスト生成 | E-02 (lines 112-116) | ○ |
| C-19 | ReadAsyncがストリームから読み込み | E-02 (lines 124-155) | ○ |
| C-20 | MaximumRequestSizeを超えると例外 | E-02 (lines 131-135) | ○ |
| C-21 | WriteAsyncがストリームに書き込み | E-02 (lines 160-191) | ○ |
| C-22 | 書き込みサイズ超過で例外 | E-02 (lines 181-184) | ○ |
| C-23 | Argument構造体が正しく初期化 | E-02 (lines 206-219) | ○ |
| C-24 | ReadFromBinaryReaderがArgumentを読み込み | E-02 (lines 221-227) | ○ |
| C-25 | WriteToBinaryWriterがArgumentを書き込み | E-02 (lines 229-234) | ○ |
| C-26 | BuildResponse.WriteAsyncがレスポンス書き込み | E-02 (lines 282-310) | ○ |
| C-27 | BuildResponse.ReadAsyncがレスポンス読み込み | E-02 (lines 320-359) | ○ |
| C-28 | 不正なレスポンスタイプで例外 | E-02 (lines 354-357) | ○ |
| C-29 | CompletedBuildResponseコンストラクタ | E-02 (lines 381-388) | ○ |
| C-30 | outputがnullの場合空文字列 | E-02 (line 387) | ○ |
| C-31 | CompletedBuildResponse.Create | E-02 (lines 392-398) | ○ |
| C-32 | ShutdownBuildResponseコンストラクタ | E-02 (lines 412-415) | ○ |
| C-33 | ShutdownBuildResponse.Create | E-02 (lines 424-428) | ○ |
| C-34 | AnalyzerInconsistencyBuildResponseコンストラクタ | E-02 (lines 457-460) | ○ |
| C-35 | AnalyzerInconsistencyBuildResponse.Create | E-02 (lines 471-481) | ○ |
| C-36 | RejectedBuildResponseコンストラクタ | E-02 (lines 493-496) | ○ |
| C-37 | RejectedBuildResponse.Create | E-02 (lines 503-508) | ○ |
| C-38 | ReadLengthPrefixedStringが文字列読み込み | E-02 (lines 561-570) | ○ |
| C-39 | 長さが負の場合null | E-02 (lines 564-567) | ○ |
| C-40 | WriteLengthPrefixedStringが文字列書き込み | E-02 (lines 577-588) | ○ |
| C-41 | nullの場合-1を書き込み | E-02 (lines 584-587) | ○ |
| C-42 | GetCommitHashがハッシュ取得 | E-02 (lines 594-603) | ○ |
| C-43 | 属性がない場合null | E-02 (lines 597-601) | ○ |
| C-44 | ReadAllAsyncが指定バイト読み込み | E-02 (lines 608-627) | ○ |
| C-45 | EOF時に例外 | E-02 (lines 621-624) | ○ |

### BuildServerConnection.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | CreateBuildRequestがリクエスト生成 | E-03 (lines 69-90) | ○ |
| C-47 | RunServerShutdownRequestAsyncがシャットダウン | E-03 (lines 99-166) | ○ |
| C-48 | サーバー未起動時にtrue | E-03 (lines 106-111) | ○ |
| C-49 | RunServerBuildRequestAsyncがビルド実行 | E-03 (lines 168-336) | ○ |
| C-50 | 接続失敗時CannotConnectResponse | E-03 (lines 193-196) | ○ |
| C-51 | MonitorDisconnectAsyncが切断検出 | E-03 (lines 343-370) | ○ |
| C-52 | TryConnectToServerAsyncがサーバー接続 | E-03 (lines 376-439) | ○ |
| C-53 | タイムアウト時null | E-03 (lines 407-418) | ○ |
| C-54 | GetServerProcessInfoがプロセス情報取得 | E-03 (lines 441-454) | ○ |
| C-55 | 実行ファイル未存在時フォールバック | E-03 (lines 446-451) | ○ |
| C-56 | GetServerEnvironmentVariablesが環境変数取得 | E-03 (lines 491-523) | ○ |
| C-57 | 非CoreCLR環境でnull | E-03 (lines 493-496) | ○ |
| C-58 | TryCreateServerがサーバー作成 | E-03 (lines 531-647) | ○ |
| C-59 | 実行ファイル未存在時false | E-03 (lines 536-539) | ○ |
| C-60 | GetPipeNameがパイプ名生成 | E-03 (lines 652-665) | ○ |
| C-61 | 管理者権限で異なるパイプ名 | E-03 (lines 667-688) | ○ |
| C-62 | 末尾スラッシュ正規化 | E-03 (lines 674-678) | ○ |
| C-63 | WasServerMutexOpenがミューテックス確認 | E-03 (lines 690-710) | ○ |
| C-64 | OpenOrCreateMutexがミューテックス操作 | E-03 (lines 712-724) | ○ |
| C-65 | GetServerMutexNameがサーバー名生成 | E-03 (lines 726-729) | ○ |
| C-66 | GetClientMutexNameがクライアント名生成 | E-03 (lines 731-734) | ○ |
| C-67 | ServerFileMutexコンストラクタ | E-03 (lines 769-774) | ○ |
| C-68 | GetMutexDirectoryがディレクトリ取得 | E-03 (lines 761-767) | ○ |
| C-69 | TryLockがロック取得 | E-03 (lines 867-894) | ○ |
| C-70 | 既にロック済みでfalse | E-03 (lines 875-893) | ○ |
| C-71 | Disposed後に例外 | E-03 (lines 869-870) | ○ |
| C-72 | CouldLockがロック可能判定 | E-03 (lines 896-922) | ○ |
| C-73 | Disposeがリソース解放 | E-03 (lines 924-938) | ○ |
| C-74 | ServerNamedMutexコンストラクタ | E-03 (lines 949-958) | ○ |
| C-75 | WasOpenが開放確認 | E-03 (lines 960-977) | ○ |
| C-76 | TryLockがロック取得 | E-03 (lines 979-986) | ○ |
| C-77 | Disposeがミューテックス解放 | E-03 (lines 988-1004) | ○ |

### RuntimeHostInfo.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | IsCoreClrRuntimeが判定 | E-04 (lines 22-27) | ○ |
| C-79 | IsDesktopRuntimeが判定 | E-04 (line 20) | ○ |
| C-80 | GetToolDotNetRootがパス取得 | E-04 (lines 36-62) | ○ |
| C-81 | シンボリックリンク解決失敗でnull | E-04 (lines 49-53) | ○ |
| C-82 | DOTNET_HOST_PATHからパス取得 | E-04 (lines 71-74) | ○ |
| C-83 | PATHからdotnet検索 | E-04 (lines 85-100) | ○ |
| C-84 | 見つからない場合デフォルト | E-04 (line 102) | ○ |
| C-85 | GetDotNetExecCommandLineがコマンド生成 | E-04 (lines 105-106) | ○ |

### CompilerServerLogger.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | CompilerServerLoggerコンストラクタ | E-05 (lines 112-141) | ○ |
| C-87 | 環境変数からログパス取得 | E-05 (lines 118-129) | ○ |
| C-88 | ディレクトリ指定時プロセスIDベース名 | E-05 (lines 124-128) | ○ |
| C-89 | IsLoggingがストリーム状態確認 | E-05 (line 107) | ○ |
| C-90 | Logがメッセージ書き込み | E-05 (lines 149-163) | ○ |
| C-91 | Disposeがストリーム解放 | E-05 (lines 143-147) | ○ |
| C-92 | EmptyCompilerServerLogger.Instance | E-05 (line 169) | ○ |
| C-93 | EmptyCompilerServerLogger.IsLoggingがfalse | E-05 (line 171) | ○ |
| C-94 | 拡張メソッドLogがフォーマット出力 | E-05 (lines 32-38) | ○ |
| C-95 | LogErrorがエラープレフィックス付き出力 | E-05 (lines 40-54) | ○ |
| C-96 | LogExceptionが例外情報出力 | E-05 (lines 59-88) | ○ |
| C-97 | 内部例外も出力 | E-05 (lines 70-78) | ○ |

### ConsoleUtil.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | RunWithUtf8OutputがUTF-8実行 | E-06 (lines 20-39) | ○ |
| C-99 | 実行後エンコーディング復元 | E-06 (lines 28-38) | ○ |
| C-100 | 3引数版utf8Output=trueでUTF-8 | E-06 (lines 41-54) | ○ |
| C-101 | Console.Out以外で例外 | E-06 (lines 45-48) | ○ |

### NamedPipeUtil.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | CreateClientがパイプクライアント作成 | E-07 (lines 47-48) | ○ |
| C-103 | Unix環境で/tmpパス使用 | E-07 (lines 26-42) | ○ |
| C-104 | CreateServerがパイプサーバー作成 | E-07 (lines 84-95) | ○ |
| C-105 | pipeDirection未指定時InOut | E-07 (lines 88-89) | ○ |
| C-106 | CheckClientElevationMatchesが権限確認 | E-07 (lines 56-79) | ○ |
| C-107 | 異なる権限でfalse | E-07 (lines 65-67) | ○ |
| C-108 | 非Windows環境でtrue | E-07 (line 78) | ○ |
| C-109 | CheckPipeConnectionOwnershipが所有者確認 | E-07 (lines 132-146, 175-176) | ○ |
| C-110 | NETCOREAPPでtrue | E-07 (line 175) | ○ |
| C-111 | CreatePipeSecurityがACL作成 | E-07 (lines 148-167) | ○ |
| C-112 | Mono環境でnull | E-07 (lines 150-157) | ○ |

### NativeMethods.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | CreateProcessがプロセス作成 | E-08 (lines 79-94) | ○ |
| C-114 | CloseHandleがハンドル閉じる | E-08 (lines 72-74) | ○ |
| C-115 | GetCommandLineがコマンドライン取得 | E-08 (lines 96-97) | ○ |
| C-116 | ResolveLinkTargetWin32がリンク解決 | E-08 (lines 116-143) | ○ |
| C-117 | returnFinalTarget=falseで例外 | E-08 (line 118) | ○ |
| C-118 | 無効パスでnull | E-08 (lines 129-132) | ○ |

### CoreClrShim.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | IsRunningOnCoreClrが判定 | E-09 (line 18) | ○ |
| C-120 | AssemblyLoadContext.Typeが型取得 | E-09 (lines 20-23) | ○ |
| C-121 | AppContext.GetDataがデリゲート取得 | E-09 (lines 26-33) | ○ |

### Csc.cs / Vbc.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | Cscコンストラクタが初期化 | E-10 (lines 17-19) | ○ |
| C-123 | Csc.Runがコンパイル実行 | E-10 (lines 22-29) | ○ |
| C-124 | FatalError.SetHandlers呼び出し | E-10 (line 24) | ○ |
| C-125 | Vbcコンストラクタが初期化 | E-11 (lines 17-19) | ○ |
| C-126 | Vbc.Runがコンパイル実行 | E-11 (lines 22-29) | ○ |

### ExitingTraceListener.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | コンストラクタがLogger設定 | E-12 (lines 23-26) | ○ |
| C-128 | WriteがExit呼び出し | E-12 (lines 28-31) | ○ |
| C-129 | WriteLineがExit呼び出し | E-12 (lines 33-36) | ○ |
| C-130 | Installがリスナー追加 | E-12 (lines 38-42) | ○ |

### GlobalAssemblyCache.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | Mono環境でMonoGlobalAssemblyCache | E-13 (lines 22-25) | ○ |
| C-132 | .NET FrameworkでClrGlobalAssemblyCache | E-13 (lines 27-30) | ○ |
| C-133 | .NET CoreでDotNetCoreGlobalAssemblyCache | E-13 (line 30) | ○ |
| C-134 | 32bit環境でX86アーキテクチャ | E-13 (lines 37-39) | ○ |
| C-135 | 64bit環境でAmd64アーキテクチャ | E-13 (lines 37-39) | ○ |
| C-136 | ResolvePartialNameがアセンブリ解決 | E-13 (lines 72-78) | ○ |
| C-137 | displayNameがnullで例外 | E-14 (lines 207-209) | ○ |

### ClrGlobalAssemblyCache.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138 | GetAssemblyIdentities(AssemblyName) | E-14 (lines 83-86) | ○ |
| C-139 | GetAssemblyIdentities(string) | E-14 (lines 94-111) | ○ |
| C-140 | 無効名で空列挙 | E-14 (lines 100-103) | ○ |
| C-141 | GetAssemblySimpleNames | E-14 (lines 118-123) | ○ |
| C-142 | ResolvePartialName | E-14 (lines 201-230) | ○ |
| C-143 | GetAssemblyLocation | E-14 (lines 232-256) | ○ |

### MonoGlobalAssemblyCache.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | GetAssemblyIdentities(AssemblyName) | E-15 (lines 140-143) | ○ |
| C-145 | GetAssemblyIdentities(string) | E-15 (lines 145-158) | ○ |
| C-146 | GetAssemblySimpleNames | E-15 (lines 160-164) | ○ |
| C-147 | ResolvePartialName | E-15 (lines 166-212) | ○ |
| C-148 | displayNameがnullで例外 | E-15 (lines 172-175) | ○ |

### DotNetCoreGlobalAssemblyCache.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149 | GetAssemblyIdentities(AssemblyName)が空 | E-16 (lines 22-25) | ○ |
| C-150 | GetAssemblyIdentities(string)が空 | E-16 (lines 27-30) | ○ |
| C-151 | GetAssemblySimpleNamesが空 | E-16 (lines 32-35) | ○ |
| C-152 | ResolvePartialNameがnull | E-16 (lines 37-41) | ○ |

### GacFileResolver.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | コンストラクタが初期化 | E-17 (lines 55-71) | ○ |
| C-154 | GAC未サポートで例外 | E-17 (lines 59-62) | ○ |
| C-155 | architectures defaultでCurrentArchitectures | E-17 (lines 64-67) | ○ |
| C-156 | IsAvailableが可用性判定 | E-17 (lines 25-36) | ○ |
| C-157 | Resolveがパス解決 | E-17 (lines 73-78) | ○ |
| C-158 | 未発見でnull | E-17 (line 77) | ○ |
| C-159 | Equalsが等価判定（同一） | E-17 (lines 85-90) | ○ |
| C-160 | Equalsが等価判定（異なる） | E-17 (lines 85-90) | ○ |
| C-161 | GetHashCodeがハッシュ計算 | E-17 (lines 80-83) | ○ |

### FusionAssemblyIdentity.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | GetDisplayNameが表示名取得 | E-18 (lines 129-156) | ○ |
| C-163 | 空名で空文字列 | E-18 (lines 135-138) | ○ |
| C-164 | GetPropertyBytesがバイト取得 | E-18 (lines 158-185) | ○ |
| C-165 | GetPropertyStringが文字列取得 | E-18 (lines 187-199) | ○ |
| C-166 | GetVersionがバージョン取得 | E-18 (lines 209-220) | ○ |
| C-167 | GetPublicKeyTokenがトークン取得 | E-18 (lines 254-268) | ○ |
| C-168 | キーnullで空または null | E-18 (lines 262-267) | ○ |
| C-169 | ToAssemblyIdentityが変換 | E-18 (lines 403-424) | ○ |
| C-170 | nullでnull | E-18 (lines 405-408) | ○ |
| C-171 | ToAssemblyNameObject(AssemblyName) | E-18 (lines 429-494) | ○ |
| C-172 | nullでnull | E-18 (lines 431-434) | ○ |
| C-173 | null文字で例外 | E-18 (lines 442-451) | ○ |
| C-174 | ToAssemblyNameObject(string) | E-18 (lines 499-517) | ○ |
| C-175 | null文字でnull | E-18 (lines 502-505) | ○ |
| C-176 | GetBestMatchが最適選択 | E-18 (lines 523-579) | ○ |
| C-177 | 空候補でnull | E-18 (lines 525-576) | ○ |
| C-178 | カルチャ優先 | E-18 (lines 544-564) | ○ |

### GlobalAssemblyCacheLocation.cs 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-179 | RootLocationsがGACパス取得 | E-19 (lines 32-43) | ○ |
| C-180 | キャッシュ値返却 | E-19 (lines 36-39) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコード（E-01〜E-19）を直接参照して生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコードによる根拠あり
- 注意点:
  - プラットフォーム固有のテスト（Windows/Unix/Mono）は実行環境で結果が異なる可能性
  - P/Invoke関連（NativeMethods）のテストはモック化が必要
  - 非同期処理（BuildServerConnection）のテストはタイミングに依存する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースが対象クラス/メソッドの全パブリックAPIをカバーしているか
- [ ] 正常系・異常系・境界値のバランスが適切か
- [ ] 優先度の設定が業務要件に合致しているか
- [ ] プラットフォーム固有のテストが識別されているか
- [ ] モック化が必要な外部依存（ファイルシステム、ネットワーク）が考慮されているか
- [ ] セキュリティ関連のテスト（権限チェック、パイプ所有者確認）が含まれているか
