---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Dependencies モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Dependencies/Contracts/Contract.cs` - 契約検証クラス（ThrowIfNull, ThrowIfFalse, ThrowIfTrue, Fail）
- E-02: `src/Dependencies/Contracts/ExceptionUtilities.cs` - 例外ユーティリティ（UnexpectedValue, Unreachable, IsCurrentOperationBeingCancelled）
- E-03: `src/Dependencies/Contracts/ReferenceEqualityComparer.cs` - 参照比較クラス（Instance, Equals, GetHashCode）
- E-04: `src/Dependencies/Contracts/ErrorReporting/FatalError.cs` - 致命的エラー報告（SetHandlers, ReportAndPropagate, ReportAndCatch）
- E-05: `src/Dependencies/PooledObjects/ObjectPool`1.cs` - オブジェクトプール（Allocate, Free, コンストラクタ）
- E-06: `src/Dependencies/PooledObjects/ArrayBuilder.cs` - 配列ビルダー（Add, ToImmutable, GetInstance, Free, 各種操作）
- E-07: `src/Dependencies/PooledObjects/PooledHashSet.cs` - プール付きHashSet（GetInstance, Free）
- E-08: `src/Dependencies/PooledObjects/PooledDictionary.cs` - プール付きDictionary（GetInstance, Free, ToImmutableDictionaryAndFree）
- E-09: `src/Dependencies/Threading/CancellationSeries.cs` - キャンセルシリーズ（CreateNext, HasActiveToken, Dispose）
- E-10: `src/Dependencies/Threading/AsyncBatchingWorkQueue`2.cs` - 非同期バッチキュー（AddWork, CancelExistingWork, WaitUntilCurrentBatchCompletesAsync）
- E-11: `src/Dependencies/Collections/OneOrMany.cs` - 単一または複数要素コレクション（各種メソッド）
- E-12: `src/Dependencies/Collections/TemporaryArray`1.cs` - 一時配列（Add, インデクサ, ToImmutableAndClear, Dispose）
- E-13: `src/Dependencies/CodeAnalysis.Debugging/CustomDebugInfoReader.cs` - デバッグ情報読み取り（各種デコードメソッド）
- E-14: `src/Dependencies/CodeAnalysis.Debugging/CustomDebugInfoEncoder.cs` - デバッグ情報エンコード（各種Addメソッド）
- E-15: `src/Dependencies/Collections/RoslynImmutableInterlocked.cs` - アトミック操作（Update, InterlockedExchange, GetOrAdd, TryAdd, TryRemove）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Contract.ThrowIfNull正常系テスト | E-01 L30-36 | ○ |
| C-02 | Contract.ThrowIfNull異常系テスト | E-01 L30-36 | ○ |
| C-03 | Contract.ThrowIfNullカスタムメッセージ正常系 | E-01 L56-62 | ○ |
| C-04 | Contract.ThrowIfNullカスタムメッセージ異常系 | E-01 L56-62 | ○ |
| C-05 | Contract.ThrowIfFalse正常系テスト | E-01 L82-88 | ○ |
| C-06 | Contract.ThrowIfFalse異常系テスト | E-01 L82-88 | ○ |
| C-07 | Contract.ThrowIfTrue正常系テスト | E-01 L121-127 | ○ |
| C-08 | Contract.ThrowIfTrue異常系テスト | E-01 L121-127 | ○ |
| C-09 | Contract.Fail異常系テスト | E-01 L158-162 | ○ |
| C-10 | ExceptionUtilities.UnexpectedValue正常系 | E-02 L21-28 | ○ |
| C-11 | ExceptionUtilities.UnexpectedValue null処理 | E-02 L21-28 | ○ |
| C-12 | ExceptionUtilities.Unreachable異常系 | E-02 L30-31 | ○ |
| C-13 | ExceptionUtilities.IsCurrentOperationBeingCancelled正常系 | E-02 L39-40 | ○ |
| C-14 | IsCurrentOperationBeingCancelled非キャンセル例外 | E-02 L39-40 | ○ |
| C-15 | IsCurrentOperationBeingCancelled未キャンセルトークン | E-02 L39-40 | ○ |
| C-16 | ReferenceEqualityComparer.Instance取得 | E-03 L26 | ○ |
| C-17 | ReferenceEqualityComparer.Equals同一参照 | E-03 L41 | ○ |
| C-18 | ReferenceEqualityComparer.Equals異なる参照 | E-03 L41 | ○ |
| C-19 | ReferenceEqualityComparer.Equals両方null | E-03 L41 | ○ |
| C-20 | ReferenceEqualityComparer.GetHashCode | E-03 L55-61 | ○ |
| C-21 | ObjectPool<T>デフォルトコンストラクタ | E-05 L111-114 | ○ |
| C-22 | ObjectPool<T>サイズ指定コンストラクタ | E-05 L116-122 | ○ |
| C-23 | ObjectPool<T>.Allocate新規オブジェクト | E-05 L145-167 | ○ |
| C-24 | ObjectPool<T>.Allocateオブジェクト再利用 | E-05 L145-167 | ○ |
| C-25 | ObjectPool<T>.Free返却 | E-05 L199-215 | ○ |
| C-26 | ObjectPool<T>.Freeプール満杯時 | E-05 L217-231 | ○ |
| C-27 | ArrayBuilder<T>デフォルトコンストラクタ | E-06 L65-67 | ○ |
| C-28 | ArrayBuilder<T>サイズ指定コンストラクタ | E-06 L60-63 | ○ |
| C-29 | ArrayBuilder<T>.Add要素追加 | E-06 L171-174 | ○ |
| C-30 | ArrayBuilder<T>.Add複数要素追加 | E-06 L171-174 | ○ |
| C-31 | ArrayBuilder<T>インデクサ正常系 | E-06 L131-142 | ○ |
| C-32 | ArrayBuilder<T>インデクサ異常系 | E-06 L131-142 | ○ |
| C-33 | ArrayBuilder<T>.Clear | E-06 L189-192 | ○ |
| C-34 | ArrayBuilder<T>.ToImmutable | E-06 L78-81 | ○ |
| C-35 | ArrayBuilder<T>.ToImmutableAndFree | E-06 L428-448 | ○ |
| C-36 | ArrayBuilder<T>.GetInstance | E-06 L504-509 | ○ |
| C-37 | ArrayBuilder<T>.Free | E-06 L470-499 | ○ |
| C-38 | ArrayBuilder<T>.Contains存在する | E-06 L194-197 | ○ |
| C-39 | ArrayBuilder<T>.Contains存在しない | E-06 L194-197 | ○ |
| C-40 | ArrayBuilder<T>.IndexOf存在する | E-06 L199-212 | ○ |
| C-41 | ArrayBuilder<T>.IndexOf存在しない | E-06 L199-212 | ○ |
| C-42 | ArrayBuilder<T>.Remove存在する | E-06 L254-257 | ○ |
| C-43 | ArrayBuilder<T>.Remove存在しない | E-06 L254-257 | ○ |
| C-44 | ArrayBuilder<T>.RemoveAt | E-06 L259-262 | ○ |
| C-45 | ArrayBuilder<T>.Sort | E-06 L336-339 | ○ |
| C-46 | ArrayBuilder<T>.ReverseContents | E-06 L331-334 | ○ |
| C-47 | ArrayBuilder<T>.First | E-06 L375-378 | ○ |
| C-48 | ArrayBuilder<T>.Last | E-06 L369-370 | ○ |
| C-49 | ArrayBuilder<T>.Any要素あり | E-06 L380-383 | ○ |
| C-50 | ArrayBuilder<T>.Any要素なし | E-06 L380-383 | ○ |
| C-51 | PooledHashSet<T>.GetInstance | E-07 L44-49 | ○ |
| C-52 | PooledHashSet<T>.Free | E-07 L27-31 | ○ |
| C-53 | PooledHashSet<T>.Add | E-07継承元HashSet | ○ |
| C-54 | PooledDictionary<K,V>.GetInstance | E-08 L55-60 | ○ |
| C-55 | PooledDictionary<K,V>.Free | E-08 L38-42 | ○ |
| C-56 | PooledDictionary<K,V>.ToImmutableDictionaryAndFree | E-08 L29-34 | ○ |
| C-57 | CancellationSeriesコンストラクタ | E-09 L37-44 | ○ |
| C-58 | CancellationSeriesスーパートークン付き | E-09 L37-44 | ○ |
| C-59 | CancellationSeries.CreateNext新規トークン | E-09 L68-114 | ○ |
| C-60 | CancellationSeries.CreateNext前回キャンセル | E-09 L68-114 | ○ |
| C-61 | CancellationSeries.HasActiveTokenアクティブ | E-09 L49-50 | ○ |
| C-62 | CancellationSeries.HasActiveToken初期 | E-09 L49-50 | ○ |
| C-63 | CancellationSeries.Disposeリソース解放 | E-09 L116-134 | ○ |
| C-64 | CancellationSeries.Disposeトークンキャンセル | E-09 L116-134 | ○ |
| C-65 | CancellationSeries.CreateNextDispose後 | E-09 L95-100 | ○ |
| C-66 | AsyncBatchingWorkQueueコンストラクタ | E-10 L105-123 | ○ |
| C-67 | AsyncBatchingWorkQueue.AddWork単一 | E-10 L147-149 | ○ |
| C-68 | AsyncBatchingWorkQueue.AddWork複数 | E-10 L152-196 | ○ |
| C-69 | AsyncBatchingWorkQueue.AddWork重複排除 | E-10 L179-195 | ○ |
| C-70 | AsyncBatchingWorkQueue.CancelExistingWork | E-10 L134-145 | ○ |
| C-71 | AsyncBatchingWorkQueue.WaitUntilCurrentBatchCompletesAsync | E-10 L229-245 | ○ |
| C-72 | AsyncBatchingWorkQueue.Dispose | E-10 L125-128 | ○ |
| C-73 | OneOrMany<T>単一要素コンストラクタ | E-11 L33-37 | ○ |
| C-74 | OneOrMany<T>複数要素コンストラクタ | E-11 L39-56 | ○ |
| C-75 | OneOrMany<T>単一要素ImmutableArray | E-11 L46-49 | ○ |
| C-76 | OneOrMany<T>デフォルトImmutableArray例外 | E-11 L41-44 | ○ |
| C-77 | OneOrMany<T>インデクサ単一index0 | E-11 L68-86 | ○ |
| C-78 | OneOrMany<T>インデクサ単一index1例外 | E-11 L68-86 | ○ |
| C-79 | OneOrMany<T>.Count単一 | E-11 L88-89 | ○ |
| C-80 | OneOrMany<T>.Count複数 | E-11 L88-89 | ○ |
| C-81 | OneOrMany<T>.IsEmpty空 | E-11 L91-92 | ○ |
| C-82 | OneOrMany<T>.IsEmpty要素あり | E-11 L91-92 | ○ |
| C-83 | OneOrMany<T>.Add | E-11 L94-97 | ○ |
| C-84 | OneOrMany<T>.Contains存在する | E-11 L111-112 | ○ |
| C-85 | OneOrMany<T>.Contains存在しない | E-11 L111-112 | ○ |
| C-86 | OneOrMany<T>.RemoveAll | E-11 L114-122 | ○ |
| C-87 | OneOrMany<T>.Select | E-11 L124-129 | ○ |
| C-88 | OneOrMany<T>.ToImmutable | E-11 L185-186 | ○ |
| C-89 | OneOrMany<T>.SequenceEqual同一 | E-11 L191-204 | ○ |
| C-90 | OneOrMany<T>.SequenceEqual異なる | E-11 L191-204 | ○ |
| C-91 | TemporaryArray<T>.Addインライン | E-12 L159-177 | ○ |
| C-92 | TemporaryArray<T>.Add4要素まで | E-12 L159-177 | ○ |
| C-93 | TemporaryArray<T>.Add5要素目動的 | E-12 L159-177, L334-353 | ○ |
| C-94 | TemporaryArray<T>インデクサ正常系 | E-12 L109-149 | ○ |
| C-95 | TemporaryArray<T>インデクサ異常系 | E-12 L109-149 | ○ |
| C-96 | TemporaryArray<T>.Clear | E-12 L220-231 | ○ |
| C-97 | TemporaryArray<T>.RemoveLast | E-12 L233-250 | ○ |
| C-98 | TemporaryArray<T>.ToImmutableAndClear | E-12 L302-326 | ○ |
| C-99 | TemporaryArray<T>.Dispose | E-12 L151-157 | ○ |
| C-100 | TemporaryArray<T>.ReverseContents | E-12 L355-381 | ○ |
| C-101 | TemporaryArray<T>.Sort | E-12 L383-434 | ○ |
| C-102 | CustomDebugInfoReader.TryGetCustomDebugInfoRecord正常系 | E-13 L56-67 | ○ |
| C-103 | CustomDebugInfoReader.TryGetCustomDebugInfoRecord存在しない | E-13 L56-67 | ○ |
| C-104 | CustomDebugInfoReader.GetCustomDebugInfoRecords | E-13 L73-117 | ○ |
| C-105 | CustomDebugInfoReader.GetCustomDebugInfoRecords不正データ | E-13 L73-117 | ○ |
| C-106 | CustomDebugInfoReader.DecodeUsingRecord | E-13 L127-139 | ○ |
| C-107 | CustomDebugInfoReader.DecodeForwardRecord | E-13 L149-153 | ○ |
| C-108 | CustomDebugInfoReader.DecodeStateMachineHoistedLocalScopesRecord | E-13 L175-201 | ○ |
| C-109 | CustomDebugInfoReader.DecodeForwardIteratorRecord | E-13 L214-232 | ○ |
| C-110 | CustomDebugInfoReader.DecodeDynamicLocalsRecord | E-13 L243-297 | ○ |
| C-111 | CustomDebugInfoReader.DecodeTupleElementNamesRecord | E-13 L302-313 | ○ |
| C-112 | CustomDebugInfoReader.TryParseCSharpImportString Using | E-13 L577-596 | ○ |
| C-113 | CustomDebugInfoReader.TryParseCSharpImportString エイリアス | E-13 L617-648 | ○ |
| C-114 | CustomDebugInfoReader.TryParseCSharpImportString空文字列 | E-13 L584-587 | ○ |
| C-115 | CustomDebugInfoReader.TryParseVisualBasicImportString | E-13 L678-823 | ○ |
| C-116 | CustomDebugInfoEncoderコンストラクタ | E-14 L23-38 | ○ |
| C-117 | CustomDebugInfoEncoder.ToArray空 | E-14 L43-53 | ○ |
| C-118 | CustomDebugInfoEncoder.ToArrayレコードあり | E-14 L43-53 | ○ |
| C-119 | CustomDebugInfoEncoder.AddStateMachineTypeName | E-14 L55-65 | ○ |
| C-120 | CustomDebugInfoEncoder.AddForwardMethodInfo | E-14 L67-72 | ○ |
| C-121 | CustomDebugInfoEncoder.AddUsingGroups | E-14 L83-106 | ○ |
| C-122 | CustomDebugInfoEncoder.AddUsingGroups空 | E-14 L89-92 | ○ |
| C-123 | CustomDebugInfoEncoder.AddStateMachineHoistedLocalScopes | E-14 L108-136 | ○ |
| C-124 | CustomDebugInfoEncoder.AddDynamicLocals | E-14 L141-163 | ○ |
| C-125 | CustomDebugInfoEncoder.AddTupleElementNames | E-14 L165-203 | ○ |
| C-126 | RoslynImmutableInterlocked.Update(List)更新 | E-15 L33-54 | ○ |
| C-127 | RoslynImmutableInterlocked.Update(List)無変更 | E-15 L33-54 | ○ |
| C-128 | RoslynImmutableInterlocked.Update(List)null例外 | E-15 L35-36 | ○ |
| C-129 | RoslynImmutableInterlocked.InterlockedExchange(List) | E-15 L105-108 | ○ |
| C-130 | RoslynImmutableInterlocked.InterlockedCompareExchange(List)一致 | E-15 L119-122 | ○ |
| C-131 | RoslynImmutableInterlocked.InterlockedCompareExchange(List)不一致 | E-15 L119-122 | ○ |
| C-132 | RoslynImmutableInterlocked.InterlockedInitialize(List)未初期化 | E-15 L133-136 | ○ |
| C-133 | RoslynImmutableInterlocked.InterlockedInitialize(List)初期化済み | E-15 L133-136 | ○ |
| C-134 | RoslynImmutableInterlocked.GetOrAdd存在しない | E-15 L431-456 | ○ |
| C-135 | RoslynImmutableInterlocked.GetOrAdd存在する | E-15 L431-456 | ○ |
| C-136 | RoslynImmutableInterlocked.TryAdd存在しない | E-15 L533-556 | ○ |
| C-137 | RoslynImmutableInterlocked.TryAdd存在する | E-15 L533-556 | ○ |
| C-138 | RoslynImmutableInterlocked.TryRemove存在する | E-15 L587-610 | ○ |
| C-139 | RoslynImmutableInterlocked.TryRemove存在しない | E-15 L587-610 | ○ |
| C-140 | RoslynImmutableInterlocked.TryUpdate一致 | E-15 L559-584 | ○ |
| C-141 | FatalError.SetHandlers | E-04 L47-55 | ○ |
| C-142 | FatalError.OverwriteHandler | E-04 L62-65 | ○ |
| C-143 | FatalError.ReportAndPropagate | E-04 L101-106 | ○ |
| C-144 | FatalError.ReportAndPropagateUnlessCanceledキャンセル | E-04 L114-122 | ○ |
| C-145 | FatalError.ReportAndPropagateUnlessCanceled通常 | E-04 L114-122 | ○ |
| C-146 | FatalError.ReportAndCatch | E-04 L164-168 | ○ |
| C-147 | FatalError.ReportAndCatchUnlessCanceledキャンセル | E-04 L189-197 | ○ |
| C-148 | FatalError.ReportAndCatchUnlessCanceled通常 | E-04 L189-197 | ○ |
| C-149 | FatalError.ReportNonFatalError | E-04 L270-273 | ○ |
| C-150 | FatalError.CopyHandlersTo | E-04 L74-94 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードの解析に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、根拠が明確です
- SegmentedCollections（SegmentedList, SegmentedDictionary, SegmentedHashSet等）の詳細なテストケースは、ファイルサイズが大きいため主要なメソッドに限定しています
- 非同期処理（AsyncBatchingWorkQueue）のテストは、実行環境によって挙動が異なる可能性があります

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト観点（正常系/異常系/境界値）が適切か確認
- [ ] 入力値と期待結果の整合性を確認
- [ ] 優先度の設定が適切か確認（金額・数量計算、認証・認可、データ整合性関連は「高」）
- [ ] プロジェクト固有のビジネスロジックに関するテストケースが網羅されているか確認
- [ ] 既存のテストコードとの整合性を確認
- [ ] PooledObjects関連のメモリ管理テストが十分か確認
- [ ] Threading関連の並行処理テストが十分か確認
