---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 92
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：EditorFeatures-CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：92 / 100、根拠なし：8
- 優先レビュー（高）
  1. **UT-EFC-078～083**：継承元クラスの実装詳細が未確認
  2. **UT-EFC-085～092**：一部のコマンドハンドラの詳細実装が未確認
  3. **UT-EFC-094～097**：StringCopyPaste関連の一部ヘルパーの詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EditorFeatures/CSharp/CodeCleanup/CSharpCodeCleanupService.cs`
- E-02: `src/EditorFeatures/CSharp/InlineRename/CSharpEditorInlineRenameService.cs`
- E-03: `src/EditorFeatures/CSharp/TextStructureNavigation/CSharpTextStructureNavigatorProvider.cs`
- E-04: `src/EditorFeatures/CSharp/CommentSelection/CSharpToggleBlockCommentCommandHandler.cs`
- E-05: `src/EditorFeatures/CSharp/AutomaticCompletion/AutomaticLineEnderCommandHandler.cs`
- E-06: `src/EditorFeatures/CSharp/AutomaticCompletion/AutomaticLineEnderCommandHandler_Helpers.cs`
- E-07: `src/EditorFeatures/CSharp/StringCopyPaste/StringCopyPasteCommandHandler.cs`
- E-08: `src/EditorFeatures/CSharp/StringCopyPaste/AbstractPasteProcessor.cs`
- E-09: `src/EditorFeatures/CSharp/StringCopyPaste/StringCopyPasteHelpers.cs`
- E-10: `src/EditorFeatures/CSharp/EventHookup/EventHookupSessionManager.cs`
- E-11: `src/EditorFeatures/CSharp/EventHookup/EventHookupCommandHandler.cs`
- E-12: `src/EditorFeatures/CSharp/DocumentationComments/DocumentationCommentCommandHandler.cs`
- E-13: `src/EditorFeatures/CSharp/SplitStringLiteral/SplitStringLiteralCommandHandler.cs`
- E-14: `src/EditorFeatures/CSharp/BlockCommentEditing/BlockCommentEditingCommandHandler.cs`
- E-15: `src/EditorFeatures/CSharp/CompleteStatement/CompleteStatementCommandHandler.cs`
- E-16: `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler.cs`
- E-17: `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler_Return.cs`
- E-18: `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler_TypeChar.cs`
- E-19: `src/EditorFeatures/CSharp/Formatting/CSharpFormattingInteractionService.cs`
- E-20: `src/EditorFeatures/CSharp/AddImports/CSharpAddImportsPasteCommandHandler.cs`
- E-21: `src/EditorFeatures/CSharp/EndConstruct/CSharpEndConstructGenerationService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpCodeCleanupService.GetDiagnosticSetsが診断セットを返す | E-01 L25-172 | ○ |
| C-02 | CSharpCodeCleanupService.OrganizeImportsDescriptionがローカライズ文字列を返す | E-01 L174-175 | ○ |
| C-03 | CSharpEditorInlineRenameService.GetRenameContextAsyncがコンテキストを返す | E-02 L38-169 | ○ |
| C-04 | GetRenameContextAsyncがMaxDefinitionCount(10)で制限 | E-02 L31, L46 | ○ |
| C-05 | GetRenameContextAsyncがMaxReferenceCount(50)で制限 | E-02 L32, L79 | ○ |
| C-06 | GetRenameContextAsyncが空定義を処理 | E-02 L95-97 | ○ |
| C-07 | CSharpTextStructureNavigatorProvider.ShouldSelectEntireTriviaFromStartがコメントを判定 | E-03 L28-29 | ○ |
| C-08 | CSharpTextStructureNavigatorProvider.GetExtentOfWordFromTokenがトークン種別で処理を分岐 | E-03 L31-125 | ○ |
| C-09-12 | GetExtentOfWordFromTokenの各トークン種別処理 | E-03 L37-81 | ○ |
| C-13-15 | CSharpToggleBlockCommentCommandHandler.GetBlockCommentsInDocumentがブロックコメントを検出 | E-04 L41-51 | ○ |
| C-16-17 | AutomaticLineEnderCommandHandler.TreatAsReturnがShift+Enterを処理 | E-05 L61-91 | ○ |
| C-18-19 | AutomaticLineEnderCommandHandler.FormatBasedOnEndTokenがフォーマットを適用 | E-05 L93-108 | ○ |
| C-20-21 | AutomaticLineEnderCommandHandler.GetEndingStringがセミコロンを判定 | E-05 L128-165 | ○ |
| C-22-25 | AutomaticLineEnderCommandHandler.GetValidNodeToModifyBracesとModifySelectedNode | E-05 L656-678, L302-383 | ○ |
| C-26-30 | StringCopyPasteCommandHandler.ExecuteCommandがペーストを処理 | E-07 L72-227 | ○ |
| C-31-37 | StringCopyPasteHelpersの各ヘルパーメソッド | E-09 L24-595 | ○ |
| C-38-40 | AbstractPasteProcessor.GetQuotesToAddToRawStringとGetDollarSignsToAddToRawString | E-08 L136-167 | ○ |
| C-41-45 | EventHookupSessionManagerのセッション管理 | E-10 L59-209 | ○ |
| C-46 | DocumentationCommentCommandHandler.ExteriorTriviaText | E-12 L33 | ○ |
| C-47-50 | SplitStringLiteralCommandHandler.ExecuteCommandWorker | E-13 L43-156 | ○ |
| C-51-54 | BlockCommentEditingCommandHandler.TryHandleReturnKeyとIsCaretInsideBlockCommentSyntax | E-14 L61-317 | ○ |
| C-55-63 | CompleteStatementCommandHandler.ExecuteCommandと関連メソッド | E-15 L73-613 | ○ |
| C-64-66 | RawStringLiteralCommandHandler Return処理 | E-17 L23-256 | ○ |
| C-67-69 | RawStringLiteralCommandHandler TypeChar処理 | E-18 L21-81 | ○ |
| C-70-74 | CSharpFormattingInteractionServiceの各メソッド | E-19 L43-114 | ○ |
| C-75-76 | CSharpAddImportsPasteCommandHandlerのプロパティ | E-20 L34-35 | ○ |
| C-77 | CSharpEndConstructGenerationService.TryDoAsync | E-21 L24-25 | ○ |
| C-78 | CSharpGoToBaseServiceの基底クラス移動 | **根拠なし** | △ |
| C-79 | CSharpContentTypeLanguageServiceのサービス登録 | **根拠なし** | △ |
| C-80 | CSharpRenameTrackingLanguageHeuristicsServiceのヒューリスティクス | **根拠なし** | △ |
| C-81 | CSharpChangeSignatureCommandHandlerのコマンド実行 | **根拠なし** | △ |
| C-82 | EncapsulateFieldCommandHandlerのコマンド実行 | E-02(EncapsulateField) 基底クラス参照 | △ |
| C-83 | ExtractInterfaceCommandHandlerのコマンド実行 | **根拠なし** | △ |
| C-84 | ConvertNamespaceCommandHandlerのコマンド実行 | **根拠なし** | △ |
| C-85 | XmlTagCompletionCommandHandlerのタグ補完 | **根拠なし** | △ |
| C-86-100 | 残りのテストケース | E-05, E-06, E-07, E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- **CSharpGoToBaseService**: 基底クラス(AbstractGoToBaseService)の実装詳細が必要
  - 候補：EditorFeatures/Core/GoToBase/AbstractGoToBaseService.cs
- **CSharpChangeSignatureCommandHandler**: 基底クラス(AbstractChangeSignatureCommandHandler)の実装詳細が必要
  - 候補：EditorFeatures/Core/ChangeSignature/AbstractChangeSignatureCommandHandler.cs
- **ExtractInterfaceCommandHandler**: 基底クラスの実装詳細が必要
  - 候補：EditorFeatures/Core/ExtractInterface/AbstractExtractInterfaceCommandHandler.cs
- **XMLタグ補完関連**: XmlTagCompletionCommandHandler.csの詳細実装確認が必要
  - 候補：DocumentationComments/XmlTagCompletionCommandHandler.cs

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**: UT-EFC-001～077 - ソースコードから直接確認可能な主張
- **リスク1（中リスク）**: UT-EFC-078～092 - 基底クラスの実装に依存する主張。継承関係の確認が必要
- **リスク0（低リスク）**: UT-EFC-093～100 - ヘルパーメソッドの詳細はソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 基底クラスを継承しているコマンドハンドラ（UT-EFC-078～083）の期待結果が基底クラスの実装と整合しているか確認
- [ ] StringCopyPaste関連のテストケース（UT-EFC-026～040, 094～097）がエッジケースを網羅しているか確認
- [ ] AutomaticLineEnderCommandHandler関連のテストケース（UT-EFC-016～025）がすべてのSyntaxNode種別をカバーしているか確認
- [ ] CompleteStatementCommandHandler関連のテストケース（UT-EFC-055～063）がすべてのStatement種別をカバーしているか確認
- [ ] RawStringLiteral関連のテストケース（UT-EFC-064～069）が空・非空・補間の各ケースを網羅しているか確認
- [ ] 優先度「高」のテストケースが実装上の重要な機能を正しくカバーしているか確認
