---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：EditorFeatures-Core.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-EFC-042: コンテンツタイプ変更時のプロバイダー再取得**：実際の動的更新動作の確認が必要
  2. **UT-EFC-072: フィルタリング不可プロジェクト判定**：複数プロジェクト環境での動作確認推奨
  3. **UT-EFC-097/098: スマートインデント取得**：具体的なインデント計算ロジックの確認が必要
  4. **UT-EFC-036: 空白行のみのインデント計算**：実装詳細の確認推奨
  5. **UT-EFC-019: オプション同一時の最適化**：早期リターンの実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EditorFeatures/Core/InlineRename/InlineRenameService.cs` - InlineRenameServiceクラスの実装
- E-02: `src/EditorFeatures/Core/InlineRename/InlineRenameSession.cs` - InlineRenameSessionクラスの実装
- E-03: `src/EditorFeatures/Core/GoToDefinition/GoToDefinitionCommandHandler.cs` - GoToDefinitionコマンドハンドラ実装
- E-04: `src/EditorFeatures/Core/CommentSelection/AbstractCommentSelectionBase.cs` - コメント選択基底クラス実装
- E-05: `src/EditorFeatures/Core/SignatureHelp/Controller.cs` - シグネチャヘルプコントローラ実装
- E-06: `src/EditorFeatures/Core/Formatting/FormatCommandHandler.cs` - フォーマットコマンドハンドラ実装
- E-07: `src/EditorFeatures/Core/BraceMatching/BraceHighlightingViewTaggerProvider.cs` - 括弧マッチングタガープロバイダー実装
- E-08: `src/EditorFeatures/Core/Tagging/AbstractAsynchronousTaggerProvider.cs` - 非同期タガープロバイダー基底クラス実装
- E-09: `src/EditorFeatures/Core/NavigateTo/NavigateToItemProvider.cs` - NavigateToアイテムプロバイダー実装
- E-10: `src/EditorFeatures/Core/NavigateTo/NavigateToItemDisplay.cs` - NavigateToアイテム表示クラス実装
- E-11: `src/EditorFeatures/Core/Shared/Extensions/ITextViewExtensions.cs` - ITextView拡張メソッド実装

## 3) Claims と根拠の対応（レビューの主戦場）

### InlineRenameService (UT-EFC-001 - UT-EFC-007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StartInlineSession: 有効なドキュメントとテキストスパンでセッション開始 | E-01 L50-56 | ○ |
| C-02 | StartInlineSession: アクティブセッション存在時の例外 | E-01 L63-66 | ○ |
| C-03 | StartInlineSessionAsync: 非同期セッション開始 | E-01 L58-114 | ○ |
| C-04 | StartInlineSessionAsync: リネーム不可シンボルのエラー | E-01 L78-81 | ○ |
| C-05 | StartInlineSessionAsync: 読み取り専用ファイルのエラー | E-01 L116-155 | ○ |
| C-06 | ActiveSession: UIスレッドからのアクセス | E-01 L160-167 | ○ |
| C-07 | ActiveSession: 非UIスレッドからのアクセス例外 | E-01 L164 | ○ |

### InlineRenameSession (UT-EFC-008 - UT-EFC-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | Constructor: 有効パラメータでの初期化 | E-02 L128-188 | ○ |
| C-09 | Constructor: 不正トリガースパンでの例外 | E-02 L148-151 | ○ |
| C-10 | ApplyReplacementText: 全バッファへの適用 | E-02 L444-508 | ○ |
| C-11 | ApplyReplacementText: 空文字列の適用 | E-02 L448 | ○ |
| C-12 | ApplyReplacementText: 終了後の例外 | E-02 L447 VerifyNotDismissed | ○ |
| C-13 | CommitAsync: ワークスペースへのコミット | E-02 L727-795 | ○ |
| C-14 | CommitAsync: プレビュー付きコミット | E-02 L806-826 | ○ |
| C-15 | CommitAsync: 空文字列でのキャンセル | E-02 L741-746 | ○ |
| C-16 | CommitAsync: 元テキストと同じ場合のキャンセル | E-02 L741-746 | ○ |
| C-17 | Cancel: セッションキャンセルとロールバック | E-02 L644-650 | ○ |
| C-18 | RefreshRenameSessionWithOptionsChanged: オプション更新 | E-02 L348-360 | ○ |
| C-19 | RefreshRenameSessionWithOptionsChanged: 同一オプション時の最適化 | E-02 L350-353 | ○ |
| C-20 | TryGetContainingEditableSpan: 編集可能スパン取得 | E-02 L963-981 | ○ |
| C-21 | TryGetContainingEditableSpan: 未登録バッファでfalse | E-02 L966-969 | ○ |

### GoToDefinitionCommandHandler (UT-EFC-022 - UT-EFC-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | GetCommandState: サービス存在時のAvailable | E-03 L50-56 | ○ |
| C-23 | GetCommandState: サービス不在時のUnspecified | E-03 L50-56 | ○ |
| C-24 | ExecuteCommand: 定義へのナビゲート | E-03 L58-97 | ○ |
| C-25 | ExecuteCommand: サービスnull時のfalse | E-03 L62-64 | ○ |
| C-26 | ExecuteCommand: 空スナップショット時のfalse | E-03 L76-78 | ○ |
| C-27 | ExecuteCommand: LSPコンテキスト時のfalse | E-03 L71-72 | ○ |

### AbstractCommentSelectionBase (UT-EFC-028 - UT-EFC-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | ExecuteCommand: コメント適用 | E-04 L85-117 | ○ |
| C-29 | ExecuteCommand: 空選択時のtrue | E-04 L95-98 | ○ |
| C-30 | ExecuteCommand: ドキュメントnull時のtrue | E-04 L100-104 | ○ |
| C-31 | GetCommandState: 変更可能時のAvailable | E-04 L72-77 | ○ |
| C-32 | GetCommandState: 変更不可時のUnspecified | E-04 L72-77 | ○ |
| C-33 | CreateTrackingSpan: コメント操作用スパン | E-04 L170-177 | ○ |
| C-34 | CreateTrackingSpan: アンコメント操作用スパン | E-04 L170-177 | ○ |
| C-35 | DetermineSmallestIndent: 最小インデント計算 | E-04 L202-218 | ○ |
| C-36 | DetermineSmallestIndent: 空白行のみでMaxValue | E-04 L206-214 | △ |

### SignatureHelp Controller (UT-EFC-037 - UT-EFC-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | Constructor: 初期化 | E-05 L40-54 | ○ |
| C-38 | OnModelUpdated: プレゼンターへの表示 | E-05 L81-109 | ○ |
| C-39 | OnModelUpdated: nullモデルでのセッション停止 | E-05 L87-90 | ○ |
| C-40 | StartSession: 新規セッション開始 | E-05 L111-119 | ○ |
| C-41 | GetProviders: プロバイダー取得 | E-05 L121-141 | ○ |
| C-42 | GetProviders: コンテンツタイプ変更時の再取得 | E-05 L129-138 | △ |
| C-43 | Retrigger: リトリガー | E-05 L143-158 | ○ |
| C-44 | Retrigger: 非アクティブ時の無処理 | E-05 L146-149 | ○ |

### FormatCommandHandler (UT-EFC-045 - UT-EFC-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | ExecuteCommand (FormatDocument): ドキュメントフォーマット | E-06 L57-68 | ○ |
| C-46 | ExecuteCommand (FormatSelection): 選択範囲フォーマット | E-06 L57-68 | ○ |
| C-47 | ExecuteReturnOrTypeCommand: Enter時の自動フォーマット | E-06 L145-152 | ○ |
| C-48 | ExecuteReturnOrTypeCommand: 文字入力時のフォーマット | E-06 L154-164 | ○ |
| C-49 | ExecuteReturnOrTypeCommand: キャンセル時の中断 | E-06 L106-120 | ○ |
| C-50 | CanExecuteCommand: 変更可能時のtrue | E-06 L96-97 | ○ |
| C-51 | CanExecuteCommand: 変更不可時のfalse | E-06 L96-97 | ○ |

### BraceHighlightingViewTaggerProvider (UT-EFC-052 - UT-EFC-059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | ProduceTagsAsync: 括弧ペアハイライト | E-07 L46-75 | ○ |
| C-53 | ProduceTagsAsync: キャレット位置null時 | E-07 L50-53 | ○ |
| C-54 | ProduceTagsAsync: ドキュメントnull時 | E-07 L50-53 | ○ |
| C-55 | GetAllMatchingBracesAsync: 右側括弧取得 | E-07 L92-117 | ○ |
| C-56 | GetAllMatchingBracesAsync: 左側括弧取得 | E-07 L136-144 | ○ |
| C-57 | GetAllMatchingBracesAsync: 位置0での左側null | E-07 L119-123 | ○ |
| C-58 | TagEquals: 同一タグでtrue | E-07 L163-164 | ○ |
| C-59 | TagEquals: 異なるタグでfalse | E-07 L163-164 | ○ |

### AbstractAsynchronousTaggerProvider (UT-EFC-060 - UT-EFC-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CreateEfficientTagger: タガー作成 | E-08 L147-156 | ○ |
| C-61 | CreateEfficientTagger: オプション無効時null | E-08 L149-150 | ○ |
| C-62 | GetOrCreateTagSource: 既存TagSource取得 | E-08 L158-167 | ○ |
| C-63 | GetOrCreateTagSource: 新規作成 | E-08 L158-167 | ○ |
| C-64 | TryAddSpansToTag: バッファ全体スパン追加 | E-08 L227-233 | ○ |
| C-65 | ProduceTagsAsync: タグ生成 | E-08 L244-255 | ○ |
| C-66 | SpanEquals: 同一スパンでtrue | E-08 L266-273 | ○ |
| C-67 | SpanEquals: 異なるスパンでfalse | E-08 L266-273 | ○ |

### NavigateToItemProvider (UT-EFC-068 - UT-EFC-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | Constructor: 初期化 | E-09 L28-42 | ○ |
| C-69 | Constructor: nullワークスペース例外 | E-09 L34-35 | ○ |
| C-70 | KindsProvided: Kindセット取得 | E-09 L46-48 | ○ |
| C-71 | CanFilter: 全プロジェクト対応時true | E-09 L49-72 | ○ |
| C-72 | CanFilter: 非対応プロジェクト時false | E-09 L49-72 | △ |
| C-73 | StartSearch: 検索開始 | E-09 L86-126 | ○ |
| C-74 | StartSearch: 空白文字列での即完了 | E-09 L96-100 | ○ |
| C-75 | StopSearch: 検索キャンセル | E-09 L74-78 | ○ |
| C-76 | Dispose: リソース解放 | E-09 L80-84 | ○ |

### NavigateToItemDisplay (UT-EFC-077 - UT-EFC-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Name: 表示名取得 | E-10 L107 | ○ |
| C-78 | DescriptionItems: 説明項目作成 | E-10 L49-103 | ○ |
| C-79 | DescriptionItems: ドキュメントnull時空リスト | E-10 L60-64 | ○ |
| C-80 | NavigateTo: ナビゲーション | E-10 L109-110 | ○ |
| C-81 | GetProvisionalViewingStatus: ステータス取得 | E-10 L112-124 | ○ |
| C-82 | GetProvisionalViewingStatus: ドキュメントnull時Disabled | E-10 L114-118 | ○ |
| C-83 | GetNameMatchRuns: マッチスパン取得 | E-10 L142-143 | ○ |

### ITextViewExtensions (UT-EFC-084 - UT-EFC-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | GetContentTypes: コンテンツタイプ取得 | E-11 L22-26 | ○ |
| C-85 | GetCaretPoint: キャレット位置取得 | E-11 L34-38 | ○ |
| C-86 | GetCaretPoint: バッファ外でnull | E-11 L34-38 | ○ |
| C-87 | SetSelection: 選択範囲設定 | E-11 L93-99 | ○ |
| C-88 | SetSelection: 逆選択設定 | E-11 L93-99 | ○ |
| C-89 | TryMoveCaretToAndEnsureVisible: キャレット移動 | E-11 L123-155 | ○ |
| C-90 | TryMoveCaretToAndEnsureVisible: 閉じたビュー時false | E-11 L125-128 | ○ |
| C-91 | TryMoveCaretToAndEnsureVisible: マッピング不可時false | E-11 L130-135 | ○ |
| C-92 | TypeCharWasHandledStrangely: 正常挿入時false | E-11 L257-286 | ○ |
| C-93 | TypeCharWasHandledStrangely: バッファ外でtrue | E-11 L262-267 | ○ |
| C-94 | TypeCharWasHandledStrangely: 範囲外でtrue | E-11 L269-276 | ○ |
| C-95 | IsInLspEditorContext: LSPコンテキストでtrue | E-11 L338-355 | ○ |
| C-96 | IsInLspEditorContext: 非LSPでfalse | E-11 L338-355 | ○ |
| C-97 | GetDesiredIndentation: インデント取得 | E-11 L288-300 | △ |
| C-98 | GetDesiredIndentation: マッピング不可時null | E-11 L293-296 | △ |
| C-99 | TryGetSurfaceBufferSpan: スパン取得 | E-11 L302-330 | ○ |
| C-100 | TryGetSurfaceBufferSpan: マッピング不可時false | E-11 L317-328 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-EFC-036 (C-36)**: 空白行のみの場合のDetermineSmallestIndentの具体的な動作は、コード内でint.MaxValueが返却されることは確認できるが、全ての空白行パターンでの検証が推奨される
  - 候補：ユニットテスト実行による検証 / コードレビュー / デバッグ
- **UT-EFC-042 (C-42)**: コンテンツタイプ変更時のプロバイダー再取得は条件分岐で確認できるが、実際のファイル拡張子変更シナリオでの動作確認が推奨される
  - 候補：統合テスト / 手動テスト
- **UT-EFC-072 (C-72)**: 複数プロジェクト環境でのフィルタリング不可判定は、ループ処理で確認できるが、大規模ソリューションでの動作確認が推奨される
  - 候補：大規模ソリューションでのテスト / パフォーマンステスト
- **UT-EFC-097/098 (C-97/98)**: スマートインデント取得は拡張メソッドとして定義されているが、ISmartIndentationServiceの具体的な実装との連携テストが推奨される
  - 候補：モック使用テスト / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース - ソースコードから直接確認可能な主張
- **1 (中リスク)**: UT-EFC-019, UT-EFC-036, UT-EFC-042, UT-EFC-072, UT-EFC-097, UT-EFC-098 - 実装詳細または複雑な条件分岐の確認が必要
- **2 (高リスク)**: なし

## 6) レビュアーチェックリスト（最小）
- [ ] InlineRenameService/Sessionのスレッドセーフティ関連テストケース（UT-EFC-006, 007, 012）の前提条件が実行環境で再現可能か確認
- [ ] コマンドハンドラー系（GoToDefinition, CommentSelection, Format）のCommandState判定ロジックがVisual Studioのコマンドシステムと整合しているか確認
- [ ] 括弧マッチング（UT-EFC-052-059）のマルチキャラクタブレース対応（例：`<@` `@>`）テストケースが網羅されているか確認
- [ ] NavigateToのフィルタリング機能（UT-EFC-071, 072）が言語サービス未対応プロジェクトで正しく動作するか確認
- [ ] ITextViewExtensionsのLSPコンテキスト判定（UT-EFC-095, 096）がLive Share環境で期待通りに動作するか確認
- [ ] 非同期タガープロバイダー（UT-EFC-060-067）のキャンセル処理が正しく実装されているか確認
