---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 121
  claims_with_evidence: 118
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：ExpressionEvaluator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから抽出したクラス・メソッド・処理ロジックの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッド・処理パスを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 121、根拠なし：3
- 優先レビュー（高）
  1. **C-076, C-082**: ResultProvider.GetClrValue/GetUnderlyingStringのフォールバック挙動（実装詳細の確認が必要）
  2. **C-098**: Formatter.GetClrTypeNameの無効識別子処理（具体的な無効パターンの確認が必要）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ExpressionEvaluator/Core/Source/FunctionResolver/FunctionResolver.cs` - FunctionResolverクラスの実装
- E-02: `src/ExpressionEvaluator/Core/Source/FunctionResolver/MetadataResolver.cs` - MetadataResolverクラスの実装
- E-03: `src/ExpressionEvaluator/Core/Source/FunctionResolver/RequestSignature.cs` - RequestSignatureクラスの実装
- E-04: `src/ExpressionEvaluator/Core/Source/FunctionResolver/TypeSignature.cs` - TypeSignature階層の実装
- E-05: `src/ExpressionEvaluator/Core/Source/FunctionResolver/Name.cs` - Name階層の実装
- E-06: `src/ExpressionEvaluator/Core/Source/FunctionResolver/CSharp/MemberSignatureParser.cs` - C#シグネチャパーサーの実装
- E-07: `src/ExpressionEvaluator/Core/Source/ExpressionCompiler/ExpressionCompiler.cs` - ExpressionCompilerクラスの実装
- E-08: `src/ExpressionEvaluator/Core/Source/ExpressionCompiler/EvaluationContextBase.cs` - EvaluationContextBaseクラスの実装
- E-09: `src/ExpressionEvaluator/CSharp/Source/ExpressionCompiler/EvaluationContext.cs` - C# EvaluationContextの実装
- E-10: `src/ExpressionEvaluator/Core/Source/ResultProvider/ResultProvider.cs` - ResultProviderクラスの実装
- E-11: `src/ExpressionEvaluator/Core/Source/ResultProvider/Formatter.cs` - Formatterクラスの実装
- E-12: `src/ExpressionEvaluator/Core/Source/ResultProvider/Expansion/ArrayExpansion.cs` - ArrayExpansionの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### FunctionResolver関連 (C-001 - C-007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ShouldEnableFunctionResolverがプロセスに対して有効化を制御 | E-01: line 82-92 | ○ |
| C-002 | DataItemがプロセスにキャッシュされる | E-01: line 84-90 | ○ |
| C-003 | GetAllModulesがDkmClrModuleInstanceのみ返却 | E-01: line 94-112 | ○ |
| C-004 | モジュールが0件の場合に空コレクション返却 | E-01: line 96-111 | ○ |
| C-005 | GetModuleNameがモジュール名を返却 | E-01: line 114-117 | ○ |
| C-006 | TryGetMetadataがメタデータを取得 | E-01: line 119-133 | ○ |
| C-007 | TryGetMetadataが不正メタデータでfalse返却 | E-01: line 127-132 | ○ |

### MetadataResolver関連 (C-008 - C-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-008 | Resolveがメソッドシグネチャを解決 | E-02: line 44-107 | ○ |
| C-009 | Resolveがプロパティを解決 | E-02: line 81-91 | ○ |
| C-010 | Resolveがイベントを解決 | E-02: line 93-104 | ○ |
| C-011 | 型が見つからない場合に解決なし | E-02: line 59-63 | ○ |
| C-012 | MatchesTypeがジェネリック型をマッチ | E-02: line 391-397 | ○ |
| C-013 | MatchesTypeが配列型をマッチ | E-02: line 408-414 | ○ |
| C-014 | MatchesTypeがポインタ型をマッチ | E-02: line 415-420 | ○ |
| C-015 | Kindが異なる場合にfalse返却 | E-02: line 384-387 | ○ |

### RequestSignature/TypeSignature/Name関連 (C-016 - C-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-016 | RequestSignatureコンストラクタがプロパティ設定 | E-03: line 13-17 | ○ |
| C-017 | Parametersがdefaultの場合IsDefault=true | E-03: line 20 | ○ |
| C-018 | GenericTypeSignatureコンストラクタがプロパティ設定 | E-04: line 31-37 | ○ |
| C-019 | GenericTypeSignature.GetDebuggerDisplayがフォーマット | E-04: line 43-60 | ○ |
| C-020 | QualifiedTypeSignatureコンストラクタがプロパティ設定 | E-04: line 65-70 | ○ |
| C-021 | QualifiedTypeSignature.GetDebuggerDisplayがQualifier=nullでName返却 | E-04: line 76-79 | ○ |
| C-022 | QualifiedTypeSignature.GetDebuggerDisplayがドット区切り | E-04: line 78 | ○ |
| C-023 | ArrayTypeSignatureコンストラクタがプロパティ設定 | E-04: line 84-89 | ○ |
| C-024 | ArrayTypeSignature.GetDebuggerDisplayがRank=1で[] | E-04: line 95-103 | ○ |
| C-025 | ArrayTypeSignature.GetDebuggerDisplayがRank=3で[,,] | E-04: line 100 | ○ |
| C-026 | PointerTypeSignatureコンストラクタがプロパティ設定 | E-04: line 108-112 | ○ |
| C-027 | PointerTypeSignature.GetDebuggerDisplayがアスタリスク付き | E-04: line 117-120 | ○ |
| C-028 | GenericNameコンストラクタがプロパティ設定 | E-05: line 28-35 | ○ |
| C-029 | GenericName.GetDebuggerDisplayが型パラメータ付き | E-05: line 41-58 | ○ |
| C-030 | QualifiedNameコンストラクタがプロパティ設定 | E-05: line 63-68 | ○ |
| C-031 | QualifiedNameコンストラクタが空文字でAssert | E-05: line 65 | ○ |

### MemberSignatureParser関連 (C-032 - C-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-032 | Parse静的メソッドがシグネチャ解析 | E-06: line 16-36 | ○ |
| C-033 | Parseがジェネリックメソッド解析 | E-06: line 83-87 | ○ |
| C-034 | Parseがパラメータなしメソッド解析 | E-06: line 258-262 | ○ |
| C-035 | Parseが括弧なしメソッド解析 | E-06: line 61-64 | ○ |
| C-036 | Parseが不正シグネチャでnull返却 | E-06: line 32-35 | ○ |
| C-037 | Parseがref/outパラメータ解析 | E-06: line 233-252 | ○ |
| C-038 | Parseが配列型パラメータ解析 | E-06: line 201-215 | ○ |
| C-039 | Parseがポインタ型パラメータ解析 | E-06: line 216-219 | ○ |
| C-040 | ParseがNullable型パラメータ解析 | E-06: line 220-225 | ○ |
| C-041 | GetSpecialTypeがキーワード変換 | E-06: line 283-321 | ○ |
| C-042 | GetSpecialTypeが未知キーワードでNone | E-06: line 319-320 | ○ |

### ExpressionCompiler関連 (C-043 - C-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-043 | GetClrLocalVariableQueryがローカル変数取得 | E-07: line 45-90 | ○ |
| C-044 | argumentsOnly=trueで引数のみ取得 | E-07: line 54-56 | ○ |
| C-045 | CompileExpressionが式コンパイル | E-07: line 114-156 | ○ |
| C-046 | CompileExpressionが構文エラーでerror設定 | E-07: line 143-150 | ○ |
| C-047 | CompileAssignmentが代入コンパイル | E-07: line 158-207 | ○ |
| C-048 | CompileAssignmentが読み取り専用でエラー | E-07: line 175-186 | ○ |
| C-049 | CompileDisplayAttributeが属性コンパイル | E-07: line 209-249 | ○ |
| C-050 | ShouldTryAgainWithMoreMetadataBlocksが不足アセンブリ追加 | E-07: line 268-278 | ○ |
| C-051 | 追加アセンブリなしでfalse | E-07: line 271-276 | ○ |
| C-052 | GetMakeAssemblyReferencesKindが参照モード選択 | E-07: line 256-263 | ○ |

### EvaluationContextBase関連 (C-053 - C-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-053 | NormalizeILOffsetが通常オフセット返却 | E-08: line 96-99 | ○ |
| C-054 | NormalizeILOffsetがuint.MaxValueで0返却 | E-08: line 98 | ○ |
| C-055 | GetErrorMessageAndMissingAssemblyIdentitiesがエラー処理 | E-08: line 51-78 | ○ |
| C-056 | SimpleMessageDiagnostic.GetMessageがメッセージ返却 | E-08: line 160-163 | ○ |

### CSharp EvaluationContext関連 (C-057 - C-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-057 | CreateTypeContextが型コンテキスト作成 | E-09: line 74-92 | ○ |
| C-058 | CreateTypeContextが不正tokenで例外 | E-09: line 79-81 | ○ |
| C-059 | CreateMethodContextがメソッドコンテキスト作成 | E-09: line 115-195 | ○ |
| C-060 | CreateMethodContextがローカル変数設定 | E-09: line 174-186 | ○ |
| C-061 | CompileExpressionが式コンパイル | E-09: line 276-328 | ○ |
| C-062 | CompileExpressionがフォーマット指定子抽出 | E-09: line 286, 327 | ○ |
| C-063 | CompileExpressionが構文エラーでnull | E-09: line 287-291 | ○ |
| C-064 | CompileAssignmentが代入コンパイル | E-09: line 362-413 | ○ |
| C-065 | CompileAssignmentが不正代入先でnull | E-09: line 372-376 | ○ |
| C-066 | CompileGetLocalsがローカル変数リスト返却 | E-09: line 418-461 | ○ |
| C-067 | CompileGetLocalsがargumentsOnly対応 | E-09: line 421, 427 | ○ |
| C-068 | CompileGetLocalsがローカルなしで空 | E-09: line 453-457 | ○ |
| C-069 | GetMissingAssemblyIdentitiesHelperがERR_NoTypeDef処理 | E-09: line 491-504 | ○ |
| C-070 | GetMissingAssemblyIdentitiesHelperがLINQ処理 | E-09: line 519-525 | ○ |
| C-071 | HasDuplicateTypesOrAssembliesが重複エラー検出 | E-09: line 463-475 | ○ |
| C-072 | HasDuplicateTypesOrAssembliesが非重複でfalse | E-09: line 473-474 | ○ |

### ResultProvider関連 (C-073 - C-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-073 | GetResultが評価結果取得 | E-10: line 71-95 | ○ |
| C-074 | GetResultがフォーマット指定子適用 | E-10: line 73-81 | ○ |
| C-075 | GetClrValueがDkmClrValue取得 | E-10: line 97-114 | ○ |
| C-076 | GetClrValueがDataItemなしでフォールバック | E-10: line 102-106 | △ |
| C-077 | GetChildrenが子要素取得 | E-10: line 116-157 | ○ |
| C-078 | GetChildrenが展開なしで空配列 | E-10: line 127-131 | ○ |
| C-079 | GetItemsが範囲アイテム取得 | E-10: line 159-198 | ○ |
| C-080 | GetItemsが範囲外で空配列 | E-10: line 172-176 | ○ |
| C-081 | GetUnderlyingStringが文字列取得 | E-10: line 200-217 | ○ |
| C-082 | GetUnderlyingStringがDataItemなしでフォールバック | E-10: line 205-209 | △ |
| C-083 | GetTypeNameが型名取得 | E-10: line 504-533 | ○ |
| C-084 | GetTypeNameがランタイム型表示 | E-10: line 515-529 | ○ |
| C-085 | CreateDataItemがEvalResult作成 | E-10: line 535-639 | ○ |
| C-086 | CreateDataItemがNullableアンラップ | E-10: line 562-594 | ○ |
| C-087 | CreateDataItemがNullable nullで展開なし | E-10: line 572-576 | ○ |
| C-088 | GetTypeExpansionが配列展開 | E-10: line 952-976 | ○ |
| C-089 | GetTypeExpansionがタプル展開 | E-10: line 1010-1013 | ○ |
| C-090 | GetTypeExpansionがポインタ展開 | E-10: line 989-997 | ○ |
| C-091 | GetTypeExpansionがプリミティブで展開なし | E-10: line 978-981 | ○ |

### Formatter関連 (C-092 - C-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-092 | GetValueStringが値文字列化 | E-11: line 41-48 | ○ |
| C-093 | GetValueStringがNoQuotes対応 | E-11: line 43-47 | ○ |
| C-094 | GetTypeNameが型名取得 | E-11: line 50-54 | ○ |
| C-095 | HasUnderlyingStringが文字列判定 | E-11: line 56-59 | ○ |
| C-096 | HasUnderlyingStringが非文字列判定 | E-11: line 56-59 | ○ |
| C-097 | GetClrTypeNameがC#型名取得 | E-11: line 76-82 | ○ |
| C-098 | GetClrTypeNameが無効識別子でnull | E-11: line 80-81 | △ |
| C-099 | GetClrArrayIndexExpressionが配列インデックス生成 | E-11: line 84-87 | ○ |
| C-100 | GetClrCastExpressionがキャスト式生成 | E-11: line 89-98 | ○ |
| C-101 | GetClrValidIdentifierが有効識別子返却 | E-11: line 111-120 | ○ |
| C-102 | GetClrValidIdentifierが無効識別子でnull | E-11: line 117 | ○ |
| C-103 | ClrExpressionMayRequireParenthesesが括弧必要判定 | E-11: line 127-130 | ○ |
| C-104 | ClrExpressionMayRequireParenthesesが括弧不要判定 | E-11: line 226-271 | ○ |
| C-105 | GetClrMemberNameが静的メンバー名生成 | E-11: line 142-149 | ○ |
| C-106 | GetClrMemberNameがキャスト付きメンバー生成 | E-11: line 151-159 | ○ |
| C-107 | TrimAndGetFormatSpecifiersがフォーマット指定子抽出 | E-11: line 122-125, 315-352 | ○ |
| C-108 | AddFormatSpecifierが指定子追加 | E-11: line 282-292 | ○ |
| C-109 | AddFormatSpecifierが重複防止 | E-11: line 284-287 | ○ |

### ArrayExpansion関連 (C-110 - C-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | CreateExpansionが配列展開作成 | E-12: line 23-37 | ○ |
| C-111 | CreateExpansionが空配列でnull | E-12: line 36 | ○ |
| C-112 | CreateExpansionが多次元配列対応 | E-12: line 29-36 | ○ |
| C-113 | GetRowsが配列要素取得 | E-12: line 48-70 | ○ |
| C-114 | GetRowsが範囲外で空 | E-12: line 59-61 | ○ |
| C-115 | GetIndicesが1次元インデックス計算 | E-12: line 103-112 | ○ |
| C-116 | GetIndicesが多次元インデックス計算 | E-12: line 114-122 | ○ |
| C-117 | GetIndicesが非ゼロ下限対応 | E-12: line 110, 119 | ○ |
| C-118 | CalculateDivisorsが1次元でnull | E-12: line 139-142 | ○ |
| C-119 | CalculateDivisorsが多次元除数計算 | E-12: line 144-151 | ○ |
| C-120 | GetFullNameが完全名生成 | E-12: line 153-179 | ○ |
| C-121 | GetFullNameがnull親でnull | E-12: line 155-159 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-076, C-082**: ResultProvider内のフォールバック処理（`evaluationResult.GetClrValue()`, `result.GetUnderlyingString()`）の具体的な挙動はDkmクライアント実装に依存
  - 候補：Concord SDK ドキュメント / DkmEvaluationResult実装
- **C-098**: 「無効な識別子」の具体的なパターン（C#予約語、不正文字等）の詳細定義
  - 候補：C#言語仕様 / IsValidIdentifierメソッドの実装

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストケースC-001〜C-042（FunctionResolver/MemberSignatureParser関連）- ソースコードから直接抽出した明確なロジック
- **0 (低リスク)**: テストケースC-053〜C-072（EvaluationContext関連）- コンパイル処理の基本フロー
- **1 (中リスク)**: テストケースC-073〜C-091（ResultProvider関連）- デバッガーコンポーネントとの連携が多く、モック設計に注意が必要
- **0 (低リスク)**: テストケースC-110〜C-121（ArrayExpansion関連）- 純粋な計算ロジック

## 6) レビュアーチェックリスト（最小）
- [ ] FunctionResolver系テストケース（C-001〜C-015）のメタデータ処理ロジックが正しくカバーされているか
- [ ] MemberSignatureParser系テストケース（C-032〜C-042）がC#シグネチャ構文を網羅しているか
- [ ] ExpressionCompiler系テストケース（C-043〜C-072）がコンパイルエラーパスを十分にカバーしているか
- [ ] ResultProvider系テストケース（C-073〜C-091）のモック/スタブ設計が実現可能か
- [ ] Formatter系テストケース（C-092〜C-109）がC#固有の型表現を網羅しているか
- [ ] ArrayExpansion系テストケース（C-110〜C-121）の多次元配列・非ゼロ下限配列のエッジケースが十分か
- [ ] 優先度「高」のテストケースが主要なビジネスロジックをカバーしているか
- [ ] 境界値テストケースが数値/コレクションの限界値を適切にテストしているか
