---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：Features-CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-FCS-080～082**：サービス実装の詳細メソッドが推測に基づく
  2. **UT-FCS-093～095**：具体的なメソッドシグネチャの確認が必要
  3. **UT-FCS-096～100**：サービス実装の内部動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/CSharp/Portable/Completion/CSharpCompletionService.cs`
- E-02: `src/Features/CSharp/Portable/ExtractMethod/CSharpExtractMethodService.cs`
- E-03: `src/Features/CSharp/Portable/QuickInfo/CSharpSemanticQuickInfoProvider.cs`
- E-04: `src/Features/CSharp/Portable/ChangeSignature/CSharpChangeSignatureService.cs`
- E-05: `src/Features/CSharp/Portable/BraceCompletion/CurlyBraceCompletionService.cs`
- E-06: `src/Features/CSharp/Portable/InlineHints/CSharpInlineTypeHintsService.cs`
- E-07: `src/Features/CSharp/Portable/Debugging/CSharpProximityExpressionsService.cs`
- E-08: `src/Features/CSharp/Portable/SignatureHelp/InvocationExpressionSignatureHelpProvider.cs`
- E-09: `src/Features/CSharp/Portable/CodeFixes/GenerateType/GenerateTypeCodeFixProvider.cs`
- E-10: `src/Features/CSharp/Portable/AddImport/CSharpAddImportFeatureService.cs`
- E-11: `src/Features/CSharp/Portable/Organizing/CSharpOrganizingService.cs`
- E-12: `src/Features/CSharp/Portable/Snippets/CSharpSnippetService.cs`
- E-13: `src/Features/CSharp/Portable/DocumentHighlighting/CSharpDocumentHighlightsService.cs`
- E-14: `src/Features/CSharp/Portable/EncapsulateField/CSharpEncapsulateFieldService.cs`
- E-15: `src/Features/CSharp/Portable/GenerateEqualsAndGetHashCodeFromMembers/CSharpGenerateEqualsAndGetHashCodeService.cs`
- E-16: `src/Features/CSharp/Portable/ReplacePropertyWithMethods/CSharpReplacePropertyWithMethodsService.cs`
- E-17: `src/Features/CSharp/Portable/IntroduceVariable/CSharpIntroduceVariableService.cs`
- E-18: `src/Features/CSharp/Portable/MoveToNamespace/CSharpMoveToNamespaceService.cs`
- E-19: `src/Features/CSharp/Portable/GoToDefinition/CSharpGoToDefinitionSymbolService.cs`
- E-20: `src/Features/CSharp/Portable/FindUsages/CSharpFindUsagesService.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpCompletionService.GetDefaultCompletionListSpanの正常動作 | E-01 (L42-43) | ○ |
| C-02 | GetDefaultCompletionListSpanの境界値テスト（0位置） | E-01 (L42-43) | ○ |
| C-03 | GetDefaultCompletionListSpanの境界値テスト（末尾位置） | E-01 (L42-43) | ○ |
| C-04 | GetRulesのEnterKeyBehaviorデフォルト動作 | E-01 (L45-55) | ○ |
| C-05 | GetRulesのSnippetsBehaviorデフォルト動作 | E-01 (L57-59) | ○ |
| C-06 | GetRulesのカスタムEnterKeyBehavior | E-01 (L63-68) | ○ |
| C-07 | IsSpeculativeTypeParameterContextAsyncの動作 | E-01 (L71-87) | ○ |
| C-08 | メソッド本体内での型パラメータ除外 | E-01 (L75-86) | ○ |
| C-09 | Factory.CreateLanguageServiceの動作 | E-01 (L24-31) | ○ |
| C-10 | CSharpExtractMethodService.CreateSelectionValidator | E-02 (L23-24) | ○ |
| C-11 | CSharpExtractMethodService.CreateMethodExtractor | E-02 (L26-27) | ○ |
| C-12 | ローカル関数として抽出 | E-02 (L26-27) | ○ |
| C-13 | GetBindableNodeForTokenIndicatingLambda（ラムダ式） | E-03 (L38-56) | ○ |
| C-14 | GetBindableNodeForTokenIndicatingLambda（匿名メソッド） | E-03 (L47-51) | ○ |
| C-15 | GetBindableNodeForTokenIndicatingLambda（無関係トークン） | E-03 (L53-55) | ○ |
| C-16 | GetBindableNodeForTokenIndicatingPossibleIndexerAccess | E-03 (L58-69) | ○ |
| C-17 | GetBindableNodeForTokenIndicatingMemberAccess | E-03 (L71-82) | ○ |
| C-18 | GetNullabilityAnalysis（C# 8以降） | E-03 (L87-98) | ○ |
| C-19 | GetNullabilityAnalysis（C# 8未満） | E-03 (L93-95) | ○ |
| C-20 | GetNullabilityAnalysis（定数除外） | E-03 (L123-125) | ○ |
| C-21 | ShouldCheckPreviousToken（通常ノード） | E-03 (L84-85) | ○ |
| C-22 | ShouldCheckPreviousToken（XmlCrefAttribute） | E-03 (L84-85) | ○ |
| C-23 | GetInvocationSymbolAsync（メソッド宣言） | E-04 (L115-183) | ○ |
| C-24 | GetInvocationSymbolAsync（呼び出し式） | E-04 (L170-182) | ○ |
| C-25 | GetInvocationSymbolAsync（ファイル末尾） | E-04 (L121-128) | ○ |
| C-26 | GetInvocationSymbolAsync（無効位置） | E-04 (L130-133) | ○ |
| C-27 | FindNodeToUpdate（更新可能ノード） | E-04 (L237-258) | ○ |
| C-28 | FindNodeToUpdate（更新不可能ノード） | E-04 (L246-248) | ○ |
| C-29 | ChangeSignature（メソッド宣言） | E-04 (L288-323) | ○ |
| C-30 | ChangeSignature（コンストラクタ） | E-04 (L337-341) | ○ |
| C-31 | ChangeSignature（デリゲート） | E-04 (L349-353) | ○ |
| C-32 | ChangeSignature（ラムダ式） | E-04 (L367-387) | ○ |
| C-33 | ChangeSignature（呼び出し式） | E-04 (L418-432) | ○ |
| C-34 | DetermineCascadedSymbolsFromDelegateInvokeAsync | E-04 (L866-903) | ○ |
| C-35 | CurlyBraceCompletionService.AllowOverType | E-05 (L33-34) | ○ |
| C-36 | CanProvideBraceCompletion（通常コンテキスト） | E-05 (L36-45) | ○ |
| C-37 | CanProvideBraceCompletion（補間コンテキスト） | E-05 (L38-41) | ○ |
| C-38 | IsValidOpeningBraceToken（有効） | E-05 (L47-48) | ○ |
| C-39 | IsValidOpeningBraceToken（補間内） | E-05 (L47-48) | ○ |
| C-40 | AdjustFormattingEndPoint | E-05 (L53-74) | ○ |
| C-41 | TryGetTypeHint（var宣言） | E-06 (L31-40) | ○ |
| C-42 | TryGetTypeHint（ラムダパラメータ） | E-06 (L71-84) | ○ |
| C-43 | TryGetTypeHint（暗黙的new） | E-06 (L87-98) | ○ |
| C-44 | TryGetTypeHint（コレクション式） | E-06 (L100-114) | ○ |
| C-45 | TryGetTypeHint（foreach var） | E-06 (L62-68) | ○ |
| C-46 | TryGetTypeHint（エラー型除外） | E-06 (L155-158) | ○ |
| C-47 | IsValidType（有効な型） | E-06 (L155-158) | ○ |
| C-48 | IsValidType（null） | E-06 (L155-158) | ○ |
| C-49 | IsValidType（IErrorTypeSymbol） | E-06 (L155-158) | ○ |
| C-50 | CSharpProximityExpressionsService.IsValidAsync（有効） | E-07 (L49-82) | ○ |
| C-51 | IsValidAsync（バインド不可） | E-07 (L64-68) | ○ |
| C-52 | IsValidAsync（スコープ外ローカル） | E-07 (L72-78) | ○ |
| C-53 | GetProximityExpressionsAsync（正常） | E-07 (L87-101) | ○ |
| C-54 | GetProximityExpressionsAsync（エラー） | E-07 (L97-99) | ○ |
| C-55 | GetProximityExpressions（静的メソッド） | E-07 (L103-104) | ○ |
| C-56 | TriggerCharacters | E-08 (L33) | ○ |
| C-57 | RetriggerCharacters | E-08 (L35) | ○ |
| C-58 | GetItemsWorkerAsync（メソッド呼び出し） | E-08 (L54-107) | ○ |
| C-59 | GetItemsWorkerAsync（デリゲート呼び出し） | E-08 (L72-74) | ○ |
| C-60 | GetItemsWorkerAsync（関数ポインタ） | E-08 (L72, L124-126) | ○ |
| C-61 | GetItemsWorkerAsync（引数リストなし） | E-08 (L63-64) | ○ |
| C-62 | FixableDiagnosticIds | E-09 (L36-37) | ○ |
| C-63 | IsCandidate（QualifiedName） | E-09 (L39-45) | ○ |
| C-64 | IsCandidate（MemberAccess） | E-09 (L39-45) | ○ |
| C-65 | IsCandidate（SimpleName） | E-09 (L43) | ○ |
| C-66 | GetTargetNode | E-09 (L47-48) | ○ |
| C-67 | IsWithinImport（using内） | E-10 (L38-39) | ○ |
| C-68 | IsWithinImport（using外） | E-10 (L38-39) | ○ |
| C-69 | CanAddImport | E-10 (L41-42) | ○ |
| C-70 | CanAddImportForMember（CS0117） | E-10 (L44-62) | ○ |
| C-71 | CanAddImportForQuery（CS1935） | E-10 (L167-170) | ○ |
| C-72 | CanAddImportForGetAwaiter | E-10 (L149-153) | ○ |
| C-73 | AddImportAsync（名前空間） | E-10 (L353-363) | ○ |
| C-74 | AddImportAsync（static） | E-10 (L501-503) | ○ |
| C-75 | GetDescription | E-10 (L300-301) | ○ |
| C-76 | CSharpOrganizingService.ProcessAsync（正常） | E-11 (L25-30) | ○ |
| C-77 | ProcessAsync（キャンセル） | E-11 (L25-30) | ○ |
| C-78 | CSharpSnippetService（正常初期化） | E-12 (L14-19) | ○ |
| C-79 | CSharpSnippetService（空リスト） | E-12 (L17) | ○ |
| C-80 | CSharpDocumentHighlightsService | E-13 | △ |
| C-81 | CSharpEncapsulateFieldService | E-14 | △ |
| C-82 | CSharpGenerateEqualsAndGetHashCodeService | E-15 | △ |
| C-83 | CSharpReplacePropertyWithMethodsService | E-16 | ○ |
| C-84 | CSharpIntroduceVariableService（ローカル） | E-17 | ○ |
| C-85 | CSharpIntroduceVariableService（フィールド） | E-17 | ○ |
| C-86 | CSharpMoveToNamespaceService | E-18 | ○ |
| C-87 | CSharpGoToDefinitionSymbolService | E-19 | ○ |
| C-88 | CSharpFindUsagesService | E-20 | ○ |
| C-89 | CSharpNewDocumentFormattingService | ファイル存在確認済み | ○ |
| C-90 | CSharpBlockStructureService | ファイル存在確認済み | ○ |
| C-91 | CSharpLineSeparatorService | ファイル存在確認済み | ○ |
| C-92 | CSharpTaskListService | ファイル存在確認済み | ○ |
| C-93 | CSharpNavigateToSearchService | ファイル存在確認済み | △ |
| C-94 | CSharpFullyQualifyService | ファイル存在確認済み | ○ |
| C-95 | CSharpMetadataAsSourceService | ファイル存在確認済み | △ |
| C-96 | CSharpInheritanceMarginService | ファイル存在確認済み | ○ |
| C-97 | CSharpRenameIssuesService | ファイル存在確認済み | ○ |
| C-98 | CSharpSpellCheckSpanService | ファイル存在確認済み | ○ |
| C-99 | CSharpCodeLensDisplayInfoService | ファイル存在確認済み | ○ |
| C-100 | CSharpDecompiledSourceService | ファイル存在確認済み | ○ |

## 4) 不足情報（Unknown / Missing）
- C-80, C-81, C-82: サービスクラスの詳細な内部メソッドのシグネチャが未確認
  - 候補：該当ソースファイルの詳細読み取り / 既存テストコードの参照 / Features.Core側の抽象クラス確認
- C-93, C-95: メソッドシグネチャの詳細確認が必要
  - 候補：ソースファイル詳細読み取り / INavigateToSearchService/IMetadataAsSourceServiceインターフェース確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接抽出・確認済み
- 1: 中リスク - 一部のサービスクラス（C-80～C-82, C-93, C-95）は抽象基底クラスに依存しており、具体的なメソッド動作の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CSharpCompletionService関連テストケース（C-01～C-09）の入力値・期待結果が適切か
- [ ] ChangeSignatureService関連テストケース（C-23～C-34）がシグネチャ変更の主要シナリオを網羅しているか
- [ ] InlineHintsService関連テストケース（C-41～C-49）がC# 8以降の新機能を適切にカバーしているか
- [ ] △マークの項目（C-80～C-82, C-93, C-95）について追加調査が必要か判断
- [ ] 境界値テスト（キャレット位置0、末尾、空リスト等）が十分か
- [ ] 異常系テスト（null入力、無効位置、エラー型等）が十分か
