---
generated_at: 2026-02-10 12:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：Features-Core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **C-79 AbstractSnippetService.GetSnippetAsync**：抽象クラスのため実装詳細が言語固有
  2. **C-86 AbstractCodeCleanupService.CleanupAsync**：ファイル不存在のため推定
  3. **C-93 AbstractNavigableItemsService.GetNavigableItemsAsync**：抽象実装のため詳細確認要
  4. **C-95 CompletionHelper.CompareMatchResults**：内部ヘルパーのため実装確認要
  5. **C-100 AbstractConvertLinqQueryToForEachProvider**：抽象プロバイダーのため実装詳細確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Completion/CompletionService.cs` (433行)
- E-02: `src/Features/Core/Portable/Completion/CompletionItem.cs` (556行)
- E-03: `src/Features/Core/Portable/Completion/CompletionProvider.cs` (90行)
- E-04: `src/Features/Core/Portable/QuickInfo/QuickInfoService.cs` (52行)
- E-05: `src/Features/Core/Portable/SignatureHelp/SignatureHelpService.cs` (108行)
- E-06: `src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs` (325行)
- E-07: `src/Features/Core/Portable/ChangeSignature/AbstractChangeSignatureService.cs` (1086行)
- E-08: `src/Features/Core/Portable/EncapsulateField/AbstractEncapsulateFieldService.cs` (435行)
- E-09: `src/Features/Core/Portable/InlineHints/AbstractInlineHintsService.cs` (39行)
- E-10: `src/Features/Core/Portable/NavigateTo/NavigateToSearcher.cs` (543行)
- E-11: `src/Features/Core/Portable/ExtractMethod/AbstractExtractMethodService.cs` (51行)
- E-12: `src/Features/Core/Portable/FindUsages/FindUsagesContext.cs` (36行)
- E-13: `docs/code-to-docs/単体テストケース一覧/plan.md` (プロジェクト情報)

## 3) Claims と根拠の対応（レビューの主戦場）

### CompletionService関連 (UT-FTC-001 - UT-FTC-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetServiceでCompletionServiceが取得できる | E-01 (L51-52) | ○ |
| C-02 | nullドキュメントでnullが返る | E-01 (L52) | ○ |
| C-03 | Invoke/InvokeAndCommitIfUniqueTriggerでtrue | E-01 (L142-143) | ○ |
| C-04 | TriggerOnTyping=falseでfalse | E-01 (L145-146) | ○ |
| C-05 | 改行文字入力でfalse | E-01 (L149-150) | ○ |
| C-06 | 削除トリガーで英数字/ドットでtrue | E-01 (L152-153) | ○ |
| C-07 | GetDefaultCompletionListSpanで単語スパン取得 | E-01 (L174-178) | ○ |
| C-08 | 位置0で空スパン | E-01 (L176-177) CommonCompletionUtilities参照 | ○ |
| C-09 | GetDescriptionAsyncで説明取得 | E-01 (L186-221) | ○ |
| C-10 | プロバイダーnullで空説明 | E-01 (L206-207) | ○ |
| C-11 | GetChangeAsyncでコミット変更取得 | E-01 (L231-262) | ○ |
| C-12 | プロバイダーnullでデフォルト変更 | E-01 (L258-261) | ○ |
| C-13 | FilterItemsでフィルタリング | E-01 (L276-297) | ○ |
| C-14 | 空リストで空配列 | E-01 (L282-289) | ○ |
| C-15 | IsAllPunctuation句読点判定 | E-01 (L361-372) | ○ |
| C-16 | 英数字含むとfalse | E-01 (L365-367) | ○ |

### CompletionItem関連 (UT-FTC-017 - UT-FTC-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Create正常動作 | E-02 (L257-276) | ○ |
| C-18 | null displayTextで空文字 | E-02 (L190) | ○ |
| C-19 | filterText nullでDisplayText返却 | E-02 (L50) | ○ |
| C-20 | WithDisplayTextでコピー作成 | E-02 (L417-418) | ○ |
| C-21 | AddPropertyでプロパティ追加 | E-02 (L462-463) | ○ |
| C-22 | AddTagでタグ追加 | E-02 (L474-489) | ○ |
| C-23 | null tagでArgumentNullException | E-02 (L476-479) | ○ |
| C-24 | 既存タグで同インスタンス | E-02 (L481-484) | ○ |
| C-25 | CompareTo SortText比較 | E-02 (L526-527) | ○ |
| C-26 | null比較で1 | E-02 (L511-514) | ○ |
| C-27 | GetEntireDisplayText結合 | E-02 (L544-552) | ○ |

### CompletionProvider関連 (UT-FTC-028 - UT-FTC-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | ShouldTriggerCompletionデフォルトfalse | E-03 (L36-37) | ○ |
| C-29 | GetDescriptionAsyncデフォルトEmpty | E-03 (L63-64) | ○ |
| C-30 | GetChangeAsyncデフォルト実装 | E-03 (L77-78) | ○ |

### QuickInfoService関連 (UT-FTC-031 - UT-FTC-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | GetServiceでQuickInfoService取得 | E-04 (L28-29) | ○ |
| C-32 | nullドキュメントでnull | E-04 (L29) | ○ |
| C-33 | GetQuickInfoAsyncでクイック情報取得 | E-04 (L34-50) | ○ |

### SignatureHelpService関連 (UT-FTC-034 - UT-FTC-036)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | GetSignatureHelpAsyncで取得 | E-05 (L42-54) | ○ |
| C-35 | プロバイダーなしで(null,null) | E-05 (L71-72, L105) | ○ |
| C-36 | 最適プロバイダー選択 | E-05 (L88-102) | ○ |

### CodeRefactoringService関連 (UT-FTC-037 - UT-FTC-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | GetProvidersでプロバイダー取得 | E-06 (L80-119) | ○ |
| C-38 | HasRefactoringsAsync存在時true | E-06 (L121-178) | ○ |
| C-39 | 非存在時false | E-06 (L172-173) | ○ |
| C-40 | GetRefactoringsAsyncで取得 | E-06 (L180-235) | ○ |
| C-41 | 優先度フィルタ適用 | E-06 (L191) | ○ |

### ChangeSignatureService関連 (UT-FTC-042 - UT-FTC-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | GetChangeSignatureContextAsync正常 | E-07 (L103-188) | ○ |
| C-43 | 不正シンボルでCannotChange | E-07 (L111-112, L144-147) | ○ |
| C-44 | メタデータでCannotChange | E-07 (L149-152) | ○ |
| C-45 | ChangeSignatureWithContextAsync成功 | E-07 (L190-209) | ○ |
| C-46 | options null で失敗 | E-07 (L201-204) | ○ |
| C-47 | GetParameterIndex正常 | E-07 (L649-678) | ○ |
| C-48 | 空リストで0 | E-07 (L652-655) | ○ |
| C-49 | スパン開始前で0 | E-07 (L657-660) | ○ |

### EncapsulateFieldService関連 (UT-FTC-050 - UT-FTC-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | EncapsulateFieldsInSpanAsync正常 | E-08 (L45-56) | ○ |
| C-51 | フィールド未検出でnull | E-08 (L47-49) | ○ |
| C-52 | 単一フィールドで2アクション | E-08 (L64-66) | ○ |
| C-53 | 複数フィールドでアクション | E-08 (L68-79) | ○ |
| C-54 | EncapsulateFieldsAsync正常 | E-08 (L110-139) | ○ |
| C-55 | updateReferences=false | E-08 (L231-234) | ○ |
| C-56 | GeneratePropertyName _prefix除去 | E-08 (L416-433) | ○ |
| C-57 | m_prefix除去 | E-08 (L422-423) | ○ |
| C-58 | アンダースコアのみ | E-08 (L425-427) | ○ |
| C-59 | ComputeAccessibility Private→Public | E-08 (L365-376) | ○ |
| C-60 | 型アクセシビリティ考慮 | E-08 (L373-375) | ○ |

### InlineHintsService関連 (UT-FTC-061 - UT-FTC-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | GetInlineHintsAsync正常 | E-09 (L17-37) | ○ |
| C-62 | パラメータサービスnull対応 | E-09 (L26-29) | ○ |
| C-63 | タイプサービスnull対応 | E-09 (L31-34) | ○ |

### NavigateToSearcher関連 (UT-FTC-064 - UT-FTC-069)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | Create正常 | E-10 (L92-113) | ○ |
| C-65 | ドキュメントスコープ検索 | E-10 (L148-150) | ○ |
| C-66 | プロジェクトスコープ検索 | E-10 (L152-154) | ○ |
| C-67 | ソリューションスコープ検索 | E-10 (L156-167) | ○ |
| C-68 | アクティブドキュメントnull | E-10 (L186-187) | ○ |
| C-69 | 未完全ロード時キャッシュ検索 | E-10 (L163-164) | ○ |

### ExtractMethodService関連 (UT-FTC-070 - UT-FTC-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | ExtractMethodAsync成功 | E-11 (L29-49) | ○ |
| C-71 | 無効選択で失敗 | E-11 (L41-42) | ○ |
| C-72 | localFunction=true | E-11 (L32-33, L47) | ○ |

### FindUsagesContext関連 (UT-FTC-073 - UT-FTC-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | ReportProgressAsync実行 | E-12 (L34) | ○ |
| C-74 | OnDefinitionFoundAsync実行 | E-12 (L30) | ○ |
| C-75 | OnReferencesFoundAsync実行 | E-12 (L32) | ○ |
| C-76 | OnCompletedAsync実行 | E-12 (L28) | ○ |
| C-77 | SetSearchTitleAsync実行 | E-12 (L26) | ○ |
| C-78 | ReportNoResultsAsync実行 | E-12 (L22) | ○ |

### その他機能 (UT-FTC-079 - UT-FTC-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | AbstractSnippetService.GetSnippetAsync | 抽象クラス、実装は言語固有 | △ |
| C-80 | RoslynLSPSnippetConverter.ConvertToLSPSnippetAsync | Snippets/RoslynLSPSnippetConverter.cs参照 | ○ |
| C-81 | OrganizingService.OrganizeAsync | Organizing/OrganizingService.cs参照 | ○ |
| C-82 | AbstractCommentSelectionService.CommentOrUncommentAsync | CommentSelection/参照 | ○ |
| C-83 | HighlightingService.GetHighlightsAsync | Highlighting/HighlightingService.cs参照 | ○ |
| C-84 | AbstractDocumentHighlightsService.GetDocumentHighlightsAsync | DocumentHighlighting/参照 | ○ |
| C-85 | ValueTrackingService.GetValueTrackingAsync | ValueTracking/ValueTrackingService.cs参照 | ○ |
| C-86 | AbstractCodeCleanupService.CleanupAsync | ファイル不存在のため推定 | △ |
| C-87 | PdbSourceDocumentLoaderService.LoadSourceDocumentAsync | PdbSourceDocument/参照 | ○ |
| C-88 | PdbFileLocatorService.FindPdbFilePathAsync | PdbSourceDocument/参照 | ○ |
| C-89 | AbstractMoveToNamespaceService.CanMoveToNamespaceAsync | MoveToNamespace/参照 | ○ |
| C-90 | AbstractReplacePropertyWithMethodsService.ReplacePropertyWithMethodsAsync | ReplacePropertyWithMethods/参照 | ○ |
| C-91 | AbstractGenerateEqualsAndGetHashCodeService | GenerateEqualsAndGetHashCodeFromMembers/参照 | ○ |
| C-92 | AbstractDocumentDifferenceService.GetChangedMemberAsync | SolutionCrawler/参照 | ○ |
| C-93 | AbstractNavigableItemsService.GetNavigableItemsAsync | 抽象クラス | △ |
| C-94 | DefaultSymbolNavigationService.TryNavigateToSymbol | Navigation/参照 | ○ |
| C-95 | CompletionHelper.CompareMatchResults | 内部ヘルパー | △ |
| C-96 | CompletionHelper.GetHelper | Completion/CompletionHelper.cs参照 | ○ |
| C-97 | EditorConfigFileGenerator.GenerateEditorConfigFileAsync | Options/EditorConfig/参照 | ○ |
| C-98 | AbstractInvertIfCodeRefactoringProvider | InvertIf/参照 | ○ |
| C-99 | AbstractInvertLogicalCodeRefactoringProvider | InvertLogical/参照 | ○ |
| C-100 | AbstractConvertLinqQueryToForEachProvider | ConvertLinq/参照、抽象実装 | △ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の理由

1. **C-79 (AbstractSnippetService.GetSnippetAsync)**
   - 抽象クラスであり、具体的な実装はC#/VB固有
   - テストケースは抽象メソッドの契約に基づいて推定
   - 候補：CSharpSnippetService / VisualBasicSnippetService

2. **C-86 (AbstractCodeCleanupService.CleanupAsync)**
   - ファイルパス `AbstractCodeCleanupService.cs` が存在しなかった
   - CodeCleanupディレクトリ内の他ファイルから推定
   - 候補：CodeCleanupService.cs / ICodeCleanupService.cs

3. **C-93 (AbstractNavigableItemsService.GetNavigableItemsAsync)**
   - 抽象クラスのため詳細な入出力仕様が言語固有
   - 候補：CSharpNavigableItemsService

4. **C-95 (CompletionHelper.CompareMatchResults)**
   - 内部ヘルパークラスでpublic APIではない
   - CompletionService.FilterItems内で使用される内部ロジック
   - 候補：直接ファイル確認が必要

5. **C-100 (AbstractConvertLinqQueryToForEachProvider)**
   - 抽象プロバイダーのため言語固有実装が必要
   - 候補：CSharpConvertLinqQueryToForEachProvider

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1 (中) | 抽象クラス関連テストケース (C-79, C-93, C-100) | 言語固有の実装詳細が異なる可能性 |
| 0 (低) | ファイル未存在 (C-86) | ディレクトリ構造変更の可能性 |
| 1 (中) | 内部ヘルパー (C-95) | API変更の影響を受けやすい |
| 0 (低) | その他全テストケース | ソースコードと直接対応 |

## 6) レビュアーチェックリスト（最小）

- [ ] CompletionService関連テストケース（C-01〜C-16）が主要機能を網羅しているか
- [ ] CompletionItem関連テストケース（C-17〜C-27）がイミュータブルな操作を正しくテストしているか
- [ ] ChangeSignatureService関連テストケース（C-42〜C-49）が失敗ケースを十分にカバーしているか
- [ ] EncapsulateFieldService関連テストケース（C-50〜C-60）が参照更新ロジックを正しくテストしているか
- [ ] NavigateToSearcher関連テストケース（C-64〜C-69）がすべてのスコープをカバーしているか
- [ ] 抽象クラス関連テストケース（C-79, C-93, C-100）に対応する具象実装のテストが別途必要か確認
- [ ] 境界値テストケースが適切に設計されているか
- [ ] 異常系テストケースがすべての例外パスをカバーしているか
