---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 119
  claims_with_evidence: 119
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：LanguageServer-Framework 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：119 / 119、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractLanguageServer.cs`
- E-02: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/RequestExecutionQueue.cs`
- E-03: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/HandlerProvider.cs`
- E-04: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs`
- E-05: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/MethodHandlerDetails.cs`
- E-06: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/TypeRef.cs`
- E-07: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/TypeRef.DefaultResolver.cs`
- E-08: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractTypeRefResolver.cs`
- E-09: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/LanguageServerEndpointAttribute.cs`
- E-10: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractRequestContextFactory.cs`
- E-11: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractRequestScope.cs`
- E-12: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IRequestHandler.cs`
- E-13: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs`
- E-14: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IMethodHandler.cs`
- E-15: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/ILspServices.cs`
- E-16: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/ILspLogger.cs`
- E-17: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractLspLogger.cs`
- E-18: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IQueueItem.cs`
- E-19: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IRequestExecutionQueue.cs`
- E-20: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IInitializeManager.cs`
- E-21: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/ILifeCycleManager.cs`
- E-22: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractHandlerProvider.cs`
- E-23: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/IMethodHandlerProvider.cs`
- E-24: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/ITextDocumentIdentifierHandler.cs`
- E-25: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/RequestHandlerMetadata.cs`
- E-26: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/RequestShutdownEventArgs.cs`
- E-27: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/LspErrorCodes.cs`
- E-28: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/LanguageServerConstants.cs`
- E-29: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/AbstractTelemetryService.cs`
- E-30: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializeHandler.cs`
- E-31: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs`
- E-32: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/NewtonsoftLanguageServer.cs`
- E-33: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/SystemTextJsonLanguageServer.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractLanguageServer.Initialize正常系 | E-01 (行88-91) | ○ |
| C-02 | AbstractLanguageServer.GetLspServices正常系 | E-01 (行108) | ○ |
| C-03 | AbstractLanguageServer.OnInitialized正常系 | E-01 (行165-168) | ○ |
| C-04 | AbstractLanguageServer.ShutdownAsync正常系 | E-01 (行246-271) | ○ |
| C-05 | AbstractLanguageServer.ShutdownAsync冪等性 | E-01 (行249-255) | ○ |
| C-06 | AbstractLanguageServer.ExitAsync正常系 | E-01 (行277-325) | ○ |
| C-07 | AbstractLanguageServer.ExitAsync異常系（シャットダウン前） | E-01 (行282-285) | ○ |
| C-08 | AbstractLanguageServer.WaitForExitAsync正常系 | E-01 (行225-240) | ○ |
| C-09 | AbstractLanguageServer.WaitForExitAsync異常系 | E-01 (行229-233) | ○ |
| C-10 | AbstractLanguageServer.TryGetLanguageForRequest正常系 | E-01 (行185-190) | ○ |
| C-11 | AbstractLanguageServer.SetupRequestDispatcher正常系 | E-01 (行110-157) | ○ |
| C-12 | AbstractLanguageServer.SetupRequestDispatcher異常系 | E-01 (行127-134) | ○ |
| C-13 | RequestExecutionQueue.コンストラクタ正常系 | E-02 (行86-92) | ○ |
| C-14 | RequestExecutionQueue.Start正常系 | E-02 (行127-131) | ○ |
| C-15 | RequestExecutionQueue.ExecuteAsync正常系 | E-02 (行156-188) | ○ |
| C-16 | RequestExecutionQueue.ExecuteAsync異常系（シャットダウン後） | E-02 (行184-186) | ○ |
| C-17 | RequestExecutionQueue.ExecuteAsync キャンセル | E-02 (行166-167) | ○ |
| C-18 | RequestExecutionQueue.DisposeAsync正常系 | E-02 (行443-454) | ○ |
| C-19 | RequestExecutionQueue.ProcessQueueCoreAsync mutating | E-02 (行354-372) | ○ |
| C-20 | RequestExecutionQueue.ProcessQueueCoreAsync non-mutating | E-02 (行374-405) | ○ |
| C-21 | RequestExecutionQueue.BeforeRequest正常系 | E-02 (行411-414) | ○ |
| C-22 | RequestExecutionQueue.WrapStartRequestTaskAsync正常系 | E-02 (行435-438) | ○ |
| C-23 | HandlerProvider.GetMethodHandler正常系 | E-03 (行26-37) | ○ |
| C-24 | HandlerProvider.GetMethodHandler異常系 | E-03 (行31-34) | ○ |
| C-25 | HandlerProvider.GetRegisteredMethods正常系 | E-03 (行39-43) | ○ |
| C-26 | HandlerProvider.CreateMethodToHandlerMap正常系 | E-03 (行48-96) | ○ |
| C-27 | HandlerProvider.CreateMethodToHandlerMap重複エラー | E-03 (行119-125) | ○ |
| C-28 | HandlerProvider.VerifyHandlers異常系 | E-03 (行127-134) | ○ |
| C-29 | QueueItem.Create正常系 | E-04 (行70-85) | ○ |
| C-30 | QueueItem.CreateRequestContextAsync正常系 | E-04 (行87-105) | ○ |
| C-31 | QueueItem.CreateRequestContextAsync非mutatingエラー | E-04 (行96-100, 149-154) | ○ |
| C-32 | QueueItem.CreateRequestContextAsync mutatingエラー | E-04 (行144-148) | ○ |
| C-33 | QueueItem.StartRequestAsync IRequestHandler | E-04 (行190-194) | ○ |
| C-34 | QueueItem.StartRequestAsync INotificationHandler | E-04 (行202-208) | ○ |
| C-35 | QueueItem.StartRequestAsync context null | E-04 (行172-185) | ○ |
| C-36 | QueueItem.StartRequestAsync キャンセル | E-04 (行223-230) | ○ |
| C-37 | QueueItem.StartRequestAsync 未知ハンドラ | E-04 (行216-219) | ○ |
| C-38 | QueueItem.FailRequest正常系 | E-04 (行261-275) | ○ |
| C-39 | QueueItem.FailRequest異常系 | E-04 (行265-268) | ○ |
| C-40 | MethodHandlerDetails.From正常系 | E-05 (行31-52) | ○ |
| C-41 | MethodHandlerDetails.From異常系 | E-05 (行92-95) | ○ |
| C-42 | MethodHandlerDetails.GetRequestHandlerMethod正常系 | E-05 (行100-114) | ○ |
| C-43 | MethodHandlerDetails.GetRequestHandlerMethod異常系 | E-05 (行108-111) | ○ |
| C-44 | TypeRef.From(string,string,string?)正常系 | E-06 (行82-92) | ○ |
| C-45 | TypeRef.From キャッシュ | E-06 (行86-88) | ○ |
| C-46 | TypeRef.From(Type)正常系 | E-06 (行98-113) | ○ |
| C-47 | TypeRef.From(Type) null例外 | E-06 (行100-103) | ○ |
| C-48 | TypeRef.FromOrNull正常系 | E-06 (行119-120) | ○ |
| C-49 | TypeRef.Equals同一 | E-06 (行50-54) | ○ |
| C-50 | TypeRef.Equals異なる | E-06 (行50-54) | ○ |
| C-51 | TypeRef.GetHashCode正常系 | E-06 (行56-72) | ○ |
| C-52 | TypeRef.DefaultResolver.ResolveCore正常系 | E-07 (行22-27) | ○ |
| C-53 | TypeRef.DefaultResolver.ResolveCore異常系 | E-07 (行26-27) | ○ |
| C-54 | AbstractTypeRefResolver.Resolveキャッシュ保存 | E-08 (行17-26) | ○ |
| C-55 | AbstractTypeRefResolver.Resolveキャッシュ取得 | E-08 (行19-22) | ○ |
| C-56 | LanguageServerEndpointAttribute.コンストラクタ正常系 | E-09 (行40-44) | ○ |
| C-57 | LanguageServerEndpointAttribute.コンストラクタデフォルト | E-09 (行28-32) | ○ |
| C-58 | RequestHandlerMetadata.コンストラクタ正常系 | E-25 (行10) | ○ |
| C-59 | RequestHandlerMetadata.HandlerDescription正常系 | E-25 (行12) | ○ |
| C-60 | RequestShutdownEventArgs.コンストラクタ正常系 | E-26 (行13-19) | ○ |
| C-61 | AbstractRequestScope.コンストラクタ正常系 | E-11 (行12) | ○ |
| C-62 | AbstractRequestScope.RecordHandlerLanguage正常系 | E-11 (行27-30) | ○ |
| C-63 | InitializeHandler.HandleRequestAsync正常系 | E-30 (行26-33) | ○ |
| C-64 | InitializeHandler.MutatesSolutionState正常系 | E-30 (行24) | ○ |
| C-65 | InitializedHandler.HandleNotificationAsync正常系 | E-31 (行21-28) | ○ |
| C-66 | InitializedHandler.HandleNotificationAsync二重初期化 | E-31 (行23-26) | ○ |
| C-67 | InitializedHandler.MutatesSolutionState正常系 | E-31 (行19) | ○ |
| C-68 | NewtonsoftLanguageServer.DeserializeRequest正常系 | E-32 (行27-52) | ○ |
| C-69 | NewtonsoftLanguageServer.DeserializeRequest NoValue | E-32 (行31-40) | ○ |
| C-70 | NewtonsoftLanguageServer.DeserializeRequest パラメータ必須 | E-32 (行33-36) | ○ |
| C-71 | NewtonsoftLanguageServer.DeserializeRequest パラメータ不要 | E-32 (行43-46) | ○ |
| C-72 | NewtonsoftLanguageServer.CreateDelegatingEntryPoint正常系 | E-32 (行54-57) | ○ |
| C-73 | SystemTextJsonLanguageServer.DeserializeRequest正常系 | E-33 (行27-51) | ○ |
| C-74 | SystemTextJsonLanguageServer.DeserializeRequest NoValue | E-33 (行29-40) | ○ |
| C-75 | SystemTextJsonLanguageServer.DeserializeRequest パラメータ必須 | E-33 (行31-34) | ○ |
| C-76 | SystemTextJsonLanguageServer.DeserializeRequest パラメータ不要 | E-33 (行42-45) | ○ |
| C-77 | SystemTextJsonLanguageServer.CreateDelegatingEntryPoint正常系 | E-33 (行53-56) | ○ |
| C-78 | SystemTextJsonDelegatingEntryPoint.GetEntryPoint パラメータあり | E-33 (行65-67) | ○ |
| C-79 | SystemTextJsonDelegatingEntryPoint.GetEntryPoint パラメータなし | E-33 (行65-67) | ○ |
| C-80 | NoValue.Instance正常系 | E-04 (行20-23) | ○ |
| C-81 | ILspServices.GetService正常系 | E-15 (行16) | ○ |
| C-82 | ILspServices.GetService未登録 | E-15 (行16) | ○ |
| C-83 | ILspServices.GetRequiredService正常系 | E-15 (行17) | ○ |
| C-84 | ILspServices.GetRequiredService未登録 | E-15 (行17) | ○ |
| C-85 | ILspServices.TryGetService正常系 | E-15 (行19) | ○ |
| C-86 | ILspServices.TryGetService未登録 | E-15 (行19) | ○ |
| C-87 | ILspServices.GetRequiredServices正常系 | E-15 (行21) | ○ |
| C-88 | ILspServices.GetRequiredServices空 | E-15 (行21) | ○ |
| C-89 | ILspServices.Dispose正常系 | E-15 (行14) | ○ |
| C-90 | ILspLogger.CreateContext正常系 | E-16 (行14) | ○ |
| C-91 | ILspLogger.CreateLanguageContext正常系 | E-16 (行15) | ○ |
| C-92 | ILspLogger.LogDebug正常系 | E-16 (行17) | ○ |
| C-93 | ILspLogger.LogInformation正常系 | E-16 (行18) | ○ |
| C-94 | ILspLogger.LogWarning正常系 | E-16 (行19) | ○ |
| C-95 | ILspLogger.LogError正常系 | E-16 (行20) | ○ |
| C-96 | ILspLogger.LogException正常系 | E-16 (行21) | ○ |
| C-97 | IMethodHandler.MutatesSolutionState正常系 | E-14 (行18-19) | ○ |
| C-98 | IRequestHandler.HandleRequestAsync正常系 | E-12 (行21-22) | ○ |
| C-99 | IRequestHandler(パラメータなし).HandleRequestAsync正常系 | E-12 (行32-33) | ○ |
| C-100 | INotificationHandler.HandleNotificationAsync正常系 | E-13 (行27-29) | ○ |
| C-101 | INotificationHandler(パラメータなし).HandleNotificationAsync正常系 | E-13 (行17-19) | ○ |
| C-102 | IInitializeManager.GetInitializeResult正常系 | E-20 (行15-16) | ○ |
| C-103 | IInitializeManager.SetInitializeParams正常系 | E-20 (行21-22) | ○ |
| C-104 | IInitializeManager.GetInitializeParams正常系 | E-20 (行27-28) | ○ |
| C-105 | ILifeCycleManager.ExitAsync正常系 | E-21 (行24-26) | ○ |
| C-106 | ILifeCycleManager.ShutdownAsync正常系 | E-21 (行32-35) | ○ |
| C-107 | AbstractHandlerProvider.GetRegisteredMethods正常系 | E-22 (行19-20) | ○ |
| C-108 | AbstractHandlerProvider.GetMethodHandler正常系 | E-22 (行29-34) | ○ |
| C-109 | IMethodHandlerProvider.GetMethodHandlers正常系 | E-23 (行17-18) | ○ |
| C-110 | ITextDocumentIdentifierHandler.GetTextDocumentIdentifier正常系 | E-24 (行13-15) | ○ |
| C-111 | IRequestExecutionQueue.ExecuteAsync正常系 | E-19 (行22-24) | ○ |
| C-112 | IRequestExecutionQueue.Start正常系 | E-19 (行28-29) | ○ |
| C-113 | IQueueItem.StartRequestAsync正常系 | E-18 (行26-28) | ○ |
| C-114 | IQueueItem.CreateRequestContextAsync正常系 | E-18 (行36-38) | ○ |
| C-115 | IQueueItem.FailRequest正常系 | E-18 (行43-44) | ○ |
| C-116 | AbstractTelemetryService.CreateRequestScope正常系 | E-29 (行12) | ○ |
| C-117 | LanguageServerConstants.DefaultLanguageName正常系 | E-28 (行14-15) | ○ |
| C-118 | LspErrorCodes.ContentModified正常系 | E-27 (行16) | ○ |
| C-119 | RoslynLspErrorCodes.NonFatalRequestFailure正常系 | E-27 (行40) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：すべてのテストケースに対してソースコードからの根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): すべてのテストケースがソースコードに基づいて生成されており、実装との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractLanguageServerのライフサイクル管理テストケース（C-01〜C-12）が実際の使用パターンを網羅しているか確認
- [ ] RequestExecutionQueueのmutating/non-mutatingリクエスト処理テストケース（C-19, C-20）が並行性要件を満たすか確認
- [ ] HandlerProviderの重複ハンドラ検証テストケース（C-27, C-28）がすべてのエッジケースをカバーしているか確認
- [ ] QueueItemのデシリアライズエラー処理テストケース（C-31, C-32）がmutating/non-mutatingの違いを正しく反映しているか確認
- [ ] NewtonsoftLanguageServerとSystemTextJsonLanguageServerのデシリアライズテストケース（C-68〜C-79）が両シリアライザの動作差異を適切に考慮しているか確認
- [ ] InitializeHandler/InitializedHandlerのテストケース（C-63〜C-67）がLSPプロトコル仕様と整合しているか確認
