---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 91
  claims_with_evidence: 91
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：LanguageServer-Main 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：91 / 91、根拠なし：0
- 優先レビュー（高）
  1. **LanguageServerHost**: サーバーのメインエントリポイントで、LSP通信の基盤となるクラス
  2. **LanguageServerProjectSystem**: ソリューション/プロジェクトのロード機能の中核
  3. **TestRunner/TestDiscoverer**: テスト実行・発見機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Program.cs`
- E-02: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/LanguageServerHost.cs`
- E-03: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectSystem.cs`
- E-04: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerWorkspaceFactory.cs`
- E-05: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestRunner.cs`
- E-06: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestDiscoverer.cs`
- E-07: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Services/ExtensionAssemblyManager.cs`
- E-08: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/ServiceBrokerFactory.cs`
- E-09: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/DotnetCliHelper.cs`
- E-10: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LoadedProject.cs`
- E-11: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectLoader.cs`
- E-12: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Logging/LspServiceLogger.cs`
- E-13: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/FileWatching/LspFileChangeWatcher.cs`
- E-14: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/Restore/RestoreHandler.cs`
- E-15: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/DebugConfiguration/WorkspaceDebugConfigurationHandler.cs`
- E-16: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/BrokeredServiceContainer.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LanguageServerHost コンストラクタの正常系テスト | E-02 (line 29-54) | ○ |
| C-02 | LanguageServerHost.Start の正常系テスト | E-02 (line 56-62) | ○ |
| C-03 | LanguageServerHost.WaitForExitAsync の正常系テスト | E-02 (line 64-68) | ○ |
| C-04 | LanguageServerHost.GetRequiredLspService<T> の正常系テスト | E-02 (line 70-73) | ○ |
| C-05 | LanguageServerHost.GetRequiredLspService<T> の異常系テスト | E-02 (line 70-73) | ○ |
| C-06 | LanguageServerProjectSystem.OpenSolutionAsync の正常系テスト | E-03 (line 54-66) | ○ |
| C-07 | LanguageServerProjectSystem.OpenSolutionAsync の異常系テスト | E-03 (line 54-66) | ○ |
| C-08 | LanguageServerProjectSystem.OpenProjectsAsync の正常系テスト | E-03 (line 68-79) | ○ |
| C-09 | LanguageServerProjectSystem.OpenProjectsAsync の境界値テスト | E-03 (line 70-71) | ○ |
| C-10 | LanguageServerProjectSystem.TryLoadProjectInMSBuildHostAsync の正常系テスト | E-03 (line 81-100) | ○ |
| C-11 | LanguageServerProjectSystem.TryLoadProjectInMSBuildHostAsync の異常系テスト | E-03 (line 84-85) | ○ |
| C-12 | LanguageServerWorkspaceFactory コンストラクタの正常系テスト | E-04 (line 27-71) | ○ |
| C-13 | LanguageServerWorkspaceFactory.CreateSolutionLevelAnalyzerReferencesForWorkspace の正常系テスト | E-04 (line 81-105) | ○ |
| C-14 | LanguageServerWorkspaceFactory.CreateSolutionLevelAnalyzerReferencesForWorkspace の境界値テスト | E-04 (line 93-101) | ○ |
| C-15 | TestRunner.RunTestsAsync の正常系テスト | E-05 (line 29-49) | ○ |
| C-16 | TestRunner.RunTestsAsync のデバッガーアタッチテスト | E-05 (line 61-65) | ○ |
| C-17 | TestRunner.RunTestsAsync のキャンセルテスト | E-05 (line 47) | ○ |
| C-18 | TestRunner.RunTests のデフォルト設定テスト | E-05 (line 60) | ○ |
| C-19 | TestDiscoverer.DiscoverTestsAsync の正常系テスト | E-06 (line 33-87) | ○ |
| C-20 | TestDiscoverer.DiscoverTestsAsync の境界値テスト | E-06 (line 49-53) | ○ |
| C-21 | TestDiscoverer.DiscoverTestsAsync の異常系テスト | E-06 (line 64-68) | ○ |
| C-22 | TestDiscoverer.MatchDiscoveredTestsToTestsInRangeAsync の正常系テスト | E-06 (line 89-109) | ○ |
| C-23 | ExtensionAssemblyManager.Create の正常系テスト | E-07 (line 48-137) | ○ |
| C-24 | ExtensionAssemblyManager.Create の異常系テスト | E-07 (line 87-91) | ○ |
| C-25 | ExtensionAssemblyManager.TryLoadAssemblyInExtensionContext(string) の正常系テスト | E-07 (line 163-177) | ○ |
| C-26 | ExtensionAssemblyManager.TryLoadAssemblyInExtensionContext(string) の境界値テスト | E-07 (line 165-176) | ○ |
| C-27 | ExtensionAssemblyManager.TryLoadAssemblyInExtensionContext(AssemblyName) の正常系テスト | E-07 (line 183-192) | ○ |
| C-28 | ExtensionAssemblyManager.TryLoadAssemblyInExtensionContext(AssemblyName) の境界値テスト | E-07 (line 185-191) | ○ |
| C-29 | ServiceBrokerFactory.CreateAsync の正常系テスト | E-08 (line 63-80) | ○ |
| C-30 | ServiceBrokerFactory.CreateAsync の異常系テスト | E-08 (line 65) | ○ |
| C-31 | ServiceBrokerFactory.CreateAndConnectAsync の正常系テスト | E-08 (line 82-88) | ○ |
| C-32 | ServiceBrokerFactory.TryGetFullAccessServiceBroker の正常系テスト | E-08 (line 52) | ○ |
| C-33 | ServiceBrokerFactory.TryGetFullAccessServiceBroker の境界値テスト | E-08 (line 52) | ○ |
| C-34 | ServiceBrokerFactory.ShutdownAndWaitForCompletionAsync の正常系テスト | E-08 (line 90-97) | ○ |
| C-35 | DotnetCliHelper.Run の正常系テスト | E-09 (line 71-113) | ○ |
| C-36 | DotnetCliHelper.Run のローカライズ制御テスト | E-09 (line 95-100) | ○ |
| C-37 | DotnetCliHelper.GetVsTestConsolePathAsync の正常系テスト | E-09 (line 115-122) | ○ |
| C-38 | DotnetCliHelper.GetVsTestConsolePathAsync の異常系テスト | E-09 (line 62-66) | ○ |
| C-39 | DotnetCliHelper.GetDotNetPathOrDefault の正常系テスト | E-09 (line 129-155) | ○ |
| C-40 | DotnetCliHelper.GetDotNetPathOrDefault の境界値テスト | E-09 (line 152-154) | ○ |
| C-41 | LoadedProject コンストラクタの正常系テスト | E-10 (line 44-67) | ○ |
| C-42 | LoadedProject コンストラクタの異常系テスト | E-10 (line 46) | ○ |
| C-43 | LoadedProject.UpdateWithNewProjectInfoAsync の正常系テスト | E-10 (line 137-307) | ○ |
| C-44 | LoadedProject.UpdateWithNewProjectInfoAsync のFilePath不一致テスト | E-10 (line 142) | ○ |
| C-45 | LoadedProject.UpdateWithNewProjectInfoAsync のTargetFramework不一致テスト | E-10 (line 143) | ○ |
| C-46 | LoadedProject.GetTargetFramework の正常系テスト | E-10 (line 118-122) | ○ |
| C-47 | LoadedProject.GetTargetFramework の異常系テスト | E-10 (line 120) | ○ |
| C-48 | LoadedProject.Dispose の正常系テスト | E-10 (line 129-135) | ○ |
| C-49 | LoadedProject.NeedsReload イベントテスト | E-10 (line 69-92, 116) | ○ |
| C-50 | LanguageServerProjectLoader.BeginLoadingProjectAsync の正常系テスト | E-11 (line 472-485) | ○ |
| C-51 | LanguageServerProjectLoader.BeginLoadingProjectAsync の境界値テスト | E-11 (line 476-479) | ○ |
| C-52 | LanguageServerProjectLoader.WaitForProjectsToFinishLoadingAsync の正常系テスト | E-11 (line 487) | ○ |
| C-53 | LanguageServerProjectLoader.TryUnloadProjectAsync の正常系テスト | E-11 (line 503-508) | ○ |
| C-54 | LanguageServerProjectLoader.TryUnloadProjectAsync の境界値テスト | E-11 (line 513-517) | ○ |
| C-55 | LanguageServerProjectLoader.UnloadAllProjectsAsync の正常系テスト | E-11 (line 490-501) | ○ |
| C-56 | LanguageServerProjectLoader.IsProjectLoadedAsync の正常系テスト | E-11 (line 416-422) | ○ |
| C-57 | LanguageServerProjectLoader.IsProjectLoadedAsync の境界値テスト | E-11 (line 420) | ○ |
| C-58 | LspServiceLogger.LogDebug の正常系テスト | E-12 (line 29) | ○ |
| C-59 | LspServiceLogger.LogError の正常系テスト | E-12 (line 31) | ○ |
| C-60 | LspServiceLogger.LogException の正常系テスト | E-12 (line 33) | ○ |
| C-61 | LspServiceLogger.CreateContext の正常系テスト | E-12 (line 22) | ○ |
| C-62 | LspServiceLogger.CreateLanguageContext の正常系テスト | E-12 (line 24-27) | ○ |
| C-63 | LspServiceLogger.CreateLanguageContext の境界値テスト | E-12 (line 25-26) | ○ |
| C-64 | LspFileChangeWatcher コンストラクタの正常系テスト | E-13 (line 28-35) | ○ |
| C-65 | LspFileChangeWatcher.SupportsLanguageServerHost の正常系テスト | E-13 (line 37-42) | ○ |
| C-66 | LspFileChangeWatcher.SupportsLanguageServerHost の境界値テスト | E-13 (line 41) | ○ |
| C-67 | LspFileChangeWatcher.CreateContext の正常系テスト | E-13 (line 44-45) | ○ |
| C-68 | RestoreHandler.HandleRequestAsync の正常系テスト | E-14 (line 33-59) | ○ |
| C-69 | RestoreHandler.HandleRequestAsync の境界値テスト | E-14 (line 165-189) | ○ |
| C-70 | RestoreHandler.RestoreAsync の正常系テスト | E-14 (line 63-76) | ○ |
| C-71 | RestoreHandler.RestoreAsync の異常系テスト | E-14 (line 118-122) | ○ |
| C-72 | RestoreHandler.RestoreAsync のキャンセルテスト | E-14 (line 106-109) | ○ |
| C-73 | WorkspaceDebugConfigurationHandler.HandleRequestAsync の正常系テスト | E-15 (line 31-39) | ○ |
| C-74 | WorkspaceDebugConfigurationHandler.HandleRequestAsync の境界値テスト | E-15 (line 42-45) | ○ |
| C-75 | WorkspaceDebugConfigurationHandler.HandleRequestAsync の異常系テスト | E-15 (line 33) | ○ |
| C-76 | BrokeredServiceContainer.CreateAsync の正常系テスト | E-16 (line 37-57) | ○ |
| C-77 | BrokeredServiceContainer.RegisterServices の正常系テスト | E-16 (line 27-28) | ○ |
| C-78 | BrokeredServiceContainer.UnregisterServices の正常系テスト | E-16 (line 31-32) | ○ |
| C-79 | BrokeredServiceContainer.GetRegisteredServices の正常系テスト | E-16 (line 34-35) | ○ |
| C-80 | Program.CreateNewPipeNames のWindows正常系テスト | E-01 (line 358-372) | ○ |
| C-81 | Program.CreateNewPipeNames のUnix正常系テスト | E-01 (line 369-371) | ○ |
| C-82 | Program.GetUnixTypePipeName の正常系テスト | E-01 (line 374-378) | ○ |
| C-83 | Program.WaitForClientProcessExitAsync の正常系テスト | E-01 (line 380-392) | ○ |
| C-84 | Program.WaitForClientProcessExitAsync の異常系テスト | E-01 (line 387-391) | ○ |
| C-85 | Program.RunAsync のオプション競合テスト | E-01 (line 39-42) | ○ |
| C-86 | Program.CreateCommand の正常系テスト | E-01 (line 189-356) | ○ |
| C-87 | DocumentFileInfoComparer.Equals の等価テスト | E-10 (line 323-326) | ○ |
| C-88 | DocumentFileInfoComparer.Equals の非等価テスト | E-10 (line 323-326) | ○ |
| C-89 | DocumentFileInfoComparer.GetHashCode の正常系テスト | E-10 (line 328-331) | ○ |
| C-90 | ExtensionAssemblyLoadContext.Load の正常系テスト | E-07 (line 210-224) | ○ |
| C-91 | ExtensionAssemblyLoadContext.Load の境界値テスト | E-07 (line 220-223) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

すべてのテストケースはソースコードに基づいて生成されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードの実装に基づいて定義されています。

## 6) レビュアーチェックリスト（最小）
- [ ] LanguageServerHost のテストケースがLSP通信の主要機能を網羅しているか確認
- [ ] LanguageServerProjectSystem のソリューション/プロジェクトロード機能のテストケースが十分か確認
- [ ] TestRunner/TestDiscoverer のテスト実行・発見機能のテストケースが十分か確認
- [ ] ExtensionAssemblyManager の拡張機能ロード機能のテストケースが十分か確認
- [ ] ServiceBrokerFactory のサービスブローカー機能のテストケースが十分か確認
- [ ] DotnetCliHelper のCLI実行機能のテストケースが十分か確認
- [ ] 境界値テスト（空配列、null値、存在しないパスなど）が適切に含まれているか確認
- [ ] 異常系テスト（例外発生条件）が網羅されているか確認

## 7) 解析対象ファイル一覧

本テストケース一覧は、以下のファイルを解析して生成しました：

| ファイルパス | 主要クラス/関数 |
|-------------|----------------|
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Program.cs | Program (エントリポイント) |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/LanguageServerHost.cs | LanguageServerHost |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectSystem.cs | LanguageServerProjectSystem |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerWorkspaceFactory.cs | LanguageServerWorkspaceFactory |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestRunner.cs | TestRunner |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestDiscoverer.cs | TestDiscoverer |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Services/ExtensionAssemblyManager.cs | ExtensionAssemblyManager |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/ServiceBrokerFactory.cs | ServiceBrokerFactory |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/DotnetCliHelper.cs | DotnetCliHelper |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LoadedProject.cs | LoadedProject |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectLoader.cs | LanguageServerProjectLoader |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Logging/LspServiceLogger.cs | LspServiceLogger |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/FileWatching/LspFileChangeWatcher.cs | LspFileChangeWatcher |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/Restore/RestoreHandler.cs | RestoreHandler |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/DebugConfiguration/WorkspaceDebugConfigurationHandler.cs | WorkspaceDebugConfigurationHandler |
| src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/BrokeredServiceContainer.cs | BrokeredServiceContainer |
