---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：LanguageServer-Protocol 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-LSP-099**: LspServicesのGetRequiredServiceの内部実装詳細が未確認
  2. **UT-LSP-100**: 未登録サービス時の具体的な例外型が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/LanguageServer/Protocol/RoslynLanguageServer.cs`（241行）
- E-02: `src/LanguageServer/Protocol/RoslynRequestExecutionQueue.cs`（90行）
- E-03: `src/LanguageServer/Protocol/DefaultCapabilitiesProvider.cs`（184行）
- E-04: `src/LanguageServer/Protocol/Handler/RequestContext.cs`（374行）
- E-05: `src/LanguageServer/Protocol/Handler/Completion/CompletionHandler.cs`（307行）
- E-06: `src/LanguageServer/Protocol/Handler/Hover/HoverHandler.cs`（150行）
- E-07: `src/LanguageServer/Protocol/Handler/Rename/RenameHandler.cs`（76行）
- E-08: `src/LanguageServer/Protocol/Workspaces/LspWorkspaceManager.cs`（611行）
- E-09: `src/LanguageServer/Protocol/Extensions/ProtocolConversions.cs`（1096行）
- E-10: `src/LanguageServer/Protocol/Handler/SemanticTokens/SemanticTokensHelpers.cs`（386行）
- E-11: `src/LanguageServer/Protocol/Handler/Diagnostics/AbstractPullDiagnosticHandler.cs`（319行）
- E-12: `src/LanguageServer/Protocol/Handler/Diagnostics/DiagnosticsPullCache.cs`（141行）
- E-13: `src/LanguageServer/Protocol/LspServices/LspServices.cs`（推定・直接未読）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RoslynLanguageServerコンストラクタが正しく初期化 | E-01（28-47行） | ○ |
| C-02 | CreateJsonMessageFormatterがSystemTextJsonFormatterを生成 | E-01（49-54行） | ○ |
| C-03 | ConstructLspServicesがLspServicesを構築 | E-01（56-59行） | ○ |
| C-04 | TryGetLanguageForRequestがtextDocumentからlanguageを取得 | E-01（162-223行） | ○ |
| C-05 | パラメータnullでデフォルト言語使用 | E-01（164-169行） | ○ |
| C-06 | Initializeリクエストでデフォルト言語使用 | E-01（224-238行） | ○ |
| C-07 | OnInitializedAsyncが初期化完了を処理 | E-01（157-160行） | ○ |
| C-08 | RoslynRequestExecutionQueueコンストラクタ初期化 | E-02（22-26行） | ○ |
| C-09 | WrapStartRequestTaskAsyncがタスクを正常完了 | E-02（28-39行） | ○ |
| C-10 | 例外時にrethrowExceptions=falseで抑制 | E-02（34-38行） | ○ |
| C-11 | BeforeRequestでCultureInfo設定 | E-02（41-45行） | ○ |
| C-12 | GetCultureForRequestがLocaleからカルチャ取得 | E-02（50-88行） | ○ |
| C-13 | 無効Localeでフォールバック | E-02（74-87行） | ○ |
| C-14 | InitializeParams nullで現在カルチャ返却 | E-02（57-63行） | ○ |
| C-15 | GetCapabilitiesがServerCapabilities生成 | E-03（45-172行） | ○ |
| C-16 | VSクライアントでVS拡張機能含む | E-03（47-48行, 174-182行） | ○ |
| C-17 | CompletionProviderからトリガー文字設定 | E-03（50-52行） | ○ |
| C-18 | SemanticTokensOptions設定 | E-03（105-116行） | ○ |
| C-19 | RequestContextコンストラクタ初期化 | E-04（165-200行） | ○ |
| C-20 | Workspaceプロパティ取得 | E-04（64-78行） | ○ |
| C-21 | ClearSolutionContext後のアクセスで例外 | E-04（76行） | ○ |
| C-22 | Solutionプロパティ取得 | E-04（83-97行） | ○ |
| C-23 | Documentプロパティ取得 | E-04（103-120行） | ○ |
| C-24 | DocumentがDocument型でない場合例外 | E-04（117-118行） | ○ |
| C-25 | GetRequiredClientCapabilities取得 | E-04（202-207行） | ○ |
| C-26 | ClientCapabilities nullで例外 | E-04（204-206行） | ○ |
| C-27 | GetRequiredDocument取得 | E-04（209-214行） | ○ |
| C-28 | Document nullで例外 | E-04（211-213行） | ○ |
| C-29 | CreateAsync非同期コンテキスト作成 | E-04（223-296行） | ○ |
| C-30 | ドキュメント関連コンテキスト作成 | E-04（259-265行） | ○ |
| C-31 | StartTrackingAsync追跡開始 | E-04（302-303行） | ○ |
| C-32 | UpdateTrackedDocument更新 | E-04（309-310行） | ○ |
| C-33 | StopTrackingAsync追跡停止 | E-04（322-323行） | ○ |
| C-34 | GetTrackedDocumentInfo取得 | E-04（312-316行） | ○ |
| C-35 | 未追跡URIで例外 | E-04（314行） | ○ |
| C-36 | IsTrackingでtrue返却 | E-04（325-326行） | ○ |
| C-37 | 未追跡でfalse返却 | E-04（325-326行） | ○ |
| C-38 | ClearSolutionContextクリア | E-04（328-334行） | ○ |
| C-39 | GetRequiredLspService取得 | E-04（354-357行） | ○ |
| C-40 | CompletionHandler HandleRequestAsync処理 | E-05（45-67行） | ○ |
| C-41 | トリガー文字でコンプリーション発動 | E-05（90-94行） | ○ |
| C-42 | コンプリーション非発動でnull | E-05（90-94行） | ○ |
| C-43 | GetCompletionListAsync生成 | E-05（69-109行） | ○ |
| C-44 | コンプリーション項目なしでnull | E-05（99-100行） | ○ |
| C-45 | FilterCompletionListフィルタリング | E-05（187-256行） | ○ |
| C-46 | 最大サイズ超過でリスト切り詰め | E-05（209-210行, 267-304行） | ○ |
| C-47 | HoverHandler HandleRequestAsync処理 | E-06（42-51行） | ○ |
| C-48 | シンボルなしでnull | E-06（98-99行） | ○ |
| C-49 | VSクライアントでVS拡張ホバー | E-06（101-102行, 106-130行） | ○ |
| C-50 | マークダウン対応でMarkdown | E-06（101-103行, 132-148行） | ○ |
| C-51 | RenameHandler HandleRequestAsync処理 | E-07（30-31行） | ○ |
| C-52 | リネーム不可でnull | E-07（40-41行） | ○ |
| C-53 | GetRenameEditAsync編集生成 | E-07（33-74行） | ○ |
| C-54 | リネーム競合でnull | E-07（58-62行） | ○ |
| C-55 | LspWorkspaceManager StartTrackingAsync開始 | E-08（106-138行） | ○ |
| C-56 | 既追跡で例外 | E-08（109行） | ○ |
| C-57 | StopTrackingAsync停止 | E-08（146-193行） | ○ |
| C-58 | 未追跡停止で例外 | E-08（149行） | ○ |
| C-59 | UpdateTrackedDocument更新 | E-08（200-211行） | ○ |
| C-60 | 未追跡更新で例外 | E-08（203行） | ○ |
| C-61 | GetTrackedLspText一覧取得 | E-08（213行） | ○ |
| C-62 | GetLspSolutionInfoAsyncソリューション取得 | E-08（226-235行） | ○ |
| C-63 | GetLspDocumentInfoAsyncドキュメント取得 | E-08（244-317行） | ○ |
| C-64 | 存在しないドキュメントでデフォルト | E-08（295-316行） | ○ |
| C-65 | TryGetLanguageForUri言語取得 | E-08（542-558行） | ○ |
| C-66 | 未知URIでfalse | E-08（554-557行） | ○ |
| C-67 | PositionToLinePosition変換 | E-09（308-309行） | ○ |
| C-68 | RangeToLinePositionSpan変換 | E-09（311-312行） | ○ |
| C-69 | RangeToTextSpan変換 | E-09（314-355行） | ○ |
| C-70 | 終了位置超過でクランプ | E-09（322-330行） | ○ |
| C-71 | TextSpanToRange変換 | E-09（379-383行） | ○ |
| C-72 | LinePositionToPosition変換 | E-09（373-374行） | ○ |
| C-73 | TextChangeToTextEdit変換 | E-09（357-365行） | ○ |
| C-74 | TextEditToTextChange変換 | E-09（367-368行） | ○ |
| C-75 | CreateAbsoluteUri作成 | E-09（199-215行） | ○ |
| C-76 | 無効パスで例外 | E-09（209-213行） | ○ |
| C-77 | GetDocumentationMarkupContentマークダウン | E-09（957-1085行） | ○ |
| C-78 | マークダウン非対応でPlainText | E-09（959-966行） | ○ |
| C-79 | LSPToRoslynCompletionTriggerAsyncトリガー変換 | E-09（124-185行） | ○ |
| C-80 | contextがnullでInvoke | E-09（131-133行） | ○ |
| C-81 | NavigateToKindToSymbolKind変換 | E-09（618-637行） | ○ |
| C-82 | HighlightSpanKindToDocumentHighlightKind変換 | E-09（639-650行） | ○ |
| C-83 | GlyphToSymbolKind変換 | E-09（716-762行） | ○ |
| C-84 | SymbolKindToGlyph変換 | E-09（661-714行） | ○ |
| C-85 | SemanticTokensHelpers HandleRequestHelperAsync | E-10（25-53行） | ○ |
| C-86 | rangesがnullで全ドキュメント処理 | E-10（35-36行） | ○ |
| C-87 | ComputeSemanticTokensDataAsync計算 | E-10（80-109行） | ○ |
| C-88 | 複数行スパンを単一行に分割 | E-10（156-225行） | ○ |
| C-89 | ComputeTokensトークン配列生成 | E-10（227-257行） | ○ |
| C-90 | ComputeNextToken次トークン計算 | E-10（283-376行） | ○ |
| C-91 | AbstractPullDiagnosticHandler HandleRequestAsync | E-11（99-217行） | ○ |
| C-92 | 前回結果と同じでunchanged report | E-11（169-181行） | ○ |
| C-93 | 削除ドキュメントでremoved report | E-11（194-200行） | ○ |
| C-94 | ReportCurrentDiagnostics現在診断レポート | E-11（269-293行） | ○ |
| C-95 | HandleRemovedDocuments削除レポート | E-11（295-307行） | ○ |
| C-96 | DiagnosticsPullCache ComputeVersionAsync | E-12（36-39行） | ○ |
| C-97 | ComputeDataAsync診断データ計算 | E-12（42-47行） | ○ |
| C-98 | ComputeChecksumチェックサム計算 | E-12（49-71行） | ○ |
| C-99 | LspServices GetRequiredService取得 | E-13 | △ |
| C-100 | 未登録サービスで例外 | E-13 | △ |

## 4) 不足情報（Unknown / Missing）
- **LspServices.csの詳細実装**: LspServicesクラスの内部実装を直接読み込んでいないため、GetRequiredServiceの具体的な実装と例外型が未確認
  - 候補：`src/LanguageServer/Protocol/LspServices/LspServices.cs` を追加読み込み

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: テストケースの大部分はソースコード解析に基づいており、メソッドシグネチャ、実装ロジック、例外処理が明確に確認できる
- **1（中リスク）**: C-99, C-100のLspServicesに関するテストケースは、ファイルを直接読み込んでいないため、実装詳細の確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] LspServices.csを確認し、GetRequiredServiceの例外型を特定する
- [ ] 各Handlerクラスの境界値テストケースが実際のエッジケースをカバーしているか確認
- [ ] 非同期メソッド（Async系）のキャンセレーションハンドリングテストケースが十分か確認
- [ ] 各Contractアサーションに対応するテストケースが存在することを確認
- [ ] VS拡張機能対応テストケース（VSInternalXxx）が正しい条件分岐をカバーしているか確認
