---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：RoslynAnalyzers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-45 GetLinesFromSourceText null処理**：null入力時の動作はコード確認済みだがドキュメント記載なし
  2. **C-89 JsonWriter.Dispose**：内部実装の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/Core/AbstractAllocationAnalyzer.cs` - 抽象アロケーション分析クラス
- E-02: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/Core/ExplicitAllocationAnalyzer.cs` - 明示的アロケーション分析クラス
- E-03: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/CSharp/Analyzers/CallSiteImplicitAllocationAnalyzer.cs` - 暗黙的アロケーション分析クラス
- E-04: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/CSharp/Analyzers/TypeConversionAllocationAnalyzer.cs` - 型変換アロケーション分析クラス
- E-05: `src/RoslynAnalyzers/PublicApiAnalyzers/Core/Analyzers/DeclarePublicApiAnalyzer.cs` - PublicAPI宣言分析クラス
- E-06: `src/RoslynAnalyzers/PublicApiAnalyzers/Core/Analyzers/PublicApiFile.cs` - PublicAPIファイル識別構造体
- E-07: `src/RoslynAnalyzers/PublicApiAnalyzers/Core/CodeFixes/DeclarePublicApiFix.cs` - PublicAPI宣言修正クラス
- E-08: `src/RoslynAnalyzers/Microsoft.CodeAnalysis.Analyzers/Core/MetaAnalyzers/DiagnosticAnalyzerCorrectnessAnalyzer.cs` - 診断アナライザー正確性分析クラス
- E-09: `src/RoslynAnalyzers/Microsoft.CodeAnalysis.Analyzers/Core/MetaAnalyzers/DiagnosticDescriptorCreationAnalyzer.cs` - 診断記述子作成分析クラス
- E-10: `src/RoslynAnalyzers/Microsoft.CodeAnalysis.Analyzers/Core/MetaAnalyzers/CompareSymbolsCorrectlyAnalyzer.cs` - シンボル比較正確性分析クラス
- E-11: `src/RoslynAnalyzers/Microsoft.CodeAnalysis.BannedApiAnalyzers/Core/SymbolIsBannedAnalyzer.cs` - 禁止APIシンボル分析クラス
- E-12: `src/RoslynAnalyzers/Utilities/FlowAnalysis/FlowAnalysis/Analysis/PointsToAnalysis/PointsToAnalysis.cs` - PointsTo解析クラス
- E-13: `src/RoslynAnalyzers/Tools/GenerateDocumentationAndConfigFiles/JsonWriter.cs` - JSON出力ユーティリティクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractAllocationAnalyzer.Initialize: コンパイル開始時にOperationBlockStartActionが登録される | E-01 (L29-45) | ○ |
| C-02 | AbstractAllocationAnalyzer.Initialize: PerformanceSensitiveAttribute未定義時に早期リターン | E-01 (L34-38) | ○ |
| C-03 | AbstractAllocationAnalyzer.Initialize: Operations空の場合に早期リターン | E-01 (L24-27) | ○ |
| C-04 | AttributeChecker.TryGetContainsPerformanceSensitiveInfo: 属性がある場合にtrue | E-01 (L73-86) | ○ |
| C-05 | AttributeChecker.TryGetContainsPerformanceSensitiveInfo: プロパティアクセサの属性継承 | E-01 (L81-86) | ○ |
| C-06 | AttributeChecker.TryGetContainsPerformanceSensitiveInfo: 属性なしでfalse | E-01 (L88-89) | ○ |
| C-07 | CreatePerformanceSensitiveInfo: AllowCapturesパラメータ読み取り | E-01 (L114-116) | ○ |
| C-08 | CreatePerformanceSensitiveInfo: AllowGenericEnumerationパラメータ読み取り | E-01 (L117-119) | ○ |
| C-09 | CreatePerformanceSensitiveInfo: AllowLocksパラメータ読み取り | E-01 (L120-122) | ○ |
| C-10 | ExplicitAllocationAnalyzer.AnalyzeNode: 配列作成でArrayCreationRule診断 | E-02 (L80-88) | ○ |
| C-11 | ExplicitAllocationAnalyzer.AnalyzeNode: 暗黙的配列作成は報告しない | E-02 (L83) | ○ |
| C-12 | ExplicitAllocationAnalyzer.AnalyzeNode: 参照型オブジェクト作成でObjectCreationRule | E-02 (L99-103) | ○ |
| C-13 | ExplicitAllocationAnalyzer.AnalyzeNode: 属性使用では報告しない | E-02 (L93-97) | ○ |
| C-14 | ExplicitAllocationAnalyzer.AnalyzeNode: ボックス化で診断報告 | E-02 (L105-113) | ○ |
| C-15 | ExplicitAllocationAnalyzer.AnalyzeNode: 匿名オブジェクト作成でAnonymousObjectCreationRule | E-02 (L116-128) | ○ |
| C-16 | ExplicitAllocationAnalyzer.AnalyzeNode: 暗黙的匿名オブジェクトでLetCauseRule | E-02 (L118-120) | ○ |
| C-17 | ExplicitAllocationAnalyzer.AnalyzeNode: 明示的デリゲート作成でObjectCreationRule | E-02 (L130-138) | ○ |
| C-18 | ExplicitAllocationAnalyzer.AnalyzeNode: 暗黙的デリゲート作成は報告しない | E-02 (L133) | ○ |
| C-19 | CallSiteImplicitAllocationAnalyzer.AnalyzeNode: params配列でParamsParameterRule | E-03 (L67-79) | ○ |
| C-20 | CallSiteImplicitAllocationAnalyzer.AnalyzeNode: Array.Empty使用時は報告しない | E-03 (L72-73) | ○ |
| C-21 | CallSiteImplicitAllocationAnalyzer.CheckNonOverridenMethodOnStruct: ValueType判定 | E-03 (L83-93) | ○ |
| C-22 | CallSiteImplicitAllocationAnalyzer.CheckNonOverridenMethodOnStruct: Enum判定 | E-03 (L89) | ○ |
| C-23 | TypeConversionAllocationAnalyzer.AnalyzeNode: ボックス化でValueTypeToReferenceTypeConversionRule | E-04 (L264-269) | ○ |
| C-24 | TypeConversionAllocationAnalyzer.CheckDelegateCreation: メソッドグループでMethodGroupAllocationRule | E-04 (L286-293) | ○ |
| C-25 | TypeConversionAllocationAnalyzer.CheckDelegateCreation: 読み取り専用フィールドでReadonlyMethodGroupAllocationRule | E-04 (L299-302) | ○ |
| C-26 | TypeConversionAllocationAnalyzer.CheckDelegateCreation: 構造体インスタンスメソッドでDelegateOnStructInstanceRule | E-04 (L318-321) | ○ |
| C-27 | TypeConversionAllocationAnalyzer.InterpolationCheck: 文字列補間内の値型でボックス化診断 | E-04 (L205-212) | ○ |
| C-28 | DeclarePublicApiAnalyzer.Initialize: Public/Internal両方の実装登録 | E-05 (L109-110) | ○ |
| C-29 | DeclarePublicApiAnalyzer.ReadApiData: ApiLineが正しく読み取られる | E-05 (L156-195) | ○ |
| C-30 | DeclarePublicApiAnalyzer.ReadApiData: *REMOVED*プレフィックスの処理 | E-05 (L183-186) | ○ |
| C-31 | DeclarePublicApiAnalyzer.ReadApiData: #nullable enable処理 | E-05 (L176-179) | ○ |
| C-32 | DeclarePublicApiAnalyzer.ReadApiData: 空白行スキップ | E-05 (L170-172) | ○ |
| C-33 | DeclarePublicApiAnalyzer.TryGetApiData: Shipped/Unshipped統合 | E-05 (L221-225) | ○ |
| C-34 | DeclarePublicApiAnalyzer.TryGetApiData: ファイル欠落時のエラー診断 | E-05 (L228-240) | ○ |
| C-35 | DeclarePublicApiAnalyzer.TryGetApiData: EditorConfig設定によるサイレント終了 | E-05 (L207-213) | ○ |
| C-36 | DeclarePublicApiAnalyzer.ValidateApiFiles: Shippedファイルの*REMOVED*検証 | E-05 (L366-368) | ○ |
| C-37 | DeclarePublicApiAnalyzer.ValidateApiFiles: #nullable enable位置検証 | E-05 (L370-381) | ○ |
| C-38 | DeclarePublicApiAnalyzer.ValidateApiList: 重複API検出 | E-05 (L391-406) | ○ |
| C-39 | PublicApiFile: PublicAPI.Shipped.txt識別 | E-06 (L14-22) | ○ |
| C-40 | PublicApiFile: PublicAPI.Unshipped.txt識別 | E-06 (L19-21) | ○ |
| C-41 | PublicApiFile: InternalAPI.Shipped.txt識別 | E-06 (L18) | ○ |
| C-42 | PublicApiFile: 非APIファイル除外 | E-06 (L21) | ○ |
| C-43 | DeclarePublicApiFix.RegisterCodeFixesAsync: コードフィックス登録 | E-07 (L36-68) | ○ |
| C-44 | DeclarePublicApiFix.GetLinesFromSourceText: 非空白行抽出 | E-07 (L179-198) | ○ |
| C-45 | DeclarePublicApiFix.GetLinesFromSourceText: null入力で空リスト | E-07 (L181-184) | △ |
| C-46 | IgnoreCaseWhenPossibleComparer.Compare: 比較ロジック | E-07 (L408-415) | ○ |
| C-47 | DiagnosticAnalyzerCorrectnessAnalyzer.Initialize: シンボルアクション登録 | E-08 (L14-38) | ○ |
| C-48 | DiagnosticAnalyzerCorrectnessAnalyzer.Initialize: 型不在時のスキップ | E-08 (L27-31) | ○ |
| C-49 | DiagnosticDescriptorCreationAnalyzer.Initialize: OperationAction登録 | E-09 (L253-283) | ○ |
| C-50 | DiagnosticDescriptorCreationAnalyzer.TryGetDescriptorCreateMethodAndArguments: コンストラクタ検出 | E-09 (L530-537) | ○ |
| C-51 | DiagnosticDescriptorCreationAnalyzer.TryGetDescriptorCreateMethodAndArguments: ヘルパーメソッド検出 | E-09 (L546-550) | ○ |
| C-52 | DiagnosticDescriptorCreationAnalyzer.AnalyzeTitle: 非ローカライズタイトル検出 | E-09 (L628-630) | ○ |
| C-53 | DiagnosticDescriptorCreationAnalyzer.AnalyzeTitleCore: 末尾ピリオド検出 | E-09 (L648-661) | ○ |
| C-54 | DiagnosticDescriptorCreationAnalyzer.AnalyzeTitleCore: 複数文検出 | E-09 (L647-661) | ○ |
| C-55 | DiagnosticDescriptorCreationAnalyzer.AnalyzeHelpLinkUri: HelpLink欠落検出 | E-09 (L1027-1052) | ○ |
| C-56 | DiagnosticDescriptorCreationAnalyzer.AnalyzeCustomTags: 空customTags検出 | E-09 (L1075-1083) | ○ |
| C-57 | DiagnosticDescriptorCreationAnalyzer.AnalyzeRuleId: 非定数ID検出 | E-09 (L1276-1281) | ○ |
| C-58 | DiagnosticDescriptorCreationAnalyzer.AnalyzeRuleId: 予約済みID検出 | E-09 (L1250-1252) | ○ |
| C-59 | DiagnosticDescriptorCreationAnalyzer.IsReservedDiagnosticId: CA接頭辞判定 | E-09 (L1296-1297) | ○ |
| C-60 | DiagnosticDescriptorCreationAnalyzer.IsReservedDiagnosticId: CS接頭辞判定 | E-09 (L1298-1300) | ○ |
| C-61 | DiagnosticDescriptorCreationAnalyzer.IsReservedDiagnosticId: 許可アセンブリ除外 | E-09 (L1316-1322) | ○ |
| C-62 | DiagnosticDescriptorCreationAnalyzer.IsReservedDiagnosticId: 短いID処理 | E-09 (L1291-1294) | ○ |
| C-63 | CompareSymbolsCorrectlyAnalyzer.Initialize: アクション登録 | E-10 (L99-122) | ○ |
| C-64 | CompareSymbolsCorrectlyAnalyzer.HandleBinaryOperator: シンボル==比較検出 | E-10 (L125-164) | ○ |
| C-65 | CompareSymbolsCorrectlyAnalyzer.HandleBinaryOperator: null比較除外 | E-10 (L141-144) | ○ |
| C-66 | CompareSymbolsCorrectlyAnalyzer.HandleBinaryOperator: 明示的キャスト除外 | E-10 (L158-161) | ○ |
| C-67 | CompareSymbolsCorrectlyAnalyzer.HandleInvocationOperation: GetHashCode呼び出し検出 | E-10 (L179-187) | ○ |
| C-68 | CompareSymbolsCorrectlyAnalyzer.HandleInvocationOperation: Equals呼び出し検出 | E-10 (L189-198) | ○ |
| C-69 | CompareSymbolsCorrectlyAnalyzer.HandleInvocationOperation: HashCode.Combine検出 | E-10 (L201-209) | ○ |
| C-70 | CompareSymbolsCorrectlyAnalyzer.HandleObjectCreation: Dictionary作成検出 | E-10 (L259-271) | ○ |
| C-71 | CompareSymbolsCorrectlyAnalyzer.HandleObjectCreation: IEqualityComparer付き除外 | E-10 (L268) | ○ |
| C-72 | CompareSymbolsCorrectlyAnalyzer.UseSymbolEqualityComparer: コンパレータ存在確認 | E-10 (L375-376) | ○ |
| C-73 | SymbolIsBannedAnalyzer.ReadBannedApis: バンファイルパース | E-11 (L53-129) | ○ |
| C-74 | SymbolIsBannedAnalyzer.ReadBannedApis: コメント処理 | E-11 (L67-68) | ○ |
| C-75 | SymbolIsBannedAnalyzer.ReadBannedApis: 重複検出 | E-11 (L83-100) | ○ |
| C-76 | SymbolIsBannedAnalyzer.ReadBannedApis: 空ファイル処理 | E-11 (L78-79) | ○ |
| C-77 | PointsToAnalysis.TryGetOrComputeResult: 基本解析実行 | E-12 (L30-81) | ○ |
| C-78 | PointsToAnalysis.TryGetOrComputeResult: AnalysisKind.None処理 | E-12 (L60-64) | ○ |
| C-79 | PointsToAnalysis.TryGetOrComputeResult: null CFG処理 | E-12 (L71-75) | ○ |
| C-80 | PointsToAnalysis.ShouldBeTracked: null許容型判定 | E-12 (L94-96) | ○ |
| C-81 | PointsToAnalysis.ShouldBeTracked: IDisposable型判定 | E-12 (L96) | ○ |
| C-82 | JsonWriter.WriteObjectStart: オブジェクト開始出力 | E-13 (L40-43) | ○ |
| C-83 | JsonWriter.Write(string,string): キー値ペア出力 | E-13 (L79-83) | ○ |
| C-84 | JsonWriter.EscapeString: バックスラッシュエスケープ | E-13 (L203-205) | ○ |
| C-85 | JsonWriter.EscapeString: ダブルクォートエスケープ | E-13 (L198-202) | ○ |
| C-86 | JsonWriter.EscapeString: 制御文字Unicodeエスケープ | E-13 (L207-209) | ○ |
| C-87 | JsonWriter.EscapeString: 空文字列処理 | E-13 (L172-175) | ○ |
| C-88 | JsonWriter.ShouldAppendAsUnicode: Unicode改行文字判定 | E-13 (L247-250) | ○ |
| C-89 | JsonWriter.Dispose: リソース解放 | E-13 (L158-161) | △ |
| C-90 | DiagnosticDescriptorCreationAnalyzer.IsMultiSentences: マルチセンテンス判定 | E-09 (L958-959) | ○ |
| C-91 | DiagnosticDescriptorCreationAnalyzer.EndsWithPeriod: ピリオド判定 | E-09 (L968-969) | ○ |
| C-92 | DiagnosticDescriptorCreationAnalyzer.HasLeadingOrTrailingWhitespaces: 空白判定 | E-09 (L1018-1019) | ○ |
| C-93 | DiagnosticDescriptorCreationAnalyzer.ContainsLineReturn: 改行判定 | E-09 (L977-978) | ○ |
| C-94 | DiagnosticDescriptorCreationAnalyzer.FixMultiSentences: マルチセンテンス修正 | E-09 (L961-966) | ○ |
| C-95 | DiagnosticDescriptorCreationAnalyzer.RemoveTrailingPeriod: ピリオド削除 | E-09 (L971-975) | ○ |
| C-96 | DiagnosticDescriptorCreationAnalyzer.EndsWithPunctuation: 感嘆符判定 | E-09 (L1011-1016) | ○ |
| C-97 | DiagnosticDescriptorCreationAnalyzer.EndsWithPunctuation: 疑問符判定 | E-09 (L1011-1016) | ○ |
| C-98 | DiagnosticDescriptorCreationAnalyzer.TryGetAdditionalDocumentLocationInfo: 情報取得 | E-09 (L689-716) | ○ |
| C-99 | DiagnosticDescriptorCreationAnalyzer.TryGetAdditionalDocumentLocationInfo: プロパティ欠落処理 | E-09 (L697-701) | ○ |
| C-100 | DiagnosticDescriptorCreationAnalyzer.GetDefaultSeverityAndEnabledByDefault: フラグ読み取り | E-09 (L1107-1180) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-45 (GetLinesFromSourceText null処理)**: コード上ではnullチェックが存在し空リストを返すことが確認できるが、この動作に関する公式ドキュメントやコメントがない
  - 候補：単体テストコード / メソッドのXMLドキュメント / 設計書
- **C-89 (JsonWriter.Dispose)**: Disposeメソッドは内部TextWriterのDisposeを呼び出すが、例外処理やnullチェックに関する明示的なドキュメントがない
  - 候補：IDisposableパターンに関するガイドライン / 単体テストコード

## 5) リスクフラグ（レビュー観点）
- 0: **低リスク** - 全体の98%のテストケースがソースコードから直接根拠を確認できる
- 1: **中リスク** - 一部のエッジケース（null処理、リソース解放）については追加の確認が推奨される
- 0: **高リスク** - 特になし

## 6) レビュアーチェックリスト（最小）
- [ ] PerformanceSensitiveAnalyzers関連のテストケース（UT-RAZ-001〜027）がAllocationRulesの仕様と一致しているか確認
- [ ] PublicApiAnalyzers関連のテストケース（UT-RAZ-028〜046）がPublicAPI.txt形式仕様と一致しているか確認
- [ ] MetaAnalyzers関連のテストケース（UT-RAZ-047〜072）がDiagnosticDescriptor生成ルールと一致しているか確認
- [ ] BannedApiAnalyzers関連のテストケース（UT-RAZ-073〜076）がBannedSymbols.txt形式仕様と一致しているか確認
- [ ] FlowAnalysis関連のテストケース（UT-RAZ-077〜081）がデータフロー解析の要件と一致しているか確認
- [ ] JsonWriter関連のテストケース（UT-RAZ-082〜089）がJSON仕様（RFC 8259）と一致しているか確認
- [ ] 境界値テストケースが適切にエッジケースをカバーしているか確認
- [ ] 優先度「高」のテストケースが重要なビジネスロジック/セキュリティ機能に対応しているか確認
