---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 161
  claims_with_evidence: 158
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：Scripting モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装・メソッドシグネチャ・コメントなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：対象クラス・メソッドの主要な機能をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 161、根拠なし：3
- 優先レビュー（高）
  1. **UT-SCR-130（NuGet参照解決）**：PackageResolverの具体実装が抽象クラスのため動作確認が必要
  2. **UT-SCR-156（対話モード）**：実際の対話動作は統合テストでの確認が推奨
  3. **UT-SCR-076（例外キャッチ動作）**：非同期処理との組み合わせで追加確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Scripting/Core/Script.cs` - Script/Script<T>クラスの実装
- E-02: `src/Scripting/Core/ScriptState.cs` - ScriptState/ScriptState<T>クラスの実装
- E-03: `src/Scripting/Core/ScriptVariable.cs` - ScriptVariableクラスの実装
- E-04: `src/Scripting/Core/ScriptOptions.cs` - ScriptOptionsクラスの実装
- E-05: `src/Scripting/Core/ScriptBuilder.cs` - ScriptBuilderクラスの実装
- E-06: `src/Scripting/Core/ScriptCompiler.cs` - ScriptCompiler抽象クラスの定義
- E-07: `src/Scripting/Core/CompilationErrorException.cs` - CompilationErrorExceptionクラスの実装
- E-08: `src/Scripting/Core/ScriptExecutionState.cs` - ScriptExecutionStateクラスの実装
- E-09: `src/Scripting/CSharp/CSharpScript.cs` - CSharpScriptクラスの実装
- E-10: `src/Scripting/CSharp/CSharpScriptCompiler.cs` - CSharpScriptCompilerクラスの実装
- E-11: `src/Scripting/Core/Hosting/InteractiveScriptGlobals.cs` - InteractiveScriptGlobalsクラスの実装
- E-12: `src/Scripting/Core/Hosting/PrintOptions.cs` - PrintOptionsクラスの実装
- E-13: `src/Scripting/Core/Hosting/ObjectFormatter/ObjectFormatter.cs` - ObjectFormatter抽象クラスの定義
- E-14: `src/Scripting/Core/Hosting/ObjectFormatter/CommonObjectFormatter.cs` - CommonObjectFormatterクラスの実装
- E-15: `src/Scripting/Core/Hosting/AssemblyLoader/InteractiveAssemblyLoader.cs` - InteractiveAssemblyLoaderクラスの実装
- E-16: `src/Scripting/Core/Hosting/Resolvers/RuntimeMetadataReferenceResolver.cs` - RuntimeMetadataReferenceResolverクラスの実装
- E-17: `src/Scripting/Core/Hosting/Resolvers/NuGetPackageResolver.cs` - NuGetPackageResolver抽象クラスの定義
- E-18: `src/Scripting/Core/Hosting/AssemblyLoader/MetadataShadowCopyProvider.cs` - MetadataShadowCopyProviderクラスの実装
- E-19: `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs` - CommandLineRunnerクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### Script/Script<T>クラス（UT-SCR-001 - UT-SCR-024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateInitialScriptで有効なスクリプトが作成される | E-01: 54-57行目 | ○ |
| C-02 | sourceTextがnullの場合にDebug.Assertが失敗する | E-01: 41行目 | ○ |
| C-03 | ContinueWithでスクリプトの継続が正しく行われる | E-01: 114-118行目 | ○ |
| C-04 | ContinueWithでcodeがnullでも空文字列として処理される | E-01: 117行目 | ○ |
| C-05 | ContinueWith(Stream)でStreamがnullの場合にArgumentNullException | E-01: 127-128行目 | ○ |
| C-06 | GetCompilationでCompilationオブジェクトが取得できる | E-01: 144-153行目 | ○ |
| C-07 | GetCompilationで複数回呼び出しても同じCompilationが返る | E-01: 146-149行目（Interlocked.CompareExchange） | ○ |
| C-08 | WithOptionsでオプション変更後のスクリプトが返却される | E-01: 351-354行目 | ○ |
| C-09 | WithOptionsで同じオプションを指定した場合に同一オブジェクトが返る | E-01: 353行目 | ○ |
| C-12 | RunAsyncでスクリプトが正常に実行される | E-01: 486-498行目 | ○ |
| C-13 | RunAsyncでglobalsがnullだがglobalsType指定時にArgumentException | E-01: 589-593行目 | ○ |
| C-14 | RunAsyncでglobalsの型がglobalsTypeと一致しない場合にArgumentException | E-01: 595-601行目 | ○ |
| C-15 | RunAsyncでglobalsTypeがnullでglobals指定時にArgumentException | E-01: 603-606行目 | ○ |
| C-17 | RunFromAsyncで前の状態から実行が継続される | E-01: 546-572行目 | ○ |
| C-18 | RunFromAsyncでpreviousStateがnullの場合にArgumentNullException | E-01: 551-553行目 | ○ |
| C-19 | RunFromAsyncでpreviousStateが現在のスクリプトの実行結果である場合にそのまま返却 | E-01: 556-559行目 | ○ |
| C-20 | RunFromAsyncでpreviousStateが不正な場合にArgumentException | E-01: 562-566行目 | ○ |
| C-21 | CreateDelegateでScriptRunner<T>デリゲートが作成される | E-01: 506-517行目 | ○ |
| C-22 | Compileで警告診断のみが返却される | E-01: 358-372行目 | ○ |
| C-24 | EvaluateAsyncでスクリプトの評価結果が返却される | E-01: 454-455行目 | ○ |

### ScriptState/ScriptState<T>クラス（UT-SCR-025 - UT-SCR-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Variablesで定義された変数一覧が取得できる | E-02: 61-72行目 | ○ |
| C-26 | GetVariableで変数名で変数が取得できる | E-02: 83-92行目 | ○ |
| C-27 | GetVariableでnameがnullの場合にArgumentNullException | E-02: 85-88行目 | ○ |
| C-28 | GetVariableで存在しない変数名の場合にnullが返却される | E-02: 91行目 | ○ |
| C-29 | ReturnValueで実行結果の戻り値が取得できる | E-02: 54-56行目 | ○ |
| C-31 | ContinueWithAsyncで新しいコードで実行が継続される | E-02: 156-157行目 | ○ |

### ScriptVariableクラス（UT-SCR-033 - UT-SCR-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Nameで変数名が取得できる | E-03: 34行目 | ○ |
| C-34 | Typeで変数の型が取得できる | E-03: 39行目 | ○ |
| C-35 | IsReadOnlyで読み取り専用かどうかが判定できる | E-03: 44行目 | ○ |
| C-36 | Value(get)で変数の値が取得できる | E-03: 53-56行目 | ○ |
| C-37 | Value(set)で変数の値が設定できる | E-03: 70行目 | ○ |
| C-38 | Value(set)でreadonly変数への設定でInvalidOperationException | E-03: 60-63行目 | ○ |
| C-39 | Value(set)でconst変数への設定でInvalidOperationException | E-03: 65-68行目 | ○ |

### ScriptOptionsクラス（UT-SCR-040 - UT-SCR-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Defaultでデフォルトオプションが取得できる | E-04: 25-37行目 | ○ |
| C-41 | WithFilePathでファイルパスが設定される | E-04: 205-206行目 | ○ |
| C-42 | WithFilePathでnullを指定すると空文字列になる | E-04: 206行目 | ○ |
| C-43 | WithReferences(MetadataReference[])で参照が設定される | E-04: 229-230行目 | ○ |
| C-48 | WithImportsでインポートが設定される | E-04: 330-331行目 | ○ |
| C-50 | WithMetadataResolverでメタデータリゾルバが設定される | E-04: 310-311行目 | ○ |
| C-52 | WithEmitDebugInformationでデバッグ情報出力設定が変更される | E-04: 357-358行目 | ○ |
| C-53 | WithOptimizationLevelで最適化レベルが設定される | E-04: 369-370行目 | ○ |
| C-54 | WithAllowUnsafeでunsafeコード許可設定が変更される | E-04: 375-376行目 | ○ |
| C-55 | WithCheckOverflowでオーバーフローチェック設定が変更される | E-04: 381-382行目 | ○ |
| C-56 | WithWarningLevelで警告レベルが設定される | E-04: 387-388行目 | ○ |

### ScriptBuilderクラス（UT-SCR-058 - UT-SCR-065）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタでScriptBuilderが正しく初期化される | E-05: 60-66行目 | ○ |
| C-59 | GenerateSubmissionIdで一意のサブミッションIDが生成される | E-05: 68-75行目 | ○ |
| C-61 | CreateExecutorで実行デリゲートが作成される | E-05: 78-101行目 | ○ |
| C-62 | CreateExecutorでコンパイルエラーがある場合にCompilationErrorException | E-05: 103-117行目 | ○ |
| C-63 | GetEmitOptionsでデバッグ情報有効時に正しいEmitOptionsが返る | E-05: 165-166行目 | ○ |
| C-65 | GetEntryPointRuntimeMethodでエントリポイントメソッドが取得できる | E-05: 186-193行目 | ○ |

### CompilationErrorExceptionクラス（UT-SCR-066 - UT-SCR-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | コンストラクタで例外が正しく初期化される | E-07: 22-31行目 | ○ |
| C-67 | コンストラクタでdiagnosticsがdefaultの場合にArgumentNullException | E-07: 25-28行目 | ○ |
| C-68 | Diagnosticsで診断情報が取得できる | E-07: 20行目 | ○ |

### ScriptExecutionStateクラス（UT-SCR-069 - UT-SCR-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Createで実行状態が作成される | E-08: 31-37行目 | ○ |
| C-71 | FreezeAndCloneで状態がフリーズされクローンされる | E-08: 39-57行目 | ○ |
| C-73 | GetSubmissionStateでサブミッション状態が取得できる | E-08: 61-65行目 | ○ |
| C-74 | RunSubmissionsAsyncでサブミッションが順次実行される | E-08: 67-154行目 | ○ |
| C-76 | RunSubmissionsAsyncで例外発生時にcatchExceptionがtrueを返すと例外がキャッチされる | E-08: 123-153行目 | △ |

### CSharpScriptクラス（UT-SCR-077 - UT-SCR-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Create<T>(string)でC#スクリプトが作成される | E-09: 33-38行目 | ○ |
| C-78 | Create<T>(string)でcodeがnullの場合にArgumentNullException | E-09: 35-36行目 | ○ |
| C-79 | Create<T>(Stream)でStreamからスクリプトが作成される | E-09: 50-55行目 | ○ |
| C-80 | Create<T>(Stream)でStreamがnullの場合にArgumentNullException | E-09: 52-53行目 | ○ |
| C-82 | RunAsync<T>でスクリプトが実行されてScriptState<T>が返る | E-09: 98-101行目 | ○ |
| C-85 | EvaluateAsync<T>でスクリプトの評価結果が返る | E-09: 128-131行目 | ○ |

### CSharpScriptCompilerクラス（UT-SCR-087 - UT-SCR-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | Instanceでシングルトンインスタンスが取得できる | E-10: 16行目 | ○ |
| C-88 | CreateSubmissionでCSharpCompilationが作成される | E-10: 33-77行目 | ○ |
| C-90 | ParseSubmissionで構文木が作成される | E-10: 30-31行目 | ○ |
| C-91 | IsCompleteSubmissionで完全なサブミッションかどうかが判定される | E-10: 28行目 | ○ |

### InteractiveScriptGlobalsクラス（UT-SCR-094 - UT-SCR-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | コンストラクタでグローバルオブジェクトが正しく初期化される | E-11: 47-70行目 | ○ |
| C-95 | コンストラクタでoutputWriterがnullの場合にArgumentNullException | E-11: 49-52行目 | ○ |
| C-96 | コンストラクタでobjectFormatterがnullの場合にArgumentNullException | E-11: 54-57行目 | ○ |
| C-97 | Printでオブジェクトが整形されて出力される | E-11: 37-40行目 | ○ |

### PrintOptionsクラス（UT-SCR-101 - UT-SCR-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | NumberRadixで数値基数が設定できる | E-12: 21-36行目 | ○ |
| C-102 | NumberRadixで無効な基数でArgumentOutOfRangeException | E-12: 30-33行目 | ○ |
| C-103 | MemberDisplayFormatでメンバー表示形式が設定できる | E-12: 54-69行目 | ○ |
| C-104 | MemberDisplayFormatで無効な値でArgumentOutOfRangeException | E-12: 63-66行目 | ○ |
| C-105 | MaximumOutputLengthで最大出力長が設定できる | E-12: 72-88行目 | ○ |
| C-106 | MaximumOutputLengthで0以下の値でArgumentOutOfRangeException | E-12: 80-83行目 | ○ |

### ObjectFormatter/CommonObjectFormatterクラス（UT-SCR-109 - UT-SCR-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | FormatObjectでオブジェクトが整形される | E-13: 16行目 | ○ |
| C-112 | CommonObjectFormatter.FormatObjectでオブジェクトが整形される | E-14: 21-33行目 | ○ |
| C-113 | CommonObjectFormatter.FormatObjectでoptionsがnullの場合にArgumentNullException | E-14: 23-28行目 | ○ |
| C-114 | CommonObjectFormatter.FormatExceptionで例外が整形される | E-14: 61-105行目 | ○ |
| C-115 | CommonObjectFormatter.FormatExceptionでeがnullの場合にArgumentNullException | E-14: 63-66行目 | ○ |

### InteractiveAssemblyLoaderクラス（UT-SCR-117 - UT-SCR-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | コンストラクタでアセンブリローダーが初期化される | E-15: 84-94行目 | ○ |
| C-119 | Disposeでリソースが解放される | E-15: 96-99行目 | ○ |
| C-120 | RegisterDependency(AssemblyIdentity, string)で依存関係が登録される | E-15: 154-170行目 | ○ |
| C-121 | RegisterDependency(AssemblyIdentity, string)でdependencyがnullの場合にArgumentNullException | E-15: 156-159行目 | ○ |
| C-122 | RegisterDependency(AssemblyIdentity, string)でpathが相対パスの場合にArgumentException | E-15: 161-164行目 | ○ |
| C-123 | RegisterDependency(Assembly)でアセンブリ依存関係が登録される | E-15: 181-192行目 | ○ |
| C-124 | RegisterDependency(Assembly)でdependencyがnullの場合にArgumentNullException | E-15: 183-186行目 | ○ |
| C-125 | LoadAssemblyFromStreamでストリームからアセンブリがロードされる | E-15: 101-106行目 | ○ |

### RuntimeMetadataReferenceResolverクラス（UT-SCR-128 - UT-SCR-136）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 | CreateCurrentPlatformResolverで現在のプラットフォーム用リゾルバが作成される | E-16: 51-63行目 | ○ |
| C-129 | ResolveReferenceで参照が解決される | E-16: 142-195行目 | ○ |
| C-130 | ResolveReferenceでNuGetパッケージ参照が解決される | E-16: 144-152行目 | △ |
| C-131 | ResolveReferenceで解決できない参照で空配列が返る | E-16: 194行目 | ○ |
| C-132 | ResolveMissingAssemblyで欠落アセンブリが解決される | E-16: 96-134行目 | ○ |
| C-134 | Equalsで同一リゾルバでtrueが返る | E-16: 238-246行目 | ○ |
| C-136 | GetHashCodeでハッシュコードが取得できる | E-16: 230-236行目 | ○ |

### NuGetPackageResolverクラス（UT-SCR-137 - UT-SCR-141）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | TryParsePackageReferenceでNuGetパッケージ参照が解析される | E-17: 20-47行目 | ○ |
| C-138 | TryParsePackageReferenceでバージョンなしの参照が解析される | E-17: 30-33行目 | ○ |
| C-139 | TryParsePackageReferenceで無効な参照でfalseが返る | E-17: 44-46行目 | ○ |

### MetadataShadowCopyProviderクラス（UT-SCR-142 - UT-SCR-155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | コンストラクタでプロバイダが初期化される | E-18: 71-107行目 | ○ |
| C-143 | コンストラクタでカスタムディレクトリで初期化される | E-18: 73-84行目 | ○ |
| C-144 | コンストラクタで相対パスでArgumentException | E-18: 109-119行目 | ○ |
| C-145 | Disposeでリソースが解放される | E-18: 160-171行目 | ○ |
| C-146 | IsShadowCopyでシャドウコピーパスかどうかが判定される | E-18: 128-149行目 | ○ |
| C-147 | IsShadowCopyでnullでArgumentNullException | E-18: 130行目（RequireAbsolutePath呼び出し） | ○ |
| C-149 | NeedsShadowCopyでシャドウコピーが必要かどうかが判定される | E-18: 382-395行目 | ○ |
| C-150 | GetMetadataでメタデータが取得される | E-18: 230-274行目 | ○ |
| C-151 | GetMetadataShadowCopyでシャドウコピーが取得される | E-18: 288-341行目 | ○ |
| C-153 | SuppressShadowCopyでシャドウコピーが抑制される | E-18: 363-373行目 | ○ |
| C-154 | SuppressShadowCopyでnullでArgumentNullException | E-18: 365行目 | ○ |

### CommandLineRunnerクラス（UT-SCR-156 - UT-SCR-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | RunInteractiveで対話モードが正常に開始される | E-19: 53-69行目 | △ |
| C-157 | RunInteractiveでバージョン表示時に0が返る | E-19: 80-84行目 | ○ |
| C-158 | RunInteractiveでヘルプ表示時に0が返る | E-19: 102-106行目 | ○ |
| C-160 | GetMetadataReferenceResolverでメタデータリゾルバが作成される | E-19: 180-193行目 | ○ |
| C-161 | GetSourceReferenceResolverでソースリゾルバが作成される | E-19: 195-198行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SCR-076**: RunSubmissionsAsyncの例外キャッチ動作については、非同期処理との組み合わせで複雑な動作となるため、実際の動作確認が推奨される
  - 候補：既存のテストコード（CSharpTest/ScriptTests.cs）の確認
- **UT-SCR-130**: NuGetPackageResolverは抽象クラスであり、具体的な実装はプロジェクト外部に依存する可能性がある
  - 候補：NuGetPackageResolverの具体実装クラスの調査
- **UT-SCR-156**: CommandLineRunnerの対話モードは、コンソールI/Oを伴うため単体テストでの完全な検証が困難
  - 候補：TestConsoleIOを使用したモック環境でのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- 1: 中リスク - 非同期処理（RunAsync系）の例外ハンドリングについては、追加の統合テストが推奨される
- 0: 低リスク - C#スクリプトコンパイラの主要機能は既存のテストスイートでカバーされている

## 6) レビュアーチェックリスト（最小）
- [ ] Script.RunAsyncのグローバル検証（UT-SCR-013, 014, 015）が実際の挙動と一致するか確認
- [ ] ScriptVariable.Value setterのreadonly/const検証（UT-SCR-038, 039）が正しくInvalidOperationExceptionをスローするか確認
- [ ] InteractiveAssemblyLoaderのパス検証（UT-SCR-122）が絶対パス要求を正しく行っているか確認
- [ ] MetadataShadowCopyProviderのDisposeが全リソースを正しく解放するか確認
- [ ] NuGetパッケージ参照解析（UT-SCR-137-141）のエッジケースが網羅されているか確認
