---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：VisualStudio-CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-VSC-100**：キャンセル処理のメッセージ内容の確認が必要
  2. **UT-VSC-104**：ドキュメント削除時の動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/CSharp/Impl/CSharpPackage.cs`
- E-02: `src/VisualStudio/CSharp/Impl/CodeModel/CSharpCodeModelService.cs`
- E-03: `src/VisualStudio/CSharp/Impl/Snippets/CSharpSnippetExpansionLanguageHelper.cs`
- E-04: `src/VisualStudio/CSharp/Impl/Snippets/SnippetCommandHandler.cs`
- E-05: `src/VisualStudio/CSharp/Impl/Snippets/CSharpSnippetInfoService.cs`
- E-06: `src/VisualStudio/CSharp/Impl/Venus/CSharpVenusBraceMatchingService.cs`
- E-07: `src/VisualStudio/CSharp/Impl/Options/AutomationObject/AutomationObject.cs`
- E-08: `src/VisualStudio/CSharp/Impl/CodeModel/ModifierFlagsExtensions.cs`
- E-09: `src/VisualStudio/CSharp/Impl/CodeModel/ParameterFlagsExtensions.cs`
- E-10: `src/VisualStudio/CSharp/Impl/CodeModel/SyntaxNodeExtensions.cs`
- E-11: `src/VisualStudio/CSharp/Impl/ProjectSystemShim/TempPECompilerService.cs`
- E-12: `src/VisualStudio/CSharp/Impl/ProjectSystemShim/CSharpEntryPointFinder.cs`
- E-13: `src/VisualStudio/CSharp/Impl/ProjectSystemShim/CSharpProjectShim.cs`
- E-14: `src/VisualStudio/CSharp/Impl/CodeModel/MethodXml/MethodXmlBuilder.cs`
- E-15: `src/VisualStudio/CSharp/Impl/CodeModel/Extenders/ExtensionMethodExtender.cs`
- E-16: `src/VisualStudio/CSharp/Impl/CodeModel/Extenders/AutoImplementedPropertyExtender.cs`
- E-17: `src/VisualStudio/CSharp/Impl/CodeModel/Extenders/PartialMethodExtender.cs`
- E-18: `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchQueryExecutor.cs`
- E-19: `src/VisualStudio/CSharp/Impl/ObjectBrowser/ObjectBrowserLibraryManager.cs`
- E-20: `src/VisualStudio/CSharp/Impl/ObjectBrowser/DescriptionBuilder.cs`
- E-21: `src/VisualStudio/CSharp/Impl/ObjectBrowser/ListItemFactory.cs`
- E-22: `src/VisualStudio/CSharp/Impl/LanguageService/CSharpLanguageService.cs`
- E-23: `src/VisualStudio/CSharp/Impl/LanguageService/CSharpEditorFactory.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpPackage.RegisterInitializeAsyncWork正常系 | E-01 (行63-68) | ○ |
| C-02 | CSharpPackage.PackageInitializationBackgroundThreadAsync正常系 | E-01 (行70-95) | ○ |
| C-03 | CSharpPackage.RegisterObjectBrowserLibraryManager正常系 | E-01 (行97-112) | ○ |
| C-04 | CSharpPackage.RegisterObjectBrowserLibraryManager異常系 | E-01 (行99) | ○ |
| C-05 | CSharpPackage.UnregisterObjectBrowserLibraryManager正常系 | E-01 (行114-129) | ○ |
| C-06 | CSharpPackage.NeedExport正常系（エクスポート要） | E-01 (行131-137) | ○ |
| C-07 | CSharpPackage.NeedExport正常系（エクスポート不要） | E-01 (行131-137) | ○ |
| C-08 | CSharpPackage.GetAutomationObject正常系 | E-01 (行139-147) | ○ |
| C-09 | CSharpPackage.CreateEditorFactories正常系 | E-01 (行149-155) | ○ |
| C-10 | CSharpCodeModelService.IsNameableNode（Class） | E-02 (行90-121) | ○ |
| C-11 | CSharpCodeModelService.IsNameableNode（Method） | E-02 (行90-121) | ○ |
| C-12 | CSharpCodeModelService.IsNameableNode（VariableDeclarator） | E-02 (行114-117) | ○ |
| C-13 | CSharpCodeModelService.IsNameableNode（未サポート） | E-02 (行118-119) | ○ |
| C-14 | CSharpCodeModelService.GetElementKind正常系 | E-02 (行123-134) | ○ |
| C-15 | CSharpCodeModelService.GetElementKind異常系 | E-02 (行130-132) | ○ |
| C-16 | CSharpCodeModelService.MatchesScope（Namespace） | E-02 (行140-148) | ○ |
| C-17 | CSharpCodeModelService.MatchesScope（Class） | E-02 (行150-156) | ○ |
| C-18 | CSharpCodeModelService.MatchesScope（Method） | E-02 (行158-172) | ○ |
| C-19 | CSharpCodeModelService.GetImportNodes正常系 | E-02 (行283-289) | ○ |
| C-20 | CSharpCodeModelService.GetImportNodes境界値 | E-02 (行288) | ○ |
| C-21 | CSharpCodeModelService.GetAttributeNodes正常系 | E-02 (行302-347) | ○ |
| C-22 | CSharpCodeModelService.GetMemberNodes正常系 | E-02 (行442-495) | ○ |
| C-23 | CSharpCodeModelService.GetMemberNodes再帰 | E-02 (行487-493) | ○ |
| C-24 | CSharpCodeModelService.GetMemberNodes論理フィールド | E-02 (行468-475) | ○ |
| C-25 | CSharpCodeModelService.Language | E-02 (行497-500) | ○ |
| C-26 | CSharpSnippetExpansionLanguageHelper.LanguageServiceGuid | E-03 (行41) | ○ |
| C-27 | CSharpSnippetExpansionLanguageHelper.FallbackDefaultLiteral | E-03 (行42) | ○ |
| C-28 | CSharpSnippetExpansionLanguageHelper.InsertEmptyCommentAndGetEndPositionTrackingSpan正常系 | E-03 (行46-68) | ○ |
| C-29 | CSharpSnippetExpansionLanguageHelper.InsertEmptyCommentAndGetEndPositionTrackingSpan異常系 | E-03 (行51-54) | ○ |
| C-30 | CSharpSnippetExpansionLanguageHelper.AddImportsAsync正常系 | E-03 (行70-106) | ○ |
| C-31 | CSharpSnippetExpansionLanguageHelper.AddImportsAsync境界値 | E-03 (行79-80) | ○ |
| C-32 | CSharpSnippetExpansionLanguageHelper.GetUsingDirectivesToAdd | E-03 (行108-148) | ○ |
| C-33 | SnippetCommandHandler.ExecuteCommand(SurroundWith)正常系 | E-04 (行50-60) | ○ |
| C-34 | SnippetCommandHandler.ExecuteCommand(SurroundWith)異常系 | E-04 (行54-57) | ○ |
| C-35 | SnippetCommandHandler.GetCommandState(SurroundWith)正常系 | E-04 (行62-78) | ○ |
| C-36 | SnippetCommandHandler.GetCommandState(SurroundWith)異常系 | E-04 (行66-75) | ○ |
| C-37 | SnippetCommandHandler.ExecuteCommand(TypeChar)正常系 | E-04 (行85-100) | ○ |
| C-38 | SnippetCommandHandler.TryInvokeInsertionUI正常系 | E-04 (行102-127) | ○ |
| C-39 | SnippetCommandHandler.IsSnippetExpansionContext正常系 | E-04 (行129-135) | ○ |
| C-40 | SnippetCommandHandler.IsSnippetExpansionContext（文字列内） | E-04 (行133) | ○ |
| C-41 | SnippetCommandHandler.IsSnippetExpansionContext（コメント内） | E-04 (行134) | ○ |
| C-42 | CSharpSnippetInfoService.ShouldFormatSnippet（#region） | E-05 (行25, 37-38) | ○ |
| C-43 | CSharpSnippetInfoService.ShouldFormatSnippet（#endregion） | E-05 (行25, 37-38) | ○ |
| C-44 | CSharpSnippetInfoService.ShouldFormatSnippet（その他） | E-05 (行37-38) | ○ |
| C-45 | CSharpVenusBraceMatchingService.TryGetCorrespondingOpenBrace正常系 | E-06 (行25-37) | ○ |
| C-46 | CSharpVenusBraceMatchingService.TryGetCorrespondingOpenBrace異常系 | E-06 (行35-36) | ○ |
| C-47 | AutomationObject.GetBooleanOption（true） | E-07 (行21-22) | ○ |
| C-48 | AutomationObject.GetBooleanOption（false） | E-07 (行21-22) | ○ |
| C-49 | AutomationObject.SetBooleanOption（非0） | E-07 (行33-34) | ○ |
| C-50 | AutomationObject.SetBooleanOption（0） | E-07 (行33-34) | ○ |
| C-51 | AutomationObject.GetBooleanOption（フラグ） | E-07 (行27-28) | ○ |
| C-52 | AutomationObject.SetBooleanOption（フラグ） | E-07 (行39-40) | ○ |
| C-53 | ModifierFlagsExtensions.GetModifierFlags（public） | E-08 (行38-101) | ○ |
| C-54 | ModifierFlagsExtensions.GetModifierFlags（複合） | E-08 (行38-101) | ○ |
| C-55 | ModifierFlagsExtensions.GetModifierFlags（なし） | E-08 (行40) | ○ |
| C-56 | ModifierFlagsExtensions.UpdateModifiers正常系 | E-08 (行103-122) | ○ |
| C-57 | ModifierFlagsExtensions.UpdateModifiers（トリビア保持） | E-08 (行107-108, 121) | ○ |
| C-58 | ParameterFlagsExtensions.GetParameterFlags（ref） | E-09 (行14-35) | ○ |
| C-59 | ParameterFlagsExtensions.GetParameterFlags（out） | E-09 (行14-35) | ○ |
| C-60 | ParameterFlagsExtensions.GetParameterFlags（params） | E-09 (行14-35) | ○ |
| C-61 | SyntaxNodeExtensions.TryGetAttributeLists（CompilationUnit） | E-10 (行14-20) | ○ |
| C-62 | SyntaxNodeExtensions.TryGetAttributeLists（BaseTypeDeclaration） | E-10 (行21-26) | ○ |
| C-63 | SyntaxNodeExtensions.TryGetAttributeLists（未サポート） | E-10 (行56-58) | ○ |
| C-64 | SyntaxNodeExtensions.GetFirstTokenAfterAttributes正常系 | E-10 (行61-69) | ○ |
| C-65 | SyntaxNodeExtensions.GetFirstTokenAfterAttributes境界値 | E-10 (行68) | ○ |
| C-66 | TempPECompilerService.CompileTempPE正常系 | E-11 (行32-67) | ○ |
| C-67 | TempPECompilerService.CompileTempPE異常系 | E-11 (行66) | ○ |
| C-68 | TempPECompilerService.ParseCommandLineArguments（参照） | E-11 (行80-88) | ○ |
| C-69 | TempPECompilerService.ParseCommandLineArguments（ブール） | E-11 (行90-99) | ○ |
| C-70 | CSharpEntryPointFinder.MatchesMainMethodName正常系 | E-12 (行14-15) | ○ |
| C-71 | CSharpEntryPointFinder.MatchesMainMethodName異常系 | E-12 (行14-15) | ○ |
| C-72 | CSharpEntryPointFinder.FindEntryPoints正常系 | E-12 (行17-25) | ○ |
| C-73 | CSharpEntryPointFinder.FindEntryPoints境界値 | E-12 (行17-25) | ○ |
| C-74 | CSharpProjectShim.constructor正常系 | E-13 (行48-73) | ○ |
| C-75 | CSharpProjectShim.Disconnect正常系 | E-13 (行75-80) | ○ |
| C-76 | CSharpProjectShim.TryCreateFileCodeModelThroughProjectSystem正常系 | E-13 (行97-108) | ○ |
| C-77 | CSharpProjectShim.TryCreateFileCodeModelThroughProjectSystem異常系 | E-13 (行104-107) | ○ |
| C-78 | MethodXmlBuilder.Generate正常系 | E-14 (行604-612) | ○ |
| C-79 | MethodXmlBuilder.GenerateBlock正常系 | E-14 (行22-35) | ○ |
| C-80 | MethodXmlBuilder.GenerateComments正常系 | E-14 (行37-57) | ○ |
| C-81 | MethodXmlBuilder.TryGenerateLocal正常系 | E-14 (行88-132) | ○ |
| C-82 | MethodXmlBuilder.TryGenerateLocal異常系 | E-14 (行111-114) | ○ |
| C-83 | MethodXmlBuilder.TryGenerateExpression正常系 | E-14 (行154-159) | ○ |
| C-84 | MethodXmlBuilder.TryGenerateLiteral正常系 | E-14 (行231-280) | ○ |
| C-85 | MethodXmlBuilder.TryGenerateCharLiteral正常系 | E-14 (行282-321) | ○ |
| C-86 | MethodXmlBuilder.TryGenerateCharLiteral（非英数字） | E-14 (行299-311) | ○ |
| C-87 | MethodXmlBuilder.TryGenerateBinaryOperation正常系 | E-14 (行331-354) | ○ |
| C-88 | MethodXmlBuilder.TryGenerateCast正常系 | E-14 (行373-387) | ○ |
| C-89 | MethodXmlBuilder.TryGenerateNewClass正常系 | E-14 (行389-410) | ○ |
| C-90 | MethodXmlBuilder.GenerateMethodCall正常系 | E-14 (行536-555) | ○ |
| C-91 | ExtensionMethodExtender.Create正常系 | E-15 (行17-21) | ○ |
| C-92 | ExtensionMethodExtender.IsExtension正常系 | E-15 (行26) | ○ |
| C-93 | AutoImplementedPropertyExtender.Create正常系 | E-16 (行17-21) | ○ |
| C-94 | AutoImplementedPropertyExtender.IsAutoImplemented正常系 | E-16 (行26) | ○ |
| C-95 | PartialMethodExtender.Create正常系 | E-17 (行17-21) | ○ |
| C-96 | PartialMethodExtender.IsPartial正常系 | E-17 (行32) | ○ |
| C-97 | PartialMethodExtender.HasOtherPart正常系 | E-17 (行36-38) | ○ |
| C-98 | SemanticSearchQueryExecutor.ExecuteAsync正常系 | E-18 (行104-202) | ○ |
| C-99 | SemanticSearchQueryExecutor.ExecuteAsync（プロジェクトなし） | E-18 (行108-121) | ○ |
| C-100 | SemanticSearchQueryExecutor.ExecuteAsync（キャンセル） | E-18 (行172-176) | △ |
| C-101 | ResultsObserver.OnDefinitionFoundAsync正常系 | E-18 (行38-39) | ○ |
| C-102 | ResultsObserver.OnDocumentUpdatedAsync正常系 | E-18 (行57-60) | ○ |
| C-103 | ResultsObserver.GetUpdatedSolutionAsync正常系 | E-18 (行66-92) | ○ |
| C-104 | ResultsObserver.GetUpdatedSolutionAsync（削除） | E-18 (行73-76) | △ |
| C-105 | ObjectBrowserLibraryManager.CreateDescriptionBuilder正常系 | E-19 (行21-27) | ○ |
| C-106 | ObjectBrowserLibraryManager.CreateListItemFactory正常系 | E-19 (行29-30) | ○ |
| C-107 | DescriptionBuilder.BuildNamespaceDeclaration正常系 | E-20 (行24-28) | ○ |
| C-108 | DescriptionBuilder.BuildDelegateDeclarationAsync正常系 | E-20 (行30-59) | ○ |
| C-109 | DescriptionBuilder.BuildTypeDeclarationAsync正常系 | E-20 (行61-125) | ○ |
| C-110 | DescriptionBuilder.BuildAccessibility正常系 | E-20 (行127-159) | ○ |
| C-111 | DescriptionBuilder.BuildMethodDeclarationAsync正常系 | E-20 (行185-234) | ○ |
| C-112 | DescriptionBuilder.BuildGenericConstraintsAsync正常系 | E-20 (行318-328, 330-402) | ○ |
| C-113 | ListItemFactory.GetMemberDisplayString正常系 | E-21 (行30-31) | ○ |
| C-114 | ListItemFactory.GetMemberAndTypeDisplayString正常系 | E-21 (行33-34) | ○ |
| C-115 | CSharpLanguageService.DebuggerLanguageId正常系 | E-22 (行29-35) | ○ |
| C-116 | CSharpLanguageService.ContentTypeName正常系 | E-22 (行37-43) | ○ |
| C-117 | CSharpLanguageService.CreateContext正常系 | E-22 (行69-83) | ○ |
| C-118 | CSharpEditorFactory.ContentTypeName正常系 | E-23 (行21) | ○ |
| C-119 | CSharpEditorFactory.GetProjectWithCorrectParseOptionsForProject正常系 | E-23 (行24-35) | ○ |
| C-120 | CSharpEditorFactory.GetProjectWithCorrectParseOptionsForProject境界値 | E-23 (行34) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-100：キャンセル時のメッセージ文言 `ServicesVSResources.Search_cancelled` の実際の内容を確認する必要がある
  - 候補：リソースファイル / ローカライズファイル / テスト実行による確認
- C-104：ドキュメント削除時の条件 `changes.IsEmpty` の詳細な動作仕様が不明確
  - 候補：設計書 / コード仕様書 / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出可能
- 1: 中リスク - キャンセル処理（C-100）は実行時テストで検証推奨
- 0: 低リスク - ドキュメント削除処理（C-104）は境界条件のため追加検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] テストID命名規則（UT-VSC-xxx）が一貫しているか確認
- [ ] 各テストケースの前提条件が現実的に設定可能か確認
- [ ] 期待結果が具体的かつ検証可能な形で記述されているか確認
- [ ] 高優先度のテストケースが実際にビジネスクリティカルな機能を網羅しているか確認
- [ ] 異常系テストケースが例外処理・エラーハンドリングを適切にカバーしているか確認
- [ ] 境界値テストケースが境界条件を正確に特定しているか確認
- [ ] C-100（キャンセル処理）のメッセージ内容を実際のリソースファイルで確認
- [ ] C-104（ドキュメント削除）の動作仕様を設計チームに確認
