---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 121
  claims_with_evidence: 121
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：VisualStudio-Core単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードに対応するクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なパブリックメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で主要なテストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：121 / 121、根拠なし：0
- 優先レビュー（高）
  1. **ChangeSignatureDialogViewModel**: 署名変更機能の中核クラス
  2. **AddParameterDialogViewModel**: パラメータ追加ダイアログの検証ロジック
  3. **SnippetExpansionClient**: スニペット展開処理の重要なハンドラ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialogViewModel.cs`
- E-02: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs`
- E-03: `src/VisualStudio/Core/Impl/Options/OptionStore.cs`
- E-04: `src/VisualStudio/Core/Impl/CodeModel/FileCodeModel.cs`
- E-05: `src/VisualStudio/Core/Impl/CodeModel/SyntaxNodeKey.cs`
- E-06: `src/VisualStudio/Core/Def/DocumentOutline/DocumentOutlineViewModel.cs`
- E-07: `src/VisualStudio/Core/Def/DocumentOutline/DocumentSymbolDataViewModelSorter.cs`
- E-08: `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialogViewModel.cs`
- E-09: `src/VisualStudio/Core/Def/PullMemberUp/SymbolDependentsBuilder.cs`
- E-10: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialogViewModel.cs`
- E-11: `src/VisualStudio/Core/Impl/CodeModel/CodeTypeRef.cs`
- E-12: `src/VisualStudio/Core/Impl/ProjectSystem/CPS/TempPECompiler.cs`
- E-13: `src/VisualStudio/Core/Def/Snippets/SnippetExpansionClient.cs`
- E-14: `src/VisualStudio/Core/Impl/CodeModel/GlobalNodeKey.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ChangeSignatureDialogViewModel (UT-VSC-001 〜 UT-VSC-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetStartingSelectionIndexメソッドの正常系テスト | E-01 L158-171 | ○ |
| C-02 | CanRemoveプロパティの正常系・異常系テスト | E-01 L175-186 | ○ |
| C-03 | CanRestoreプロパティのテスト | E-01 L188-199 | ○ |
| C-04 | Remove/Restoreメソッドの動作テスト | E-01 L225-250 | ○ |
| C-05 | AddParameterメソッドのテスト | E-01 L252-265 | ○ |
| C-06 | CanMoveUp/CanMoveDownプロパティのテスト | E-01 L405-443 | ○ |
| C-07 | MoveUp/MoveDownメソッドのテスト | E-01 L445-474 | ○ |
| C-08 | CanSubmit/TrySubmitメソッドのテスト | E-01 L476-502 | ○ |
| C-09 | GetParameterConfigurationメソッドのテスト | E-01 L278-286 | ○ |

### AddParameterDialogViewModel (UT-VSC-025 〜 UT-VSC-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | CanSubmitメソッドの入力検証テスト | E-02 L119-159 | ○ |
| C-11 | TrySubmitメソッドのテスト | E-02 L161-170 | ○ |
| C-12 | 型名検証ロジックのテスト | E-02 L177-232 | ○ |
| C-13 | パラメータ名検証ロジックのテスト | E-02 L263-267 | ○ |

### OptionStore (UT-VSC-035 〜 UT-VSC-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | GetOptionメソッドの値取得テスト | E-03 L68-83 | ○ |
| C-15 | SetOptionメソッドの値設定テスト | E-03 L97-105 | ○ |
| C-16 | Clearメソッドのテスト | E-03 L41-45 | ○ |
| C-17 | GetChangedOptionsメソッドのテスト | E-03 L47-48 | ○ |

### FileCodeModel (UT-VSC-043 〜 UT-VSC-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | GetDocumentIdメソッドのテスト | E-04 L181-194 | ○ |
| C-19 | OnRenameメソッドのテスト | E-04 L108-119 | ○ |
| C-20 | UpdateCodeElementNodeKeyメソッドのテスト | E-04 L196-220 | ○ |
| C-21 | OnCodeElementCreated/Deletedメソッドのテスト | E-04 L222-236 | ○ |
| C-22 | GetOrCreateCodeElementメソッドのテスト | E-04 L238-269 | ○ |
| C-23 | IsBatchOpenプロパティのテスト | E-04 L761-767 | ○ |
| C-24 | ParseStatusプロパティのテスト | E-04 L772-780 | ○ |

### SyntaxNodeKey (UT-VSC-058 〜 UT-VSC-062)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタの正常系・異常系テスト | E-05 L23-34 | ○ |
| C-26 | IsEmptyプロパティのテスト | E-05 L36-37 | ○ |

### DocumentOutlineViewModel (UT-VSC-063 〜 UT-VSC-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Disposeメソッドのテスト | E-06 L100-105 | ○ |
| C-28 | ExpandOrCollapseAllメソッドのテスト | E-06 L236-249 | ○ |

### DocumentSymbolDataViewModelSorter (UT-VSC-067 〜 UT-VSC-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | GetComparerメソッドのテスト | E-07 L33-40 | ○ |
| C-30 | Convertメソッドのテスト | E-07 L22-31 | ○ |
| C-31 | 各Comparerのテスト | E-07 L48-72 | ○ |

### MoveToNamespaceDialogViewModel (UT-VSC-075 〜 UT-VSC-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | OnNamespaceUpdatedメソッドのテスト | E-08 L49-73 | ○ |
| C-33 | IsValidNamespaceメソッドのテスト | E-08 L75-93 | ○ |

### SymbolDependentsBuilder (UT-VSC-081 〜 UT-VSC-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | FindMemberToDependentsMapメソッドのテスト | E-09 L20-32 | ○ |
| C-35 | SymbolWalkerクラスのテスト | E-09 L34-88 | ○ |

### PullMemberUpDialogViewModel (UT-VSC-086 〜 UT-VSC-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | EnableOrDisableOkButtonメソッドのテスト | E-10 L84-88 | ○ |
| C-37 | CreatePullMemberUpOptionsメソッドのテスト | E-10 L76-83 | ○ |

### CodeTypeRef (UT-VSC-089 〜 UT-VSC-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | LookupTypeSymbolメソッドのテスト | E-11 L49-57 | ○ |
| C-39 | CreateArrayTypeメソッドのテスト | E-11 L75-85 | ○ |
| C-40 | ElementTypeプロパティのテスト | E-11 L87-110 | ○ |
| C-41 | IsGenericプロパティのテスト | E-11 L112-119 | ○ |
| C-42 | Rankプロパティのテスト | E-11 L126-143 | ○ |

### TempPECompiler (UT-VSC-100 〜 UT-VSC-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | CompileAsyncメソッドの正常系テスト | E-12 L29-92 | ○ |
| C-44 | CompileAsyncメソッドの入力検証テスト | E-12 L31-39 | ○ |

### SnippetExpansionClient (UT-VSC-104 〜 UT-VSC-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | TryHandleTab/BackTab/Escapeメソッドのテスト | E-13 L399-446 | ○ |
| C-46 | TryHandleReturn/CommitSnippetメソッドのテスト | E-13 L448-479 | ○ |
| C-47 | GetExpansionFunctionメソッドのテスト | E-13 L132-155 | ○ |
| C-48 | EndExpansionメソッドのテスト | E-13 L949-961 | ○ |
| C-49 | TryGetSubjectBufferSpanメソッドのテスト | E-13 L1121-1135 | ○ |
| C-50 | PositionCaretForEditingInternalメソッドのテスト | E-13 L391-397 | ○ |

### GlobalNodeKey (UT-VSC-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | コンストラクタのテスト | E-14 L16-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対応するソースコードが確認できたため、根拠なしの項目はありません。
- 追加で検討すべき項目：
  - UIスレッド関連のテスト（多くのプロパティがThrowIfNotOnUIThreadを呼び出している）
  - 非同期処理のテスト（AsyncBatchingWorkQueueを使用するメソッド）
  - COM相互運用に関するテスト（IVsExpansionClient実装など）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なゲッター・セッター、単純な状態判定メソッド
- **1（中リスク）**: コレクション操作、状態遷移を伴うメソッド
- **2（高リスク）**: 入力検証、外部サービス連携、コンパイル処理

各テストケースのリスク評価：
- 高リスク（優先度：高）: UT-VSC-004〜008, UT-VSC-020〜023, UT-VSC-025〜034, UT-VSC-100〜103
- 中リスク（優先度：中）: UT-VSC-001〜003, UT-VSC-009〜019, UT-VSC-035〜042
- 低リスク（優先度：低）: UT-VSC-063〜066, UT-VSC-121

## 6) レビュアーチェックリスト（最小）
- [ ] ChangeSignatureDialogViewModelのパラメータ操作ロジックが正しくテストされているか
- [ ] AddParameterDialogViewModelの全ての入力検証パターンがカバーされているか
- [ ] OptionStoreのキャッシュ動作が正しくテストされているか
- [ ] FileCodeModelのリネーム処理とノードキー管理が適切にテストされているか
- [ ] SyntaxNodeKeyのコンストラクタ検証が網羅的か
- [ ] SnippetExpansionClientの各ハンドラメソッドが正しくテストされているか
- [ ] TempPECompilerの境界条件（null入力、空入力）がテストされているか
- [ ] 異常系テストケースで適切な例外がスローされることが確認されているか

---

## 補足：モジュール構成

VisualStudio-Coreモジュールは以下の主要なサブシステムで構成されています：

1. **ChangeSignature** - メソッド署名変更機能
2. **Options** - オプション設定管理
3. **CodeModel** - EnvDTE CodeModel実装
4. **DocumentOutline** - ドキュメントアウトライン表示
5. **MoveToNamespace** - 名前空間移動機能
6. **PullMemberUp** - メンバー引き上げリファクタリング
7. **Snippets** - コードスニペット機能
8. **ProjectSystem** - プロジェクトシステム連携（CPS）

これらのサブシステムの主要なクラスに対して、正常系・異常系・境界値のテストケースを網羅的に生成しました。
