---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 105
  claims_with_evidence: 98
  claims_without_evidence: 7
confidence_derived: 0.93
---

# 根拠レポート：Workspaces-CSharp 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：98 / 105、根拠なし：7
- 優先レビュー（高）
  1. **C-103〜C-105**: MEFエクスポート確認テスト - 実際のテスト実装方法要確認
  2. **C-028, C-029**: OrganizeImportsService - Rewriterの内部動作詳細要確認
  3. **C-054, C-055**: セマンティックモデル取得 - 投機的モデル生成の詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/CSharp/Portable/Classification/ClassificationHelpers.cs`
- E-02: `src/Workspaces/CSharp/Portable/Classification/Worker.cs`
- E-03: `src/Workspaces/CSharp/Portable/CodeCleanup/CSharpCodeCleanerService.cs`
- E-04: `src/Workspaces/CSharp/Portable/OrganizeImports/CSharpOrganizeImportsService.cs`
- E-05: `src/Workspaces/CSharp/Portable/Simplification/CSharpSimplificationService.cs`
- E-06: `src/Workspaces/CSharp/Portable/Rename/CSharpRenameRewriterLanguageService.cs`
- E-07: `src/Workspaces/CSharp/Portable/FindSymbols/CSharpDeclaredSymbolInfoFactoryService.cs`
- E-08: `src/Workspaces/CSharp/Portable/Recommendations/CSharpRecommendationService.cs`
- E-09: `src/Workspaces/CSharp/Portable/Recommendations/CSharpRecommendationServiceRunner.cs`
- E-10: `src/Workspaces/CSharp/Portable/Workspace/LanguageServices/CSharpSyntaxTreeFactoryService.cs`
- E-11: `src/Workspaces/CSharp/Portable/Workspace/LanguageServices/CSharpCompilationFactoryService.cs`
- E-12: `src/Workspaces/CSharp/Portable/Classification/SyntaxClassification/CSharpSyntaxClassificationService.cs`
- E-13: `src/Workspaces/CSharp/Portable/CaseCorrection/CSharpCaseCorrectionService.cs`
- E-14: `src/Workspaces/CSharp/Portable/Simplification/Simplifiers/NameSimplifier.cs`
- E-15: `docs/code-to-docs/単体テストケース一覧/plan.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetClassificationがキーワードを正しく分類 | E-01 L30-61 | ○ |
| C-02 | 制御キーワードの分類 | E-01 L63-97 | ○ |
| C-03 | 文字列リテラルの分類 | E-01 L140-157 | ○ |
| C-04 | verbatim文字列の分類 | E-01 L159-192 | ○ |
| C-05 | 数値リテラルの分類 | E-01 L55-58 | ○ |
| C-06 | 識別子トークンの分類 | E-01 L45-48 | ○ |
| C-07 | null parent処理 | E-01 L63-66 | ○ |
| C-08 | AwaitKeyword判定 | E-01 L72 | ○ |
| C-09 | 非制御キーワード判定 | E-01 L68-97 | ○ |
| C-10 | IfStatement判定 | E-01 L99-138 | ○ |
| C-11 | クラス宣言識別子分類 | E-01 L196-198 | ○ |
| C-12 | メソッド宣言識別子分類 | E-01 L208-217 | ○ |
| C-13 | 拡張メソッド分類 | E-01 L210-214 | ○ |
| C-14 | プロパティ宣言分類 | E-01 L230-232 | ○ |
| C-15 | const フィールド分類 | E-01 L242-251 | ○ |
| C-16 | static修飾子判定 | E-01 L312-337 | ○ |
| C-17 | インスタンスメンバー判定 | E-01 L312-337 | ○ |
| C-18 | AddLexicalClassifications | E-01 L503-508 | ○ |
| C-19 | AdjustStaleClassification | E-01 L511-566 | ○ |
| C-20 | IsCodeBlockWithCSharpLang | E-01 L571-586 | ○ |
| C-21 | CollectClassifiedSpans(tokens) | E-02 L37-43 | ○ |
| C-22 | CollectClassifiedSpans(node) | E-02 L45-50 | ○ |
| C-23 | UTF8文字列特殊処理 | E-02 L127-135 | ○ |
| C-24 | コメントトリビア分類 | E-02 L207-211 | ○ |
| C-25 | プリプロセッサ分類 | E-02 L234-254 | ○ |
| C-26 | GetDefaultProviders | E-03 L14-17 | ○ |
| C-27 | GetSpansToAvoid | E-03 L19-20 | ○ |
| C-28 | OrganizeImportsAsync | E-04 L20-29 | ○ |
| C-29 | OrganizeImportsAsync null処理 | E-04 L26 | △ |
| C-30 | SortImportsDisplayStringWithAccelerator | E-04 L31-32 | ○ |
| C-31 | DefaultOptions | E-05 L46-47 | ○ |
| C-32 | GetSimplifierOptions | E-05 L49-50 | ○ |
| C-33 | Expand(node)基本機能 | E-05 L52-75 | ○ |
| C-34 | Expand(node)例外 | E-05 L72 | ○ |
| C-35 | Expand(token) | E-05 L77-92 | ○ |
| C-36 | TryEscapeIdentifierToken エスケープ | E-05 L95-135 | ○ |
| C-37 | TryEscapeIdentifierToken 既存エスケープ | E-05 L98-101 | ○ |
| C-38 | TryEscapeIdentifierToken 通常識別子 | E-05 L103-106 | ○ |
| C-39 | AppendElasticTriviaIfNecessary | E-05 L137-147 | ○ |
| C-40 | GetUnusedNamespaceImports | E-05 L185-200 | ○ |
| C-41 | AnnotateAndRename | E-06 L40-44 | ○ |
| C-42 | LocalVariableConflict 検出 | E-06 L740-778 | ○ |
| C-43 | LocalVariableConflict 競合なし | E-06 L740-778 | ○ |
| C-44 | ComputeDeclarationConflictsAsync | E-06 L780-925 | ○ |
| C-45 | ラベル競合検出 | E-06 L831-839 | ○ |
| C-46 | ComputeImplicitReferenceConflictsAsync | E-06 L947-990 | ○ |
| C-47 | ComputePossibleImplicitUsageConflicts | E-06 L992-1057 | ○ |
| C-48 | TryAddPossibleNameConflicts Attribute | E-06 L1061-1070 | ○ |
| C-49 | TryAddPossibleNameConflicts プロパティ | E-06 L1072-1081 | ○ |
| C-50 | IsIdentifierValid 有効 | E-06 L1156-1179 | ○ |
| C-51 | IsIdentifierValid var拒否 | E-06 L1159-1166 | ○ |
| C-52 | IsIdentifierValid dynamic拒否 | E-06 L1162 | ○ |
| C-53 | GetExpansionTargetForLocation | E-06 L1112-1113 | ○ |
| C-54 | GetSemanticModelForNode 元モデル | E-06 L1188-1224 | ○ |
| C-55 | GetSemanticModelForNode 投機的モデル | E-06 L1196-1223 | △ |
| C-56 | GetTypeDeclarationInfo | E-07 L199-237 | ○ |
| C-57 | GetTypeDeclarationInfo 部分型除外 | E-07 L210-215 | ○ |
| C-58 | GetEnumDeclarationInfo | E-07 L239-258 | ○ |
| C-59 | AddMemberDeclarationInfos コンストラクタ | E-07 L271-286 | ○ |
| C-60 | AddMemberDeclarationInfos メソッド | E-07 L344-360 | ○ |
| C-61 | 拡張メソッド検出 | E-07 L346, L610-611 | ○ |
| C-62 | インデクサ情報 | E-07 L330-343 | ○ |
| C-63 | AddLocalFunctionInfos | E-07 L157-197 | ○ |
| C-64 | AddSynthesizedDeclaredSymbolInfos | E-07 L403-450 | ○ |
| C-65 | GetExtensionReceiverTypeName | E-07 L634-651 | ○ |
| C-66 | CreateRunner | E-08 L20-21 | ○ |
| C-67 | GetRecommendedSymbols 式コンテキスト | E-09 L40-49 | ○ |
| C-68 | GetRecommendedSymbols 型コンテキスト | E-09 L88-91 | ○ |
| C-69 | GetRecommendedSymbols 非ユーザーコード | E-09 L42-43 | ○ |
| C-70 | GetLambdaParameterCount | E-09 L31-38 | ○ |
| C-71 | GetLambdaParameterCount SimpleLambda | E-09 L36 | ○ |
| C-72 | TryGetExplicitTypeOfLambdaParameter 取得 | E-09 L51-70 | ○ |
| C-73 | TryGetExplicitTypeOfLambdaParameter 暗黙 | E-09 L67-69 | ○ |
| C-74 | GetDefaultParseOptions | E-10 L29-30 | ○ |
| C-75 | GetDefaultParseOptionsWithLatestLanguageVersion | E-10 L32-33 | ○ |
| C-76 | TryParsePdbParseOptions | E-10 L35-46 | ○ |
| C-77 | TryParsePdbParseOptions 無効バージョン | E-10 L37-41 | ○ |
| C-78 | OptionsDifferOnlyByPreprocessorDirectives 検出 | E-10 L48-56 | ○ |
| C-79 | OptionsDifferOnlyByPreprocessorDirectives 複数差異 | E-10 L48-56 | ○ |
| C-80 | CreateSyntaxTree | E-10 L58-62 | ○ |
| C-81 | CreateSyntaxTree nullオプション | E-10 L60 | ○ |
| C-82 | ParseSyntaxTree | E-10 L64-68 | ○ |
| C-83 | CreateCompilation | E-11 L26-31 | ○ |
| C-84 | CreateCompilation nullオプション | E-11 L30 | ○ |
| C-85 | CreateSubmissionCompilation | E-11 L33-40 | ○ |
| C-86 | GetDefaultCompilationOptions | E-11 L42-43 | ○ |
| C-87 | TryParsePdbCompilationOptions | E-11 L45-54 | ○ |
| C-88 | TryParsePdbCompilationOptions 無効 | E-11 L47-51 | ○ |
| C-89 | CreateGeneratorDriver | E-11 L56-57 | ○ |
| C-90 | GetDefaultSyntaxClassifiers | E-12 L41-42 | ○ |
| C-91 | AddLexicalClassifications | E-12 L44-45 | ○ |
| C-92 | AddSyntacticClassifications | E-12 L47-53 | ○ |
| C-93 | FixClassification | E-12 L55-56 | ○ |
| C-94 | GetSyntacticClassificationForIdentifier | E-12 L58-59 | ○ |
| C-95 | AddReplacements C#無効 | E-13 L26-35 | ○ |
| C-96 | TrySimplify 名前簡略化 | E-14 L33-367 | ○ |
| C-97 | TrySimplify エイリアス | E-14 L116-202 | ○ |
| C-98 | TrySimplify Nullable | E-14 L272-305 | ○ |
| C-99 | TrySimplify 名前空間除外 | E-14 L50-53 | ○ |
| C-100 | TrySimplify var除外 | E-14 L44-47 | ○ |
| C-101 | CanReplaceWithReducedNameInContext using制限 | E-14 L578-596 | ○ |
| C-102 | CanReplaceWithReducedNameInContext ローカル競合 | E-14 L587 | ○ |
| C-103 | CSharpDiagnosticPropertiesService MEF | **根拠なし** | △ |
| C-104 | CSharpFormattingService MEF | **根拠なし** | △ |
| C-105 | CSharpSyntaxGenerator MEF | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-103〜C-105 (MEFエクスポート確認)**: 対象ファイルの詳細な内容を確認していないため、テストケースの妥当性を完全に検証できていません
  - 候補：`src/Workspaces/CSharp/Portable/Diagnostics/CSharpDiagnosticPropertiesService.cs` / `src/Workspaces/CSharp/Portable/Formatting/CSharpFormattingService.cs` / `src/Workspaces/CSharp/Portable/CodeGeneration/CSharpSyntaxGenerator.cs`
- **C-029 (OrganizeImportsAsync null処理)**: Contract.ThrowIfNullの具体的な動作確認が必要
  - 候補：既存のテストコード / Contractクラスのドキュメント
- **C-055 (投機的モデル生成)**: SpeculationAnalyzerの詳細な動作確認が必要
  - 候補：`src/Workspaces/CSharp/Portable/Utilities/SpeculationAnalyzer.cs` / 既存のテストコード

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Classification系テストケース (C-01〜C-25) - ソースコードとの対応が明確
- **0 (低リスク)**: Factory系サービステスト (C-74〜C-89) - シンプルなファクトリパターン
- **1 (中リスク)**: Rename系テストケース (C-41〜C-55) - 複雑なロジックを含むため、エッジケースの網羅性要確認
- **1 (中リスク)**: Simplification系テストケース (C-96〜C-102) - 多様なコンテキストでの動作確認が必要
- **2 (高リスク)**: MEFエクスポートテスト (C-103〜C-105) - 根拠となるソースコードを直接確認していない

## 6) レビュアーチェックリスト（最小）
- [ ] Classification系テストケース(C-01〜C-25)のテスト観点が網羅的であることを確認
- [ ] Rename系テストケース(C-41〜C-55)のエッジケースが十分にカバーされていることを確認
- [ ] 各サービスのMEFエクスポート属性が正しく設定されていることを確認
- [ ] 境界値テストケースの入力値と期待結果が適切であることを確認
- [ ] 異常系テストケースで想定される例外の種類が正確であることを確認
- [ ] テストIDの命名規則(UT-WCS-XXX)が一貫していることを確認
- [ ] 優先度の設定基準が要件と整合していることを確認
