---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：Workspaces-Core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-WKC-094 CodeCleaner.CleanupAsync**：具体的なメソッドシグネチャの確認が必要
  2. **UT-WKC-095 Classifier.GetClassifiedSpansAsync**：具体的な戻り値型の確認が必要
  3. **UT-WKC-099/100 SerializerService**：内部実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/Core/Portable/Workspace/Solution/Solution.cs` - Solutionクラスの定義
- E-02: `src/Workspaces/Core/Portable/Workspace/Solution/Document.cs` - Documentクラスの定義（622行）
- E-03: `src/Workspaces/Core/Portable/Workspace/Solution/Project.cs` - Projectクラスの定義（842行）
- E-04: `src/Workspaces/Core/Portable/CodeActions/CodeAction.cs` - CodeActionクラスの定義（761行）
- E-05: `src/Workspaces/Core/Portable/FindSymbols/SymbolFinder.cs` - SymbolFinderクラスの定義（246行）
- E-06: `src/Workspaces/Core/Portable/Rename/Renamer.cs` - Renamerクラスの定義（205行）
- E-07: `src/Workspaces/Core/Portable/Editing/SyntaxGenerator.cs` - SyntaxGeneratorクラスの定義
- E-08: `src/Workspaces/Core/Portable/Formatting/Formatter.cs` - Formatterクラスの定義
- E-09: `src/Workspaces/Core/Portable/Simplification/Simplifier.cs` - Simplifierクラスの定義
- E-10: `src/Workspaces/Core/Portable/Differencing/Match.cs` - Match<TNode>クラスの定義（387行）
- E-11: `src/Workspaces/Core/Portable/PatternMatching/PatternMatcher.cs` - PatternMatcherクラスの定義（615行）
- E-12: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト構成情報

## 3) Claims と根拠の対応（レビューの主戦場）

### Solution関連テストケース (UT-WKC-001 - UT-WKC-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Solution.GetProjectは有効なProjectIdでプロジェクトを取得できる | E-01 | ○ |
| C-02 | Solution.GetProjectは存在しないIDでnullを返す | E-01 | ○ |
| C-03 | Solution.GetDocumentは有効なDocumentIdでドキュメントを取得できる | E-01 | ○ |
| C-04 | Solution.GetDocumentは存在しないIDでnullを返す | E-01 | ○ |
| C-05 | Solution.AddProjectで新しいプロジェクトを追加できる | E-01 | ○ |
| C-06 | Solution.AddProjectはnullで例外をスローする | E-01 | ○ |
| C-07 | Solution.AddDocumentで新しいドキュメントを追加できる | E-01 | ○ |
| C-08 | Solution.RemoveProjectでプロジェクトを削除できる | E-01 | ○ |
| C-09 | Solution.RemoveDocumentでドキュメントを削除できる | E-01 | ○ |
| C-10 | Solution.WithDocumentTextでテキストを更新できる | E-01 | ○ |

### Document関連テストケース (UT-WKC-011 - UT-WKC-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Document.GetSyntaxTreeAsyncは構文木を非同期で取得できる | E-02 (行168-195) | ○ |
| C-12 | Document.GetSyntaxTreeAsyncはSupportsSyntaxTree=falseでnullを返す | E-02 (行171-174) | ○ |
| C-13 | Document.GetSemanticModelAsyncはセマンティックモデルを取得できる | E-02 (行313-316) | ○ |
| C-14 | Document.GetSemanticModelAsyncはSupportsSemanticModel=falseでnullを返す | E-02 (行328-329) | ○ |
| C-15 | Document.TryGetSyntaxTreeはキャッシュされた構文木を取得できる | E-02 (行78-100) | ○ |
| C-16 | Document.TryGetSyntaxTreeはキャッシュなしでfalseを返す | E-02 (行87-90) | ○ |
| C-17 | Document.GetSyntaxRootAsyncはルートノードを取得できる | E-02 (行226-235) | ○ |
| C-18 | Document.WithTextは新しいテキストでドキュメントを更新できる | E-02 (行390-401) | ○ |
| C-19 | Document.WithSyntaxRootは新しい構文木で更新できる | E-02 (行406-417) | ○ |
| C-20 | Document.GetTextChangesAsyncは差分を取得できる | E-02 (行441-514) | ○ |
| C-21 | Document.GetTextChangesAsyncは同一ドキュメントで空を返す | E-02 (行466-467) | ○ |
| C-22 | Document.GetTextChangesAsyncは異なるIDで例外をスローする | E-02 (行469-471) | ○ |
| C-23 | Document.GetLinkedDocumentIdsはリンクドキュメントIDを取得できる | E-02 (行522-526) | ○ |

### Project関連テストケース (UT-WKC-024 - UT-WKC-038)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Project.GetDocumentは有効なIDでドキュメントを取得できる | E-03 (行243-244) | ○ |
| C-25 | Project.GetDocumentは存在しないIDでnullを返す | E-03 (行258-271) | ○ |
| C-26 | Project.GetCompilationAsyncはコンパイレーションを取得できる | E-03 (行524-525) | ○ |
| C-27 | Project.GetCompilationAsyncはSupportsCompilation=falseでnullを返す | E-03 (行97, 519-522) | ○ |
| C-28 | Project.TryGetCompilationはキャッシュされたコンパイレーションを取得できる | E-03 (行513-514) | ○ |
| C-29 | Project.AddDocumentで新しいドキュメントを追加できる | E-03 (行702-727) | ○ |
| C-30 | Project.RemoveDocumentでドキュメントを削除できる | E-03 (行759-764) | ○ |
| C-31 | Project.ContainsDocumentはドキュメントの存在を確認できる | E-03 (行213-214) | ○ |
| C-32 | Project.ContainsDocumentは存在しないIDでfalseを返す | E-03 (行213-214) | ○ |
| C-33 | Project.WithCompilationOptionsでオプションを更新できる | E-03 (行602-603) | ○ |
| C-34 | Project.WithParseOptionsでパースオプションを更新できる | E-03 (行608-609) | ○ |
| C-35 | Project.AddProjectReferenceでプロジェクト参照を追加できる | E-03 (行615-616) | ○ |
| C-36 | Project.GetChangesは差分を取得できる | E-03 (行537-545) | ○ |
| C-37 | Project.GetChangesはnullで例外をスローする | E-03 (行539-542) | ○ |
| C-38 | Project.GetSourceGeneratedDocumentsAsyncはソース生成ドキュメントを取得できる | E-03 (行316-323) | ○ |

### CodeAction関連テストケース (UT-WKC-039 - UT-WKC-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | CodeAction.GetOperationsAsyncは操作を取得できる | E-04 (行232-242) | ○ |
| C-40 | CodeAction.Create(Document)はDocumentChangeActionを作成できる | E-04 (行496-510) | ○ |
| C-41 | CodeAction.Create(Document)はnullのtitleで例外をスローする | E-04 (行503-504) | ○ |
| C-42 | CodeAction.Create(Document)はnullのcreateChangedDocumentで例外をスローする | E-04 (行506-507) | ○ |
| C-43 | CodeAction.Create(Solution)はSolutionChangeActionを作成できる | E-04 (行536-549) | ○ |
| C-44 | CodeAction.Create(NestedActions)はCodeActionWithNestedActionsを作成できる | E-04 (行559-574) | ○ |
| C-45 | CodeAction.Priorityは適切な範囲に収まる | E-04 (行91-107) | ○ |
| C-46 | CodeAction.PostProcessChangesAsyncは後処理を適用する | E-04 (行453-455) | ○ |

### SymbolFinder関連テストケース (UT-WKC-047 - UT-WKC-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | SymbolFinder.FindSymbolAtPositionAsyncは指定位置のシンボルを見つける | E-05 (行123-133) | ○ |
| C-48 | SymbolFinder.FindSymbolAtPositionAsyncはnullのdocumentで例外をスローする | E-05 (行128-129) | ○ |
| C-49 | SymbolFinder.FindSymbolAtPositionAsyncはシンボルがない位置でnullを返す | E-05 (行101-107) | ○ |
| C-50 | SymbolFinder.FindSourceDefinitionAsyncはソース定義を見つける | E-05 (行139-140) | ○ |
| C-51 | SymbolFinder.FindSimilarSymbolsは類似シンボルを見つける | E-05 (行154-174) | ○ |
| C-52 | SymbolFinder.FindSimilarSymbolsはnullのsymbolで例外をスローする | E-05 (行157-158) | ○ |
| C-53 | SymbolFinder.FindSimilarSymbolsはnullのcompilationで例外をスローする | E-05 (行160-161) | ○ |

### Renamer関連テストケース (UT-WKC-054 - UT-WKC-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Renamer.RenameSymbolAsyncはシンボルをリネームできる | E-06 (行41-65) | ○ |
| C-55 | Renamer.RenameSymbolAsyncはnullのsolutionで例外をスローする | E-06 (行44-45) | ○ |
| C-56 | Renamer.RenameSymbolAsyncはnullのsymbolで例外をスローする | E-06 (行47-48) | ○ |
| C-57 | Renamer.RenameSymbolAsyncは空のnewNameで例外をスローする | E-06 (行50-51) | ○ |
| C-58 | Renamer.RenameSymbolAsyncはnullのnewNameで例外をスローする | E-06 (行50-51) | ○ |
| C-59 | Renamer.RenameDocumentAsyncはドキュメントをリネームできる | E-06 (行97-136) | ○ |
| C-60 | Renamer.RenameDocumentAsyncはnullのdocumentで例外をスローする | E-06 (行104-105) | ○ |

### SyntaxGenerator関連テストケース (UT-WKC-061 - UT-WKC-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | SyntaxGenerator.GetGenerator(Workspace)はSyntaxGeneratorを取得できる | E-07 (行60-61) | ○ |
| C-62 | SyntaxGenerator.GetGenerator(Document)はSyntaxGeneratorを取得できる | E-07 (行72-73) | ○ |
| C-63 | SyntaxGenerator.FieldDeclarationはフィールド宣言を生成できる | E-07 (行122-127) | ○ |
| C-64 | SyntaxGenerator.MethodDeclarationはメソッド宣言を生成できる | E-07 (行161-173) | ○ |
| C-65 | SyntaxGenerator.GetDeclarationはノードから宣言を取得できる | E-07 (行86-99) | ○ |
| C-66 | SyntaxGenerator.GetDeclarationは宣言がない場合nullを返す | E-07 (行88-98) | ○ |

### Formatter関連テストケース (UT-WKC-067 - UT-WKC-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Formatter.FormatAsync(Document)はドキュメントをフォーマットできる | E-08 (行47-50) | ○ |
| C-68 | Formatter.FormatAsync(Document,TextSpan)は指定範囲をフォーマットできる | E-08 (行63-66) | ○ |
| C-69 | Formatter.Format(SyntaxNode)は構文ノードをフォーマットできる | E-08 (行190-191) | ○ |
| C-70 | Formatter.Format(SyntaxNode)はnullのworkspaceで例外をスローする | E-08 (行162-164) | ○ |
| C-71 | Formatter.Format(SyntaxNode)はnullのnodeで例外をスローする | E-08 (行166-168) | ○ |

### Simplifier関連テストケース (UT-WKC-072 - UT-WKC-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Simplifier.ExpandAsyncはノードを展開できる | E-09 (行62-76) | ○ |
| C-73 | Simplifier.ExpandAsyncはnullのnodeで例外をスローする | E-09 (行64-67) | ○ |
| C-74 | Simplifier.ExpandAsyncはnullのdocumentで例外をスローする | E-09 (行69-72) | ○ |
| C-75 | Simplifier.ReduceAsyncはドキュメントを簡略化できる | E-09 (行152-163) | ○ |
| C-76 | Simplifier.ReduceAsyncはnullのdocumentで例外をスローする | E-09 (行154-157) | ○ |
| C-77 | Simplifier.ReduceAsync(annotation)は指定範囲を簡略化できる | E-09 (行175-191) | ○ |
| C-78 | Simplifier.ReduceAsync(annotation)はnullのannotationで例外をスローする | E-09 (行182-185) | ○ |

### Match関連テストケース (UT-WKC-079 - UT-WKC-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Match<TNode>.TryAddはノードマッピングを追加できる | E-10 (行280-293) | ○ |
| C-80 | Match<TNode>.TryAddは既存マッピングでfalseを返す | E-10 (行285-288) | ○ |
| C-81 | Match<TNode>.TryGetNewNodeは古いノードから新しいノードを取得できる | E-10 (行351-352) | ○ |
| C-82 | Match<TNode>.TryGetNewNodeはマッピングなしでfalseを返す | E-10 (行351-352) | ○ |
| C-83 | Match<TNode>.TryGetOldNodeは新しいノードから古いノードを取得できる | E-10 (行354-355) | ○ |
| C-84 | Match<TNode>.GetTreeEditsはツリー編集スクリプトを取得できる | E-10 (行361-362) | ○ |
| C-85 | Match<TNode>.GetSequenceEditsはシーケンス編集を取得できる | E-10 (行369-384) | ○ |
| C-86 | Match<TNode>.GetSequenceEditsはnullのoldNodesで例外をスローする | E-10 (行371-374) | ○ |
| C-87 | Match<TNode>.GetSequenceEditsはnullのnewNodesで例外をスローする | E-10 (行376-379) | ○ |

### PatternMatcher関連テストケース (UT-WKC-088 - UT-WKC-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | PatternMatcher.CreatePatternMatcherはPatternMatcherを作成できる | E-11 (行67-74) | ○ |
| C-89 | PatternMatcher.CreateContainerPatternMatcherはコンテナマッチャーを作成できる | E-11 (行76-85) | ○ |
| C-90 | PatternMatcher.AddMatchesはマッチを追加できる | E-11 (行107) | ○ |
| C-91 | PatternMatcher.AddMatchesはnull/空の候補でfalseを返す | E-11 (行109-110) | ○ |
| C-92 | PatternMatcher.AddMatchesは空白のみの候補でfalseを返す | E-11 (行109-110) | ○ |
| C-93 | PatternMatcher.Disposeはリソースを解放する | E-11 (行63-65) | ○ |

### その他のテストケース (UT-WKC-094 - UT-WKC-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | CodeCleaner.CleanupAsyncはドキュメントをクリーンアップできる | **根拠不足** | △ |
| C-95 | Classifier.GetClassifiedSpansAsyncは分類済みスパンを取得できる | **根拠不足** | △ |
| C-96 | OptionSet.GetOptionはオプション値を取得できる | **根拠不足** | △ |
| C-97 | OptionSet.WithChangedOptionはオプション値を変更できる | **根拠不足** | △ |
| C-98 | ApplyChangesOperation.ApplyAsyncは変更を適用できる | E-04関連 | ○ |
| C-99 | SerializerService.Serializeはオブジェクトをシリアライズできる | **根拠不足** | △ |
| C-100 | SerializerService.Deserializeはオブジェクトをデシリアライズできる | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **CodeCleaner/Classifier/OptionSet/SerializerService関連ファイル**：これらのクラスの具体的なメソッドシグネチャは直接確認していない
  - 候補：`src/Workspaces/Core/Portable/CodeCleanup/CodeCleaner.cs` / `src/Workspaces/Core/Portable/Classification/Classifier.cs` / `src/Workspaces/Core/Portable/Options/OptionSet.cs` / `src/Workspaces/Core/Portable/Serialization/SerializerService.cs`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: Solution/Document/Project関連テストケース - 主要なパブリックAPIで十分な根拠あり
- **0（低リスク）**: CodeAction/SymbolFinder/Renamer関連テストケース - メソッドシグネチャと例外処理が確認済み
- **0（低リスク）**: SyntaxGenerator/Formatter/Simplifier関連テストケース - 根拠が明確
- **0（低リスク）**: Match/PatternMatcher関連テストケース - 詳細なソースコード確認済み
- **1（中リスク）**: CodeCleaner/Classifier/OptionSet/SerializerService関連テストケース - 直接的な根拠確認が不足

## 6) レビュアーチェックリスト（最小）
- [ ] Solution/Document/Projectの基本操作テストケースが網羅されているか確認
- [ ] 各publicメソッドに対して正常系・異常系・境界値のテストケースが存在するか確認
- [ ] 例外処理のテストケースが適切なArgumentNullException/ArgumentExceptionを期待しているか確認
- [ ] 非同期メソッド（*Async）に対するCancellationToken対応のテストケースを追加検討
- [ ] CodeCleaner/Classifier/OptionSet/SerializerServiceの具体的なメソッドシグネチャを確認し、テストケースを調整
- [ ] 実際の既存テストコード（`src/Workspaces/CoreTest/`等）との整合性を確認
