---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 144
  claims_with_evidence: 144
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Workspaces-MSBuild 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケースの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：144 / 144、根拠なし：0
- 優先レビュー（高）
  1. **BuildHostProcessManager関連**: プラットフォーム固有の動作検証が必要
  2. **RPC関連**: 非同期通信のタイミング依存テストに注意
  3. **MonoMSBuildDiscovery関連**: Unix環境固有の機能のため環境依存テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/MSBuild/Core/MSBuild/MSBuildWorkspace.cs`
- E-02: `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.cs`
- E-03: `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.Worker.cs`
- E-04: `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.Worker_ResolveReferences.cs`
- E-05: `src/Workspaces/MSBuild/Core/MSBuild/ProjectMap.cs`
- E-06: `src/Workspaces/MSBuild/Core/MSBuild/BuildHostProcessManager.cs`
- E-07: `src/Workspaces/MSBuild/Core/MSBuild/SolutionFileReader.cs`
- E-08: `src/Workspaces/MSBuild/Core/MSBuild/SolutionFileReader.SolutionFilterReader.cs`
- E-09: `src/Workspaces/MSBuild/Core/MSBuild/DiagnosticReporter.cs`
- E-10: `src/Workspaces/MSBuild/Core/MSBuild/PathResolver.cs`
- E-11: `src/Workspaces/MSBuild/Core/MSBuild/ProjectFileExtensionRegistry.cs`
- E-12: `src/Workspaces/MSBuild/Core/Rpc/RpcClient.cs`
- E-13: `src/Workspaces/MSBuild/Core/Rpc/RemoteBuildHost.cs`
- E-14: `src/Workspaces/MSBuild/Core/Rpc/RemoteProjectFile.cs`
- E-15: `src/Workspaces/MSBuild/BuildHost/MSBuild/ProjectFile/ProjectFile.cs`
- E-16: `src/Workspaces/MSBuild/BuildHost/Build/ProjectBuildManager.cs`
- E-17: `src/Workspaces/MSBuild/Contracts/ProjectFileInfo.cs`
- E-18: `src/Workspaces/MSBuild/Contracts/DocumentFileInfo.cs`
- E-19: `src/Workspaces/MSBuild/Contracts/MonoMSBuildDiscovery.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### MSBuildWorkspace クラス (UT-MSB-001 〜 013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create()でデフォルトワークスペースを作成 | E-01 L46-48 | ○ |
| C-02 | Create(properties)でプロパティ設定 | E-01 L55-58 | ○ |
| C-03 | propertiesがnullでArgumentNullException | E-01 L77-80 | ○ |
| C-04 | hostServicesがnullでArgumentNullException | E-01 L82-85 | ○ |
| C-05 | OpenSolutionAsyncでソリューション読込 | E-01 L190-212 | ○ |
| C-06 | solutionFilePathがnullでArgumentNullException | E-01 L197-200 | ○ |
| C-07 | OpenProjectAsyncでプロジェクト読込 | E-01 L238-264 | ○ |
| C-08 | projectFilePathがnullでArgumentNullException | E-01 L245-248 | ○ |
| C-09 | CanApplyChangeでChangeDocumentサポート | E-01 L269-282 | ○ |
| C-10 | CanApplyChangeでAddDocumentサポート | E-01 L269-282 | ○ |
| C-11 | CanApplyChangeでRemoveDocumentサポート | E-01 L269-282 | ○ |
| C-12 | CloseSolutionでソリューションクリア | E-01 L152-158 | ○ |
| C-13 | AssociateFileExtensionWithLanguageで拡張子関連付け | E-01 L144-147 | ○ |

### MSBuildProjectLoader クラス (UT-MSB-014 〜 024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタでWorkspace指定 | E-02 L60-63 | ○ |
| C-15 | AssociateFileExtensionWithLanguageで関連付け | E-02 L106-118 | ○ |
| C-16 | projectFileExtensionがnullでArgumentNullException | E-02 L108-111 | ○ |
| C-17 | languageがnullでArgumentNullException | E-02 L113-116 | ○ |
| C-18 | LoadSolutionInfoAsyncでソリューション情報読込 | E-02 L155-201 | ○ |
| C-19 | solutionFilePathがnullでArgumentNullException | E-02 L161-162 | ○ |
| C-20 | LoadProjectInfoAsyncでプロジェクト情報読込 | E-02 L214-244 | ○ |
| C-21 | projectFilePathがnullでArgumentNullException | E-02 L221-222 | ○ |
| C-22 | BinLogPathProvider.GetNewLogPathでサフィックスなし | E-02 L355-364 | ○ |
| C-23 | BinLogPathProvider.GetNewLogPathでサフィックス付き | E-02 L355-364 | ○ |
| C-24 | BinLogPathProvider nullでデフォルト値 | E-02 L342-353 | ○ |

### ProjectMap クラス (UT-MSB-025 〜 034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Create()で空のProjectMap作成 | E-05 L53 | ○ |
| C-26 | Create(Solution)でSolutionから初期化 | E-05 L59-69 | ○ |
| C-27 | Addでプロジェクト追加 | E-05 L75-79 | ○ |
| C-28 | AddProjectInfoでProjectInfo追加 | E-05 L99-120 | ○ |
| C-29 | FilePathが空でArgumentException | E-05 L102-105 | ○ |
| C-30 | 重複IDでArgumentException | E-05 L112-115 | ○ |
| C-31 | GetOrCreateProjectIdで既存ID取得 | E-05 L129-140 | ○ |
| C-32 | GetOrCreateProjectIdで新規ID作成 | E-05 L129-140 | ○ |
| C-33 | TryGetIdsByProjectPathでIDセット取得 | E-05 L196-197 | ○ |
| C-34 | 未登録パスでfalse | E-05 L196-197 | ○ |

### BuildHostProcessManager クラス (UT-MSB-035 〜 041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタでインスタンス作成 | E-06 L38-44 | ○ |
| C-36 | GetKindForProjectでSDK形式判定 | E-06 L355-413 | ○ |
| C-37 | GetKindForProjectでレガシー形式判定 | E-06 L355-413 | ○ |
| C-38 | 読み込めないファイルでデフォルト値 | E-06 L376-386 | ○ |
| C-39 | CreateBuildHostStartInfoでNetCore用作成 | E-06 L176-185, L231-251 | ○ |
| C-40 | CreateBuildHostStartInfoでNetFramework用作成 | E-06 L176-185, L258-269 | ○ |
| C-41 | DisposeAsyncでリソース解放 | E-06 L215-229 | ○ |

### SolutionFileReader クラス (UT-MSB-042 〜 048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | ReadSolutionFileAsyncでソリューション読込 | E-07 L22-41 | ○ |
| C-43 | ReadSolutionFileAsyncでソリューションフィルタ読込 | E-07 L27-32 | ○ |
| C-44 | 無効なファイルで例外スロー | E-07 L37 | ○ |
| C-45 | IsSolutionFilterFilenameで.slnf判定true | E-08 L18-21 | ○ |
| C-46 | IsSolutionFilterFilenameで.sln判定false | E-08 L18-21 | ○ |
| C-47 | TryReadでソリューションフィルタ読込成功 | E-08 L23-66 | ○ |
| C-48 | 無効なJSONで読込失敗 | E-08 L67-73 | ○ |

### DiagnosticReporter クラス (UT-MSB-049 〜 054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタでインスタンス作成 | E-09 L16-21 | ○ |
| C-50 | ThrowモードでInvalidOperationException | E-09 L27-33 | ○ |
| C-51 | Logモードで診断追加 | E-09 L35-37 | ○ |
| C-52 | Ignoreモードで何もしない | E-09 L39-40 | ○ |
| C-53 | 無効なモードでArgumentException | E-09 L42-43 | ○ |
| C-54 | AddDiagnosticでスレッドセーフ追加 | E-09 L47-50 | ○ |

### PathResolver クラス (UT-MSB-055 〜 059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | TryGetAbsoluteSolutionPathで相対パス解決 | E-10 L21-44 | ○ |
| C-56 | 存在しないファイルでfalse（Logモード） | E-10 L34-41 | ○ |
| C-57 | 存在しないファイルでFileNotFoundException（Throwモード） | E-10 L36-39 | ○ |
| C-58 | TryGetAbsoluteProjectPathでパス解決 | E-10 L46-69 | ○ |
| C-59 | 無効なパスでfalse | E-10 L48-57 | ○ |

### ProjectFileExtensionRegistry クラス (UT-MSB-060 〜 065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタでデフォルト拡張子登録 | E-11 L22-33 | ○ |
| C-61 | AssociateFileExtensionWithLanguageで拡張子登録 | E-11 L38-44 | ○ |
| C-62 | TryGetLanguageNameFromProjectPathでC#取得 | E-11 L46-83 | ○ |
| C-63 | TryGetLanguageNameFromProjectPathでVB取得 | E-11 L46-83 | ○ |
| C-64 | 未登録拡張子でfalse | E-11 L76-81 | ○ |
| C-65 | nullパスでfalse | E-11 L50-56 | ○ |

### RpcClient クラス (UT-MSB-066 〜 072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | コンストラクタでインスタンス作成 | E-12 L40-44 | ○ |
| C-67 | Startで受信ループ開始 | E-12 L48-113 | ○ |
| C-68 | Shutdownで受信停止 | E-12 L115-118 | ○ |
| C-69 | InvokeAsyncでvoidメソッド呼び出し | E-12 L120-124 | ○ |
| C-70 | InvokeAsync<T>で戻り値取得 | E-12 L132-137 | ○ |
| C-71 | InvokeNullableAsync<T>でnull許容取得 | E-12 L126-130 | ○ |
| C-72 | Disconnectedイベント発火 | E-12 L46, L111 | ○ |

### RemoteBuildHost クラス (UT-MSB-073 〜 079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | コンストラクタでインスタンス作成 | E-13 L18-22 | ○ |
| C-74 | FindBestMSBuildAsyncでMSBuild検索 | E-13 L30-31 | ○ |
| C-75 | HasUsableMSBuildAsyncで使用可能確認 | E-13 L39-40 | ○ |
| C-76 | ConfigureGlobalStateAsyncで状態設定 | E-13 L43-44 | ○ |
| C-77 | LoadProjectFileAsyncでプロジェクト読込 | E-13 L46-51 | ○ |
| C-78 | LoadProjectAsyncでインメモリ読込 | E-13 L58-63 | ○ |
| C-79 | ShutdownAsyncでシャットダウン | E-13 L68-69 | ○ |

### RemoteProjectFile クラス (UT-MSB-080 〜 089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | コンストラクタでインスタンス作成 | E-14 L16-20 | ○ |
| C-81 | GetDiagnosticLogItemsAsyncで診断取得 | E-14 L22-23 | ○ |
| C-82 | GetProjectFileInfosAsyncで情報取得 | E-14 L25-26 | ○ |
| C-83 | AddDocumentAsyncでドキュメント追加 | E-14 L28-29 | ○ |
| C-84 | RemoveDocumentAsyncでドキュメント削除 | E-14 L31-32 | ○ |
| C-85 | AddMetadataReferenceAsyncで参照追加 | E-14 L34-35 | ○ |
| C-86 | RemoveMetadataReferenceAsyncで参照削除 | E-14 L37-38 | ○ |
| C-87 | AddProjectReferenceAsyncで参照追加 | E-14 L40-41 | ○ |
| C-88 | RemoveProjectReferenceAsyncで参照削除 | E-14 L43-44 | ○ |
| C-89 | SaveAsyncで保存 | E-14 L52-53 | ○ |

### ProjectFile クラス (UT-MSB-090 〜 105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | FilePathでパス取得 | E-15 L24-25 | ○ |
| C-91 | GetDiagnosticLogItemsで診断取得 | E-15 L27-28 | ○ |
| C-92 | GetProjectFileInfosAsyncで非同期取得 | E-15 L35-46 | ○ |
| C-93 | projectがnullで空ProjectFileInfo | E-15 L37-39 | ○ |
| C-94 | AddDocumentでドキュメント追加 | E-15 L48-69 | ○ |
| C-95 | リンク付きドキュメント追加 | E-15 L58-66 | ○ |
| C-96 | RemoveDocumentでドキュメント削除 | E-15 L71-87 | ○ |
| C-97 | AddMetadataReferenceで参照追加 | E-15 L89-104 | ○ |
| C-98 | エイリアス付き参照追加 | E-15 L96-98 | ○ |
| C-99 | RemoveMetadataReferenceで参照削除 | E-15 L106-118 | ○ |
| C-100 | 存在しない参照でInvalidOperationException | E-15 L157 | ○ |
| C-101 | AddProjectReferenceで参照追加 | E-15 L163-182 | ○ |
| C-102 | RemoveProjectReferenceで参照削除 | E-15 L184-196 | ○ |
| C-103 | AddAnalyzerReferenceで参照追加 | E-15 L220-229 | ○ |
| C-104 | RemoveAnalyzerReferenceで参照削除 | E-15 L231-248 | ○ |
| C-105 | Saveで保存 | E-15 L249-257 | ○ |

### ProjectBuildManager クラス (UT-MSB-106 〜 116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | コンストラクタでインスタンス作成 | E-16 L73-77 | ○ |
| C-107 | StartBatchBuildでバッチビルド開始 | E-16 L217-256 | ○ |
| C-108 | 二重開始でInvalidOperationException | E-16 L219-222 | ○ |
| C-109 | EndBatchBuildでバッチビルド終了 | E-16 L258-272 | ○ |
| C-110 | 未開始終了でInvalidOperationException | E-16 L260-263 | ○ |
| C-111 | LoadProjectAsyncでプロジェクト読込 | E-16 L144-168 | ○ |
| C-112 | 存在しないファイルで診断追加 | E-16 L101-105 | ○ |
| C-113 | LoadProjectでストリーム読込 | E-16 L170-202 | ○ |
| C-114 | TryGetOutputFilePathAsyncで出力パス取得 | E-16 L204-213 | ○ |
| C-115 | BuildProjectInstancesAsyncで単一TFMビルド | E-16 L274-283 | ○ |
| C-116 | BuildProjectInstancesAsyncでマルチTFMビルド | E-16 L274-316 | ○ |

### Contracts クラス群 (UT-MSB-117 〜 124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | ProjectFileInfo.CreateEmptyで空作成 | E-17 L150-165 | ○ |
| C-118 | ProjectFileInfo.ToStringでFilePath返却 | E-17 L145-148 | ○ |
| C-119 | ProjectFileInfo.ToStringで括弧付き返却 | E-17 L145-148 | ○ |
| C-120 | DocumentFileInfoコンストラクタ | E-18 L14-47 | ○ |
| C-121 | GetMonoMSBuildDirectoryでディレクトリ取得 | E-19 L131-162 | ○ |
| C-122 | Mono未インストールでnull | E-19 L137-139, L144-146 | ○ |
| C-123 | GetMonoMSBuildVersionでバージョン取得 | E-19 L164-190 | ○ |
| C-124 | MSBuild未インストールでnull | E-19 L170-172, L184-186 | ○ |

### Worker クラス (UT-MSB-125 〜 144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | コンストラクタでインスタンス作成 | E-03 L67-94 | ○ |
| C-126 | LoadAsyncでプロジェクト情報読込 | E-03 L96-131 | ○ |
| C-127 | 重複パスで警告出力 | E-03 L105-113 | ○ |
| C-128 | キャンセル機能 | E-03 L103 | ○ |
| C-129 | CreateDocumentInfosでドキュメント情報作成 | E-03 L349-370 | ○ |
| C-130 | 空リストで空配列 | E-03 L349-370 | ○ |
| C-131 | CheckForDuplicateDocumentsで重複検出 | E-03 L392-410 | ○ |
| C-132 | GetDocumentNameAndFoldersでパス解析 | E-03 L374-390 | ○ |
| C-133 | フォルダなしで空配列 | E-03 L379-382 | ○ |
| C-134 | GetAssemblyNameFromProjectPathでアセンブリ名取得 | E-03 L307-318 | ○ |
| C-135 | nullパスでデフォルト名 | E-03 L311-315 | ○ |
| C-136 | ResolvedReferencesBuilderコンストラクタ | E-04 L59-65 | ○ |
| C-137 | AddProjectReferenceで参照追加 | E-04 L93-96 | ○ |
| C-138 | SwapMetadataReferenceForProjectReferenceで置換 | E-04 L98-109 | ○ |
| C-139 | Containsで存在確認 | E-04 L114-116 | ○ |
| C-140 | nullパスでfalse | E-04 L114-116 | ○ |
| C-141 | Removeで参照削除 | E-04 L121-127 | ○ |
| C-142 | ToResolvedReferencesで参照取得 | E-04 L183-184 | ○ |
| C-143 | ResolveReferencesAsyncで参照解決 | E-04 L187-271 | ○ |
| C-144 | 循環参照検出 | E-04 L311-341 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードに明確な根拠を持つ
- **注意事項**:
  - BuildHostProcessManager: プラットフォーム固有（Windows/Unix/Mono）の動作を含むため、環境依存テストに注意
  - RpcClient: 非同期通信のため、タイムアウトや接続エラーのテストを考慮
  - MonoMSBuildDiscovery: Unix環境固有のため、テスト環境の準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースのカバレッジがpublicメソッドを網羅しているか確認
- [ ] 正常系・異常系・境界値のバランスが適切か確認
- [ ] プラットフォーム依存テスト（Windows/Unix）の考慮があるか確認
- [ ] 非同期メソッドのキャンセル処理テストが含まれているか確認
- [ ] RPC関連テストでモック/スタブの方針が適切か確認
- [ ] MSBuild依存テストの環境設定要件が明確か確認
