---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：Workspaces-Remote 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-52: IsCurrentProcessRunningOnCoreClr** - 環境依存のため実行時検証が必要
  2. **C-59/60: CleanAssetsWorkerAsync** - 非同期タイマー動作のため実際のタイミング検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/Remote/Core/SolutionAssetStorage.cs`
- E-02: `src/Workspaces/Remote/Core/SolutionAssetStorage.Scope.cs`
- E-03: `src/Workspaces/Remote/Core/SolutionAssetProvider.cs`
- E-04: `src/Workspaces/Remote/Core/AbstractAssetProvider.cs`
- E-05: `src/Workspaces/Remote/Core/ServiceHubRemoteHostClient.cs`
- E-06: `src/Workspaces/Remote/Core/BrokeredServiceConnection.cs`
- E-07: `src/Workspaces/Remote/Core/RemoteCallback.cs`
- E-08: `src/Workspaces/Remote/Core/RemoteHostAssetWriter.cs`
- E-09: `src/Workspaces/Remote/Core/RemoteHostAssetReader.cs`
- E-10: `src/Workspaces/Remote/Core/ServiceDescriptor.cs`
- E-11: `src/Workspaces/Remote/Core/ServiceDescriptors.cs`
- E-12: `src/Workspaces/Remote/ServiceHub/Host/SolutionAssetCache.cs`
- E-13: `src/Workspaces/Remote/ServiceHub/Host/AssetProvider.cs`
- E-14: `src/Workspaces/Remote/ServiceHub/Host/RemoteWorkspace.cs`
- E-15: `src/Workspaces/Remote/ServiceHub/Host/RemoteWorkspaceManager.cs`
- E-16: `src/Workspaces/Remote/ServiceHub/Services/BrokeredServiceBase.cs`
- E-17: `src/Workspaces/Remote/Core/AbstractAssetProviderExtensions.cs`
- E-18: `src/Workspaces/Remote/Core/Serialization/MessagePackFormatters.cs`
- E-19: `src/Workspaces/Remote/Core/CancellationTokenSourceExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SolutionAssetStorage.GetScope - 登録済みチェックサムでScopeを取得 | E-01: lines 34-46 | ○ |
| C-02 | SolutionAssetStorage.GetScope - 未登録チェックサムで例外 | E-01: lines 38-42 | ○ |
| C-03 | SolutionAssetStorage.StoreAssetsAsync(Solution) - 正常系 | E-01: lines 51-52 | ○ |
| C-04 | SolutionAssetStorage.StoreAssetsAsync(Project) - 正常系 | E-01: lines 55-56 | ○ |
| C-05 | SolutionAssetStorage.StoreAssetsAsync - RefCount増加 | E-01: lines 81-86 | ○ |
| C-06 | SolutionAssetStorage.DecreaseScopeRefCount - RefCount維持 | E-01: lines 94-107 | ○ |
| C-07 | SolutionAssetStorage.DecreaseScopeRefCount - 削除処理 | E-01: lines 108-111 | ○ |
| C-08 | Scope.FindAssetsAsync - 正常系 | E-02: lines 40-66 | ○ |
| C-09 | Scope.FindAssetsAsync - Checksum.Null検証 | E-02: line 53 | ○ |
| C-10 | Scope.FindAssetsAsync - 空配列 | E-02: lines 51-52 | ○ |
| C-11 | Scope.Dispose - RefCount減少 | E-02: lines 33-34 | ○ |
| C-12 | SolutionAssetProvider.WriteAssetsAsync - 正常系 | E-03: lines 27-65 | ○ |
| C-13 | SolutionAssetProvider.WriteAssetsAsync - 例外処理 | E-03: lines 49-63 | ○ |
| C-14 | AbstractAssetProvider.CreateSolutionInfoAsync - 正常系 | E-04: lines 29-71 | ○ |
| C-15 | AbstractAssetProvider.CreateProjectInfoAsync - 正常系 | E-04: lines 73-132 | ○ |
| C-16 | AbstractAssetProvider.CreateProjectInfoAsync - 言語検証 | E-04: line 83 | ○ |
| C-17 | AbstractAssetProvider.CreateDocumentInfoAsync - 正常系 | E-04: lines 163-173 | ○ |
| C-18 | AbstractAssetProvider.SynchronizeProjectDocumentsAsync - 正常系 | E-04: lines 134-161 | ○ |
| C-19 | ServiceHubRemoteHostClient.CreateAsync - 正常系 | E-05: lines 50-114 | ○ |
| C-20 | ServiceHubRemoteHostClient.CreateAsync - エラー処理 | E-05: lines 75-106 | ○ |
| C-21 | ServiceHubRemoteHostClient.CreateConnection - 正常系 | E-05: lines 119-139 | ○ |
| C-22 | ServiceHubRemoteHostClient.Dispose - 正常系 | E-05: lines 141-147 | ○ |
| C-23 | BrokeredServiceConnection.TryInvokeAsync - 正常系 | E-06: lines 98-111 | ○ |
| C-24 | BrokeredServiceConnection.TryInvokeAsync - キャンセル | E-06: lines 106-110 | ○ |
| C-25 | BrokeredServiceConnection.TryInvokeAsync<TResult> - 正常系 | E-06: lines 113-125 | ○ |
| C-26 | BrokeredServiceConnection.TryInvokeAsync(compilationState) - 正常系 | E-06: lines 164-178 | ○ |
| C-27 | BrokeredServiceConnection.TryInvokeAsync(projectId) - 正常系 | E-06: lines 197-211 | ○ |
| C-28 | BrokeredServiceConnection.TryInvokeAsync(2 solutions) - 正常系 | E-06: lines 306-321 | ○ |
| C-29 | BrokeredServiceConnection.ReportUnexpectedException - IOException | E-06: lines 325-344 | ○ |
| C-30 | BrokeredServiceConnection.IsRemoteIOException - 正常系 | E-06: lines 350-351 | ○ |
| C-31 | BrokeredServiceConnection.Dispose - 正常系 | E-06: lines 75-78 | ○ |
| C-32 | RemoteCallback.InvokeServiceAsync - 正常系 | E-07: lines 34-56 | ○ |
| C-33 | RemoteCallback.InvokeServiceAsync - ObjectDisposedException | E-07: lines 45-50 | ○ |
| C-34 | RemoteCallback.InvokeAsync - 正常系 | E-07: lines 61-71 | ○ |
| C-35 | RemoteCallback.InvokeAsync(PipeWriter) - 正常系 | E-07: lines 98-204 | ○ |
| C-36 | RemoteCallback.InvokeAsync(PipeWriter) - 例外処理 | E-07: lines 179-203 | ○ |
| C-37 | RemoteCallback.ReportUnexpectedException - IOException | E-07: lines 213-220 | ○ |
| C-38 | RemoteCallback.ReportUnexpectedException - ConnectionLost | E-07: lines 239-241 | ○ |
| C-39 | RemoteHostAssetWriter.WriteDataAsync - 正常系 | E-08: lines 71-77 | ○ |
| C-40 | RemoteHostAssetWriter.WriteDataAsync - チェックサム不整合 | E-08: line 114 | ○ |
| C-41 | RemoteHostAssetWriter.WriteSingleAssetToPipeAsync - フォーマット | E-08: lines 117-147 | ○ |
| C-42 | RemoteHostAssetReader.ReadDataAsync - 正常系 | E-09: lines 35-65 | ○ |
| C-43 | RemoteHostAssetReader.ReadDataAsync - チェックサム検証 | E-09: line 60 | ○ |
| C-44 | RemoteHostAssetReader.CheckSentinelByteAndReadLengthAsync - センチネル検証 | E-09: line 103 | ○ |
| C-45 | ServiceDescriptor.CreateRemoteServiceDescriptor - 正常系 | E-10: lines 61-62 | ○ |
| C-46 | ServiceDescriptor.CreateInProcServiceDescriptor - 正常系 | E-10: lines 64-65 | ○ |
| C-47 | ServiceDescriptor.GetFeatureDisplayName - 正常系 | E-10: lines 84-85 | ○ |
| C-48 | ServiceDescriptors.GetSimpleName - 正常系 | E-11: lines 110-117 | ○ |
| C-49 | ServiceDescriptors.GetSimpleName - プレフィックス検証 | E-11: lines 114-115 | ○ |
| C-50 | ServiceDescriptors.GetServiceDescriptor - 正常系 | E-11: lines 135-143 | ○ |
| C-51 | ServiceDescriptors.GetServiceDescriptor - 未登録エラー | E-11: line 139 | ○ |
| C-52 | ServiceDescriptors.IsCurrentProcessRunningOnCoreClr - 正常系 | E-11: lines 128-130 | △ |
| C-53 | SolutionAssetCache.GetOrAdd - 追加 | E-12: lines 67-74 | ○ |
| C-54 | SolutionAssetCache.GetOrAdd - 既存返却 | E-12: lines 71-73 | ○ |
| C-55 | SolutionAssetCache.GetOrAdd - null検証 | E-12: line 69 | ○ |
| C-56 | SolutionAssetCache.TryGetAsset - 存在 | E-12: lines 76-91 | ○ |
| C-57 | SolutionAssetCache.TryGetAsset - 不在 | E-12: lines 80-84 | ○ |
| C-58 | SolutionAssetCache.ContainsAsset - 正常系 | E-12: lines 94-95 | ○ |
| C-59 | SolutionAssetCache.CleanAssetsWorkerAsync - 期限切れ削除 | E-12: lines 122-152 | △ |
| C-60 | SolutionAssetCache.CleanAssetsWorkerAsync - ピン留め維持 | E-12: lines 143-147 | ○ |
| C-61 | SolutionAssetCache.CleanAssetsWorkerAsync - 空キャッシュ | E-12: lines 124-128 | ○ |
| C-62 | AssetProvider.GetAssetAsync - キャッシュヒット | E-13: lines 37-56 | ○ |
| C-63 | AssetProvider.GetAssetAsync - リモート取得 | E-13: lines 44-55 | ○ |
| C-64 | AssetProvider.GetAssetAsync - null検証 | E-13: line 40 | ○ |
| C-65 | AssetProvider.SynchronizeSolutionAssetsAsync - 正常系 | E-13: lines 68-128 | ○ |
| C-66 | AssetProvider.SynchronizeProjectAssetsAsync - 少数プロジェクト | E-13: lines 155-173 | ○ |
| C-67 | AssetProvider.SynchronizeProjectAssetsAsync - 大量プロジェクト | E-13: lines 175-183 | ○ |
| C-68 | AssetProvider.SynchronizeAssetsAsync - 差分同期 | E-13: lines 244-330 | ○ |
| C-69 | AssetProvider.SynchronizeAssetsAsync - 空入力 | E-13: lines 247-249 | ○ |
| C-70 | RemoteWorkspace.UpdatePrimaryBranchSolutionAsync - 正常系 | E-14: lines 47-64 | ○ |
| C-71 | RemoteWorkspace.UpdatePrimaryBranchSolutionAsync - スキップ | E-14: lines 52-54 | ○ |
| C-72 | RemoteWorkspace.RunWithSolutionAsync - 正常系 | E-14: lines 79-86 | ○ |
| C-73 | RemoteWorkspace.RunWithSolutionAsync - null検証 | E-14: line 95 | ○ |
| C-74 | RemoteWorkspace.RunWithSolutionAsync - InFlightCount管理 | E-14: lines 118-139 | ○ |
| C-75 | RemoteWorkspace.ComputeDisconnectedSolutionAsync - 正常系 | E-14: lines 294-312 | ○ |
| C-76 | RemoteWorkspace.CreateSolutionFromInfo - 正常系 | E-14: lines 314-322 | ○ |
| C-77 | RemoteWorkspace.UpdateWorkspaceCurrentSolutionAsync - 正常系 | E-14: lines 328-359 | ○ |
| C-78 | RemoteWorkspaceManager.GetWorkspace - 正常系 | E-15: line 80 | ○ |
| C-79 | RemoteWorkspaceManager.GetSolutionAsync - 正常系 | E-15: lines 88-101 | ○ |
| C-80 | RemoteWorkspaceManager.RunServiceAsync - 正常系 | E-15: lines 103-120 | ○ |
| C-81 | BrokeredServiceBase.RunWithSolutionAsync - 正常系 | E-16: lines 87-101 | ○ |
| C-82 | BrokeredServiceBase.RunServiceAsync(implementation) - 正常系 | E-16: lines 103-106 | ○ |
| C-83 | BrokeredServiceBase.RunServiceAsync(solutionChecksum) - 正常系 | E-16: lines 108-113 | ○ |
| C-84 | BrokeredServiceBase.RunServiceAsync(2 checksums) - 正常系 | E-16: lines 149-163 | ○ |
| C-85 | BrokeredServiceBase.Dispose - 正常系 | E-16: lines 72-73 | ○ |
| C-86 | BrokeredServiceBase.GetWorkspaceServices - 正常系 | E-16: lines 78-79 | ○ |
| C-87 | AbstractAssetProviderExtensions.GetAssetsAsync(HashSet) - 正常系 | E-17: lines 19-24 | ○ |
| C-88 | AbstractAssetProviderExtensions.GetAssetsArrayAsync - 正常系 | E-17: lines 49-81 | ○ |
| C-89 | AbstractAssetProviderExtensions.GetAssetsArrayAsync - 重複処理 | E-17: lines 54-58 | ○ |
| C-90 | ProjectIdFormatter.Serialize - 正常系 | E-18: lines 104-129 | ○ |
| C-91 | ProjectIdFormatter.Serialize - 2回目最適化 | E-18: lines 115-117 | ○ |
| C-92 | ProjectIdFormatter.Serialize - null処理 | E-18: lines 108-111 | ○ |
| C-93 | ProjectIdFormatter.Deserialize - 正常系 | E-18: lines 59-102 | ○ |
| C-94 | ProjectIdFormatter.Deserialize - キャッシュ | E-18: lines 76-85 | ○ |
| C-95 | EncodingFormatter.Serialize - 正常系 | E-18: lines 179-208 | ○ |
| C-96 | EncodingFormatter.Deserialize - 正常系 | E-18: lines 144-177 | ○ |
| C-97 | EncodingFormatter.Deserialize - null処理 | E-18: lines 148-151 | ○ |
| C-98 | CancellationTokenSourceExtensions.CancelOnAbnormalCompletion - 異常完了 | E-19: lines 19-40 | ○ |
| C-99 | CancellationTokenSourceExtensions.CancelOnAbnormalCompletion - 正常完了 | E-19: line 38 | ○ |
| C-100 | CancellationTokenSourceExtensions.CancelOnAbnormalCompletion - null検証 | E-19: lines 21-22 | ○ |

## 4) 不足情報（Unknown / Missing）

- **C-52: IsCurrentProcessRunningOnCoreClr**
  - 根拠となるコードは存在するが、環境依存のため静的解析だけでは動作を完全に検証できない
  - 候補：実行時テスト / 環境別テストマトリックス / CI環境での検証

- **C-59: CleanAssetsWorkerAsync（タイマー動作）**
  - 非同期タイマーによるバックグラウンド処理のため、タイミングに依存するテストが必要
  - 候補：モック化されたタイマー / TestAccessorを使用した直接呼び出し

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 1: 中リスク | C-52 | 環境依存の判定ロジック。異なる.NETランタイムでの動作確認が必要 |
| 1: 中リスク | C-59/60 | 非同期タイマー動作。タイミング依存のためテスト安定性に注意 |
| 0: 低リスク | C-91/94 | キャッシュ最適化。パフォーマンス影響はあるが機能的には正しい |
| 0: 低リスク | C-97 | null処理。標準的なnullチェックパターン |

## 6) レビュアーチェックリスト（最小）

- [ ] SolutionAssetStorage のスコープ管理（RefCount）が正しく実装されているか確認
- [ ] BrokeredServiceConnection の例外処理パスが網羅されているか確認
- [ ] RemoteCallback のパイプ処理でリソースリークがないか確認
- [ ] SolutionAssetCache のキャッシュクリーニングロジックがCurrentSolutionを正しく保護するか確認
- [ ] MessagePackFormatters のシリアライズ/デシリアライズが双方向で一貫しているか確認
- [ ] 環境依存テスト（C-52）について、CI環境での実行方針を決定
- [ ] 非同期タイマーテスト（C-59/60）について、TestAccessorを使用した確定的テスト方法を検討
